//
// Created by rainer on 07.03.23.
//

#ifndef APP_JAVASCRIPT_CALLBACKS_H
#define APP_JAVASCRIPT_CALLBACKS_H
#ifdef __cplusplus
extern "C" {
#endif
#include <quickjs.h>

#define LEN(X) (sizeof(X)/sizeof(X[0]))

typedef struct {
    char* name;
    int js_tag;
    int check_limits;
    int min;
    int max;
} expected_parameters;

void js_write_to_log(int level, const char* message);
void js_create_softkey(const char* id, const char* text, int row, int col, int shiftstate);
void js_destroy_softkey(const char* id);
void js_enable_softkey(const char* id, int enabled);
void js_show_toast(const char *tostring);
char* js_dump_error(JSContext *ctx);
int js_getjoystickcount();
int js_notify_tasks_deleted();
void js_notify_gamepad_task_created();
void js_init_constants();
int js_get_devicefeature(int feature);
int js_is_keycode_supported(int code);
void js_request_virtual_keyboard(int screenpart);
void js_restore_virtual_keyboard();
void arch_joystick_set_value_absolute(unsigned int joyport, uint8_t value);
int js_set_monitor(uint32_t monitor);

JSValue  js_checksyntax(const char* function, JSContext* ctx, size_t argc, JSValue* argv, expected_parameters* params, size_t parameters_len);
char *get_abs_filepath(const char *filename);
void js_store_initial_snapshot(int level);
void js_take_test_screenshot(const char* filename);
#ifdef __cplusplus
}
#endif
#endif //APP_JAVASCRIPT_CALLBACKS_H
