//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------

#include "jnihelpers.h"
#include "lib.h"
#include "initcmdline.h"
#include "logginghelpers.h"
#include "javascript.h"

extern t_shared_data* g_shareddata;

__attribute__((used)) void cmdline_reparse() {
    JNIEnv* env = getAactiveenv();
    jclass  clz = (*env)->GetObjectClass(env, g_shareddata->instance);
    jmethodID mth_getargc=(*env)->GetMethodID(env, clz, "getArgcFromPresettings","()I");
    jmethodID mth_getargv=(*env)->GetMethodID(env, clz, "getArgvFromPresettings", "(I)Ljava/lang/String;");
    jmethodID mth_getsnapshot=(*env)->GetMethodID(env, clz, "getSnapshotForStreamRestart", "()Ljava/lang/String;");
    int argc;
    char** argv;
    jstring snapshot = (jstring) (*env)->CallObjectMethod(env, g_shareddata->instance, mth_getsnapshot);
    if (snapshot) {
        argc = 2;
        argv= lib_malloc(2*sizeof(char *));
        jstring js0 = (jstring) (*env)->CallObjectMethod(env, g_shareddata->instance,
                                                            mth_getargv, 0);
        const char* s0 = GetStringUTFChars(snapshot, NULL);
        argv[0] = lib_strdup(s0);
        ReleaseStringUTFChars(js0, s0);
        jstring js1 = (jstring) (*env)->CallObjectMethod(env, g_shareddata->instance,
                                                         mth_getargv, 0);
        const char* s1 = GetStringUTFChars(snapshot, NULL);
        argv[1] = lib_strdup(s1);
        ReleaseStringUTFChars(js1, s1);
    } else {
        argc = (*env)->CallIntMethod(env,g_shareddata->instance, mth_getargc);
        argv= lib_malloc((1+argc)*sizeof(char *));

        for (int i = 0; i < argc; i++) {
            jstring strObj = (jstring) (*env)->CallObjectMethod(env, g_shareddata->instance,
                                                                mth_getargv, i);
            if (strObj) {
                const char *str = GetStringUTFChars(strObj, NULL);
                // Print the class name
                argv[i] = lib_strdup(str);

                // Release the memory pinned char array
                ReleaseStringUTFChars(strObj, str);
            } else {
                argv[i] = lib_strdup("");
            }
        }
    }
    LOGV("cmdline_reparse");
    for (int i = 0; i< argc; i++) {
        LOGV("argv[%d]=%s", i, argv[i]);
    }
    LOGV("initcmdline_check_args returned %d", initcmdline_check_args(argc, argv));
    initcmdline_check_attach();
    js_reset();

}