/*
 * vsyncarch.c - End-of-frame handling for Unix
 *
 * Written by
 *  Dag Lem <resid@nimrod.no>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */
#include "vice.h"
#include "jnihelpers.h"
#include "kbd.h"
#include "kbdbuf.h"
#include "vsyncapi.h"
#ifdef HAS_JOYSTICK
#include "joy.h"
#endif
#include "temporary_snapshot.h"
#ifdef HAVE_OPENGL_SYNC
#include "openGL_sync.h"
#endif

#include <time.h>

#include <sys/time.h>
#include <vsync.h>
#include <stdio.h>
#include "logginghelpers.h"
#include "javascript.h"
#include "mouse.h"
#include "mousedrv.h"


static jmethodID mth_vsyncarch_presync=(jmethodID)0;
__attribute__((used)) static jmethodID mth_vsyncarch_postsync=(jmethodID)0;
static jmethodID mth_handle_next_key=(jmethodID)0;
static int presync_requested=0;

int is_in_vsync=0;

__attribute__((unused)) void add_vsync_task(jobject runnable);

void vsyncarch_init(void)
{
		is_in_vsync = 0;
		presync_requested=1;
		mth_vsyncarch_presync= GetMethodID(GetObjectClass(CurrentActivity()),"presync","()Z");
#pragma clang diagnostic push
#pragma ide diagnostic ignored "UnusedValue"
		mth_vsyncarch_postsync=GetMethodID(GetObjectClass(CurrentActivity()),"postsync","()V");
#pragma clang diagnostic pop
		mth_handle_next_key=GetMethodID(GetObjectClass(CurrentActivity()),"handleNextKey","()V");
		js_init();
}

__attribute__((used)) void request_presync()
{
	presync_requested=1;
}
static float movex = 0;
static float movey = 0;
void set_mouse_movement(float x, float y) {
    double frequency = vsync_get_refresh_frequency();
    movex = x * 10000 / frequency;
    movey = y * 10000 / frequency;

}
void vsyncarch_presync(void)
{
	is_in_vsync = 1;
    if (mth_handle_next_key) {
        CallVoidMethod(CurrentActivity(), mth_handle_next_key);
    }
    if (movex || movey) {
        mouse_move(movex,movey);
    }
	if (presync_requested && mth_vsyncarch_presync)
	{
		if (CallBooleanMethod(CurrentActivity(),mth_vsyncarch_presync)) {
			presync_requested = 0;
		}
	}

	timemachine_tick();
	kbdbuf_flush();
	is_in_vsync = 0;

}
static int docrash=0;

__attribute__((used)) void request_test_crash()
{
	docrash=1;
}
void vsyncarch_postsync(void)
{
	is_in_vsync = 1;
	js_vsync_actions_check();
	if (docrash) {
		LOGV("Crashing for test reason!");
		docrash=0;
		char* null=NULL;
		sprintf(NULL, "x");
        // IGNORE ANY WARNINGS HERE!
        // This crash is intended an will be triggered during tests.
		*null=(char)255;
	}
	is_in_vsync = 0;
}
static void execute_vsync_task(void *data) {
	jobject runnable = (jobject)data;
	JNIEnv* env = getAactiveenv();
	callRun(env, runnable);
}

__attribute__((unused)) void add_vsync_task(jobject runnable) {
	JNIEnv* env = getAactiveenv();
	jobject global = (*env)->NewGlobalRef(env, runnable);
	vsync_on_vsync_do(execute_vsync_task, global);
}