//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "jnihelpers.h"
#include "logginghelpers.h"
#include "translate_javastubs.h"

extern t_javaResId translate_resources_gen[];
static char* find_text_java(int resId,t_javaResId resources[])
{
	int i;
	static jclass cls=NULL;
	static jmethodID mth=NULL;
	static char* ret=NULL;
	JNIEnv* currentenv= getAactiveenv();
	if (!cls)
	{
		cls = GetObjectClass(CurrentActivity());
		if (cls) {
			mth = GetMethodID(cls, "getViceTranslatedText",
							  "(Ljava/lang/String;)Ljava/lang/String;");
		}
	}
	if (cls && mth)
	{
		for (i=0;resources[i].resId!=0;i++)
		{
			if (resources[i].resId==resId && resources[i].resString!=NULL)
			{
				jstring param;
				jstring retjava;

				const char* val;
				param=(*currentenv)->NewStringUTF(currentenv,resources[i].resString);
				retjava=(jstring)CallObjectMethod(CurrentActivity(),mth,(jobject)param);
				DeleteLocalRef(param);
				jboolean isCopy;
				val=GetStringUTFChars(retjava, &isCopy);
				if (ret)
				{
					free(ret);
				}
				ret=strdup(val);
				if (!isCopy) {
					ReleaseStringUTFChars(retjava, val);
				}
				return ret;
			}
		}
	}
	else
	{
		LOGD("find_text_java: method not found");
	}
	return NULL;
}
char* translate_text_java(int resId)
{
	char* ret=find_text_java(resId,translate_resources_gen);
	return ret;
}
