/*
 * translate.c - Global internationalization routines.
 *
 * Written by
 *  Rainer Hock
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#include "vice.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "cmdline.h"
#include "lib.h"
#include "log.h"
#include "resources.h"
#include "translate.h"
#include "translate_javastubs.h"
#include "util.h"

#define countof(array) (sizeof(array) / sizeof((array)[0]))

typedef struct translate_s {
    int resource_id;
    char *text;
} translate_t;



static char *sid_return = NULL;

/* special case translation, this command-line option normally
   produces alot of lines (which only differ slightly) for the
   translators to translate, this function builds up the total
   command-line option from smaller translation pieces.
 */
static char *translate_and_build_sid_cmdline_option(int en_resource)
{
    char *old, *new;

    /* check if sid_return is already built */
    if (sid_return != NULL) {
        lib_free(sid_return);
    }

    /* start building up the command-line */
    old = lib_strdup("Specify SID engine and model (");

    /* add fast sid options */
    new = util_concat(old, translate_text(IDCLS_FASTSID_ENGINE_MODEL), NULL);
    lib_free(old);
    old = new;


#ifdef HAVE_RESID
    /* add resid options if available */
    if (en_resource != IDCLS_SPECIFY_SIDCART_ENGINE_MODEL) {
        new = util_concat(old, ", ", translate_text(IDCLS_RESID_ENGINE_MODEL), NULL);
        lib_free(old);
        old = new;
    }

    /* add residdtv options if available */
    if (en_resource == IDCLS_SPECIFY_SIDDTV_ENGINE_MODEL) {
        new = util_concat(old, ", ", translate_text(IDCLS_RESIDDTV_ENGINE_MODEL), NULL);
        lib_free(old);
        old = new;
    }
#endif

#ifdef HAVE_CATWEASELMKIII
    /* add catweasel options if available */
    new = util_concat(old, ", ", translate_text(IDCLS_CATWEASELMKIII_ENGINE_MODEL), NULL);
    lib_free(old);
    old = new;
#endif

#ifdef HAVE_HARDSID
    /* add hardsid options if available */
    new = util_concat(old, ", ", translate_text(IDCLS_HARDSID_ENGINE_MODEL), NULL);
    lib_free(old);
    old = new;
#endif

#ifdef HAVE_PARSID
    /* add parsid options if available */
    new = util_concat(old, ", ", translate_text(IDCLS_PARSID_ENGINE_MODEL), NULL);
    lib_free(old);
    old = new;
#endif

#ifdef HAVE_RESID_FP
    /* add resid-fp options if available */
    if (en_resource != IDCLS_SPECIFY_SIDCART_ENGINE_MODEL) {
        new = util_concat(old, ", ", translate_text(IDCLS_RESIDFP_ENGINE_MODEL), NULL);
        lib_free(old);
        old = new;
    }
#endif

    /* add ending bracket */
    new = util_concat(old, ")", NULL);
    lib_free(old);

    sid_return = new;

    return sid_return;
}
char *translate_text(int en_resource)
{
	  if (en_resource == IDCLS_SPECIFY_SIDCART_ENGINE_MODEL ||
	      en_resource == IDCLS_SPECIFY_SID_ENGINE_MODEL ||
	      en_resource == IDCLS_SPECIFY_SIDDTV_ENGINE_MODEL) {
	      return translate_and_build_sid_cmdline_option(en_resource);
	  }
	return "";
}

void translate_arch_language_init(void)
{
}
