//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


#include <malloc.h>
#include <unistd.h>
#include <android/log.h>
#include <pthread.h>
#include <unwind.h>
#include "native_signals.h"
#include "jnihelpers.h"
#include "native_threading.h"
#include <string.h>

jmp_buf  jumpbuffer;


#define arraysize(array) (sizeof((array)) / sizeof((array)[0]))
static const int SIGNALS_TO_CATCH[] = {
        SIGABRT,
        SIGBUS,
        SIGFPE,
        SIGSEGV,
        SIGILL,
        SIGTERM,
        SIGSTKFLT,
        SIGTRAP,
};
t_shared_data* current_shareddata;
static char crash_message[1024];
static void writeCrashMessage(int signo, struct siginfo* siginfo,t_shared_data* shared_data) {
    memset(&(shared_data->crashinfo),0,sizeof(shared_data->crashinfo));
    snprintf(crash_message,sizeof(crash_message)/sizeof(char), "Terminating with a C crash %d : %d", signo, siginfo->si_code);
    shared_data->crashinfo._code=siginfo->si_code;
    shared_data->crashinfo._signo=siginfo->si_signo;
    shared_data->crashinfo._errno=siginfo->si_errno;
    if (signo==SIGILL||signo==SIGSEGV||signo==SIGFPE||signo==SIGBUS) {
        shared_data->crashinfo._addr = (siginfo->_sifields._sigfault._addr);
    }

    else
    {
        shared_data->crashinfo._addr=NULL;
    }


}
static struct sigaction old_handlers[NSIG];


static void handler(int signo, struct siginfo* siginfo, void* __unused ctxvoid) {
    // Log crash message
    // Restoring an old handler to make built-in Android crash mechanism work.
    sigaction(signo, old_handlers+signo,  NULL);

    writeCrashMessage(signo, siginfo,current_shareddata);
    __android_log_print(ANDROID_LOG_ERROR, "Native Exception", "%s", crash_message);
    siglongjmp(jumpbuffer,1);
}
int start_handling_signals(t_shared_data* shareddata) {
    /*
    current_shareddata=shareddata;

    struct sigaction sigactionstruct;
    memset(&sigactionstruct, 0, sizeof(sigactionstruct));
    sigactionstruct.sa_flags = SA_SIGINFO;
    sigactionstruct.sa_sigaction = handler;
    // Register new handlers for all signals
    for (int index = 0; index < arraysize(SIGNALS_TO_CATCH); ++index) {
        const int signo = SIGNALS_TO_CATCH[index];
        if (sigaction(signo, &sigactionstruct, &old_handlers[signo])) {
            return -1;
        }
    }
     */
    return 0;
}
void stop_handling_signals() {
    // Recover old handler for all signals
    for (int signo = 0; signo < NSIG; ++signo) {
        const struct sigaction* old_handler = &old_handlers[signo];
        if (!old_handler->sa_handler) {
            continue;
        }
        sigaction(signo, old_handler, NULL);
    }
}