//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


#ifdef HAVE_COMMON_SO
#include "machine_specific_bindings.h"
#include "gen_machine_specific_bindings.h"

__attribute__((used)) void populate_machine_specific_functions() {
	t_machine_specific_bindings bindings = {main_program,\
		main_exit,\
		vicii_init,\
		mem_initialize_memory,\
		mem_powerup,\
		mem_load,\
		mem_get_basic_text,\
		mem_set_basic_text,\
		mem_toggle_watchpoints,\
		mem_rom_trap_allowed,\
		mem_mmu_translate,\
		mem_color_ram_to_snapshot,\
		mem_color_ram_from_snapshot,\
		mem_read_screen,\
		mem_inject,\
		mem_inject_key,\
		mem_bank_list,\
		mem_bank_list_nos,\
		mem_bank_from_name,\
		mem_bank_index_from_bank,\
		mem_bank_flags_from_bank,\
		mem_bank_read,\
		mem_bank_peek,\
		mem_bank_write,\
		mem_bank_poke,\
		mem_get_screen_parameter,\
		mem_get_cursor_parameter,\
		mem_ioreg_list_get,\
		mem_write_snapshot_module,\
		mem_read_snapshot_module,\
		mididrv_init,\
		mididrv_in_open,\
		mididrv_out_open,\
		mididrv_in_close,\
		mididrv_out_close,\
		mididrv_in,\
		mididrv_out,\
		mididrv_resources_init,\
		mididrv_resources_shutdown,\
		mididrv_cmdline_options_init,\
		machine_printer_setup_context,\
		machine_printer_resources_init,\
		machine_printer_resources_shutdown,\
		machine_printer_cmdline_options_init,\
		machine_printer_init,\
		machine_printer_shutdown,\
		vsyncarch_advance_frame,\
		vsyncarch_vbl_sync_enabled,\
		ssi2001_drv_open,\
		ssi2001_drv_close,\
		ssi2001_drv_read,\
		ssi2001_drv_store,\
		ssi2001_drv_available,\
		machine_video_resources_init,\
		machine_video_init,\
		machine_video_canvas_get,\
		video_canvas_map,\
		video_canvas_unmap,\
		maincpu_resync_limits,\
		maincpu_init,\
		maincpu_early_init,\
		maincpu_shutdown,\
		maincpu_reset,\
		maincpu_mainloop,\
		maincpu_monitor_interface_get,\
		maincpu_snapshot_read_module,\
		maincpu_snapshot_write_module,\
		maincpu_set_pc,\
		maincpu_set_a,\
		maincpu_set_x,\
		maincpu_set_y,\
		maincpu_set_sign,\
		maincpu_set_zero,\
		maincpu_set_carry,\
		maincpu_set_interrupt,\
		maincpu_get_pc,\
		maincpu_get_a,\
		maincpu_get_x,\
		maincpu_get_y,\
		maincpu_get_sp,\
		parsid_drv_open,\
		parsid_drv_out_ctr,\
		parsid_drv_in_ctr,\
		parsid_drv_close,\
		parsid_drv_in_data,\
		parsid_drv_out_data,\
		parsid_drv_sleep,\
		parsid_drv_available,\
		machine_resources_init,\
		machine_resources_shutdown,\
		machine_cmdline_options_init,\
		machine_setup_context,\
		machine_specific_init,\
		machine_specific_reset,\
		machine_specific_powerup,\
		machine_specific_shutdown,\
		machine_set_restore_key,\
		machine_has_restore_key,\
		machine_get_cycles_per_second,\
		machine_get_cycles_per_frame,\
		machine_set_cycles_per_frame,\
		machine_get_line_cycle,\
		machine_write_snapshot,\
		machine_read_snapshot,\
		machine_handle_pending_alarms,\
		machine_autodetect_psid,\
		machine_play_psid,\
		machine_sid2_check_range,\
		machine_sid3_check_range,\
		machine_sid4_check_range,\
		machine_sid5_check_range,\
		machine_sid6_check_range,\
		machine_sid7_check_range,\
		machine_sid8_check_range,\
		machine_change_timing,\
		machine_screenshot,\
		machine_canvas_async_refresh,\
		machine_update_memory_ptrs,\
		machine_diskcontents_bus_read,\
		machine_romset_init,\
		machine_romset_file_load,\
		machine_romset_file_save,\
		machine_romset_file_list,\
		machine_romset_archive_item_create,\
		machine_tape_type_default,\
		machine_tape_behaviour,\
		machine_addr_in_ram,\
		machine_get_name,\
		machine_get_num_keyboard_types,\
		machine_get_keyboard_info_list,\
		machine_get_keyboard_type,\
		machine_get_keyboard_type_name,\
		machine_register_userport,\
		c64scui_init_early,\
		c64dtvui_init_early,\
		c64dtvui_init,\
		c64dtvui_shutdown,\
		catweaselmkiii_drv_open,\
		catweaselmkiii_drv_close,\
		catweaselmkiii_drv_read,\
		catweaselmkiii_drv_store,\
		catweaselmkiii_drv_set_machine_parameter,\
		catweaselmkiii_drv_available,\
		disk_image_rawimage_name_set,\
		disk_image_rawimage_driver_name_set,\
		sidcart_cmdline_options_init,\
		sidcart_resources_init,\
		sidcart_enabled,\
		sidcart_sound_chip_init,\
		sidcart_detach,\
		sidcart_snapshot_write_module,\
		sidcart_snapshot_read_module,\
		export_query_list,\
		export_dump,\
		export_add,\
		export_remove,\
		export_resources_init,\
		c64io_d000_read,\
		c64io_d000_peek,\
		c64io_d000_store,\
		c64io_d100_read,\
		c64io_d100_peek,\
		c64io_d100_store,\
		c64io_d200_read,\
		c64io_d200_peek,\
		c64io_d200_store,\
		c64io_d300_read,\
		c64io_d300_peek,\
		c64io_d300_store,\
		c64io_d400_read,\
		c64io_d400_peek,\
		c64io_d400_store,\
		c64io_d500_read,\
		c64io_d500_peek,\
		c64io_d500_store,\
		c64io_d600_read,\
		c64io_d600_peek,\
		c64io_d600_store,\
		c64io_d700_read,\
		c64io_d700_peek,\
		c64io_d700_store,\
		c64io_de00_read,\
		c64io_de00_peek,\
		c64io_de00_store,\
		c64io_df00_read,\
		c64io_df00_peek,\
		c64io_df00_store,\
		vic20io0_read,\
		vic20io0_peek,\
		vic20io0_store,\
		vic20io2_read,\
		vic20io2_peek,\
		vic20io2_store,\
		vic20io3_read,\
		vic20io3_peek,\
		vic20io3_store,\
		cbm2io_d800_read,\
		cbm2io_d800_peek,\
		cbm2io_d800_store,\
		cbm2io_d900_read,\
		cbm2io_d900_peek,\
		cbm2io_d900_store,\
		cbm2io_da00_read,\
		cbm2io_da00_peek,\
		cbm2io_da00_store,\
		cbm2io_db00_read,\
		cbm2io_db00_peek,\
		cbm2io_db00_store,\
		cbm2io_dc00_read,\
		cbm2io_dc00_peek,\
		cbm2io_dc00_store,\
		cbm2io_dd00_read,\
		cbm2io_dd00_peek,\
		cbm2io_dd00_store,\
		cbm2io_de00_read,\
		cbm2io_de00_peek,\
		cbm2io_de00_store,\
		cbm2io_df00_read,\
		cbm2io_df00_peek,\
		cbm2io_df00_store,\
		petio_8800_read,\
		petio_8800_peek,\
		petio_8800_store,\
		petio_8900_read,\
		petio_8900_peek,\
		petio_8900_store,\
		petio_8a00_read,\
		petio_8a00_peek,\
		petio_8a00_store,\
		petio_8b00_read,\
		petio_8b00_peek,\
		petio_8b00_store,\
		petio_8c00_read,\
		petio_8c00_peek,\
		petio_8c00_store,\
		petio_8d00_read,\
		petio_8d00_peek,\
		petio_8d00_store,\
		petio_8e00_read,\
		petio_8e00_peek,\
		petio_8e00_store,\
		petio_8f00_read,\
		petio_8f00_peek,\
		petio_8f00_store,\
		petio_e900_read,\
		petio_e900_peek,\
		petio_e900_store,\
		petio_ea00_read,\
		petio_ea00_peek,\
		petio_ea00_store,\
		petio_eb00_read,\
		petio_eb00_peek,\
		petio_eb00_store,\
		petio_ec00_read,\
		petio_ec00_peek,\
		petio_ec00_store,\
		petio_ed00_read,\
		petio_ed00_peek,\
		petio_ed00_store,\
		petio_ee00_read,\
		petio_ee00_peek,\
		petio_ee00_store,\
		petio_ef00_read,\
		petio_ef00_peek,\
		petio_ef00_store,\
		plus4io_fd00_read,\
		plus4io_fd00_peek,\
		plus4io_fd00_store,\
		plus4io_fe00_read,\
		plus4io_fe00_peek,\
		plus4io_fe00_store,\
		io_source_ioreg_add_list,\
		io_source_register,\
		io_source_unregister,\
		cartio_shutdown,\
		c64io_vicii_init,\
		c64io_vicii_deinit,\
		c64io_vicii_reinit,\
		cartio_resources_init,\
		cartio_cmdline_options_init,\
		cartio_set_highest_order,\
		machine_bus_init_machine,\
		machine_bus_lib_directory,\
		machine_bus_lib_read_sector,\
		machine_bus_lib_write_sector,\
		machine_bus_device_type_get,\
		machine_bus_status_truedrive_set,\
		machine_bus_status_drivetype_set,\
		machine_bus_status_virtualdevices_set,\
		machine_bus_eof_callback_set,\
		machine_bus_attention_callback_set,\
		cbm2ui_init_early,\
		cbm2ui_init,\
		cbm2ui_shutdown,\
		cbm5x0ui_init_early,\
		cbm5x0ui_init,\
		cbm5x0ui_shutdown,\
		machine_drive_resources_init,\
		machine_drive_resources_shutdown,\
		machine_drive_cmdline_options_init,\
		machine_drive_init,\
		machine_drive_shutdown,\
		machine_drive_reset,\
		machine_drive_mem_init,\
		machine_drive_setup_context,\
		machine_drive_idling_method,\
		machine_drive_rom_load,\
		machine_drive_rom_setup_image,\
		machine_drive_rom_check_loaded,\
		machine_drive_rom_do_checksum,\
		machine_drive_snapshot_read,\
		machine_drive_snapshot_write,\
		machine_drive_image_attach,\
		machine_drive_image_detach,\
		machine_drive_port_default,\
		machine_drive_flush,\
		machine_drive_stub,\
		machine_drive_get_type_info_list,\
		vsid_ui_init_early,\
		vsid_ui_init,\
		vsid_ui_close,\
		vsid_ui_display_name,\
		vsid_ui_display_author,\
		vsid_ui_display_copyright,\
		vsid_ui_display_sync,\
		vsid_ui_display_sid_model,\
		vsid_ui_display_tune_nr,\
		vsid_ui_display_nr_of_tunes,\
		vsid_ui_set_default_tune,\
		vsid_ui_display_time,\
		vsid_ui_display_irqtype,\
		vsid_ui_setdrv,\
		vsid_ui_set_driver_addr,\
		vsid_ui_set_load_addr,\
		vsid_ui_set_init_addr,\
		vsid_ui_set_play_addr,\
		vsid_ui_set_data_size,\
		ps2mouse_resources_init,\
		ps2mouse_cmdline_options_init,\
		blockdev_init,\
		blockdev_resources_init,\
		blockdev_cmdline_options_init,\
		blockdev_open,\
		blockdev_close,\
		blockdev_read_sector,\
		blockdev_write_sector,\
		sound_init_sb_device,\
		sound_init_ce_device,\
		sound_init_vidc_device,\
		sound_init_beos_device,\
		sound_init_bsp_device,\
		sound_init_flac_device,\
		sound_init_vorbis_device,\
		sound_machine_dump_state,\
		sound_machine_prevent_clk_overflow,\
		sound_machine_enable,\
		iec_available_busses,\
		iec_update_ports_embedded,\
		iec_drive_write,\
		iec_drive_read,\
		parallel_cable_drive_write,\
		parallel_cable_drive_read,\
		iec_fast_drive_write,\
		iec_fast_drive_direction,\
		iec_update_cpu_bus,\
		iec_update_ports,\
		plus4tcbm_update_pa,\
		plus4tcbm_update_pb,\
		plus4tcbm_update_pc,\
		ui_display_statustext,\
		uimon_get_columns,\
		uimon_write_to_terminal,\
		uimon_get_string,\
		uimon_set_font,\
		uicolor_alloc_color,\
		uicolor_free_color,\
		uicolor_convert_color_table,\
		uicolor_set_palette,\
		uicolor_alloc_colors,\
		iecbus_drive_port,\
		cartridge_init,\
		cartridge_resources_init,\
		cartridge_cmdline_options_init,\
		cartridge_shutdown,\
		cartridge_resources_shutdown,\
		cartridge_init_config,\
		cartridge_detect,\
		cartridge_attach_image,\
		cartridge_enable,\
		cartridge_disable,\
		cartridge_detach_image,\
		cartridge_set_default,\
		cartridge_unset_default,\
		cartridge_reset,\
		cartridge_trigger_freeze,\
		cartridge_trigger_freeze_nmi_only,\
		cartridge_release_freeze,\
		cartridge_get_file_name,\
		cartridge_type_enabled,\
		cartridge_save_image,\
		cartridge_bin_save,\
		cartridge_crt_save,\
		cartridge_flush_image,\
		cartridge_can_flush_image,\
		cartridge_can_save_image,\
		cartridge_snapshot_read_modules,\
		cartridge_snapshot_write_modules,\
		cartridge_setup_context,\
		cartridge_peek_mem,\
		cartridge_mmu_translate,\
		cartridge_ram_init,\
		cartridge_sound_chip_init,\
		cartridge_get_info_list,\
		machine_trigger_flux_change,\
		machine_set_tape_sense,\
		machine_set_tape_write_in,\
		machine_set_tape_motor_in,\
		machine_sid2_enable,\
		sid_sound_chip_init,\
		gamepad_register,\
		mem_read,\
		mem_store};

	populate_callbacks (bindings);
}
#endif