//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


#ifndef JNIHELPERS_H_
#define JNIHELPERS_H_
#ifdef __cplusplus
extern "C" {
#endif
#include <jni.h>
#include "native_threading.h"
#ifndef NULL
#define NULL 0
#endif
jobject CurrentActivity();
jobject CallObjectMethod(jobject obj , jmethodID mid, ...);
jint CallIntMethod(jobject obj , jmethodID mid, ...);

__attribute__((unused)) jlong CallLongMethod(jobject obj , jmethodID mid, ...);
void CallVoidMethod(jobject obj , jmethodID mid, ...);
jclass GetObjectClass(jobject obj);
jstring NewStringUTF(const char* bytes);
jmethodID GetMethodID(jclass clsid, const char* name, const char* sig);
const char* GetStringUTFChars(jstring string, jboolean* isCopy);
void ReleaseStringUTFChars(jstring string, const char* utfchars);
jboolean CallBooleanMethod(jobject obj , jmethodID mid, ...);
#ifdef DEBUG
#endif
JNIEnv* getAactiveenv();
jbyteArray NewByteArray(jsize size);
void DeleteLocalRef(jobject ref);
void SetByteArrayRegion(jbyteArray array, jsize start, jsize len, void* buf);

__attribute__((unused)) jobject NewObject(jclass cls, jmethodID mth, ...);

__attribute__((unused)) void* getsymbol_native(char* funcname);
void callRun(JNIEnv* env, jobject runnable);
#ifdef __cplusplus
}
#endif
#endif /* JAVASTUBS_H_ */
