//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


#include <vice.h>
#include <stdlib.h>
#include <string.h>
#include <dlfcn.h>
#include <jni.h>
#include <pthread.h>
#include "logginghelpers.h"
#include "de_rainerhock_eightbitwonders_vice_ViceEmulation.h"
#include "native_threading.h"


static void* dynlib=NULL;
static void* dynlib_common=NULL;

static JNIEnv *mainenv = 0;

static pthread_t mainthread = 0;

static int functions_stopped=0;

JNIEXPORT jboolean JNICALL Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeStartEmulation
  (JNIEnv * env, jobject instance,jstring lib)
{
    jboolean ret = JNI_TRUE;
    jboolean isCopy;
	const char* libstr = (*env)->GetStringUTFChars(env, lib, &isCopy);
	if (dynlib)
	{
		LOGE("Library not unloaded");

	}
	if (dynlib_common) {
		dlclose(dynlib_common);
	}
	if (dynlib) {
		dlclose(dynlib);
	}
	dynlib=dlopen(strdup(libstr),RTLD_NOW);
	dynlib_common=dlopen(strdup("libviceshared.so"), RTLD_NOW);

    if (dynlib && dynlib_common) {
        functions_stopped=0;
		LOGV("Libraries loaded to %p, %p", dynlib, dynlib_common);
        ret = startthread(env, instance, libstr, dynlib, dynlib_common, mainenv, mainthread);
    }
    else
    {
        LOGE("No library loaded, Error: %s",dlerror());
    }
    if (!isCopy) {
        (*env)->ReleaseStringUTFChars(env, lib, libstr);
    }
    return ret;
}


JNIEXPORT void JNICALL
Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeCleanupEmulation(JNIEnv __unused *env,jobject __unused thiz)
{

	LOGV("Unloading libraries at %p and %p",dynlib, dynlib_common);
    functions_stopped=1;
    if (dynlib_common) {
        dlclose(dynlib_common);
        dynlib_common = NULL;
    }
    if (dynlib) {
        dlclose(dynlib);
        dynlib=NULL;
    }
}
static void* getsymbol_from_lib(__attribute__((unused)) JNIEnv * env,void* lib, char* str, int lastchance)
{
	return dlsym(lib,str);
}


static void* getsymbol(JNIEnv * env,jstring funcname) {
    char* str;
    void* ret;
    if (functions_stopped) {
        return NULL;
    }
    str= (char*)(*env)->GetStringUTFChars(env,funcname, NULL);
    ret = getsymbol_from_lib(env, dynlib_common, str, 0);
    if (!ret && dynlib) {
        ret = getsymbol_from_lib(env,dynlib,str, 1);
    }
    if (!ret) {
        LOGV("getsymbol: %s not found", str);
    }

    if (str) {
        (*env)->ReleaseStringUTFChars(env, funcname, str);
    }
    return ret;

}
JNIEXPORT void JNICALL Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeVoidFunc__Ljava_lang_String_2
  (JNIEnv * env, jobject __unused instance, jstring funcname)
{
	void(*func)(void)=getsymbol(env,funcname);
	if (func)
	{
		func();
	}

}
JNIEXPORT void JNICALL Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeVoidFunc__Ljava_lang_String_2II
  (JNIEnv * env, jobject __unused instance, jstring funcname, jint i1, jint i2)
{
	void(*func)(int,int)=getsymbol(env,funcname);
	if (func)
	{
		func(i1,i2);
	}
}
JNIEXPORT void JNICALL Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeVoidFunc__Ljava_lang_String_2III
  (JNIEnv  *env, jobject __unused instance , jstring funcname, jint i1, jint i2, jint i3)
{
	void(*func)(int,int,int)=getsymbol(env,funcname);
	if (func)
	{
		func(i1,i2,i3);
	}

}

JNIEXPORT jint JNICALL Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeIntFunc__Ljava_lang_String_2I
  (JNIEnv * env, jobject __unused instance, jstring funcname, jint i1)
{
	int ret=0;
	int(*func)(int)=getsymbol(env,funcname);

	if (func) {
		ret = func(i1);
	}
	return ret;
}
JNIEXPORT jint JNICALL Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeIntFunc__Ljava_lang_String_2ILjava_lang_String_2
  (JNIEnv * env, jobject __unused instance, jstring funcname, jint i1, jstring s2)
{
	int ret=0;
	int(*func)(int,const char*)=getsymbol(env,funcname);
	if (func) {
		const char *str = s2 != NULL ? (*env)->GetStringUTFChars(env, s2, NULL) : NULL;
		if (str) {
			ret = func(i1, str);
            (*env)->ReleaseStringUTFChars(env, s2, str);
		} else {
			ret = -1;
		}
	}
	return ret;
}
JNIEXPORT void JNICALL Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeVoidFunc__Ljava_lang_String_2I
  (JNIEnv * env, jobject __unused instance, jstring funcname, jint i1)
{
	void(*func)(int)=getsymbol(env,funcname);
	if (func) {
		func(i1);
	}
}
JNIEXPORT jint JNICALL Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeIntFunc__Ljava_lang_String_2Ljava_lang_String_2
  (JNIEnv * env, jobject __unused instance , jstring funcname, jstring s1)
{
	int ret=0;
	int(*func)(const char*)=getsymbol(env,funcname);
	if (func) {
		const char *str1 = s1 != NULL ? (*env)->GetStringUTFChars(env, s1, NULL) : NULL;
		if (s1) {
			ret = func(str1);
			(*env)->ReleaseStringUTFChars(env, s1, str1);
		}
	}
	return ret;

}
JNIEXPORT jint JNICALL Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeIntFunc__Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2II
  (JNIEnv * env, jobject __unused instance, jstring funcname,jstring s1, jstring s2, jint i1, jint i2)
{
	int ret=0;
	int(*func)(const char*,const char*,int,int)=getsymbol(env,funcname);
	if (func) {
		const char* str1= s1!=NULL?(*env)->GetStringUTFChars(env,s1, NULL):NULL;
		const char* str2= s2!=NULL?(*env)->GetStringUTFChars(env,s2, NULL):NULL;

		ret = func(str1, str2, i1, i2);
		if (s1) {
			(*env)->ReleaseStringUTFChars(env, s1, str1);
		}
		if (s2) {
			(*env)->ReleaseStringUTFChars(env, s2, str2);
		}
	}
	return ret;
}
JNIEXPORT jint JNICALL Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeIntFunc__Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2I
  (JNIEnv * env, jobject __unused instance, jstring funcname,jstring s1, jstring s2, jint i)
{
	int ret=0;
	int(*func)(const char*,const char*,int)=getsymbol(env,funcname);
	if (func) {
		const char *str1 = s1 != NULL ? (*env)->GetStringUTFChars(env, s1, NULL) : NULL;
		const char *str2 = s2 != NULL ? (*env)->GetStringUTFChars(env, s2, NULL) : NULL;
		ret = func(str1, str2, i);
		if (s1) {
			(*env)->ReleaseStringUTFChars(env, s1, str1);
		}
		if (s2) {
			(*env)->ReleaseStringUTFChars(env, s2, str2);
		}
	}
	return ret;
}
JNIEXPORT jint JNICALL Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeIntFunc__Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2I
  (JNIEnv * env, jobject __unused instance, jstring funcname,jstring s1, jstring s2, jstring s3, jint i1)
{
	int ret=0;
	int(*func)(const char*,const char*,const char*,int)=getsymbol(env,funcname);
	if (func) {
		const char *str1 = s1 != NULL ? (*env)->GetStringUTFChars(env, s1, NULL) : NULL;
		const char *str2 = s2 != NULL ? (*env)->GetStringUTFChars(env, s2, NULL) : NULL;
		const char *str3 = s3 != NULL ? (*env)->GetStringUTFChars(env, s3, NULL) : NULL;
		const char *f = funcname != NULL ? (*env)->GetStringUTFChars(env, funcname, NULL) : NULL;
		LOGD("Calling %s (%s,%s,%s,%d)", f, str1 ? str1 : "NULL", str2 ? str2 : "NULL",
			 str3 ? str3 : "NULL", i1);
		if (funcname) {
			(*env)->ReleaseStringUTFChars(env, funcname, f);
		}
		ret = func(str1, str2, str3, i1);
		LOGD("func returned %d", ret);
		if (s1) {
			(*env)->ReleaseStringUTFChars(env, s1, str1);
		}
		if (s2) {
			(*env)->ReleaseStringUTFChars(env, s2, str2);
		}
		if (s3) {
			(*env)->ReleaseStringUTFChars(env, s3, str3);
		}
	}
	return ret;
}

JNIEXPORT jint JNICALL Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeIntFunc__Ljava_lang_String_2
  (JNIEnv * env, jobject __unused instance , jstring funcname) {
	int ret = 0;
	int (*func)() =getsymbol(env, funcname);
	if (func)
	{
		ret = func();
	}
	return ret;

}

JNIEXPORT jbyteArray JNICALL Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeBytearrayFunc
  (JNIEnv * env, jobject __unused instance, jstring funcname,jboolean freeNative)
{
	char*(*func)()=getsymbol(env,funcname);
	jbyteArray ret=NULL;
	if (func) {
		char *data = func();
		ret = (*env)->NewByteArray(env, (jsize)strlen(data));
		(*env)->SetByteArrayRegion(env, ret, 0, (jsize)strlen(data), (const jbyte *) data);
		if (freeNative == JNI_TRUE) {
			free(data);
		}
	}
	return ret;
}
JNIEXPORT jint JNICALL Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeIntFunc__Ljava_lang_String_2Ljava_lang_String_2I
  (JNIEnv * env, jobject __unused instance, jstring funcname, jstring s1, jint i2)
{
	int ret=0;
	int(*func)(const char*,int)=getsymbol(env,funcname);
	if (func) {
		const char *str = s1 != NULL ? (*env)->GetStringUTFChars(env, s1, NULL) : NULL;
		if (str) {
			ret = func(str, i2);
            (*env)->ReleaseStringUTFChars(env, s1, str);
		} else {
			ret = -1;
		}
	}
	return ret;
}
JNIEXPORT jint JNICALL Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeIntFunc__Ljava_lang_String_2Ljava_lang_String_2III
  (JNIEnv * env, jobject __unused instance, jstring funcname , jstring s1, jint i2, jint i3, jint i4)
{
	int ret=0;
	int(*func)(const char*,int,int,int)=getsymbol(env,funcname);
	if (func) {
		const char *str = s1 != NULL ? (*env)->GetStringUTFChars(env, s1, NULL) : NULL;
		if (str) {
			ret = func(str, i2, i3, i4);
            (*env)->ReleaseStringUTFChars(env, s1, str);
		} else {
			ret = -1;
		}
	}
	return ret;
}
/*
JNIEXPORT jint JNICALL Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeCallCFunc_1I_1SO
  (JNIEnv * env, jobject instance, jstring funcname , jstring s, jobject obj)
{
	int ret=0;
	int(*func)(const char*,jobject)=getsymbol(env,funcname);
	const char* str=  s!=NULL?(*env)->GetStringUTFChars(env,s, NULL):NULL;
	if (str)
	{
		ret=func(str,obj);
		if (s)
		{
			(*env)->ReleaseStringUTFChars(env,s, str);
		}
	}
	else
	{
		ret=-1;
	}
	return ret;
}
*/
/*
JNIEXPORT void JNICALL Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeCallCFunc_1V_1SO
(JNIEnv * env, jobject instance, jstring funcname , jstring s, jobject obj)
{
	int(*func)(const char*,jobject)=getsymbol(env,funcname);
	const char* str=  s!=NULL?(*env)->GetStringUTFChars(env,s, NULL):NULL;
	if (str)
	{
		func(str,obj);
		if (s)
		{
			(*env)->ReleaseStringUTFChars(env,s, str);
		}
	}
}
*/
JNIEXPORT void JNICALL Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeVoidFunc__Ljava_lang_String_2Ljava_lang_String_2
(JNIEnv * env, jobject __unused instance, jstring funcname , jstring s)
{
	int(*func)(const char*)=getsymbol(env,funcname);
	if (func) {
		const char *str = s != NULL ? (*env)->GetStringUTFChars(env, s, NULL) : NULL;
		if (str) {
			func(str);
            (*env)->ReleaseStringUTFChars(env, s, str);
		}
	}
}

JNIEXPORT jstring JNICALL
Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeStringFunc__Ljava_lang_String_2I(JNIEnv *env,
																							 __unused jobject thiz,
																							 jstring funcname,
																							 jint i)
{
    char*(*func)(int)=getsymbol(env,funcname);
    if (func)
    {
        char* s=func(i);
        if (s)
        {
            return (*env)->NewStringUTF(env,s);
        }
    }
    return NULL;
}

__attribute__((unused)) JNIEXPORT jstring JNICALL
Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeCallCFunc_1S(JNIEnv *env,
																			__unused jobject thiz,
																			jstring funcname)
{
	char*(*func)()=getsymbol(env,funcname);
	if (func)
	{
		char* s=func();
		if (s)
		{
			char* d=strdup(s);
			return (*env)->NewStringUTF(env,d);
		}
	}
	return NULL;
}

JNIEXPORT jint JNICALL
Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeIntFunc__Ljava_lang_String_2IILjava_lang_String_2(JNIEnv *env,
																											  __unused jobject thiz,
																											  jstring funcname,
																											  jint val1, jint val2,
																											  jstring val3)
{
	int ret=0;
	int(*func)(int,int,const char*)=getsymbol(env,funcname);
	if (func) {
		const char *str = val3 != NULL ? (*env)->GetStringUTFChars(env, val3, NULL) : NULL;
		if (str) {
			ret = func(val1,val2, str);
            (*env)->ReleaseStringUTFChars(env, val3, str);
		} else {
			ret = -1;
		}
	}
	return ret;
}
JNIEXPORT jstring JNICALL
Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeStringFunc__Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2(JNIEnv *env,
																																  jobject __unused thiz,
																																  jstring funcname,
																																  jstring s1,
																																  jstring s2) {
    char*(*func)(char*,char*)=getsymbol(env,funcname);
    if (func)
    {
        jboolean isCopy1=JNI_FALSE;
        jboolean isCopy2=JNI_FALSE;

        const char *str1 = s1 != NULL ? (*env)->GetStringUTFChars(env, s1, &isCopy1) : NULL;
        const char *str2 = s2 != NULL ? (*env)->GetStringUTFChars(env, s2, &isCopy2) : NULL;
        if (str1 && str2) {
            const char* cret=func((char*)str1, (char*)str2);
            if (!isCopy1) {
                (*env)->ReleaseStringUTFChars(env, s1, str1);
            }
            if (!isCopy2) {
                (*env)->ReleaseStringUTFChars(env, s2, str1);
            }
            return (*env)->NewStringUTF(env,cret);
        }

    }
    return NULL;

}
JNIEXPORT jint JNICALL
Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeGetFiletype(JNIEnv *env, __unused jclass  clazz,
												jstring library,
												jstring function,
												jstring path) {
	const char* library_string = (*env)->GetStringUTFChars(env, library, NULL);
	const char* function_string = (*env)->GetStringUTFChars(env, function,NULL);
	const char* path_string = (*env)->GetStringUTFChars(env, path, NULL);

	int(*func)(char*);
	int ret = 0;

	void* static_dynlib=dlopen(strdup(library_string), RTLD_NOW | RTLD_GLOBAL);
	if (static_dynlib) {
		func=dlsym(static_dynlib, function_string);
		if (func){
			ret = func((char*)path_string);
		}
		dlclose(static_dynlib);
	}
	(*env)->ReleaseStringUTFChars(env, library, library_string);
	(*env)->ReleaseStringUTFChars(env, function, function_string);
	(*env)->ReleaseStringUTFChars(env, path, path_string);

	return ret;
}

JNIEXPORT void JNICALL
Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeVoidFunc__Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_Object_2(
		JNIEnv *env, __attribute__((unused)) jobject thiz, jstring funcname, jstring val, jobject obj) {

	int(*func)(const char*, jobject)=getsymbol(env,funcname);
	if (func) {
		const char *str = val != NULL ? (*env)->GetStringUTFChars(env, val, NULL) : NULL;
		jobject global = obj ? (*env)->NewGlobalRef(env, obj) : NULL;
		func(str, global);
		if (val) {
			(*env)->ReleaseStringUTFChars(env, val, str);
		}
		if (global) {
			(*env)->DeleteGlobalRef(env, global);
		}
	}
}

JNIEXPORT void JNICALL
Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeVoidFunc__Ljava_lang_String_2Ljava_lang_Object_2(
        JNIEnv *env, __attribute__((unused)) jobject thiz, jstring funcname, jobject obj) {
	int(*func)(jobject)=getsymbol(env,funcname);
	if (func) {
		jobject global = obj ? (*env)->NewGlobalRef(env, obj) : NULL;
		func(global);
		if (global) {
			(*env)->DeleteGlobalRef(env, global);
		}
	}

}

JNIEXPORT void JNICALL
Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeSetUiThread(JNIEnv *env,
                                                                        __attribute__((unused)) jobject thiz) {
	mainenv = env;
	mainthread = pthread_self();

}

JNIEXPORT void JNICALL
Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeVoidFunc__Ljava_lang_String_2ILjava_lang_Runnable_2(
        JNIEnv *env, __attribute__((unused)) jobject thiz, jstring funcname, jint val, jobject runnable) {
	int(*func)(int, jobject)=getsymbol(env,funcname);
	if (func) {
		jobject global = runnable ? (*env)->NewGlobalRef(env, runnable) : NULL;
		func(val, global);
		if (global) {
			(*env)->DeleteGlobalRef(env, global);
		}
	}

}

JNIEXPORT jbyteArray JNICALL
Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeBytearrayFunc2(JNIEnv *env,
                                                                           __attribute__((unused)) jobject thiz,
																		   jstring funcname,
																		   jint i,
																		   jboolean free_native_returnvalue) {
	void(*func)(jint, jbyte**, int*)=getsymbol(env,funcname);
	jbyte* data;
	int size;
	jbyteArray ret=NULL;
	if (func) {
		func(i, &data, &size);
		if (data && (size > 0)) {
			ret = (*env)->NewByteArray(env, (jsize) size);
			if (ret) {
				LOGV("SetByteArrayRegion (%p, %d)", data, size);
				(*env)->SetByteArrayRegion(env, ret, 0, (jsize) size, data);
			}
		}
		if (free_native_returnvalue == JNI_TRUE) {
			free(data);
		}
	}
	return ret;
}

JNIEXPORT int JNICALL
Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeIntFunc__Ljava_lang_String_2ILjava_lang_String_2Ljava_lang_Runnable_2(
        JNIEnv *env, __attribute__((unused)) jobject thiz, jstring funcname, jint val1,
        jstring val2, jobject runnable) {
    int ret = 0;
    int (*func)(int, const char *, jobject) =getsymbol(env, funcname);
    if (func) {
        jobject global = runnable ? (*env)->NewGlobalRef(env, runnable) : NULL;
        const char *str = val2 != NULL ? (*env)->GetStringUTFChars(env, val2, NULL) : NULL;
        if (str && global) {
            ret = func(val1, val2, global);
        }
        if (global) {
            (*env)->DeleteGlobalRef(env, global);
        }
        if (str) {
            (*env)->ReleaseStringUTFChars(env, val2, str);
        }
    }
    return ret;
}

JNIEXPORT void JNICALL
Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeVoidFunc__Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_Runnable_2Ljava_lang_Runnable_2(
        JNIEnv *env, __attribute__((unused)) jobject thiz, jstring funcname, jstring val, jobject runnable1,
        jobject runnable2) {
    int(*func)(char*, jobject, jobject)=getsymbol(env,funcname);
    if (func) {
        jobject global1 = runnable1 ? (*env)->NewGlobalRef(env, runnable1) : NULL;
        jobject global2 = runnable2 ? (*env)->NewGlobalRef(env, runnable2) : NULL;
        char *str = val != NULL ? (char*)(*env)->GetStringUTFChars(env, val, NULL) : NULL;
        if (val) {
            func(str, global1, global2);
        }
        if (global1) {
            (*env)->DeleteGlobalRef(env, global1);
        }
        if (global2) {
            (*env)->DeleteGlobalRef(env, global2);
        }

        if (val) {
            (*env)->ReleaseStringUTFChars(env, val, str);
        }
    }
}

JNIEXPORT void JNICALL
Java_de_rainerhock_eightbitwonders_vice_ViceEmulation_nativeVoidFunc__Ljava_lang_String_2FF(
        JNIEnv *env, __attribute__((unused)) jobject thiz, jstring funcname, jfloat f1, jfloat f2) {
    void(*func)(float,float)=getsymbol(env,funcname);
    if (func)
    {
        func(f1,f2);
    }
}