//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------

#include <string.h>
#include <malloc.h>
#include "archdep_user_config_path.h"
#include "archdep_home_path.h"
#include "jnihelpers.h"
static char* config_path=NULL;
static char* home_path=NULL;
static char* getValue(char* methodname)
{
    char* ret=NULL;
    jmethodID method=GetMethodID(GetObjectClass(CurrentActivity()),methodname,"()Ljava/lang/String;");
    jobject obj=CallObjectMethod(CurrentActivity(),method);
    jboolean isCopy;
    char* s=(char*)GetStringUTFChars((jstring)obj,&isCopy);
    if (s)
    {
        ret=strdup(s);
    }
    if (!isCopy) {
        ReleaseStringUTFChars(obj, s);
    }
    return ret;
}

char *archdep_user_config_path(void) {
    if (!config_path)
    {
        config_path=getValue("getUserConfigPath");

    }
    return config_path;

}
char* archdep_home;
void  archdep_user_config_path_free(void)
{
    if (config_path)
    {
        free(config_path);
    }
}
const char *archdep_home_path(void)
{
    if (!home_path)
    {
        home_path=getValue("getHomePath");
    }
    return home_path;
}
void        archdep_home_path_free(void)
{
    if (home_path)
    {
        free(home_path);
    }
}
