//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


#ifndef EIGHTBITWONDERS_GEN_MACHINE_SPECIFIC_BINDINGS_H
#define EIGHTBITWONDERS_GEN_MACHINE_SPECIFIC_BINDINGS_H
#include "gfxoutput.h"
#include "vic20ui.h"
#include "main.h"
#include "flash040.h"
#include "cbmimage.h"
#include "vicii.h"
#include "debug.h"
#include "version.h"
#include "fixpoint.h"
#include "mem.h"
#include "mididrv.h"
#include "ioutil.h"
#include "palette.h"
#include "riot.h"
#include "machine-printer.h"
#include "network.h"
#include "opencbmlib.h"
#include "clkguard.h"
#include "dynlib.h"
#include "uicmdline.h"
#include "vsyncapi.h"
#include "vicemaxpath.h"
#include "ssi2001.h"
#include "zipcode.h"
#include "dma.h"
#include "machine-video.h"
#include "config.android.h"
#include "video.h"
#include "maincpu.h"
#include "vicesocket.h"
#include "sysfile.h"
#include "wdc65816.h"
#include "resources.h"
#include "c128ui.h"
#include "snapshot.h"
#include "keyboard.h"
#include "mos6510dtv.h"
#include "parsid.h"
#include "traps.h"
#include "via.h"
#include "machine.h"
#include "charset.h"
#include "types.h"
#include "viewport.h"
#include "vice-event.h"
#include "zfile.h"
#include "cmdline.h"
#include "trans.h"
#include "c64ui.h"
#include "mainc64cpu.h"
#include "r65c02.h"
#include "ide-config.h"
#include "catweaselmkiii.h"
#include "fliplist.h"
#include "kbdbuf.h"
#include "vicefeatures.h"
#include "findpath.h"
#include "piacore.h"
#include "ide-siddefs.h"
#include "h6809regs.h"
#include "mainlock.h"
#include "6510core.h"
#include "petui.h"
#include "diskimage.h"
#include "ram.h"
#include "color.h"
#include "init.h"
#include "vsync.h"
#include "rawfile.h"
#include "sidcart.h"
#include "export.h"
#include "tape.h"
#include "cartio.h"
#include "embedded.h"
#include "lib.h"
#include "parallel.h"
#include "romset.h"
#include "diskconstants.h"
#include "imagecontents.h"
#include "tpi.h"
#include "machine-bus.h"
#include "cbm2ui.h"
#include "log.h"
#include "autostart-prg.h"
#include "util.h"
#include "machine-drive.h"
#include "vice.h"
#include "monitor.h"
#include "vsidui.h"
#include "printer.h"
#include "ps2mouse.h"
#include "blockdev.h"
#include "libm_math.h"
#include "sound.h"
#include "initcmdline.h"
#include "tick.h"
#include "iecdrive.h"
#include "uiapi.h"
#include "plus4ui.h"
#include "cbmdos.h"
#include "uimon.h"
#include "uicolor.h"
#include "clipboard.h"
#include "z80regs.h"
#include "acia.h"
#include "autostart.h"
#include "interrupt.h"
#include "serial.h"
#include "alarm.h"
#include "iecbus.h"
#include "fileio.h"
#include "screenshot.h"
#include "mos6510.h"
#include "midi.h"
#include "crc32.h"
#include "attach.h"
#include "fsdevice.h"
#include "cartridge.h"
#include "datasette-sound.h"
#include "datasette.h"
#include "sid.h"
#include "wave8580.h"
#include "fastsid.h"
#include "sid-cmdline-options.h"
#include "sid-snapshot.h"
#include "wave6581.h"
#include "archdep_default_rtc_file_name.h"
#include "javascript.h"
#include "archdep_user_config_path.h"
#include "archdep_default_logger.h"
#include "archdep_defs.h"
#include "archdep_join_paths.h"
#include "javascript_callbacks.h"
#include "archdep_is_haiku.h"
#include "archdep_quote_unzip.h"
#include "archdep_exit.h"
#include "archdep_startup_log_error.h"
#include "archdep_sound.h"
#include "gamepad.h"
#include "archdep_default_portable_resource_file_name.h"
#include "archdep_boot_path.h"
#include "archdep_rmdir.h"
#include "archdep_extra_title_text.h"
#include "archdep_stat.h"
#include "archdep_rename.h"
#include "archdep_home_path.h"
#include "archdep_kbd_get_host_mapping.h"
typedef struct {
	int(*main_program)(int argc, char **argv);
	void(*main_exit)(void);
	struct raster_s*(*vicii_init)(unsigned int flag);
	void(*mem_initialize_memory)(void);
	void(*mem_powerup)(void);
	int(*mem_load)(void);
	void(*mem_get_basic_text)(uint16_t *start, uint16_t *end);
	void(*mem_set_basic_text)(uint16_t start, uint16_t end);
	void(*mem_toggle_watchpoints)(int flag, void *context);
	int(*mem_rom_trap_allowed)(uint16_t addr);
	void(*mem_mmu_translate)(unsigned int addr, uint8_t **base, int *start, int *limit);
	void(*mem_color_ram_to_snapshot)(uint8_t *color_ram);
	void(*mem_color_ram_from_snapshot)(uint8_t *color_ram);
	uint8_t(*mem_read_screen)(uint16_t addr);
	void(*mem_inject)(uint32_t addr, uint8_t value);
	void(*mem_inject_key)(uint16_t addr, uint8_t value);
	const char**(*mem_bank_list)(void);
	const int*(*mem_bank_list_nos)(void);
	int(*mem_bank_from_name)(const char *name);
	int(*mem_bank_index_from_bank)(int bank);
	int(*mem_bank_flags_from_bank)(int bank);
	uint8_t(*mem_bank_read)(int bank, uint16_t addr, void *context);
	uint8_t(*mem_bank_peek)(int bank, uint16_t addr, void *context);
	void(*mem_bank_write)(int bank, uint16_t addr, uint8_t byte, void *context);
	void(*mem_bank_poke)(int bank, uint16_t addr, uint8_t byte, void *context);
	void(*mem_get_screen_parameter)(uint16_t *base, uint8_t *rows, uint8_t *columns, int *bank);
	void(*mem_get_cursor_parameter)(uint16_t *screen_addr, uint8_t *cursor_column, uint8_t *line_length, int *blinking);
	mem_ioreg_list_t*(*mem_ioreg_list_get)(void *context);
	int(*mem_write_snapshot_module)(struct snapshot_s *s, int save_roms);
	int(*mem_read_snapshot_module)(struct snapshot_s *s);
	void(*mididrv_init)(void);
	int(*mididrv_in_open)(void);
	int(*mididrv_out_open)(void);
	void(*mididrv_in_close)(void);
	void(*mididrv_out_close)(void);
	int(*mididrv_in)(uint8_t *b);
	void(*mididrv_out)(uint8_t b);
	int(*mididrv_resources_init)(void);
	void(*mididrv_resources_shutdown)(void);
	int(*mididrv_cmdline_options_init)(void);
	void(*machine_printer_setup_context)(struct machine_context_s *machine_context);
	int(*machine_printer_resources_init)(void);
	void(*machine_printer_resources_shutdown)(void);
	int(*machine_printer_cmdline_options_init)(void);
	void(*machine_printer_init)(void);
	void(*machine_printer_shutdown)(void);
	void(*vsyncarch_advance_frame)(void);
	int(*vsyncarch_vbl_sync_enabled)(void);
	int(*ssi2001_drv_open)(void);
	int(*ssi2001_drv_close)(void);
	int(*ssi2001_drv_read)(uint16_t addr, int chipno);
	void(*ssi2001_drv_store)(uint16_t addr, uint8_t val, int chipno);
	int(*ssi2001_drv_available)(void);
	int(*machine_video_resources_init)(void);
	void(*machine_video_init)(void);
	struct video_canvas_s*(*machine_video_canvas_get)(unsigned int window);
	void(*video_canvas_map)(struct video_canvas_s *canvas);
	void(*video_canvas_unmap)(__unused struct video_canvas_s *canvas);
	void(*maincpu_resync_limits)(void);
	void(*maincpu_init)(void);
	void(*maincpu_early_init)(void);
	void(*maincpu_shutdown)(void);
	void(*maincpu_reset)(void);
	void(*maincpu_mainloop)(void);
	struct monitor_interface_s*(*maincpu_monitor_interface_get)(void);
	int(*maincpu_snapshot_read_module)(struct snapshot_s *s);
	int(*maincpu_snapshot_write_module)(struct snapshot_s *s);
	void(*maincpu_set_pc)(int p0);
	void(*maincpu_set_a)(int p0);
	void(*maincpu_set_x)(int p0);
	void(*maincpu_set_y)(int p0);
	void(*maincpu_set_sign)(int p0);
	void(*maincpu_set_zero)(int p0);
	void(*maincpu_set_carry)(int p0);
	void(*maincpu_set_interrupt)(int p0);
	unsigned int(*maincpu_get_pc)(void);
	unsigned int(*maincpu_get_a)(void);
	unsigned int(*maincpu_get_x)(void);
	unsigned int(*maincpu_get_y)(void);
	unsigned int(*maincpu_get_sp)(void);
	int(*parsid_drv_open)(void);
	void(*parsid_drv_out_ctr)(uint8_t parsid_ctrport, int chipno);
	uint8_t(*parsid_drv_in_ctr)(int chipno);
	int(*parsid_drv_close)(void);
	uint8_t(*parsid_drv_in_data)(int chipno);
	void(*parsid_drv_out_data)(uint8_t addr, int chipno);
	void(*parsid_drv_sleep)(int amount);
	int(*parsid_drv_available)(void);
	int(*machine_resources_init)(void);
	void(*machine_resources_shutdown)(void);
	int(*machine_cmdline_options_init)(void);
	void(*machine_setup_context)(void);
	int(*machine_specific_init)(void);
	void(*machine_specific_reset)(void);
	void(*machine_specific_powerup)(void);
	void(*machine_specific_shutdown)(void);
	void(*machine_set_restore_key)(int v);
	int(*machine_has_restore_key)(void);
	long(*machine_get_cycles_per_second)(void);
	long(*machine_get_cycles_per_frame)(void);
	void(*machine_set_cycles_per_frame)(long cpf);
	void(*machine_get_line_cycle)(unsigned int *line, unsigned int *cycle, int *half_cycle);
	int(*machine_write_snapshot)(const char *name, int save_roms,int save_disks, int even_mode);
	int(*machine_read_snapshot)(const char *name, int even_mode);
	void(*machine_handle_pending_alarms)(int num_write_cycles);
	int(*machine_autodetect_psid)(const char *name);
	void(*machine_play_psid)(int tune);
	int(*machine_sid2_check_range)(unsigned int sid_adr);
	int(*machine_sid3_check_range)(unsigned int sid_adr);
	int(*machine_sid4_check_range)(unsigned int sid_adr);
	int(*machine_sid5_check_range)(unsigned int sid_adr);
	int(*machine_sid6_check_range)(unsigned int sid_adr);
	int(*machine_sid7_check_range)(unsigned int sid_adr);
	int(*machine_sid8_check_range)(unsigned int sid_adr);
	void(*machine_change_timing)(int timeval, int border_mode);
	int(*machine_screenshot)(struct screenshot_s *screenshot,struct video_canvas_s *canvas);
	int(*machine_canvas_async_refresh)(struct canvas_refresh_s *ref,struct video_canvas_s *canvas);
	void(*machine_update_memory_ptrs)(void);
	struct image_contents_s*(*machine_diskcontents_bus_read)(unsigned int unit);
	void(*machine_romset_init)(void);
	int(*machine_romset_file_load)(const char *filename);
	int(*machine_romset_file_save)(const char *filename);
	char*(*machine_romset_file_list)(void);
	int(*machine_romset_archive_item_create)(const char *romset_name);
	uint8_t(*machine_tape_type_default)(void);
	uint8_t(*machine_tape_behaviour)(void);
	int(*machine_addr_in_ram)(unsigned int addr);
	const char*(*machine_get_name)(void);
	int(*machine_get_num_keyboard_types)(void);
	kbdtype_info_t*(*machine_get_keyboard_info_list)(void);
	int(*machine_get_keyboard_type)(void);
	char*(*machine_get_keyboard_type_name)(int type);
	int(*machine_register_userport)(void);
	int(*c64scui_init_early)(void);
	int(*c64dtvui_init_early)(void);
	int(*c64dtvui_init)(void);
	void(*c64dtvui_shutdown)(void);
	int(*catweaselmkiii_drv_open)(void);
	int(*catweaselmkiii_drv_close)(void);
	int(*catweaselmkiii_drv_read)(uint16_t addr, int chipno);
	void(*catweaselmkiii_drv_store)(uint16_t addr, uint8_t val, int chipno);
	void(*catweaselmkiii_drv_set_machine_parameter)(long cycles_per_sec);
	int(*catweaselmkiii_drv_available)(void);
	void(*disk_image_rawimage_name_set)(disk_image_t *image, const char *name);
	void(*disk_image_rawimage_driver_name_set)(disk_image_t *image);
	int(*sidcart_cmdline_options_init)(void);
	int(*sidcart_resources_init)(void);
	int(*sidcart_enabled)(void);
	void(*sidcart_sound_chip_init)(void);
	void(*sidcart_detach)(void);
	int(*sidcart_snapshot_write_module)(snapshot_t *s);
	int(*sidcart_snapshot_read_module)(snapshot_t *s);
	export_list_t*(*export_query_list)(export_list_t *item);
	void(*export_dump)(void);
	int(*export_add)(const export_resource_t *export_res);
	int(*export_remove)(const export_resource_t *export_res);
	int(*export_resources_init)(void);
	uint8_t(*c64io_d000_read)(uint16_t addr);
	uint8_t(*c64io_d000_peek)(uint16_t addr);
	void(*c64io_d000_store)(uint16_t addr, uint8_t value);
	uint8_t(*c64io_d100_read)(uint16_t addr);
	uint8_t(*c64io_d100_peek)(uint16_t addr);
	void(*c64io_d100_store)(uint16_t addr, uint8_t value);
	uint8_t(*c64io_d200_read)(uint16_t addr);
	uint8_t(*c64io_d200_peek)(uint16_t addr);
	void(*c64io_d200_store)(uint16_t addr, uint8_t value);
	uint8_t(*c64io_d300_read)(uint16_t addr);
	uint8_t(*c64io_d300_peek)(uint16_t addr);
	void(*c64io_d300_store)(uint16_t addr, uint8_t value);
	uint8_t(*c64io_d400_read)(uint16_t addr);
	uint8_t(*c64io_d400_peek)(uint16_t addr);
	void(*c64io_d400_store)(uint16_t addr, uint8_t value);
	uint8_t(*c64io_d500_read)(uint16_t addr);
	uint8_t(*c64io_d500_peek)(uint16_t addr);
	void(*c64io_d500_store)(uint16_t addr, uint8_t value);
	uint8_t(*c64io_d600_read)(uint16_t addr);
	uint8_t(*c64io_d600_peek)(uint16_t addr);
	void(*c64io_d600_store)(uint16_t addr, uint8_t value);
	uint8_t(*c64io_d700_read)(uint16_t addr);
	uint8_t(*c64io_d700_peek)(uint16_t addr);
	void(*c64io_d700_store)(uint16_t addr, uint8_t value);
	uint8_t(*c64io_de00_read)(uint16_t addr);
	uint8_t(*c64io_de00_peek)(uint16_t addr);
	void(*c64io_de00_store)(uint16_t addr, uint8_t value);
	uint8_t(*c64io_df00_read)(uint16_t addr);
	uint8_t(*c64io_df00_peek)(uint16_t addr);
	void(*c64io_df00_store)(uint16_t addr, uint8_t value);
	uint8_t(*vic20io0_read)(uint16_t addr);
	uint8_t(*vic20io0_peek)(uint16_t addr);
	void(*vic20io0_store)(uint16_t addr, uint8_t value);
	uint8_t(*vic20io2_read)(uint16_t addr);
	uint8_t(*vic20io2_peek)(uint16_t addr);
	void(*vic20io2_store)(uint16_t addr, uint8_t value);
	uint8_t(*vic20io3_read)(uint16_t addr);
	uint8_t(*vic20io3_peek)(uint16_t addr);
	void(*vic20io3_store)(uint16_t addr, uint8_t value);
	uint8_t(*cbm2io_d800_read)(uint16_t addr);
	uint8_t(*cbm2io_d800_peek)(uint16_t addr);
	void(*cbm2io_d800_store)(uint16_t addr, uint8_t value);
	uint8_t(*cbm2io_d900_read)(uint16_t addr);
	uint8_t(*cbm2io_d900_peek)(uint16_t addr);
	void(*cbm2io_d900_store)(uint16_t addr, uint8_t value);
	uint8_t(*cbm2io_da00_read)(uint16_t addr);
	uint8_t(*cbm2io_da00_peek)(uint16_t addr);
	void(*cbm2io_da00_store)(uint16_t addr, uint8_t value);
	uint8_t(*cbm2io_db00_read)(uint16_t addr);
	uint8_t(*cbm2io_db00_peek)(uint16_t addr);
	void(*cbm2io_db00_store)(uint16_t addr, uint8_t value);
	uint8_t(*cbm2io_dc00_read)(uint16_t addr);
	uint8_t(*cbm2io_dc00_peek)(uint16_t addr);
	void(*cbm2io_dc00_store)(uint16_t addr, uint8_t value);
	uint8_t(*cbm2io_dd00_read)(uint16_t addr);
	uint8_t(*cbm2io_dd00_peek)(uint16_t addr);
	void(*cbm2io_dd00_store)(uint16_t addr, uint8_t value);
	uint8_t(*cbm2io_de00_read)(uint16_t addr);
	uint8_t(*cbm2io_de00_peek)(uint16_t addr);
	void(*cbm2io_de00_store)(uint16_t addr, uint8_t value);
	uint8_t(*cbm2io_df00_read)(uint16_t addr);
	uint8_t(*cbm2io_df00_peek)(uint16_t addr);
	void(*cbm2io_df00_store)(uint16_t addr, uint8_t value);
	uint8_t(*petio_8800_read)(uint16_t addr);
	uint8_t(*petio_8800_peek)(uint16_t addr);
	void(*petio_8800_store)(uint16_t addr, uint8_t value);
	uint8_t(*petio_8900_read)(uint16_t addr);
	uint8_t(*petio_8900_peek)(uint16_t addr);
	void(*petio_8900_store)(uint16_t addr, uint8_t value);
	uint8_t(*petio_8a00_read)(uint16_t addr);
	uint8_t(*petio_8a00_peek)(uint16_t addr);
	void(*petio_8a00_store)(uint16_t addr, uint8_t value);
	uint8_t(*petio_8b00_read)(uint16_t addr);
	uint8_t(*petio_8b00_peek)(uint16_t addr);
	void(*petio_8b00_store)(uint16_t addr, uint8_t value);
	uint8_t(*petio_8c00_read)(uint16_t addr);
	uint8_t(*petio_8c00_peek)(uint16_t addr);
	void(*petio_8c00_store)(uint16_t addr, uint8_t value);
	uint8_t(*petio_8d00_read)(uint16_t addr);
	uint8_t(*petio_8d00_peek)(uint16_t addr);
	void(*petio_8d00_store)(uint16_t addr, uint8_t value);
	uint8_t(*petio_8e00_read)(uint16_t addr);
	uint8_t(*petio_8e00_peek)(uint16_t addr);
	void(*petio_8e00_store)(uint16_t addr, uint8_t value);
	uint8_t(*petio_8f00_read)(uint16_t addr);
	uint8_t(*petio_8f00_peek)(uint16_t addr);
	void(*petio_8f00_store)(uint16_t addr, uint8_t value);
	uint8_t(*petio_e900_read)(uint16_t addr);
	uint8_t(*petio_e900_peek)(uint16_t addr);
	void(*petio_e900_store)(uint16_t addr, uint8_t value);
	uint8_t(*petio_ea00_read)(uint16_t addr);
	uint8_t(*petio_ea00_peek)(uint16_t addr);
	void(*petio_ea00_store)(uint16_t addr, uint8_t value);
	uint8_t(*petio_eb00_read)(uint16_t addr);
	uint8_t(*petio_eb00_peek)(uint16_t addr);
	void(*petio_eb00_store)(uint16_t addr, uint8_t value);
	uint8_t(*petio_ec00_read)(uint16_t addr);
	uint8_t(*petio_ec00_peek)(uint16_t addr);
	void(*petio_ec00_store)(uint16_t addr, uint8_t value);
	uint8_t(*petio_ed00_read)(uint16_t addr);
	uint8_t(*petio_ed00_peek)(uint16_t addr);
	void(*petio_ed00_store)(uint16_t addr, uint8_t value);
	uint8_t(*petio_ee00_read)(uint16_t addr);
	uint8_t(*petio_ee00_peek)(uint16_t addr);
	void(*petio_ee00_store)(uint16_t addr, uint8_t value);
	uint8_t(*petio_ef00_read)(uint16_t addr);
	uint8_t(*petio_ef00_peek)(uint16_t addr);
	void(*petio_ef00_store)(uint16_t addr, uint8_t value);
	uint8_t(*plus4io_fd00_read)(uint16_t addr);
	uint8_t(*plus4io_fd00_peek)(uint16_t addr);
	void(*plus4io_fd00_store)(uint16_t addr, uint8_t value);
	uint8_t(*plus4io_fe00_read)(uint16_t addr);
	uint8_t(*plus4io_fe00_peek)(uint16_t addr);
	void(*plus4io_fe00_store)(uint16_t addr, uint8_t value);
	void(*io_source_ioreg_add_list)(struct mem_ioreg_list_s **mem_ioreg_list);
	io_source_list_t*(*io_source_register)(io_source_t *device);
	void(*io_source_unregister)(io_source_list_t *device);
	void(*cartio_shutdown)(void);
	void(*c64io_vicii_init)(void);
	void(*c64io_vicii_deinit)(void);
	void(*c64io_vicii_reinit)(void);
	int(*cartio_resources_init)(void);
	int(*cartio_cmdline_options_init)(void);
	void(*cartio_set_highest_order)(unsigned int nr);
	void(*machine_bus_init_machine)(void);
	int(*machine_bus_lib_directory)(unsigned int unit, const char *pattern,uint8_t **buf);
	int(*machine_bus_lib_read_sector)(unsigned int unit, unsigned int track,unsigned int sector, uint8_t *buf);
	int(*machine_bus_lib_write_sector)(unsigned int unit, unsigned int track,unsigned int sector, uint8_t *buf);
	unsigned int(*machine_bus_device_type_get)(unsigned int unit);
	void(*machine_bus_status_truedrive_set)(unsigned int enable);
	void(*machine_bus_status_drivetype_set)(unsigned int unit,unsigned int enable);
	void(*machine_bus_status_virtualdevices_set)(unsigned int enable);
	void(*machine_bus_eof_callback_set)(void (*func)(void));
	void(*machine_bus_attention_callback_set)(void (*func)(void));
	int(*cbm2ui_init_early)(void);
	int(*cbm2ui_init)(void);
	void(*cbm2ui_shutdown)(void);
	int(*cbm5x0ui_init_early)(void);
	int(*cbm5x0ui_init)(void);
	void(*cbm5x0ui_shutdown)(void);
	int(*machine_drive_resources_init)(void);
	void(*machine_drive_resources_shutdown)(void);
	int(*machine_drive_cmdline_options_init)(void);
	void(*machine_drive_init)(struct diskunit_context_s *drv);
	void(*machine_drive_shutdown)(struct diskunit_context_s *drv);
	void(*machine_drive_reset)(struct diskunit_context_s *drv);
	void(*machine_drive_mem_init)(struct diskunit_context_s *drv, unsigned int type);
	void(*machine_drive_setup_context)(struct diskunit_context_s *drv);
	void(*machine_drive_idling_method)(unsigned int dnr);
	void(*machine_drive_rom_load)(void);
	void(*machine_drive_rom_setup_image)(unsigned int dnr);
	int(*machine_drive_rom_check_loaded)(unsigned int type);
	void(*machine_drive_rom_do_checksum)(unsigned int dnr);
	int(*machine_drive_snapshot_read)(struct diskunit_context_s *ctxptr, struct snapshot_s *s);
	int(*machine_drive_snapshot_write)(struct diskunit_context_s *ctxptr, struct snapshot_s *s);
	int(*machine_drive_image_attach)(struct disk_image_s *image, unsigned int unit, unsigned int drive);
	int(*machine_drive_image_detach)(struct disk_image_s *image, unsigned int unit, unsigned int drive);
	void(*machine_drive_port_default)(struct diskunit_context_s *drv);
	void(*machine_drive_flush)(void);
	void(*machine_drive_stub)(void);
	struct drive_type_info_s*(*machine_drive_get_type_info_list)(void);
	int(*vsid_ui_init_early)(void);
	int(*vsid_ui_init)(void);
	void(*vsid_ui_close)(void);
	void(*vsid_ui_display_name)(__unused const char *name);
	void(*vsid_ui_display_author)(__unused const char *author);
	void(*vsid_ui_display_copyright)(__unused const char *copyright);
	void(*vsid_ui_display_sync)(int sync);
	void(*vsid_ui_display_sid_model)(int model);
	void(*vsid_ui_display_tune_nr)(int nr);
	void(*vsid_ui_display_nr_of_tunes)(int count);
	void(*vsid_ui_set_default_tune)(int nr);
	void(*vsid_ui_display_time)(unsigned int sec);
	void(*vsid_ui_display_irqtype)(const char *irq);
	void(*vsid_ui_setdrv)(char* driver_info_text);
	void(*vsid_ui_set_driver_addr)(uint16_t addr);
	void(*vsid_ui_set_load_addr)(uint16_t addr);
	void(*vsid_ui_set_init_addr)(uint16_t addr);
	void(*vsid_ui_set_play_addr)(uint16_t addr);
	void(*vsid_ui_set_data_size)(uint16_t size);
	int(*ps2mouse_resources_init)(void);
	int(*ps2mouse_cmdline_options_init)(void);
	void(*blockdev_init)(void);
	int(*blockdev_resources_init)(void);
	int(*blockdev_cmdline_options_init)(void);
	int(*blockdev_open)(const char *name, unsigned int *read_only);
	int(*blockdev_close)(void);
	int(*blockdev_read_sector)(BYTE *buf, unsigned int track,unsigned int sector);
	int(*blockdev_write_sector)(const BYTE *buf, unsigned int track,unsigned int sector);
	int(*sound_init_sb_device)(void);
	int(*sound_init_ce_device)(void);
	int(*sound_init_vidc_device)(void);
	int(*sound_init_beos_device)(void);
	int(*sound_init_bsp_device)(void);
	int(*sound_init_flac_device)(void);
	int(*sound_init_vorbis_device)(void);
	char*(*sound_machine_dump_state)(sound_t *psid);
	void(*sound_machine_prevent_clk_overflow)(sound_t *psid, CLOCK sub);
	void(*sound_machine_enable)(int enable);
	int(*iec_available_busses)(void);
	void(*iec_update_ports_embedded)(void);
	void(*iec_drive_write)(uint8_t data, unsigned int dnr);
	uint8_t(*iec_drive_read)(unsigned int dnr);
	void(*parallel_cable_drive_write)(int port, uint8_t data, int handshake, unsigned int dnr);
	uint8_t(*parallel_cable_drive_read)(int port, int handshake);
	void(*iec_fast_drive_write)(uint8_t data, unsigned int dnr);
	void(*iec_fast_drive_direction)(int direction, unsigned int dnr);
	void(*iec_update_cpu_bus)(uint8_t data);
	void(*iec_update_ports)(void);
	void(*plus4tcbm_update_pa)(uint8_t byte, unsigned int dnr);
	void(*plus4tcbm_update_pb)(uint8_t byte, unsigned int dnr);
	void(*plus4tcbm_update_pc)(uint8_t byte, unsigned int dnr);
	void(*ui_display_statustext)(const char *text, int fade_out);
	int(*uimon_get_columns)(struct console_private_s *t);
	void(*uimon_write_to_terminal)(struct console_private_s *t, const char *data, long length);
	int(*uimon_get_string)(struct console_private_s *t, char* string, int string_len);
	bool(*uimon_set_font)(void);
	int(*uicolor_alloc_color)(unsigned int red, unsigned int green,unsigned int blue, unsigned long *color_pixel,uint8_t *pixel_return);
	void(*uicolor_free_color)(unsigned int red, unsigned int green,unsigned int blue, unsigned long color_pixel);
	void(*uicolor_convert_color_table)(unsigned int colnr, uint8_t *data,long color_pixel, void *c);
	int(*uicolor_set_palette)(struct video_canvas_s *c,const struct palette_s *palette);
	int(*uicolor_alloc_colors)(struct video_canvas_s *c);
	iecbus_t*(*iecbus_drive_port)(void);
	void(*cartridge_init)(void);
	int(*cartridge_resources_init)(void);
	int(*cartridge_cmdline_options_init)(void);
	void(*cartridge_shutdown)(void);
	void(*cartridge_resources_shutdown)(void);
	void(*cartridge_init_config)(void);
	int(*cartridge_detect)(const char *filename);
	int(*cartridge_attach_image)(int type, const char *filename);
	int(*cartridge_enable)(int type);
	int(*cartridge_disable)(int type);
	void(*cartridge_detach_image)(int type);
	void(*cartridge_set_default)(void);
	void(*cartridge_unset_default)(void);
	void(*cartridge_reset)(void);
	void(*cartridge_trigger_freeze)(void);
	void(*cartridge_trigger_freeze_nmi_only)(void);
	void(*cartridge_release_freeze)(void);
	const char*(*cartridge_get_file_name)(int type);
	int(*cartridge_type_enabled)(int type);
	int(*cartridge_save_image)(int type, const char *filename);
	int(*cartridge_bin_save)(int type, const char *filename);
	int(*cartridge_crt_save)(int type, const char *filename);
	int(*cartridge_flush_image)(int type);
	int(*cartridge_can_flush_image)(int crtid);
	int(*cartridge_can_save_image)(int crtid);
	int(*cartridge_snapshot_read_modules)(struct snapshot_s *s);
	int(*cartridge_snapshot_write_modules)(struct snapshot_s *s);
	void(*cartridge_setup_context)(struct machine_context_s *machine_context);
	uint8_t(*cartridge_peek_mem)(uint16_t addr);
	void(*cartridge_mmu_translate)(unsigned int addr, uint8_t **base, int *start, int *limit);
	void(*cartridge_ram_init)(void);
	void(*cartridge_sound_chip_init)(void);
	cartridge_info_t*(*cartridge_get_info_list)(void);
	void(*machine_trigger_flux_change)(unsigned int on);
	void(*machine_set_tape_sense)(int sense);
	void(*machine_set_tape_write_in)(int val);
	void(*machine_set_tape_motor_in)(int val);
	void(*machine_sid2_enable)(int val);
	void(*sid_sound_chip_init)(void);
	int(*gamepad_register)(void);
	uint8_t(*mem_read)(uint16_t addr);
	void(*mem_store)(uint16_t addr, uint8_t value);
} t_machine_specific_bindings;
#endif