//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


//
// Created by rainer on 07.03.23.
//
#include <android/log.h>
#include "javascript.h"
#include "logginghelpers.h"
#include "jnihelpers.h"
#include "messages.h"
#include "lib.h"

void js_init_constants() {
    static jmethodID mth=NULL;
    if (!mth) {
        mth = GetMethodID(GetObjectClass(CurrentActivity()),"jsInitConstants", "()V");
    }
    CallVoidMethod(CurrentActivity(), mth);
}
int js_is_keycode_supported(int code) {
    static jmethodID mth=NULL;
    if (!mth) {
        mth = GetMethodID(GetObjectClass(CurrentActivity()), "jsIsKeycodeSupported", "(I)Z");
    }
    return CallBooleanMethod(CurrentActivity(), mth, code) ? 1 : 0;
}
void js_notify_tasks_deleted() {
    static jmethodID mth=NULL;
    if (!mth) {
        mth = GetMethodID(GetObjectClass(CurrentActivity()), "jsNotifyTasksDeleted", "()V");
    }
    CallVoidMethod(CurrentActivity(), mth);
}
void js_notify_gamepad_task_created() {
    static jmethodID mth=NULL;
    if (!mth) {
        mth = GetMethodID(GetObjectClass(CurrentActivity()), "jsNotifyGamepadTaskCreated", "()V");
    }
    CallVoidMethod(CurrentActivity(), mth);
}
void js_write_to_log(int level, const char* message) {
    __android_log_print(level, "ViceEmulation (JNI)", "[JS]: %s", message);

}
int js_get_devicefeature(int feature) {
    static jmethodID mth= NULL;
    if (!mth) {
        mth=GetMethodID(GetObjectClass(CurrentActivity()),"jsGetDeviceFeature", "(I)Z");
    }
    return CallBooleanMethod(CurrentActivity(), mth, feature) ? 1 : 0;

}
int js_set_monitor(uint32_t monitor) {
    static jmethodID mth= NULL;
    if (!mth) {
        mth=GetMethodID(GetObjectClass(CurrentActivity()),"jsSetMonitor", "(I)Z");
    }
    return CallBooleanMethod(CurrentActivity(), mth, monitor) ? 1 : 0;

    return 0;
}

int js_getjoystickcount() {
    static jmethodID mth= NULL;
    if (!mth) {
        mth=GetMethodID(GetObjectClass(CurrentActivity()),"getJoystickCount", "()I");
    }
    return CallIntMethod(CurrentActivity(), mth);

}
void js_create_softkey(const char* id, const char* text, int row, int col, int shiftstate) {
    static jmethodID mth= NULL;
    if (!mth) {
        mth=GetMethodID(GetObjectClass(CurrentActivity()),"createSoftkey", "(Ljava/lang/String;Ljava/lang/String;III)V");
    }
    jstring j_id = NewStringUTF(id);
    jstring j_text = NewStringUTF(text);
    CallVoidMethod(CurrentActivity(),mth,j_id,j_text, row, col, shiftstate);

}
void js_destroy_softkey(const char* id) {
    static jmethodID mth = NULL;
    if (!mth) {
        mth = GetMethodID(GetObjectClass(CurrentActivity()), "destroySoftkey",
                          "(Ljava/lang/String;)V");
    }
    jstring j_id = NewStringUTF(id);
    CallVoidMethod(CurrentActivity(), mth, j_id);

}
void js_enable_softkey(const char* id, int enabled) {
    static jmethodID mth = NULL;
    if (!mth) {
        mth = GetMethodID(GetObjectClass(CurrentActivity()), "enableSoftkey",
                          "(Ljava/lang/String;Z)V");
    }
    jstring j_id = NewStringUTF(id);

    CallVoidMethod(CurrentActivity(), mth, j_id, enabled ? JNI_TRUE: JNI_FALSE);

}
void js_show_toast(const char *tostring) {
    postMessage((char*) tostring);
}
void js_request_virtual_keyboard(int screenpart) {
    static jmethodID mth= NULL;
    if (!mth) {
        mth=GetMethodID(GetObjectClass(CurrentActivity()),"jsRequestVirtualKeyboard", "(I)V");
    }
    CallVoidMethod(CurrentActivity(), mth, screenpart);
}
void js_restore_virtual_keyboard() {
    static jmethodID mth = NULL;
    if (!mth) {
        mth = GetMethodID(GetObjectClass(CurrentActivity()), "jsRestoreVirtualKeyboard", "()V");
    }
    CallVoidMethod(CurrentActivity(), mth);

}
void js_store_initial_snapshot(int level) {
    static jmethodID mth = NULL;
    if (!mth) {
        mth = GetMethodID(GetObjectClass(CurrentActivity()), "jsStoreInitialSnapshot", "(I)V");
    }
    CallVoidMethod(CurrentActivity(), mth, level);
}
void js_take_test_screenshot(const char* filename) {
    static jmethodID mth = NULL;
    if (!mth) {
        mth = GetMethodID(GetObjectClass(CurrentActivity()), "jsStoreTestScreenshot", "(Ljava/lang/String;)V");
    }
    jstring j_filename = NewStringUTF(filename);
    CallVoidMethod(CurrentActivity(), mth, j_filename);
}
int js_get_initial_snapshot_level() {
    static jmethodID mth = NULL;
    if (!mth) {
        mth = GetMethodID(GetObjectClass(CurrentActivity()), "jsGetInitialSnapshotLevel", "()I");
    }
    return CallIntMethod(CurrentActivity(), mth);
}
const char *js_get_system_language() {
    static jmethodID  mth = NULL;
    char* ret = NULL;
    if (!mth) {
        mth =GetMethodID(GetObjectClass(CurrentActivity()),"getSystemLanguage","()Ljava/lang/String;");
    }
    jobject obj=CallObjectMethod(CurrentActivity(),mth);
    jboolean isCopy;
    char* s=(char*)GetStringUTFChars((jstring)obj,&isCopy);
    if (s)
    {
        ret=lib_strdup(s);
    }
    if (!isCopy) {
        ReleaseStringUTFChars(obj, s);
    }
    return ret;
}
