package de.rainerhock.eightbitwonders.vice;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;

/**
A toggled key button that is turned on by pressing once and of by pressing agail.
Examples are shift lock and C128's 40/80-Key.
 */
public class ToggledKeyButton extends KeyButtonBase {
    private static final String TAG = ToggledKeyButton.class.getSimpleName();

    /**
     * Simple constructor to use when creating a KeyButton from code.
     * @param context The Context the view is running in, through which it can access the
     *                current theme, resources, etc.
     */
    public ToggledKeyButton(final Context context) {
        super(context);
    }
    /**
     * Constructor that is called when inflating a ToggledKeyButton from XML.
     * This is called when a view is being constructed from an XML file,
     * supplying attributes that were specified in the XML file.
     * his version uses a default style of 0, so the only attribute values applied are
     * those in the Context's Theme and the given AttributeSet.
     * @param context The Context the view is running in, through which it can access the current
     *                theme, resources, etc.
     * @param attrs The attributes of the XML tag that is inflating the view.
     *              This value may be null.
     */

    public ToggledKeyButton(final Context context, final AttributeSet attrs) {
        super(context, attrs);

    }
    /**
     * Perform inflation from XML and apply a class-specific base style from a theme attribute.
     * This constructor of View allows subclasses to use their own base style
     * when they are inflating. For example, a Button class's constructor would call
     * this version of the super class constructor and supply R.attr.buttonStyle for defStyleAttr;
     * this allows the theme's button style to modify all of the base view attributes
     * (in particular its background) as well as the Button class's attributes.
     * @param context The Context the view is running in, through which it can access
     *                the current theme, resources, etc.
     * @param attrs The attributes of the XML tag that is inflating the view.
     *              This value may be null.
     * @param defStyle An attribute in the current theme that contains a reference to
     *                 a style resource that supplies default values for the view.
     *                 Can be 0 to not look for defaults.
     */

    public ToggledKeyButton(final Context context, final AttributeSet attrs, final int defStyle) {
        super(context, attrs, defStyle);
    }
    private ViceKeyboardFragment mKeyboardFragment = null;
    @Override
    final void setKeyboardController(final ViceKeyboardFragment val) {
        mKeyboardFragment = val;
        mKeyboardFragment.higlightToggledKeyPressed(this);
    }

    @Override
    public final boolean onTouchEvent(final MotionEvent event) {
        if (event.getActionMasked() == MotionEvent.ACTION_DOWN
                || event.getActionMasked() == MotionEvent.ACTION_POINTER_DOWN) {
            Log.d(TAG, "ksh.pressKey ('" + this.getTextValue() + "')");
            mKeyboardFragment.pressKey(this);
            mKeyboardFragment.dumpstate();
        }
        return super.onTouchEvent(event);
    }

}
