package de.rainerhock.eightbitwonders.vice;

import android.annotation.SuppressLint;
import android.content.res.Resources;
import android.net.Uri;

import java.util.HashMap;
import java.util.LinkedHashMap;

import de.rainerhock.eightbitwonders.EmulationConfiguration;
import de.rainerhock.eightbitwonders.EmulationUi;
import de.rainerhock.eightbitwonders.R;

abstract class C64C128CommonBase extends ViceEmulation {
    C64C128CommonBase(final EmulationUi ui, final EmulationConfiguration conf) {
        super(ui, conf);
    }

    @SuppressLint("DiscouragedApi")
    @Override
    protected LinkedHashMap<String, Integer> getCartrigeFilters() {
        LinkedHashMap<String, Integer> ret = new LinkedHashMap<>();
        int count = nativeIntFunc("get_c64_cartridge_group_count");
        for (int i = 0; i < count; i++) {
            String name = nativeStringFunc("get_c64_cartridge_group_name", i);
            int id = nativeIntFunc("get_c64_cartridge_group_filter", i);
            String key;
            if (nativeIntFunc("get_c64_cartridge_group_text_is_ressource_id", i) != 0) {
                key = getEmulationActivity().getContext().getResources().getString(
                        getEmulationActivity().getContext().getResources().getIdentifier(
                                name, "string",
                                getEmulationActivity().getContext().getPackageName()));
            } else {
                key = name;
            }
            ret.put(key, id);
        }
        return ret;
    }

    @Override
    public HashMap<Integer, String> getJoystickports() {
        HashMap<Integer, String> ret = new LinkedHashMap<>();
        Resources res = getEmulationActivity().getContext().getResources();
        ret.put(ret.size() + 1, res.getString(R.string.IDS_JOYSTICK_IN_PORT_1));
        ret.put(ret.size() + 1, res.getString(R.string.IDS_JOYSTICK_IN_PORT_2));
        ret.put(ret.size() + 1, res.getString(R.string.IDS_JOYSTICK_IN_USERPORT_PORT_1));
        ret.put(ret.size() + 1, res.getString(R.string.IDS_JOYSTICK_IN_USERPORT_PORT_2));
        ret.put(KEYMAPPED_JOYSTICK_1, res.getString(R.string.map_to_keyset_1));
        ret.put(KEYMAPPED_JOYSTICK_2, res.getString(R.string.map_to_keyset_2));
        fixJoystickNames(ret);
        return ret;
    }

    @Override
    int getCartridgeAutodetectFlag() {
        return 0;
    }

    @Override
    protected boolean isCartridge(final Uri uri) {
        disableLogging();
        boolean ret = nativeIntFunc("crt_getid", uri.toString()) >= 0;
        enableLogging();
        return ret;
    }
}
