//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


package de.rainerhock.eightbitwonders;

import android.view.View;
import androidx.annotation.NonNull;


final class WheelJoystick extends VirtualJoystick {
    private final String mDescription;
    private JoystickWheelView mWheelview;
    private JoystickGearshiftView mGearshiftView;

    void setWheelview(final JoystickWheelView jwv) {
        mWheelview = jwv;
    }
    WheelJoystick(final String description) {
        mDescription = description;
    }



    boolean isPreferredType(final EmulationConfiguration.PreferredJoystickType type) {
        return type == EmulationConfiguration.PreferredJoystickType.WHEEL;
    }
    void setGearshiftView(final JoystickGearshiftView jgv, final boolean isRightHanded) {
        mGearshiftView = jgv;
        mGearshiftView.setFireOrientation(isRightHanded
                        ? View.LAYOUT_DIRECTION_LTR : View.LAYOUT_DIRECTION_RTL);

    }
    @Override
    protected void onChanged() {
        float x = mWheelview.isPointingWest() ? -FULL_AMPLITUDE
                : mWheelview.isPointingEast() ? FULL_AMPLITUDE : 0;

        float y = mGearshiftView.isPointingNorth() ? -FULL_AMPLITUDE
                : mGearshiftView.isPointingSouth() ? FULL_AMPLITUDE : 0;
        setXValue(x);
        setYValue(y);
        setRealButtonsPressed(mGearshiftView.isButtonPressed());
        super.onChanged();
    }

    @Override
    boolean canLockDiagonals() {
        return false;
    }

    @Override
    boolean canForceCenterFirst() {
        return false;
    }

    @Override
    public String getId() {
        return "touch_wheel";
    }

    @NonNull
    @Override
    public String toString() {
        return mDescription;
    }


    @Override
    protected int getRessourceId() {
        return R.layout.fragment_config_wheel_joystick;
    }
    @Override
    int getPseudoKeycode() {
        return Joystick.PSEUDO_KEYCODE_GEARSHIFT;
    }
}
