package de.rainerhock.eightbitwonders;

import static de.rainerhock.eightbitwonders.DialogsView.UiElement.SAVESTATES;

import android.graphics.Bitmap;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.TextView;

import androidx.annotation.NonNull;

import java.io.Serializable;

public final class TimeMachineFragment
        extends DialogsView.StatefulFragment<TimeMachineFragment.TimeMachineState> {

    private static final int UNINITIALIZED = -1;

    @Override
    TimeMachineState createDefaultState() {
        return new TimeMachineState();
    }

    @NonNull
    @Override
    View createUi(final @NonNull LayoutInflater inflater,
                  final @NonNull EmulationActivity activity,
                  final @NonNull Emulation emu,
                  final @NonNull EmulationConfiguration conf,
                  final TimeMachineState state) {
        Emulation.TimeMachineFunctions rewindfunctions = emu.getTimeMachineFunctions();
        ViewGroup root = (ViewGroup) inflater.inflate(R.layout.dialog_timemachine, null, false);
        SeekBar sb = root.findViewById(R.id.sb_seekbar);
        if (state.mNewestMoment < 0) {
            state.mNewestMoment = rewindfunctions.getNewestMoment();
        }
        sb.setMax(rewindfunctions.getOldestMoment() - state.mNewestMoment);
        Bitmap bmp = rewindfunctions.getScreenPreview(state.mNewestMoment);
        View viewApply = root.findViewById(R.id.bn_apply);
        ImageView viewBitmap = root.findViewById(R.id.iv_bitmap);
        viewBitmap.setImageBitmap(bmp);
        BaseActivity.setViewListeners(root.findViewById(R.id.bn_save), () -> {
            getContainerView().showUiElement(SAVESTATES,
                    SaveStateFragment.getBundle(
                            activity,
                            rewindfunctions.getScreenPreview(
                                    sb.getProgress() + state.mNewestMoment),
                            sb.getProgress() + state.mNewestMoment));
            dismiss();
        }, this::dismiss);
        sb.setProgress(state.mProgress > 0
                ? state.mProgress + state.mNewestMoment : state.mNewestMoment);
        TextView tv = root.findViewById(R.id.tv_time_offset);
        tv.setText(elapsedTimeAsString(inflater.getContext(), sb.getProgress()));

        Runnable r = () -> {
            Bitmap b = rewindfunctions.getScreenPreview(sb.getProgress() + state.mNewestMoment);
            if (b != null) {
                activity.setBitmap(activity.getViewModel().getCurrentDisplayId(), b);
            }
            rewindfunctions.travelTo(sb.getProgress() + state.mNewestMoment);
            setDelayAfterDialog(true);
            dismiss();
        };
        BaseActivity.setViewListeners(viewBitmap, r, this::dismiss);
        BaseActivity.setViewListeners(viewApply, r, this::dismiss);

        sb.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(final SeekBar seekBar, final int i, final boolean b) {
                if (b) {
                    viewBitmap.setImageBitmap(
                            rewindfunctions.getScreenPreview(i + state.mNewestMoment));
                    tv.setText(elapsedTimeAsString(
                            inflater.getContext(), i + state.mNewestMoment));
                    state.mProgress = i;
                }

            }

            @Override
            public void onStartTrackingTouch(final SeekBar seekBar) {
            }

            @Override
            public void onStopTrackingTouch(final SeekBar seekBar) {
            }
        });

        return root;

    }

    @Override
    public void onStop() {
        super.onStop();

    }

    static class TimeMachineState implements Serializable {

        private int mProgress = UNINITIALIZED;
        private int mNewestMoment  = UNINITIALIZED;
    }
    @Override
    boolean showAsDialog() {
        return true;
    }
}
