package de.rainerhock.eightbitwonders;

import android.annotation.SuppressLint;
import android.view.LayoutInflater;
import android.view.View;

import androidx.annotation.NonNull;

import java.io.Serializable;

public final class SoftkeysDialogFragment extends DialogsView.StatefulFragment<Serializable> {
    /**
     * Needed by android, do not use.
     */
    // CHECKSTYLE DISABLE RedundantModifier FOR 1 LINES
    public SoftkeysDialogFragment() {
        super();
    }
    void continueEmulation() {
        if (getActivity() instanceof EmulationActivity) {
            EmulationActivity ea = (EmulationActivity) getActivity();
            Emulation emu = ea.getViewModel().getEmulation();
            ea.unmuteEmulation();
            emu.setPaused(false);
        }
    }

    @Override
    int getContainerViewId() {
        return R.id.menucontainer_bottom_center_anchor;
    }

    @Override
    Serializable createDefaultState() {
        return null;
    }

    @NonNull
    @Override
    View createUi(final @NonNull LayoutInflater inflater,
                  final @NonNull EmulationActivity activity,
                  final @NonNull Emulation emu,
                  final @NonNull EmulationConfiguration conf,
                  final Serializable state) {
        @SuppressLint("InflateParams")
        SoftkeysLinearLayout root = (SoftkeysLinearLayout)
                inflater.inflate(R.layout.view_tv_softkeys, null, false);
        if (getActivity() instanceof EmulationActivity) {
            ((EmulationActivity) getActivity()).addSoftkeyViews(root,
                    this::continueEmulation, this::dismiss);
        }
        root.post(root::requestFocus);
        root.addOnLayoutChangeListener(new View.OnLayoutChangeListener() {
            //CHECKSTYLE DISABLE ParameterNumber FOR 2 LINES
            @Override
            public void onLayoutChange(final View view, final int i, final int i1,
                                       final int i2, final int i3, final int i4,
                                       final int i5, final int i6, final int i7) {
                root.post(root::requestFocus);
                root.removeOnLayoutChangeListener(this);
            }
        });

        return root;
    }
}
