package de.rainerhock.eightbitwonders;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;

import org.yaml.snakeyaml.Yaml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

enum NeutralButton { CONTROLLER_BUTTON_SOUTH, CONTROLLER_BUTTON_EAST,
    CONTROLLER_BUTTON_WEST, CONTROLLER_BUTTON_NORTH,
    L1, L2, L3, R1, R2, R3,
    DPAD_DOWN, DPAD_RIGHT, DPAD_LEFT, DPAD_UP, DPAD_CENTER
}
public final class SoftkeyConfigView extends LinearLayout {
    private static final Map<Integer, NeutralButton> NEUTRAL_BUTTON_IDS
            = new LinkedHashMap<Integer, NeutralButton>() {{
        put(KeyEvent.KEYCODE_BUTTON_A, NeutralButton.CONTROLLER_BUTTON_SOUTH);
        put(KeyEvent.KEYCODE_BUTTON_1, NeutralButton.CONTROLLER_BUTTON_SOUTH);

        put(KeyEvent.KEYCODE_BUTTON_B, NeutralButton.CONTROLLER_BUTTON_EAST);
        put(KeyEvent.KEYCODE_BUTTON_2, NeutralButton.CONTROLLER_BUTTON_EAST);

        put(KeyEvent.KEYCODE_BUTTON_X, NeutralButton.CONTROLLER_BUTTON_WEST);
        put(KeyEvent.KEYCODE_BUTTON_3, NeutralButton.CONTROLLER_BUTTON_WEST);

        put(KeyEvent.KEYCODE_BUTTON_Y, NeutralButton.CONTROLLER_BUTTON_NORTH);
        put(KeyEvent.KEYCODE_BUTTON_4, NeutralButton.CONTROLLER_BUTTON_NORTH);

        put(KeyEvent.KEYCODE_BUTTON_L1, NeutralButton.L1);
        put(KeyEvent.KEYCODE_BUTTON_5, NeutralButton.L1);
        put(KeyEvent.KEYCODE_BUTTON_R1, NeutralButton.R1);
        put(KeyEvent.KEYCODE_BUTTON_6, NeutralButton.R1);

        put(KeyEvent.KEYCODE_BUTTON_L2, NeutralButton.L2);
        put(KeyEvent.KEYCODE_BUTTON_7, NeutralButton.L2);
        put(KeyEvent.KEYCODE_BUTTON_R2, NeutralButton.R2);
        put(KeyEvent.KEYCODE_BUTTON_8, NeutralButton.R2);

        put(KeyEvent.KEYCODE_BUTTON_THUMBL, NeutralButton.L3);
        put(KeyEvent.KEYCODE_BUTTON_11, NeutralButton.L3);
        put(KeyEvent.KEYCODE_BUTTON_THUMBR, NeutralButton.R3);
        put(KeyEvent.KEYCODE_BUTTON_12, NeutralButton.R3);

        put(KeyEvent.KEYCODE_DPAD_UP, NeutralButton.DPAD_UP);
        put(KeyEvent.KEYCODE_DPAD_DOWN, NeutralButton.DPAD_DOWN);
        put(KeyEvent.KEYCODE_DPAD_LEFT, NeutralButton.DPAD_LEFT);
        put(KeyEvent.KEYCODE_DPAD_RIGHT, NeutralButton.DPAD_RIGHT);
        put(KeyEvent.KEYCODE_DPAD_CENTER, NeutralButton.DPAD_CENTER);

    }};
    private static final Map<NeutralButton, Integer> NEUTRAL_BUTTON_LABELS
            = new LinkedHashMap<NeutralButton, Integer>() {{
        put(NeutralButton.CONTROLLER_BUTTON_SOUTH, R.string.button_south);
        put(NeutralButton.CONTROLLER_BUTTON_EAST, R.string.button_east);
        put(NeutralButton.CONTROLLER_BUTTON_WEST, R.string.button_west);
        put(NeutralButton.CONTROLLER_BUTTON_NORTH, R.string.button_north);
        put(NeutralButton.L1, R.string.button_l1);
        put(NeutralButton.R1, R.string.button_r1);
        put(NeutralButton.L2, R.string.button_l2);
        put(NeutralButton.R2, R.string.button_r2);
        put(NeutralButton.L3, R.string.button_l3);
        put(NeutralButton.R3, R.string.button_r3);

        put(NeutralButton.DPAD_UP, R.string.dpad_up);
        put(NeutralButton.DPAD_DOWN, R.string.dpad_down);
        put(NeutralButton.DPAD_LEFT, R.string.dpad_left);
        put(NeutralButton.DPAD_RIGHT, R.string.dpad_right);
        put(NeutralButton.DPAD_CENTER, R.string.dpad_center);


    }};
    private static final String TAG = SoftkeyConfigView.class.getSimpleName();
    private final BaseActivity mActivity;
    private Useropts mUseropts = null;
    void setUseropts(final Useropts useropts) {
        mUseropts = useropts;
    }

    void setJoysticks(final List<Joystick> joysticks, final SoftkeysLinearLayout viewgroup) {

        Set<NeutralButton> allControllerButtons = null;
        for (Softkey sk : mSoftkeyList) {

            boolean hide = false;
            if (sk.mHideOnGamepad) {
                if (allControllerButtons == null) {
                    allControllerButtons = new HashSet<>();
                    for (Joystick joy : joysticks) {
                        if (!(joy instanceof KeyboardJoystick)
                                && !(joy instanceof VirtualJoystick)) {
                            for (int key = 0; key < KeyEvent.getMaxKeyCode(); key++) {
                                if (KeyEvent.isGamepadButton(key)
                                        && joy.deviceHasButtonWithKeycode(key)) {
                                    NeutralButton newbutton
                                            = SoftkeyConfigView.NEUTRAL_BUTTON_IDS.get(key);
                                    if (newbutton != null) {
                                        allControllerButtons.add(newbutton);
                                    }
                                }
                            }
                        }
                    }
                }
                for (NeutralButton b: allControllerButtons) {
                    if (sk.mGamepadButtons.contains(b)) {
                        hide = true;
                        break;
                    }
                }
            }
            viewgroup.setHiddenByGamepad(sk.mId, hide);
        }
    }
    private Softkey getMatchingButton(final int keycode) {
        for (Softkey key: mSoftkeyList) {
            if (key.getGamepadButtons() != null && !key.getGamepadButtons().isEmpty()) {
                for (NeutralButton b : key.getGamepadButtons()) {
                    if (NEUTRAL_BUTTON_IDS.get(keycode) == b) {
                        return key;
                    }
                }
            }
        }
        return null;

    }
    boolean onButtonPressed(final int keycode,
                                   @NonNull final Emulation.SoftkeyFunctions functions) {
        Softkey key = getMatchingButton(keycode);
        if (key != null) {
            if (key.getModificatorKeyId() != null) {
                functions.pressKey(key.getModificatorKeyId());
            }
            functions.pressKey(key.getKeyId());
            return true;
        }
        return false;
    }

    boolean onButtonReleased(final int keycode,
                                    @NonNull final Emulation.SoftkeyFunctions functions) {
        Softkey key = getMatchingButton(keycode);
        if (key != null) {
            functions.releaseKey(key.getKeyId());
            if (key.getModificatorKeyId() != null) {
                functions.releaseKey(key.getModificatorKeyId());
            }
            return true;

        }

        return false;
    }

    public static final class SoftkeyButtonFragment extends DialogFragment {

        /**
         * Added so android can recreate the dialog.
         */
        public SoftkeyButtonFragment() {
            super();
        }

        @Override
        public void onCreate(final @Nullable Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            setStyle(DialogFragment.STYLE_NO_TITLE,
                    androidx.appcompat.R.style.Base_Theme_AppCompat_Dialog);
        }

        @Override
        public void onViewCreated(final @NonNull View view,
                                  final @Nullable Bundle savedInstanceState) {
            super.onViewCreated(view, savedInstanceState);
            final NeutralButton[] lastButton = new NeutralButton[1];
            lastButton[0] = null;
            SoftkeyList usedButtons = (SoftkeyList) requireArguments()
                    .getSerializable(ALL_SOFTKEYS);
            view.setOnKeyListener((v, keyCode, event) -> {
                NeutralButton newbutton = SoftkeyConfigView.NEUTRAL_BUTTON_IDS.get(keyCode);
                Softkey key = (Softkey) requireArguments().getSerializable(SOFTKEY);
                if (event.getAction() == KeyEvent.ACTION_UP && KeyEvent.isGamepadButton(keyCode)) {
                    if (usedButtons != null) {
                        boolean usedBySameKey = false;
                        boolean usedbyOtherKey = false;
                        for (Softkey otherkey : usedButtons) {
                            if (otherkey.mGamepadButtons.contains(newbutton)) {

                                if (key != null && otherkey.getId().equals(key.getId())) {
                                    usedBySameKey = true;
                                } else {
                                    usedbyOtherKey = true;
                                }
                            }
                        }
                        if (usedBySameKey) {
                            view.findViewById(R.id.tv_used_here).setVisibility(View.VISIBLE);
                            return true;
                        } else {
                            view.findViewById(R.id.tv_used_here).setVisibility(View.GONE);
                        }
                        if (usedbyOtherKey) {
                            if (lastButton[0] != newbutton) {
                                view.findViewById(R.id.tv_used_other).setVisibility(View.VISIBLE);
                                lastButton[0] = newbutton;
                                return true;
                            }
                        } else {
                            view.findViewById(R.id.tv_used_other).setVisibility(View.GONE);
                        }
                    }
                    if (newbutton != null) {
                        Serializable s = requireArguments().getSerializable(BUTTON);
                        NeutralButton b = (NeutralButton) s;

                        if (key != null  && !key.mGamepadButtons.contains(newbutton)) {
                            ((SettingsActivity) requireActivity()).onSoftkeyButtonsChanged(key, b,
                                    SOFTKEY, newbutton);
                        }
                        dismiss();
                    } else {
                        view.findViewById(R.id.tv_error).setVisibility(View.VISIBLE);
                    }
                    return true;
                }
                return false;

            });
            view.requestFocus();

        }

        @NonNull
        @Override
        public View onCreateView(final @NonNull LayoutInflater inflater,
                                 final @Nullable ViewGroup container,
                                 final @Nullable Bundle savedInstanceState) {
            ViewGroup root = (ViewGroup) inflater.inflate(R.layout.dialog_softview_button,
                    container, false);
            Serializable s = requireArguments().getSerializable(BUTTON);
            NeutralButton b = (NeutralButton) s;
            Softkey key = (Softkey) requireArguments().getSerializable(SOFTKEY);
            assert key != null;
            Integer id = SoftkeyConfigView.NEUTRAL_BUTTON_LABELS.get(b);
            TextView title = root.findViewById(R.id.tv_title);
            title.setVisibility(View.VISIBLE);
            if (b != null && id != null) {
                title.setText(R.string.assign_other_button);
                String text = getResources().getString(R.string.current_button,
                        getResources().getString(id));
                ((TextView) root.findViewById(R.id.tv_previous_button)).setText(text);
            } else {
                title.setText(R.string.assign_button);
            }
            BaseActivity.setViewListeners(root.findViewById(R.id.bn_cancel),
                    this::dismiss, () -> { });
            root.setOnKeyListener((v, keyCode, event) -> {

                NeutralButton newbutton = SoftkeyConfigView.NEUTRAL_BUTTON_IDS.get(keyCode);
                if (KeyEvent.isGamepadButton(keyCode)) {
                    if (newbutton != null) {
                        ((SettingsActivity) requireActivity()).onSoftkeyButtonsChanged(key, b,
                                SOFTKEY, newbutton);
                        dismiss();
                    } else {
                        root.findViewById(R.id.tv_error).setVisibility(View.VISIBLE);
                    }
                    return true;
                }
                return false;

            });
            return root;
        }
    }

    public static final class SoftkeyModificatorFragment extends DialogFragment {



        /**
         * Added so android can recreate the dialog.
         */
        public SoftkeyModificatorFragment() {
            super();
        }

        @Override
        public void onCreate(final @Nullable Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            setStyle(DialogFragment.STYLE_NO_TITLE,
                    androidx.appcompat.R.style.Base_Theme_AppCompat_Dialog);
        }
        @NonNull
        @Override
        public View onCreateView(final @NonNull LayoutInflater inflater,
                                       final @Nullable ViewGroup container,
                                       final @Nullable Bundle savedInstanceState) {
            ViewGroup root = (ViewGroup) inflater.inflate(R.layout.dialog_softview_config,
                    container, false);
            return updateUi(inflater, root, (Softkey) requireArguments().getSerializable(SOFTKEY));
        }
        void updateButtons(final LayoutInflater inflater, final ViewGroup root, final Softkey key) {
            CheckBox cb = root.findViewById(R.id.cb_hide_on_gamepad);
            TableLayout table = root.findViewById(R.id.tl_mapped_buttons);
            List<View> todelete = new LinkedList<>();
            for (int i = 0; i < table.getChildCount(); i++) {
                if (table.getChildAt(i).getId() == View.NO_ID) {
                    todelete.add(table.getChildAt(i));
                }
            }
            for (View v : todelete) {
                table.removeView(v);
            }
            if (!key.getGamepadButtons().isEmpty()) {
                for (NeutralButton gpb : key.getGamepadButtons()) {
                    Integer textId = SoftkeyConfigView.NEUTRAL_BUTTON_LABELS.get(gpb);
                    if (textId != null) {
                        TableRow tr = inflater.inflate(R.layout.viewgroup_softkey_buttons_tablerow,
                                table).findViewById(R.id.tr_new_button);

                        ((TextView) tr.findViewById(R.id.tv_label)).setText(
                                getResources().getString(textId));
                        BaseActivity.setViewListeners(tr.findViewById(R.id.bn_change),
                                () -> showMappingDialog((BaseActivity) getActivity(), key, gpb),
                                this::dismiss);
                        BaseActivity.setViewListeners(tr.findViewById(R.id.bn_remove), () -> {
                            BaseActivity.AlertDialogBuilder builder =
                                    new BaseActivity.AlertDialogBuilder(requireContext());
                            builder.setTitle(R.string.remove_button)
                                    .setMessage(getResources()
                                            .getString(R.string.really_remove_button,
                                                    getResources().getString(textId)))
                                    .setPositiveButton(R.string.yes, (dialogInterface, which) -> {
                                        key.getGamepadButtons().remove(gpb);
                                        updateButtons(getLayoutInflater(),
                                                (ViewGroup) requireView(), key);
                                        dialogInterface.dismiss();

                                    })
                                    .setNegativeButton(R.string.no, (dialogInterface, i)
                                            -> dialogInterface.dismiss())
                                    .setOnDismissListener(DialogInterface::dismiss);
                            BaseActivity.AlertDialogBuilder.showStyledDialog(builder.create());
                        }, this::dismiss);
                        tr.setId(View.NO_ID);
                    }
                }
                table.findViewById(R.id.tr_show_if_empty).setVisibility(View.GONE);
                cb.setVisibility(View.VISIBLE);
                cb.setChecked(key.mHideOnGamepad);
            } else {
                table.findViewById(R.id.tr_show_if_empty).setVisibility(View.VISIBLE);
                cb.setVisibility(View.GONE);
                cb.setChecked(false);
            }
            Runnable onSelect = () -> showMappingDialog((BaseActivity) getActivity(), key, null);
            BaseActivity.setViewListeners(root.findViewById(R.id.bn_add_button), onSelect, onSelect,
                    this::dismiss);

        }
        View updateUi(final LayoutInflater inflater, final ViewGroup root,
                      final @Nullable Softkey key) {
            TextView tv = root.findViewById(R.id.tv_title);
            tv.setText(R.string.softkey);
            tv.setVisibility(View.VISIBLE);

            assert key != null;
            MappedSpinner spAllkeys = root.findViewById(R.id.sp_key);
            MappedSpinner spModificatorKeys = root.findViewById(R.id.sp_modificator_key);
            EditText etLabel = root.findViewById(R.id.et_label);
            if (key.getLabel() != null) {
                etLabel.setText(key.getLabel());
            }
            etLabel.setOnFocusChangeListener((v, hasFocus) -> {
                if (!hasFocus) {
                    String text = etLabel.getText().toString();
                    if (text.isEmpty()) {
                        autoUpdateLabel(spAllkeys, spModificatorKeys, etLabel);
                        key.mLabel = null;
                    } else {
                        key.mLabel = etLabel.getText().toString();
                    }
                    updateCheckboxes(root);
                    updateApplyButton(root);
                }
            });
            updateButtons(inflater, root, key);
            List<EmulationUi.SettingSpinnerElement> allkeys = createElementlist(SOFTKEYS);
            List<EmulationUi.SettingSpinnerElement> modificatorKeys
                    = createElementlist(MODIFICATOR_SOFTKEYS);

            spAllkeys.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
                @Override
                public void onItemSelected(final AdapterView<?> parent, final View view,
                                           final int position, final long id) {
                    root.findViewById(R.id.sp_modificator_key).setEnabled(position > 0);
                    autoUpdateLabel(spAllkeys, spModificatorKeys, etLabel);
                    updateCheckboxes(root);
                    updateApplyButton(root);

                }
                @Override
                public void onNothingSelected(final AdapterView<?> parent) {

                }
            });
            populateSpinner(allkeys, spAllkeys, key.mKeyId);
            spModificatorKeys.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
                @Override
                public void onItemSelected(final AdapterView<?> parent, final View view,
                                           final int position, final long id) {
                    autoUpdateLabel(spAllkeys, spModificatorKeys, etLabel);
                }

                @Override
                public void onNothingSelected(final AdapterView<?> parent) {

                }
            });
            populateSpinner(modificatorKeys, spModificatorKeys, key.mModificatorKeyId);
            updateCheckboxes(root);
            updateApplyButton(root);
            BaseActivity.setViewListeners(root.findViewById(R.id.bn_apply), () -> {
                int pos = spAllkeys.getSelectedItemPosition();
                if (pos > 0) {
                    key.mKeyId = allkeys.get(pos).getId();
                } else {
                    key.mKeyId = null;
                }
                int modPos = spModificatorKeys.getSelectedItemPosition();
                if (modPos > 0) {
                    key.mModificatorKeyId = modificatorKeys.get(modPos).getId();
                } else {
                    key.mModificatorKeyId = null;
                }
                autoUpdateLabel(spAllkeys, spModificatorKeys, etLabel);
                key.mLabel = etLabel.getText().toString();
                CheckBox cbKeyboard = root.findViewById(R.id.cb_hide_on_keyboard);
                key.mHideOnKeyboard = cbKeyboard.isChecked();
                CheckBox cbGamepad = root.findViewById(R.id.cb_hide_on_gamepad);
                key.mHideOnGamepad = cbGamepad.isChecked()
                        && cbGamepad.getVisibility() == View.VISIBLE;
                dismiss();
                ((SettingsActivity) requireActivity()).onSoftkeyChanged(key);
            }, () -> { });
            ((CheckBox) root.findViewById(R.id.cb_hide_on_keyboard))
                    .setChecked(key.mHideOnKeyboard);
            return root;

        }
        private void showMappingDialog(final BaseActivity activity, final Softkey key,
                                       final NeutralButton button) {
            DialogFragment f = new SoftkeyButtonFragment();
            Bundle b = new Bundle();
            b.putSerializable(SOFTKEY, key);
            if (button != null) {
                b.putSerializable(BUTTON, button);
            }
            b.putSerializable(ALL_SOFTKEYS, requireArguments().getSerializable(ALL_SOFTKEYS));
            f.setArguments(b);
            f.showNow(activity.getSupportFragmentManager(), SOFTKEYBUTTON);

        }

        private void updateCheckboxes(final ViewGroup root) {
            CheckBox cb = root.findViewById(R.id.cb_hide_on_keyboard);
            if (((EditText) root.findViewById(R.id.et_label)).getText().toString().isEmpty()) {
                cb.setVisibility(View.GONE);
                cb.setChecked(false);
            } else {
                cb.setVisibility(View.VISIBLE);
            }
        }
        private void updateApplyButton(final ViewGroup root) {
            MappedSpinner sp = root.findViewById(R.id.sp_key);
            Button b = root.findViewById(R.id.bn_apply);
            b.setEnabled(!root.getContext().getResources().getString(R.string.IDS_NONE)
                    .equals(sp.getSelectedItem().toString()));
        }
        private static String generateKeylabel(final MappedSpinner spAllkeys,
                                        final MappedSpinner spModificatorKeys) {
            String newText = spAllkeys.getSelectedItem().toString();
            if (spAllkeys.getContext().getResources().getString(R.string.IDS_NONE)
                    .equals(newText)) {
                newText = "";
            }
            if (spModificatorKeys.isEnabled()
                    && spModificatorKeys.getSelectedItemPosition() != 0) {
                newText = spModificatorKeys.getSelectedItem().toString() + " + " + newText;
            }
            return newText;
        }
        private String mLastGeneratedText = "";
        private void autoUpdateLabel(final MappedSpinner spAllkeys,
                                            final MappedSpinner spModificatorKeys,
                                            final EditText etLabel) {
            String currentText = etLabel.getText().toString();
            if (currentText.isEmpty() || currentText.equals(mLastGeneratedText)) {
                String newText = generateKeylabel(spAllkeys, spModificatorKeys);
                etLabel.setText(newText);
                mLastGeneratedText = newText;
            }
        }

        private List<EmulationUi.SettingSpinnerElement> createElementlist(final String dataId) {
            List<EmulationUi.SettingSpinnerElement> allKeys = new LinkedList<>();
            EmulationUi.SettingSpinnerElement emptyElement =
                    new EmulationUi.SettingSpinnerElement() {
                        @Override
                        public String getId() {
                            return "";
                        }

                        @Override
                        public String getText() {
                            return requireContext().getResources().getString(R.string.IDS_NONE);
                        }
                        @NonNull
                        @Override
                        public String toString() {
                            return getText();
                        }
                    };
            allKeys.add(emptyElement);
            //noinspection unchecked
            for (Emulation.AdditionalKey k : (List<Emulation.AdditionalKey>)
                    Objects.requireNonNull(requireArguments().getSerializable(dataId))) {
                allKeys.add(new EmulationUi.SettingSpinnerElement() {
                    @Override
                    public String getId() {
                        return k.getId();
                    }

                    @Override
                    public String getText() {
                        return k.getString();
                    }
                    @NonNull
                    @Override
                    public String toString() {
                        return getText();
                    }

                });
            }
            return allKeys;
        }
        private void populateSpinner(final List<EmulationUi.SettingSpinnerElement> data,
                                     final MappedSpinner sp, final String currentValue) {
            sp.populate(data);
            for (int i = 0; i < data.size(); i++) {
                if (data.get(i).getId().equals(currentValue)) {
                    sp.setSelection(i);
                    break;
                }
            }
        }
    }
    private void onBackPressed() {
        if (mActivity != null) {
            mActivity.onBackPressed();
        }
    }
    public static class SoftkeyList extends LinkedList<Softkey> { }
    private SoftkeyList mSoftkeyList = new SoftkeyList();

    void updateUi() {
        TableLayout tl = findViewById(R.id.tl_softkeys);
        List<View> delete = new LinkedList<>();
        for (int i = 0; i < tl.getChildCount(); i++) {
            if (tl.getChildAt(i).getId() == View.NO_ID) {
                delete.add(tl.getChildAt(i));
            }
        }
        for (View v : delete) {
            tl.removeView(v);
        }
        LayoutInflater inflater
                = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        int position = 1;
        findViewById(R.id.tr_show_if_empty).setVisibility(mSoftkeyList.isEmpty()
                ? View.VISIBLE : View.GONE);
        for (Softkey k : mSoftkeyList) {
            @SuppressLint("InflateParams")
            TableRow tr = (TableRow) inflater.inflate(R.layout.viewgroup_softkeys_tablerow, null);
            if (k.mLabel != null) {
                ((TextView) tr.findViewById(R.id.tv_label)).setText(k.mLabel);
            }
            tl.addView(tr, position);
            position++;
            BaseActivity.setViewListeners(tr.findViewById(R.id.bn_remove), () -> {
                BaseActivity.AlertDialogBuilder builder =
                        new BaseActivity.AlertDialogBuilder(tr.getContext());
                builder.setTitle(R.string.remove_softkey)
                        .setMessage(getResources().getString(R.string.really_remove_softkey,
                                k.getLabel()))
                        .setPositiveButton(R.string.yes, (dialogInterface, which) -> {
                            mSoftkeyList.remove(k);
                            updateUi();
                            dialogInterface.dismiss();

                        })
                        .setNegativeButton(R.string.no, (dialogInterface, i)
                                -> dialogInterface.dismiss())
                        .setOnDismissListener(DialogInterface::dismiss);
                BaseActivity.AlertDialogBuilder.showStyledDialog(builder.create());
            }, this::onBackPressed);
            tr.setId(View.NO_ID);
            BaseActivity.setViewListeners(tr.findViewById(R.id.bn_edit),
                    () -> showDialog((SettingsActivity) getContext(), k), this::onBackPressed);
        }

    }
    private static final String USEROPT_SOFTKEYS = "USEROPT_SOFTKEYS";
    private static final String BUTTON = "__BUTTON__";
    void loadConfiguration() {
        Log.v(TAG, "logConfiguration started");
        Yaml yaml = new Yaml();
        mSoftkeyList = new SoftkeyList();
        ArrayList<Softkey> data = yaml.load(mUseropts.getStringValue(USEROPT_SOFTKEYS, ""));
        if (data != null) {
            mSoftkeyList.addAll(data);
        }
        Log.v(TAG, "logConfiguration finished");
    }
    void onSoftkeyChanged(final Softkey key) {
        if (mSoftkeyList == null) {
            mSoftkeyList = new SoftkeyList();
        }
        boolean found = false;
        for (Softkey otherKey : mSoftkeyList) {
            if (otherKey.mId.equals(key.mId)) {
                if (otherKey != key) {
                    otherKey.mLabel = key.mLabel;
                    otherKey.mKeyId = key.mKeyId;
                    otherKey.mHideOnKeyboard = key.mHideOnKeyboard;
                    otherKey.mHideOnGamepad = key.mHideOnGamepad;
                    otherKey.mGamepadButtons = new LinkedList<>();
                    otherKey.mGamepadButtons.addAll(key.mGamepadButtons);
                }
                found = true;
            } else {
                for (NeutralButton nb : key.mGamepadButtons) {
                    otherKey.mGamepadButtons.remove(nb);
                }
            }
        }
        if (!found) {
            mSoftkeyList.add(key);
        }
        updateUi();
    }

    void saveConfiguration() {
        Yaml yaml = new Yaml();
        String s = yaml.dump(mSoftkeyList);
        mUseropts.setValue(Useropts.Scope.CONFIGURATION, USEROPT_SOFTKEYS, s);
    }
    void applyUseropts(final Useropts opts) {

        if (mActivity instanceof EmulationActivity) {
            EmulationActivity ea = (EmulationActivity) mActivity;
            setUseropts(opts);
            loadConfiguration();
            ea.getViewModel().setUiSoftkeys(mSoftkeyList);
        } else {
            throw new IllegalStateException("to apply " + this + "must be in "
                    + EmulationActivity.class.getSimpleName());
        }
    }
    /**
     * Constructor that is called when inflating a SoftkeyConfigView from XML.
     * This is called when a view is being constructed from an XML file,
     * supplying attributes that were specified in the XML file.
     * his version uses a default style of 0, so the only attribute values applied are
     * those in the Context's Theme and the given AttributeSet.
     * @param context The Context the view is running in, through which it can access the current
     *                theme, resources, etc.
     * @param attrs The attributes of the XML tag that is inflating the view.
     *              This value may be null.
     */

    public SoftkeyConfigView(final Context context, final AttributeSet attrs) {
        super(context, attrs);
        mActivity = context instanceof BaseActivity ? (BaseActivity) context : null;
        init();

    }
    /**
     * Perform inflation from XML and apply a class-specific base style from a theme attribute.
     * This constructor of View allows subclasses to use their own base style
     * when they are inflating. For example, a Button class's constructor would call
     * this version of the super class constructor and supply R.attr.buttonStyle for defStyleAttr;
     * this allows the theme's button style to modify all of the base view attributes
     * (in particular its background) as well as the Button class's attributes.
     * @param context The Context the view is running in, through which it can access
     *                the current theme, resources, etc.
     * @param attrs The attributes of the XML tag that is inflating the view.
     *              This value may be null.
     * @param defStyle An attribute in the current theme that contains a reference to
     *                 a style resource that supplies default values for the view.
     *                 Can be 0 to not look for defaults.
     */
    public SoftkeyConfigView(final Context context, final AttributeSet attrs, final int defStyle) {
        super(context, attrs, defStyle);
        mActivity = context instanceof BaseActivity ? (BaseActivity) context : null;
        init();
    }
    private static final String SOFTKEY = "__SOFTKEY__";
    private static final String SOFTKEYS = "__SOFTKEYS__";
    private static final String MODIFICATOR_SOFTKEYS = "__MODIFICATOR_SOFTKEYS__";

    private static final String SOFTKEYBUTTON = "__SOFTKEYBUTTON__";
    private static final String ALL_SOFTKEYS = "ALL_SOFTKEYS";
    private void showDialog(final SettingsActivity activity, final Softkey key) {
        SettingsActivity.CurrentEmulationCallbacks cec = activity.getCurrentEmulationCallbacks();
        DialogFragment f = new SoftkeyModificatorFragment();
        Bundle b = new Bundle();
        b.putSerializable(SOFTKEY, key);
        b.putSerializable(SOFTKEYS, cec.getSoftkeys());
        b.putSerializable(MODIFICATOR_SOFTKEYS, cec.getModificatorSoftkeys());

        b.putSerializable(ALL_SOFTKEYS, mSoftkeyList);
        f.setArguments(b);
        f.showNow(activity.getSupportFragmentManager(), SOFTKEY);

    }
    private void init() {
        Log.v(TAG, "init started");
        LayoutInflater inflater
                = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        @SuppressLint("InflateParams")
        LinearLayout root  = inflater.inflate(R.layout.viewgroup_softkeys_config, this)
                .findViewById(R.id.root);
        BaseActivity.setViewListeners(root.findViewById(R.id.bn_add_softkey), () -> {
            Softkey k = new Softkey();
            k.mId = UUID.randomUUID().toString();
            showDialog((SettingsActivity) getContext(), k);
        }, this::onBackPressed);
        Log.v(TAG, "init finished");

    }

    static final class Softkey implements Serializable {
        private String mId = null;
        private String mLabel = null;
        private String mKeyId = null;
        /** @noinspection FieldMayBeFinal*/
        private String mModificatorKeyId = null;
        private boolean mHideOnKeyboard = true;
        private boolean mHideOnGamepad = true;
        private List<NeutralButton> mGamepadButtons = new LinkedList<>();
        List<NeutralButton> getGamepadButtons() {
            return mGamepadButtons;
        }
        String getId() {
            return mId;
        }
        String getLabel() {
            return mLabel;
        }
        String getModificatorKeyId() {
            return mModificatorKeyId;
        }
        public String getKeyId() {
            return mKeyId;
        }
        boolean isHiddenWithKeyboard() {
            return mHideOnKeyboard;
        }
    }
}
