//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


package de.rainerhock.eightbitwonders;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;

abstract class SimpleSettingsJoystick extends Joystick {
    public static class JoystickConfigFragment extends InputDeviceConfigFragment {
        // CHECKSTYLE DISABLE RedundantModifier FOR 1 LINES
        public JoystickConfigFragment() {
            super();
        }
        private int mRessourceId = 0;
        @Override
        public View onCreateView(@NonNull final LayoutInflater inflater,
                                 final ViewGroup container,
                                 final Bundle savedInstanceState) {
            if (mRessourceId != 0) {
                View ret = inflater.inflate(mRessourceId, container, false);
                if (getParentFragment() == null) {
                    ((SettingsActivity) requireActivity()).addView(ret);
                }
                return ret;
            }

            return null;
        }

    }

    protected abstract int getRessourceId();

    @Override
    public final InputDeviceConfigFragment getDstickConfigFragment() {
        if (getRessourceId() != 0) {
            JoystickConfigFragment jcf = new JoystickConfigFragment();
            jcf.mRessourceId = getRessourceId();
            return jcf;
        } else {
            return null;
        }

    }
}
