package de.rainerhock.eightbitwonders;

import static android.graphics.Bitmap.CompressFormat.PNG;

import static de.rainerhock.eightbitwonders.DialogsView.UiElement.ADD_TO_START;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.format.DateFormat;
import android.util.Log;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.ToggleButton;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.PopupMenu;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.ViewPager2;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public final class SaveStateFragment
        extends DialogsView.StatefulFragment<SaveStateFragment.SaveStateState> {
    static Bundle getBundle(final EmulationActivity ui,
                            final Bitmap bmp,
                            final int timemachineOffset) {
        Bundle b = new Bundle();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (bmp != null) {
            bmp.compress(PNG, FULLQUALITY, baos);
            b.putByteArray("pixeldata", baos.toByteArray());
            b.putInt("bitmapwidth", bmp.getWidth());

        } else {
            b.putInt("bitmapwidth",
                    ui.getViewModel().getCanvasSize(ui.getViewModel().getCurrentDisplayId()).x);
        }

        b.putString("rootpath", ui.getViewModel().getSnapshotPath());
        b.putInt("timemachine_offset", timemachineOffset);
        return b;
    }
    Toast mToast = null;

    @Override
    public void onStop() {
        super.onStop();
        if (mToast != null) {
            mToast.cancel();
        }
    }

    private static final String SAVESTATE_SWIPE_HINT_SHOWN = "SAVESTATE_SWIPE_HINT_SHOWN";
    @Override public void onStart() {

        super.onStart();
        if (getContext() != null && getDialog() != null && !BaseActivity.isTv(getContext())) {
            Useropts opts = new Useropts(getContext());
            if (!opts.getBooleanValue(SAVESTATE_SWIPE_HINT_SHOWN, false)) {
                opts.setValue(Useropts.Scope.GLOBAL, SAVESTATE_SWIPE_HINT_SHOWN, true);
                mToast = Toast.makeText(getContext(), R.string.savestates_swipe_hint,
                        Toast.LENGTH_LONG);
                mToast.setGravity(Gravity.TOP, 0,0);
                mToast.show();
            }
            Window window = getDialog().getWindow();
            if (window != null) {
                WindowManager.LayoutParams windowParams = window.getAttributes();
                windowParams.flags |= WindowManager.LayoutParams.FLAG_DIM_BEHIND;
                window.setAttributes(windowParams);
            }
        }
    }
    private static final int CURRENT_ENTRY = -1;
    private static final int FULLQUALITY = 100;
    static final int NO_TIMEMACHINE = -1;

    private static final int NUMBER_OF_SNAPSHOTS = 6;
    private static List<String> getSubdirectories() {
        List<String> ret = new LinkedList<>();
        for (int i = 0; i < NUMBER_OF_SNAPSHOTS; i++) {
            ret.add(String.valueOf(i));
        }
        return ret;
    }

    private List<SaveState> getSaveStates(
            final EmulationActivity activity,
            final File snapshotsRoot) {
        List<SaveState> savestates = new LinkedList<>();
        final String logTag = getClass().getSimpleName() + ".showSaveStateDialog";
        if (!snapshotsRoot.exists()) {
            if (!snapshotsRoot.mkdirs()) {
                Log.e(logTag, String.format("Cannon create %s as snapshot path",
                        snapshotsRoot.getAbsolutePath()));
            }
        }
        for (String subdir : getSubdirectories()) {
            File path = new File(snapshotsRoot, subdir);
            savestates.add(new SaveState(activity) {

                @NonNull
                @Override
                public File getLabelFile() {
                    return new File(path, "timestamp");
                }

                @NonNull
                @Override
                public File getDataFile() {
                    return new File(path, "data");
                }

                @NonNull
                @Override
                public File getScreenshotFile() {
                    return new File(path, "screenshot");
                }
            });
        }
        return savestates;
    }


    @Override
    SaveStateState createDefaultState() {
        return new SaveStateState();
    }
    static class SaveStateAdapter extends RecyclerView.Adapter<SaveStateViewHolder> {
        private final List<SaveState> mSaveStates;
        private final @NonNull  Bundle mParameters;
        private final EmulationActivity mActivity;
        private final SaveStateState mUiState;
        private final SaveStateFragment mFragment;

        SaveStateAdapter(final List<SaveState> states,
                         final @NonNull Bundle bundle,
                         final EmulationActivity activity,
                         final SaveStateFragment fragment,
                         final SaveStateState state) {
            super();
            mSaveStates = states;
            mParameters = bundle;
            mActivity = activity;
            mUiState = state;
            mFragment = fragment;

        }

        @Override
        public void onBindViewHolder(final @NonNull SaveStateViewHolder holder,
                                     final int position,
                                     final @NonNull List<Object> payloads) {
            super.onBindViewHolder(holder, position, payloads);
            ViewGroup view = holder.mView;
            mUiState.mDatafile = mSaveStates.get(position).getDataFile();
            updateDescription(mActivity, view, mSaveStates.get(position));
            updateButtons(mActivity, mActivity.getViewModel().getEmulation(),
                    mActivity.getViewModel().getConfiguration(), view,
                    mActivity.getCurrentBitmap(), mSaveStates.get(position),
                    mParameters.getInt("timemachine_offset"),
                    () -> {
                        updateDescription(mActivity, view, mSaveStates.get(position));
                        Button viewSave = view.findViewById(R.id.bn_save);
                        viewSave.setText(R.string.save);
                    });

        }
        private void updateDescription(final EmulationActivity ui, final View snapshotView,
                                       final SaveState state) {
            final File timestamp = state.getLabelFile();
            final Bitmap bmp = state.getBitmap();
            final ImageView viewScreenshot = snapshotView.findViewById(R.id.iv_bitmap);
            final TextView viewNoScreenShot = snapshotView.findViewById(R.id.tv_no_bitmap);
            if (bmp != null) {
                viewScreenshot.setImageBitmap(bmp);
            } else {
                if (ui.getCurrentBitmap() != null) {
                    viewScreenshot.setImageBitmap(ui.getCurrentBitmap());
                }
                viewScreenshot.setVisibility(View.INVISIBLE);
                viewNoScreenShot.setVisibility(View.VISIBLE);
            }
            TextView viewTimestamp = snapshotView.findViewById(R.id.tv_description);
            try {
                viewTimestamp.setText(
                        new BufferedReader(new FileReader(timestamp)).readLine());
            } catch (IOException ioException) {
                viewTimestamp.setText(ui.getResources()
                        .getString(R.string.available_snapshot_slot));
            }
        }
        @NonNull
        @Override
        public SaveStateViewHolder onCreateViewHolder(final @NonNull ViewGroup parent,
                                                      final int viewType) {
            ViewGroup view = (ViewGroup) LayoutInflater.from(parent.getContext()).inflate(
                    R.layout.fragment_single_snapshot, parent, false);

            return new SaveStateViewHolder(view);
        }
        private void dismiss() {
            mRunOnDismiss.run();
        }
        // CHECKSTYLE DISABLE ParameterNumber FOR 1 LINES
        private void updateButtons(final EmulationActivity ui,
                                   final Emulation emu,
                                   final EmulationConfiguration conf,
                                   final ViewGroup rootView,
                                   final Bitmap currentScreenshot,
                                   final SaveState state,
                                   final int timemachineOffset,
                                   final Runnable runUpdateTab) {
            File rootFolder = state.getDataFile().getParentFile();
            final File timestamp = state.getLabelFile();
            final File data = state.getDataFile();
            final File screenshot = state.getScreenshotFile();
            final Bitmap bmp = state.getBitmap();
            boolean calledFromTimemachine = timemachineOffset != NO_TIMEMACHINE;
            View viewStart = rootView.findViewById(R.id.bn_start);
            Runnable r = () -> {
                boolean ret;
                Emulation.PackCurrentStateFunctions pcsf = emu.getPackCurrentStateFunctions();
                File snapshotfile;
                Runnable deleteFile = () -> {
                };
                if (calledFromTimemachine) {
                    try {
                        snapshotfile = File.createTempFile("__dump__", "");
                        final File toDelete = snapshotfile;
                        //noinspection ResultOfMethodCallIgnored
                        deleteFile = toDelete::delete;
                    } catch (IOException e) {
                        snapshotfile = data;
                    }
                    // storing unencrypted is ok since file will be deleted immediately.
                    ret = pcsf != null && pcsf.writeDump(timemachineOffset,
                            snapshotfile.getAbsoluteFile(), conf);
                } else {
                    snapshotfile = data;
                    ret = true;
                }
                ret = ret && pcsf.loadSnapshot(snapshotfile.getAbsolutePath(), conf);
                deleteFile.run();
                if (ret) {
                    if (bmp != null) {
                        ui.setBitmap(ui.getViewModel().getCurrentDisplayId(), bmp);
                    }
                    mFragment.dismiss();
                    mFragment.setDelayAfterDialog(true);
                } else {
                    ui.showErrorMessage(ui.getResources().getString(
                            R.string.IDS_CANNOT_READ_SNAPSHOT_IMG));
                }
            };
            boolean dataExists = data.exists() && timestamp.exists() && !calledFromTimemachine;
            viewStart.setVisibility(dataExists ? View.VISIBLE : View.GONE);
            BaseActivity.setViewListeners(viewStart, r, this::dismiss);
            View viewMore = rootView.findViewById(R.id.bn_more);
            mParameters.get("timemachine_offset");
            if (data.exists() && timestamp.exists() && conf != null) {
                final PopupMenu pm = createSaveStatePopup(ui, emu, viewMore,
                        timestamp, data, screenshot, bmp,
                        mParameters.getInt("timemachine_offset"), conf, () -> {
                            rootView.findViewById(R.id.bn_save).requestFocus();
                            viewStart.setVisibility(View.GONE);
                            viewMore.setVisibility(View.GONE);
                            runUpdateTab.run();

                        });
                viewMore.setVisibility(pm != null && !calledFromTimemachine
                        ? View.VISIBLE : View.GONE);
                if (pm != null) {
                    BaseActivity.setViewListeners(viewMore, pm::show, () ->
                                    BaseActivity.showGamepadMenu(viewMore, pm.getMenu()),
                            this::dismiss);
                }
            } else {
                viewMore.setVisibility(View.GONE);
            }
            Button viewSave = rootView.findViewById(R.id.bn_save);
            viewSave.setText(dataExists ? R.string.overwrite : R.string.save);

            setSaveListener(ui, emu, conf, currentScreenshot, timemachineOffset,
                    calledFromTimemachine, state, viewSave, rootFolder);

        }
        // CHECKSTYLE DISABLE ParameterNumber FOR 1 LINES
        private @Nullable PopupMenu createSaveStatePopup(final @NonNull EmulationActivity ui,
                                                         final Emulation emu,
                                                         final View viewMore,
                                                         final File timestamp,
                                                         final File data,
                                                         final File screenshot,
                                                         final Bitmap bmp,
                                                         final int timeMachineOffset,
                                                         final EmulationConfiguration conf,
                                                         final Runnable runAfterDelete) {
            PopupMenu pm = new PopupMenu(ui, viewMore);
            pm.inflate(R.menu.menu_savestate_extendend);
            Menu m = pm.getMenu();

            final Emulation.PackCurrentStateFunctions pcsf = emu.getPackCurrentStateFunctions();
            m.findItem(R.id.mi_delete).setVisible(timestamp != null
                    && (timestamp.exists() || data.exists()) && runAfterDelete != null);
            m.findItem(R.id.add_to_main_activity).setVisible(
                    conf.isBareMachine() && timestamp != null);
            m.findItem(R.id.update_main_activity).setVisible(conf.getLocalPath() != null
                    && timestamp != null);
            m.findItem(R.id.export_screenshot).setVisible(timestamp != null);
            m.findItem(R.id.start_from_here).setVisible(conf.getLocalPath() != null
                    && conf.isStream() && emu.getInitialSnapshotStorer() != null
                    && timestamp != null);
            m.findItem((R.id.share)).setVisible(!conf.isStream() && pcsf != null
                    && timestamp != null);
            pm.setOnMenuItemClickListener(menuItem -> {
                if (menuItem.getItemId() == R.id.mi_delete && runAfterDelete != null) {
                    if (timestamp != null) {
                        //noinspection ResultOfMethodCallIgnored
                        timestamp.delete();
                    }
                    //noinspection ResultOfMethodCallIgnored
                    data.delete();
                    if (screenshot.exists()) {
                        //noinspection ResultOfMethodCallIgnored
                        screenshot.delete();
                    }
                    runAfterDelete.run();
                } else if (menuItem.getItemId() == R.id.add_to_main_activity) {
                    Bundle b = new Bundle();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    if (bmp != null) {
                        bmp.compress(PNG, FULLQUALITY, baos);
                        b.putByteArray("pixeldata", baos.toByteArray());
                    }
                    if (data != null) {
                        b.putString("savestate", data.getAbsolutePath());
                    }
                    mActivity.getDialogsController().showUiElement(ADD_TO_START, b);
                } else if (menuItem.getItemId() == R.id.update_main_activity) {
                    ConfigurationFactory.updateBitmap(conf, bmp);
                    Intent i = new Intent(
                            "de.rainerhock.eightbitwonders.update");
                    i.setPackage("de.rainerhock.eightbitwonders");
                    ui.sendBroadcast(i);
                    viewMore.post(this::dismiss);
                    //dismiss();
                } else if (menuItem.getItemId() == R.id.export_screenshot) {
                    try {
                        BaseActivity.exportScreenshot(ui, bmp, true);
                        //ui.startActivityForResult(chooser, EmulationActivity.REQUEST_SHARE);

                    } catch (FileNotFoundException e) {
                        // should not happen
                    }
                } else if (menuItem.getItemId() == R.id.share) {
                    boolean tm = timeMachineOffset != NO_TIMEMACHINE;

                    Runnable r = () -> {
                    };
                    if (pcsf != null) {
                        if (data != null) {
                            r = pcsf.getImportContentsRunnable(data, conf);
                        } else {
                            if (tm) {
                                r = pcsf.getDumpContentsRunnable(timeMachineOffset, conf);
                            } else {
                                r = pcsf.getDumpContentsRunnable(0, conf);
                            }
                        }
                    }
                    Intent i = ConfigurationFactory.prepareCreatePackageIntent(
                            ui, emu, conf, r, bmp);
                    if (timestamp != null) {
                        i.putExtra("no_timemachine", true);
                    }
                    ui.shareContent(i, true);
                    dismiss();
                } else if (menuItem.getItemId() == R.id.start_from_here) {
                    emu.getInitialSnapshotStorer().run();
                    dismiss();
                }
                return true;
            });
            for (int i = 0; i < pm.getMenu().size(); i++) {
                if (pm.getMenu().getItem(i).isVisible()) {
                    return pm;
                }
            }
            return null;
        }
        // CHECKSTYLE DISABLE ParameterNumber FOR 1 LINES
        private void setSaveListener(final EmulationActivity ui,
                                     final Emulation emu,
                                     final EmulationConfiguration conf,
                                     final Bitmap currentScreenshot,
                                     final int timemachineOffset,
                                     final boolean calledFromTimemachine,
                                     final SaveState state,
                                     final View viewSave,
                                     final File dir) {
            BaseActivity.setViewListeners(viewSave, () -> {
                final File data = state.getDataFile();
                final File timestamp = state.getLabelFile();
                final File screenshot = state.getScreenshotFile();
                final String tag = SaveStateFragment.class.getSimpleName();
                boolean ok = false;
                if (dir != null) {
                    if (!(dir.isDirectory() || dir.mkdirs())
                    ) {
                        Log.e(tag, String.format(
                                "Cannon create %s as snapshot path",
                                dir.getAbsolutePath()));
                    }
                } else {
                    Log.e(tag, "rootFolder is null");
                }
                boolean ret;
                Emulation.PackCurrentStateFunctions pcsf = emu.getPackCurrentStateFunctions();
                if (calledFromTimemachine) {
                    ret = pcsf != null && pcsf.writeDump(timemachineOffset, data.getAbsoluteFile(),
                            conf);
                } else {
                    ret = pcsf != null && pcsf.writeDump(CURRENT_ENTRY, data.getAbsoluteFile(),
                            conf);
                }
                if (ret) {
                    if (currentScreenshot != null) {
                        try {
                            currentScreenshot.compress(Bitmap.CompressFormat.PNG,
                                    FULLQUALITY, new FileOutputStream(screenshot));
                        } catch (FileNotFoundException e) {
                            // that's ok
                        }
                    }
                    Date now = new Date();
                    FileWriter fw;
                    try {
                        fw = new FileWriter(timestamp.getAbsolutePath(), false);
                        fw.write(DateFormat.getDateFormat(
                                ui).format(now) + ", "
                                + DateFormat.getTimeFormat(ui)
                                .format(now));
                        fw.close();
                        ok = true;
                    } catch (IOException e) {
                        Log.e(tag, "error saving snapshot time", e);
                    }
                    if (ok) {
                        dismiss();
                    } else {
                        ui.showErrorMessage(ui.getResources().getString(
                                        R.string.IDS_CANNOT_WRITE_SNAPSHOT_S)
                                .replace(" ’%s’", ""));
                    }
                }

            }, this::dismiss);
        }
        private Runnable mRunOnDismiss = () -> { };
        @Override
        public void onBindViewHolder(final @NonNull SaveStateViewHolder holder,
                                     final int position) {
            final ViewGroup vg = holder.mView;
            mRunOnDismiss = () -> mActivity.getSupportFragmentManager().beginTransaction()
                    .remove(mFragment).commitNow();
            SaveState state = mSaveStates.get(position);
            final File timestamp = state.getLabelFile();
            final Bitmap bmp = state.getBitmap();
            final ImageView viewScreenshot = vg.findViewById(R.id.iv_bitmap);
            final TextView viewNoScreenShot = vg.findViewById(R.id.tv_no_bitmap);
            if (bmp != null) {
                viewScreenshot.setImageBitmap(bmp);
            } else {
                viewScreenshot.setImageBitmap(state.getDefaultBitmap());
                viewScreenshot.setVisibility(View.INVISIBLE);
                viewNoScreenShot.setVisibility(View.VISIBLE);
            }
            TextView viewTimestamp = vg.findViewById(R.id.tv_description);
            try {
                viewTimestamp.setText(
                        new BufferedReader(new FileReader(timestamp)).readLine());
            } catch (IOException ioException) {
                viewTimestamp.setText(vg.getResources()
                        .getString(R.string.available_snapshot_slot));
            }

        }
        @Override
        public int getItemCount() {
            return mSaveStates.size();
        }
    }
    static class SaveStateViewHolder extends RecyclerView.ViewHolder {
        private final ViewGroup mView;

        SaveStateViewHolder(final @NonNull View view) {
            super(view);
            mView = (ViewGroup) view;

        }
    }
    static class Indicators extends HashMap<Integer, ToggleButton> {

    }
    private void setIndicator(final Indicators indicators, final ViewPager2 vp, final int pos) {
        Objects.requireNonNull(indicators.get(vp.getCurrentItem()))
                        .setChecked(false);
        vp.setCurrentItem(pos);
        Objects.requireNonNull(indicators.get(pos))
                .setChecked(true);


    }
    @NonNull
    @Override
    View createUi(final @NonNull LayoutInflater inflater,
                  final @NonNull EmulationActivity activity,
                  final @NonNull Emulation emu,
                  final @NonNull EmulationConfiguration conf,
                  final SaveStateState state) {
        @SuppressLint("InflateParams")
        ViewGroup root = (ViewGroup) inflater.inflate(R.layout.dialog_savestates, null);

        ViewGroup container = root.findViewById(R.id.ll_indicator_container);
        Indicators indicators = new Indicators();
        for (int i = 0; i < NUMBER_OF_SNAPSHOTS; i++) {
            @SuppressLint("CutPasteId")
            ToggleButton tv = inflater.inflate(R.layout.view_page_indicator, container)
                    .findViewById(R.id.tv_indicator);
            String s = String.valueOf(i + 1);
            tv.setText(s);
            tv.setTextOff(s);
            tv.setTextOn(s);
            tv.setTag(String.format(Locale.getDefault(), "VP_%d", i + 1));
            indicators.put(i, tv);
            tv.setId(View.generateViewId());
        }
        List<SaveState> states =
                getSaveStates(activity, new File(Objects.requireNonNull(
                        requireArguments().getString("rootpath"))));
        ViewPager2  vp = root.findViewById(R.id.viewpager);
        vp.setAdapter(new SaveStateAdapter(states, requireArguments(),
                (EmulationActivity) getActivity(), this, state));
        vp.registerOnPageChangeCallback(new ViewPager2.OnPageChangeCallback() {
            @Override
            public void onPageSelected(final int position) {
                for (int i : indicators.keySet()) {
                    Objects.requireNonNull(indicators.get(i)).setChecked(i == position);
                }
            }
        });
        for (int i = 0; i < states.size(); i++) {
            if (states.get(i) != null && states.get(i).getDataFile().equals(state.mDatafile)) {
                vp.setCurrentItem(i);
            }
        }

        for (int id : indicators.keySet()) {
            View tv = indicators.get(id);
            Objects.requireNonNull(tv).setOnFocusChangeListener((v, hasFocus) -> {
                if (hasFocus) {
                    setIndicator(indicators, vp, id);
                }
            });
            tv.setOnClickListener(v -> setIndicator(indicators, vp, id));
            tv.setOnKeyListener((v, keyCode, event) -> {
                if (keyCode == KeyEvent.KEYCODE_DPAD_DOWN) {
                    View panel = Objects.requireNonNull(((RecyclerView) vp.getChildAt(0))
                            .findViewHolderForAdapterPosition(vp.getCurrentItem())).itemView;
                    if (panel instanceof ViewGroup) {
                        ViewGroup vg = (ViewGroup) panel;
                        boolean found = false;
                        for (int id1 : Arrays.asList(R.id.bn_start, R.id.bn_save, R.id.bn_more)) {
                            if (!found && vg.findViewById(id1).getVisibility() == View.VISIBLE) {
                                vg.findViewById(id1).requestFocus();
                                found = true;
                            }
                            vg.findViewById(id1).setNextFocusUpId(tv.getId());
                        }
                    }
                }
                return false;
            });
        }
        Objects.requireNonNull(indicators.get(vp.getCurrentItem())).setChecked(true);
        return root;

    }

    abstract static class SaveState {
        private final Bitmap mDefaultBitmap;

        @NonNull abstract File getLabelFile();
        @NonNull abstract File getDataFile();
        @Nullable abstract File getScreenshotFile();
        private final File mScreenshot = getScreenshotFile();
        private final File mTimestamp = getLabelFile();
        SaveState(final EmulationActivity ea) {
            super();
            mDefaultBitmap = ea.getCurrentBitmap();
        }
        private SaveState() {
            mDefaultBitmap = null;
        }
        Bitmap getBitmap() {
            if (mScreenshot != null && mScreenshot.exists()
                    && mTimestamp.exists() && getDataFile().exists()) {
                try {
                    return BitmapFactory.decodeStream(new FileInputStream(mScreenshot));
                } catch (FileNotFoundException e) {
                    return null;
                }
            }
            return null;
        }

        public Bitmap getDefaultBitmap() {
            return mDefaultBitmap;
        }
    }

    static class SaveStateState implements Serializable {

        private File mDatafile = null;
    }
    public static final class AddtoStartScreenFragment
            extends DialogsView.StatefulFragment<Serializable> {
        @Override
        boolean showAsDialog() {
            return true;
        }

        @Override
        Serializable createDefaultState() {
            return null;
        }

        @NonNull
        @Override
        View createUi(final @NonNull LayoutInflater inflater,
                      final @NonNull EmulationActivity ui,
                      final @NonNull Emulation emu,
                      final @NonNull EmulationConfiguration conf,
                      final Serializable state) {
            ViewGroup root = (ViewGroup) inflater.inflate(R.layout.dialog_createpackage, null);
            Emulation.TimeMachineFunctions tmf = ui.getViewModel().getEmulation()
                    .getTimeMachineFunctions();
            if (tmf != null && requireArguments()
                    .getString("savestate", null) == null) {
                byte[] buf = requireArguments().getByteArray("pixeldata");
                if (buf == null) {
                    buf = new byte[1];
                }
                Bitmap currentScreenshot = BitmapFactory.decodeByteArray(buf, 0, buf.length);
                DialogsView.initTimemachineSlider(root.findViewById(R.id.choose_moment),
                        currentScreenshot, tmf);
            } else {
                root.findViewById(R.id.choose_moment).setVisibility(View.GONE);
            }
            Button b = root.findViewById(R.id.pb_next);
            EditText etName = root.findViewById(R.id.tv_name);
            Runnable r = () -> {
                root.findViewById(R.id.part1).setVisibility(View.GONE);
                b.setVisibility(View.GONE);
                root.findViewById(R.id.part2).setVisibility(View.VISIBLE);
            };
            if (b != null) {
                if (root.findViewById(R.id.choose_moment).getVisibility() == View.GONE) {
                    r.run();
                } else {
                    b.setOnClickListener(view -> {
                        b.setVisibility(View.GONE);
                        root.findViewById(R.id.part1).setVisibility(View.GONE);
                        root.findViewById(R.id.part2).setVisibility(View.VISIBLE);
                        root.post(etName::requestFocus);
                        for (int action : Arrays.asList(MotionEvent.ACTION_DOWN,
                                MotionEvent.ACTION_UP)) {
                            MotionEvent me = MotionEvent.obtain(SystemClock.uptimeMillis(),
                                    SystemClock.uptimeMillis(),
                                    action, 0f, 0f, 0);
                            root.findViewById(R.id.tv_name).dispatchTouchEvent(me);
                            me.recycle();
                        }
                    });
                }
            } else {
                root.post(() -> {
                    root.findViewById(R.id.tv_name).requestFocus();
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                        InputMethodManager imm = root.getContext().getSystemService(InputMethodManager.class);
                        imm.showSoftInput(etName, 0);
                    }
                });

            }
            root.findViewById(R.id.bn_ok).setOnClickListener(view -> {
                int time;
                if (tmf != null) {
                    SeekBar sb = root.findViewById(R.id.sb_seekbar);
                    time = sb.getProgress();
                } else {
                    time = 0;
                }
                String path = requireArguments().getString("savestate", null);
                String name = String.valueOf(etName.getText());
                if (path != null) {
                    byte[] buf = requireArguments().getByteArray("pixeldata");
                    Bitmap bmp;
                    if (buf != null) {
                        bmp = BitmapFactory.decodeByteArray(buf, 0, buf.length);
                    } else {
                        bmp = null;
                    }
                    ConfigurationFactory.saveConfiguration(ui, name, bmp, new File(path));
                } else {
                    ConfigurationFactory.saveConfiguration(ui, name, time);
                }
                String s = getResources().getString(R.string.added_to_start_screen, name);
                Toast.makeText(getContext(), s, Toast.LENGTH_SHORT).show();
                InputMethodManager imm = (InputMethodManager) etName.getContext()
                        .getSystemService(Context.INPUT_METHOD_SERVICE);
                imm.hideSoftInputFromWindow(etName.getApplicationWindowToken(),
                        InputMethodManager.HIDE_NOT_ALWAYS);

                if (getActivity() != null) {
                    for (Fragment f : getActivity().getSupportFragmentManager().getFragments()) {
                        if (f instanceof SaveStateFragment) {
                            getActivity().getSupportFragmentManager().beginTransaction()
                                    .remove(f).commitNow();

                        }
                    }
                    for (Fragment f : getActivity().getSupportFragmentManager().getFragments()) {
                        if (f instanceof SaveStateFragment) {
                            ((SaveStateFragment) f).setPermanent(false);
                        }
                    }
                    getActivity().getSupportFragmentManager().beginTransaction()
                            .remove(this).commitNow();

                }
                dismiss();
            });

            return root;
        }
    }
    @Override
    boolean showAsDialog() {
        return true;
    }

}
