package de.rainerhock.eightbitwonders;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class RequiredJoysticksFragment
        extends DialogsView.StatefulFragment<RequiredJoysticksFragment.RequiredJoystickState> {
    private static final String INPUTDEVICETYPES = "INPUTDEVICETYPES";
    private static final String REQUIREDJOYSTICKS = "REQUIREDJOYSTICKS";
    private static final String JOYSTICKTYPES = "JOYSTICKTYPES";
    private static final int VIEW_ID_NONE = View.generateViewId();

    private static final int ERROR_COLOR = android.R.color.holo_red_light;
    private static void updateJoystickport(final EmulationActivity activity,
                                           final Joystick joy,
                                           final int port) {
        joy.setPortnumber(port);
        activity.getCurrentUseropts().setValue(
                Useropts.Scope.CONFIGURATION, "JOYSTICK_" + joy.getId() + "_PORT", port);

    }
    // CHECKSTYLE DISABLE ParameterNumber FOR 1 LINES
    private static RadioGroup addJoystickportView(final EmulationActivity activity,
                                                  final LinearLayout rootView,
                                                  final Emulation.JoystickFunctions jf,
                                                  final int port,
                                                  final boolean isRequired,
                                                  final Emulation.InputDeviceType requiredIdt,
                                                  final List<Joystick> availableJoysticks,
                                                  final Map<Integer, Joystick> joystickViewIds) {
        LayoutInflater inflater = (LayoutInflater) activity
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        @SuppressLint("InflateParams")
        LinearLayout ll = (LinearLayout) inflater.inflate(
                R.layout.view_assign_joystick, null);
        TextView tvRequired = ll.findViewById(R.id.tv_required);
        ((TextView) ll.findViewById(R.id.tv_joystickport)).setText(
                jf.getJoystickports().get(port));
        tvRequired.setVisibility(
                isRequired ? View.VISIBLE : View.GONE);
        RadioGroup rg = ll.findViewById(R.id.rg_hardware);
        @SuppressLint("InflateParams")
        RadioButton rbNone = (RadioButton) inflater
                .inflate(R.layout.view_radiobutton_joystick, null);
        int defaultColor = tvRequired.getCurrentTextColor();
        int errorColor = activity.getResources().getColor(ERROR_COLOR);
        rbNone.setText(R.string.IDS_NONE);
        rbNone.setId(VIEW_ID_NONE);
        rbNone.setOnCheckedChangeListener((compoundButton, b) -> {
            if (b) {
                tvRequired.setTextColor(errorColor);
            } else {
                tvRequired.setTextColor(defaultColor);
            }
        });
        rbNone.setOnClickListener(view -> {
            for (Joystick joy: availableJoysticks) {
                joy.readUseropts(activity);
                if (joy.getPortnumber() == port) {
                    updateJoystickport(activity, joy, Joystick.PORT_NOT_CONNECTED);
                }
            }
        });
        rg.addView(rbNone);
        boolean checked = false;
        for (int viewId : joystickViewIds.keySet()) {
            Joystick joy = joystickViewIds.get(viewId);
            if (joy != null && joy.getSupportedDeviceTypes().contains(requiredIdt)) {
                @SuppressLint("InflateParams")
                RadioButton rb = (RadioButton) inflater
                        .inflate(R.layout.view_radiobutton_joystick, null);
                rb.setId(viewId);
                rb.setText(Objects.requireNonNull(joystickViewIds.get(viewId)).toString());
                joy.setCurrentdevicetype(requiredIdt);
                joy.readUseropts(activity);
                if (joy.getPortnumber() == port) {
                    rb.setChecked(true);
                    checked = true;
                }
                rb.setOnClickListener(view -> {
                    Joystick thisJoy = joystickViewIds.get(viewId);
                    if (thisJoy != null) {
                        for (Joystick otherJoy : availableJoysticks) {
                            if (otherJoy.getHardwareDescriptor()
                                    .equals(thisJoy.getHardwareDescriptor())) {
                                updateJoystickport(activity, otherJoy, Joystick.PORT_NOT_CONNECTED);
                            }
                            if (otherJoy.getPortnumber() == port) {
                                updateJoystickport(activity, otherJoy, Joystick.PORT_NOT_CONNECTED);
                            }
                        }
                        updateJoystickport(activity, thisJoy, port);
                    }
                });

                rg.addView(rb);
            }
        }
        if (!checked) {
            rbNone.setChecked(true);
        }
        if (rg.getCheckedRadioButtonId() == VIEW_ID_NONE && isRequired) {
            tvRequired.setTextColor(activity.getResources().getColor(ERROR_COLOR));
        }

        rg.requestLayout();
        ll.requestLayout();
        rootView.addView(ll);
        return rg;

    }
    @Override
    RequiredJoystickState createDefaultState() {
        return new RequiredJoystickState();
    }

    @NonNull
    @Override
    View createUi(final @NonNull LayoutInflater inflater,
                  final @NonNull EmulationActivity activity,
                  final @NonNull Emulation emu,
                  final @NonNull EmulationConfiguration conf,
                  final RequiredJoystickState state) {

        List<Joystick> availableJoysticks = activity.getAvailableJoysticks();
        @SuppressWarnings("unchecked")
        HashMap<Integer, EmulationConfiguration.PreferredJoystickType> joysticktypes
                = (HashMap<Integer, EmulationConfiguration.PreferredJoystickType>)
                requireArguments().getSerializable(JOYSTICKTYPES);

        if (joysticktypes == null) {
            joysticktypes = new HashMap<>();
        }
        @SuppressWarnings("unchecked")
        List<Integer> required = (List<Integer>)
                requireArguments().getSerializable(REQUIREDJOYSTICKS);
        if (required == null) {
            required = new LinkedList<>();
        }
        @SuppressWarnings("unchecked")
        Map<Integer, Emulation.InputDeviceType> inputdevicestypes =
                (Map<Integer, Emulation.InputDeviceType>) requireArguments()
                        .getSerializable(INPUTDEVICETYPES);
        if (inputdevicestypes == null) {
            inputdevicestypes = new LinkedHashMap<>();
        }
        Map<Integer, Joystick> joystickViewIds = new HashMap<>();

        for (Joystick joy : availableJoysticks) {
            joy.readUseropts(activity);
            joystickViewIds.put(View.generateViewId(), joy);
        }
        final List<RadioGroup> allGroups = new ArrayList<>();
        @SuppressLint("InflateParams")
        ViewGroup root = (ViewGroup) inflater.inflate(R.layout.dialog_menu_singlerow, null);
        LinearLayout llJoysticks = root.findViewById(R.id.singlecol);
        for (int port : joysticktypes.keySet()) {
            Emulation.InputDeviceType requiredIdt;
            if (inputdevicestypes.containsKey(port)) {
                requiredIdt = inputdevicestypes.get(port);
            } else {
                requiredIdt = Emulation.InputDeviceType.DSTICK;
            }
            allGroups.add(addJoystickportView(
                    activity, llJoysticks, emu.getJoystickFunctions(),
                    port, required.contains(port), requiredIdt,
                    availableJoysticks, joystickViewIds));
        }
        for (RadioGroup rg : allGroups) {
            rg.setOnCheckedChangeListener((radioGroup, i) -> {
                if (i != VIEW_ID_NONE) {
                    for (RadioGroup otherGroup : allGroups) {
                        if (otherGroup != radioGroup) {
                            Joystick otherJoy = joystickViewIds.get(
                                    otherGroup.getCheckedRadioButtonId());
                            Joystick thisJoy = joystickViewIds.get(i);
                            if (otherJoy != null && thisJoy != null) {
                                if (otherJoy.getHardwareDescriptor()
                                        .equals(thisJoy.getHardwareDescriptor())) {
                                    ((RadioButton) otherGroup.findViewById(VIEW_ID_NONE))
                                            .setChecked(true);
                                    updateJoystickport(activity, otherJoy,
                                            Joystick.PORT_NOT_CONNECTED);
                                }
                            }
                        }
                    }
                }
            });
        }
        @SuppressLint("InflateParams")
        Button btnContinue = (Button) inflater.inflate(R.layout.view_dialog_button, null);
        btnContinue.setText(R.string.apply);
        BaseActivity.setViewListeners(btnContinue, () -> {
            activity.setDynamicUiElements();
            dismiss();
        }, this::dismiss);

        llJoysticks.addView(btnContinue);
        TextView tv = root.findViewById(R.id.tv_title);
        tv.setVisibility(View.VISIBLE);
        tv.setText(R.string.required_hardware);
        return root;
    }

    static Bundle getBundle(
            final Map<Integer, EmulationConfiguration.PreferredJoystickType> virtualJoystickTypes,
            final Map<Integer, Emulation.InputDeviceType> inputDeviceTypes,
            final List<Integer> requiredPorts) {
        Bundle b = new Bundle();
        b.putSerializable(JOYSTICKTYPES, new HashMap<>(virtualJoystickTypes));
        b.putSerializable(INPUTDEVICETYPES, new HashMap<>(inputDeviceTypes));
        b.putSerializable(REQUIREDJOYSTICKS, new LinkedList<>(requiredPorts));
        return b;
    }

    static class RequiredJoystickState implements Serializable {

    }
}
