//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


package de.rainerhock.eightbitwonders;


import java.util.Set;

/**
 * Listener to actions on a digital Joystick (8-directions, 1 button),
 * both real and virutal devices.
 */
interface JoystickListener {
    /**
     * Implementations of this method can react to actions on a digital joystick with 1 button.
     * None, some or all parameters can be true.
     * @param joyId id of the joystick that caused the value change
     * @param portnumber Number of the joystick
     * @param inputType Type of input device to be emulated.
     * @param absoluteValues true if the xvalue and yvalue are absolute positions,
     *                       false if xvalue and yvalue indicate a change
     *                       to be added to the position.
     * @param xvalue x axis value in range from
     *               -1 (full amplitude to the left) to
     *               +1 (full amplitute to the right)
     * @param yvalue y axis value in range from
     *               -1 (full amplitude to the top) to
     *               +1 (full amplitute to the bottom)
     * @param buttons joystick buttons currently pressed.
     */
    void onJoystickChanged(String joyId, Emulation.InputDeviceType inputType, int portnumber,
                           boolean absoluteValues,
                           float xvalue, float yvalue,
                           Set<Emulation.InputButton> buttons);
}
