package de.rainerhock.eightbitwonders;

import android.annotation.SuppressLint;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;

import androidx.annotation.NonNull;

import java.io.Serializable;
import java.util.Objects;
import java.util.Set;

public final class FliplistDialogFragment extends DialogsView.StatefulFragment<Serializable> {
    @NonNull
    @Override
    View createUi(final @NonNull LayoutInflater inflater,
                  final @NonNull EmulationActivity ui,
                  final @NonNull Emulation emu,
                  final @NonNull EmulationConfiguration conf,
                  final Serializable state) {
        Set<Uri> fl = conf.getFliplist();
        if (fl.isEmpty()) {
            fl = emu.getFliplistFunctions(null).getFilesInList();
        }
        Emulation.FliplistFunctions ff = emu.getFliplistFunctions(fl);
        ViewGroup root = (ViewGroup) inflater.inflate(R.layout.dialog_menu_singlerow, null);
        TextView tvTitle = root.findViewById(R.id.tv_title);
        tvTitle.setVisibility(View.VISIBLE);
        tvTitle.setText(R.string.flip_file);
        ViewGroup contents = root.findViewById(R.id.singlecol);
        boolean first = true;
        for (int drive : ff.getTargetDevices().keySet()) {
            @SuppressLint("InflateParams")
            TextView tv = (TextView) inflater.inflate(R.layout.view_dialog_sectiontitle, null);
            tv.setText(ff.getTargetDevices().get(drive));
            contents.addView(tv);
            for (Uri f : fl) {
                if (ff.canBePart(f)) {
                    @SuppressLint("InflateParams")
                    Button b = (Button) inflater.inflate(first
                            ? R.layout.view_dialog_first_button
                            : R.layout.view_dialog_button, null);
                    b.setText(f.getLastPathSegment());
                    b.setTag(drive);
                    if (ff.getAttachedImage(drive) != null) {
                        if (Objects.equals(f.getPath(), ff.getAttachedImage(drive).getPath())) {
                            b.setEnabled(false);
                            b.setFocusable(false);
                            first = false;
                        }
                    }
                    if (b.isEnabled()) {
                        BaseActivity.setViewListeners(b, () -> {
                            if (ff.attach(drive, f)) {
                                dismiss();
                            }
                        }, this::dismiss);
                    }
                    contents.addView(b);
                }
            }
        }
        return root;
    }
    @Override
    int getContainerViewId() {
        return R.id.menucontainer_featurelist_anchor;
    }
    @Override
    Serializable createDefaultState() {
        return null;
    }

}
