//  ---------------------------------------------------------------------------
//  This file is part of 8-Bit Wonders, a retro emulator for android.
//  Copyright (C) 2022  Rainer Hock <eight.bit.wonders@gmail.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  ---------------------------------------------------------------------------


package de.rainerhock.eightbitwonders;

import android.content.Context;

import java.util.List;

public interface EmulationFactory {
    /**
     * List of all available emulations.
     * @return List of emulation-IDs
     */
    List<String> getEmulatorIds();
    /**
     * Start an new emulation.
     * @param ui implementation of {@link EmulationUi} the emulation interacts with
     * @param config configuration
     * @return a new Emulation or null if an error occurred.
     */
    Emulation newEmulation(EmulationUi ui, EmulationConfiguration config);

    /**
     * Create a {@link Runnable} that prepares the emulation with the given id.
     * If a non-zero value is returned, the Runnable is run while a "Please-Wait" dialog is shown
     * @param emulatorId id of the emulator to be prepared. Must be an element of the list
     *                   returned by {@link #getEmulatorIds()}
     * @param context current {@link android.content.Context}
     * @exception Exception any Exception, the localized message is shown as error.
     * @return a Runneable to be run.
     */
    DownloaderFactory.Downloader getPrepareEmulationRunnable(Context context,
                                                             String emulatorId)
            throws Exception;

}
