package de.rainerhock.eightbitwonders;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.io.Serializable;

// CHECKSTYLE DISABLE ParameterNumber FOR 1 LINES
public final class BePreparedDialogFragment extends
        DialogsView.StatefulFragment<Serializable> {

    @Override
    public void onDetach() {
        if (mThread != null) {
            mThread.interrupt();
        }
        mThread = null;
        super.onDetach();
    }

    private Thread mThread = null;

    private void startCounting() {
        final int count = EmulationActivity.PAUSE_TICK_COUNT;
        final int delay = EmulationActivity.PAUSE_TICK_DURATION;
        ProgressBar b = requireView().findViewById(R.id.pb_be_prepared_progress);
        b.setMax(count);
        b.setProgress(count);

        mThread = new Thread(() -> {
            int c = count;
            while (c > 0) {
                try {
                    Thread.sleep(delay);
                } catch (InterruptedException e) {
                    return;
                }
                c--;
                final int c2 = c;
                requireActivity().runOnUiThread(() -> b.setProgress(c2));

            }
            requireActivity().runOnUiThread(new Thread(this::dismiss));

        });
        mThread.start();
    }


    @Override
    Serializable createDefaultState() {
        return null;
    }

    @NonNull
    @Override
    View createUi(final @NonNull LayoutInflater inflater,
                  final @NonNull EmulationActivity activity,
                  final @NonNull Emulation emu,
                  final @NonNull EmulationConfiguration conf,
                  final Serializable state) {
        @SuppressLint("InflateParams")
        ViewGroup root = (ViewGroup) inflater.inflate(
                R.layout.dialog_be_prepared, null, false);

        return root;

    }

    @Override
    public View onCreateView(final @NonNull LayoutInflater inflater,
                             final @Nullable ViewGroup parent,
                             final @Nullable Bundle savedInstanceState) {
        View ret = super.onCreateView(inflater, parent, savedInstanceState);
        new Handler(Looper.getMainLooper()).post(this::startCounting);
        return ret;
    }

    @Override
    int getContainerViewId() {
        return R.id.menucontainer_center_anchor;
    }
}
