package de.rainerhock.eightbitwonders;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ServiceInfo;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.IBinder;

import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;

import java.util.Objects;

public final class AudioService extends Service {
    private static final String CONFIGURATION = "CONFIGURATION";
    private static final String NOTIFY_PAUSED_EMULATION = "NOTIFY_PAUSED_EMULATION";
    private static final String NOTIFY_RUNNING_EMULATION = "NOTIFY_RUNNING_EMULATION";
    private static final int NOTIFICATION_ID = 1001;
    static final String CHANNEL_ID = Objects.requireNonNull(
            BaseActivity.class.getPackage()).getName();
    private static final String ORIGINAL_INTENT = "ORIGINAL_INTENT";
    private static final String EMULATION_NAME = "EMULATION_NAME";
    private static final String REMOVE_PAUSE_STATE = "REMOVE_PAUSE_STATE";
    private static final String UI_WAS_SET = "UI_WAS_SET";

    static void hideResumeNotification(final Context ctx) {
        Intent intent = new Intent(ctx, AudioService.class);
        intent.setAction(REMOVE_PAUSE_STATE);
        ctx.startService(intent);
    }
    static EmulationConfiguration extractConfiguration(final Intent intent) {
        return (EmulationConfiguration) intent.getSerializableExtra(CONFIGURATION);

    }
    @SuppressLint("MissingPermission")
    static void showResumeNotification(final Context context, final Intent callbackEvent,
                                       final String emulationName,
                                       final boolean emulationIsPaused) {
        Intent intent = new Intent(context, AudioService.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_REORDER_TO_FRONT
                | Intent.FLAG_ACTIVITY_CLEAR_TOP
                | Intent.FLAG_ACTIVITY_SINGLE_TOP);

        intent.setAction(emulationIsPaused ? NOTIFY_PAUSED_EMULATION : NOTIFY_RUNNING_EMULATION);
        intent.putExtra(ORIGINAL_INTENT, callbackEvent);
        intent.putExtra(EMULATION_NAME, emulationName);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            context.startForegroundService(intent);
        } else {
            context.startService(intent);
        }

    }

    @SuppressLint("MissingPermission")
    private Notification pushToNotificationChannel(final Intent notificationIntent,
                                                   final boolean paused) {
        Intent callbackIntent = notificationIntent.getParcelableExtra(ORIGINAL_INTENT);
        if (callbackIntent != null) {
            callbackIntent.putExtra(EmulationActivity.PAUSE_FROM_NOTIFICATION, paused);
            notificationIntent.setAction(
                    NOTIFY_PAUSED_EMULATION.equals(notificationIntent.getAction())
                            ? NOTIFY_RUNNING_EMULATION : NOTIFY_PAUSED_EMULATION);
            PendingIntent pendingIntent = PendingIntent.getActivity(this, 0,
                    callbackIntent,
                    PendingIntent.FLAG_UPDATE_CURRENT | PendingIntent.FLAG_IMMUTABLE);
            String title = getResources().getString(paused
                            ? R.string.paused_in_background
                            : R.string.emulation_running_in_background,
                    notificationIntent.getStringExtra(EMULATION_NAME));
            NotificationCompat.Builder builder = new NotificationCompat.Builder(this, CHANNEL_ID)
                    .setSmallIcon(R.drawable.smallicon)
                    .setContentTitle(title)
                    .setContentText(getResources().getString(R.string.resume_to,
                            notificationIntent.getStringExtra(EMULATION_NAME)))
                    .setPriority(NotificationCompat.PRIORITY_DEFAULT)
                    .setContentIntent(pendingIntent)
                    .setAutoCancel(false);


            PendingIntent pPPendingIntent = PendingIntent.getService(
                    this, 0, notificationIntent,
                    PendingIntent.FLAG_UPDATE_CURRENT | PendingIntent.FLAG_IMMUTABLE);
            int icon = paused ? R.drawable.ic_media_play : R.drawable.ic_media_pause;
            String text = getResources().getString(paused ? R.string.cont : R.string.pause);
            builder.addAction(icon, text, pPPendingIntent);
            NotificationManagerCompat notificationManager = NotificationManagerCompat.from(this);
            Notification notification = builder.build();
            notificationManager.notify(NOTIFICATION_ID, notification);
            return notification;
        }
        return null;

    }

    @Override
    public void onDestroy() {
        NotificationManagerCompat notificationManager = NotificationManagerCompat.from(this);
        notificationManager.cancel(NOTIFICATION_ID);
        super.onDestroy();
    }

    @Override
    public IBinder onBind(final Intent intent) {
        return null;
    }

    @Override
    public int onStartCommand(final Intent intent, final int flags, final int startId) {
        if (REMOVE_PAUSE_STATE.equals(intent.getAction())) {
            NotificationManagerCompat notificationManager = NotificationManagerCompat.from(this);
            notificationManager.cancel(NOTIFICATION_ID);
            stopService(intent);
        }
        Notification notification = null;
        boolean pause = false;
        if (NOTIFY_PAUSED_EMULATION.equals(intent.getAction())) {
            notification = pushToNotificationChannel(intent, true);
            pause = true;
        } else if (NOTIFY_RUNNING_EMULATION.equals(intent.getAction())) {
            notification = pushToNotificationChannel(intent, false);
        }
        if (notification != null) {
            Emulation emu = Emulationslist.getCurrentEmulation();
            emu.setPaused(pause);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
                startForeground(NOTIFICATION_ID, notification,
                        ServiceInfo.FOREGROUND_SERVICE_TYPE_MEDIA_PLAYBACK);
            } else {
                startForeground(NOTIFICATION_ID, notification);
            }
            EmulationConfiguration conf = (EmulationConfiguration) intent
                    .getSerializableExtra(CONFIGURATION);
            if (conf != null && emu != null) {
                if (!intent.hasExtra(UI_WAS_SET)) {
                    emu.setEmulationUI(new EmulationUiImpl(this, conf));
                    intent.putExtra(UI_WAS_SET, true);
                }
                emu.setPaused(pause);
            }

        }
        return START_NOT_STICKY;
    }

    void setBitmap(final Bitmap bitmap) {
    }
}
