package de.rainerhock.eightbitwonders;

import android.content.Context;

import androidx.annotation.StringRes;

class AgeVerification {
    interface AgeVerificationProvider {
        void checkAccess(Context ctx, AgeVerificationUi ui, Runnable runOnSuccess);
    }
    interface AgeVerificationUi {
        void showMessage(Context ctx, @StringRes int text);
        void setUserNonAffected(Context ctx);
    }
    private static final String USER_IS_AFFECTED = "USER_IS_AFFECTED_BY_AGE_VERIFICATION";
    private static final boolean DO_AGE_VERIFICATION = false;

    static void runIfAgeVerified(BaseActivity activity, Runnable runOnSuccess) {
        boolean checkRequired = BaseActivity.isInUnitTest()
                || new Useropts(activity).getBooleanValue(USER_IS_AFFECTED, DO_AGE_VERIFICATION);
        if (checkRequired) {
            AgeVerificationUi ui = new AgeVerificationUi() {
                @Override
                public void showMessage(Context ctx, int text) {
                    BaseActivity.AlertDialogBuilder.showStyledDialog(new BaseActivity.AlertDialogBuilder(ctx)
                            .setIcon(android.R.drawable.ic_dialog_alert)
                            .setTitle(R.string.age_verificaton)
                            .setMessage(text)
                            .setPositiveButton(R.string.ok,
                                    (dialogInterface, i) -> {
                                        dialogInterface.dismiss();
                                    }).create());

                }
                @Override
                public void setUserNonAffected(Context ctx) {
                    if (!BaseActivity.isInUnitTest()) {
                        new Useropts(ctx).setValue(Useropts.Scope.GLOBAL, USER_IS_AFFECTED, false);
                    }
                }
            };
            new AgeVerificationProviderImpl().checkAccess(activity, ui, runOnSuccess);
        } else {
            runOnSuccess.run();
        }
    }
}
