#version 100
precision mediump float;

#pragma id shader_upscaling

#pragma parameter u_Blur 0.25 0.0 1.0

uniform sampler2D uTexture;
varying vec2 v_TexCoord;
uniform vec2 u_BitmapSize;
uniform float u_Blur;

void main() {
    vec2 uTexelSize = 1.0 / u_BitmapSize;
    vec4 center = texture2D(uTexture, v_TexCoord);
    vec4 left   = texture2D(uTexture, v_TexCoord + vec2(-uTexelSize.x, 0.0));
    vec4 right  = texture2D(uTexture, v_TexCoord + vec2(uTexelSize.x, 0.0));
    vec4 top    = texture2D(uTexture, v_TexCoord + vec2(0.0, -uTexelSize.y));
    vec4 bottom = texture2D(uTexture, v_TexCoord + vec2(0.0, uTexelSize.y));

    vec4 topLeft     = texture2D(uTexture, v_TexCoord + vec2(-uTexelSize.x, -uTexelSize.y));
    vec4 topRight    = texture2D(uTexture, v_TexCoord + vec2(uTexelSize.x, -uTexelSize.y));
    vec4 bottomLeft  = texture2D(uTexture, v_TexCoord + vec2(-uTexelSize.x, uTexelSize.y));
    vec4 bottomRight = texture2D(uTexture, v_TexCoord + vec2(uTexelSize.x, uTexelSize.y));

    vec4 edgeBlend = (
    left + right + top + bottom +
    topLeft + topRight + bottomLeft + bottomRight
    ) / 8.0;
    vec4 result = mix(center, edgeBlend, u_Blur);
    gl_FragColor = result;
}