precision mediump float;

#pragma id shader_crt_emulation
#pragma parameter u_Curvature 0.05 0.0 0.3
#pragma parameter u_ScanlineIntensity 0.04 0.0 0.2
#pragma parameter u_VignetteStrength 0.2 0.0 1.0
#pragma parameter u_phosphorGlow 0.1 0.0 0.5
#pragma parameter u_Noise 0.1 0.0 0.3
#pragma parameter u_Saturation 1.0 0.0 2.0

uniform sampler2D u_Texture;
uniform float u_Curvature;
uniform float u_ScanlineIntensity;
uniform vec2 u_BitmapSize;
uniform float u_VignetteStrength;
uniform float u_phosphorGlow;
uniform float u_Noise;
uniform float u_Saturation;
uniform float time;

varying vec2 v_TexCoord;

void main() {
    vec2 uv = v_TexCoord;

    // Apply dual-axis curvature distortion
    vec2 curvedUV = uv * 2.0 - 1.0;
    float rx = curvedUV.x * curvedUV.x;
    float ry = curvedUV.y * curvedUV.y;

    float curvatureX = u_Curvature * 1.0;
    float curvatureY = u_Curvature * 0.6;

    curvedUV.x *= 1.0 + curvatureX * ry;
    curvedUV.y *= 1.0 + curvatureY * rx;

    curvedUV = (curvedUV + 1.0) / 2.0;

    if (curvedUV.x < 0.0 || curvedUV.x > 1.0 || curvedUV.y < 0.0 || curvedUV.y > 1.0) {
        discard;
    }

    curvedUV = clamp(curvedUV, 0.0, 1.0);
    vec4 color = texture2D(u_Texture, curvedUV);

    float scanline = sin(curvedUV.y * u_BitmapSize.y);
    float r = length(curvedUV * 2.0 - 1.0);
    float falloff = max(0.6, 1.0 - smoothstep(0.5, 1.0, r));
    scanline *= u_ScanlineIntensity * falloff;
    color.rgb -= scanline;

    float noise = fract(sin(dot(curvedUV * time, vec2(12.9898, 78.233))) * 43758.5453);
    color.rgb += noise * u_Noise;

    color.r *= 1.0 + 0.5 * u_phosphorGlow;
    color.g *= 1.0 + 0.2 * u_phosphorGlow;

    float radius = length(uv - vec2(0.5));
    float fade = smoothstep(0.5, 0.7, radius);
    float vignette = mix(1.0, 1.0 - fade, u_VignetteStrength);
    color.rgb *= vignette;

    // Saturation filter
    float luminance = dot(color.rgb, vec3(0.299, 0.587, 0.114));
    vec3 gray = vec3(luminance);
    color.rgb = mix(gray, color.rgb, u_Saturation);

    gl_FragColor = color;
}
