package de.rainerhock.eightbitwonders;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;


class AgeVerificationProviderImpl extends AgeVerificationImplBase {
    private static Integer mFakeAgeSignalsTestuser = null;

    static void setFakeAgeSignalsManager(final Integer manager) {
        if (BaseActivity.isInUnitTest()) {
            mFakeAgeSignalsTestuser = manager;
        } else {
            throw new IllegalStateException(
                    "calls to setFakeAgeSignalsManager are only allowed in unit test");
        }
    }
    public static Integer getNotAffectedUser() {
        // CHECKSTYLE DISABLE MagicNumber FOR 1 LINES
        return 7;
    }
    public static Integer getFakeVerifiedUser() {
        // CHECKSTYLE DISABLE MagicNumber FOR 1 LINES
        return 1;
    }

    public static Integer getFakeSupervisedUser() {
        // CHECKSTYLE DISABLE MagicNumber FOR 1 LINES
        return 3;
    }

    public static Integer getPendingChangesUser() {
        // CHECKSTYLE DISABLE MagicNumber FOR 1 LINES
        return 6;
    }

    public static Integer getDeniedAccessUser() {
        // CHECKSTYLE DISABLE MagicNumber FOR 1 LINES
        return 6;
    }

    public static Integer getUnknownUser() {
        // CHECKSTYLE DISABLE MagicNumber FOR 1 LINES
        return 2;
    }

    public static Integer getErrorForUser() {
        // CHECKSTYLE DISABLE MagicNumber FOR 1 LINES
        return 8;
    }

    @Override
    public void checkAccess(final Context ctx,
                            final AgeVerification.AgeVerificationUi ui,
                            final Runnable runOnSuccess) {
        Map<String, String> data = new HashMap<>();
        Uri uri;
        if (mFakeAgeSignalsTestuser != null) {
            uri = Uri.parse("content://amzn_test_appstore/getUserAgeData?testOption="
                    + mFakeAgeSignalsTestuser);
        } else {
            uri = Uri.parse("content://amzn_appstore/getUserAgeData");

        }
        Log.v(getTag(), "uri = " + uri);
        Cursor cursor = ctx.getContentResolver().query(
                uri,
                null, null, null, null, null);
        if (cursor != null) {
            Log.v(getTag(), "cursor != null");
            cursor.moveToFirst();
            for (int i = 0; i < cursor.getColumnCount(); i++) {
                String columnName = cursor.getColumnName(i);
                int index = cursor.getColumnIndex(columnName);
                if (index >= 0) {
                    String columnData = cursor.getString(index);
                    data.put(columnName, columnData);
                    Log.v("VERIFICATION", columnName + " -> " + columnData);
                }
            }
            cursor.close();
        } else {
            Log.v(getTag(), "cursor == null");
        }
        if (data.containsKey(COLUMN_RESPONSE_STATUS) && data.containsKey(COLUMN_USER_STATUS)
                && "SUCCESS".equals(data.get(COLUMN_RESPONSE_STATUS))) {
            if ("VERIFIED".equals(data.get(COLUMN_USER_STATUS))
                    || "SUPERVISED".equals(data.get(COLUMN_USER_STATUS))
                    || "".equals(data.get(COLUMN_USER_STATUS))) {
                runOnSuccess.run();
            }
            if ("VERIFIED".equals(data.get(COLUMN_USER_STATUS))
                    || "".equals(data.get(COLUMN_USER_STATUS))) {
                ui.setUserNonAffected(ctx);
            }
            if ("UNKNOWN".equals(data.get(COLUMN_USER_STATUS))) {
                ui.showMessage(ctx, R.string.unknown_user_pls);
            }
            if ("CONSENT_NOT_GRANTED".equals(data.get(COLUMN_USER_STATUS))) {
                ui.showMessage(ctx, R.string.consent_not_granted);
            }
        } else {
            // CHECKSTYLE DISABLE MagicNumber FOR 1 LINES
            if (mFakeAgeSignalsTestuser == null && Calendar.getInstance().get(Calendar.YEAR) < 2026) {
                Log.v(getTag(), "Not Running in test mode and not 2026 yet");
                runOnSuccess.run();
            } else {
                if (ERRORTEXTS.containsKey(data.get(COLUMN_RESPONSE_STATUS))) {
                    Integer i = ERRORTEXTS.get(data.get(COLUMN_RESPONSE_STATUS));
                    ui.showMessage(ctx, i != null ? i : R.string.please_try_again_later);
                } else {
                    ui.showMessage(ctx, R.string.please_try_again_later);
                }
            }
        }
    }
    private static final HashMap<String, Integer> ERRORTEXTS = new HashMap<String, Integer>() {{
       put("APP_NOT_OWNED", R.string.not_installed_by_appstore);
       put("INTERNAL_TRANSIENT_ERROR", R.string.please_try_again_later);
       put("INTERNAL_ERROR", R.string.please_try_again_later);
       put("FEATURE_NOT_SUPPORTED", R.string.please_try_again_later);
    }};
}
