package de.rainerhock.eightbitwonders;


import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isChecked;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isEnabled;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withAlpha;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withParent;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;

import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.anyOf;
import static org.hamcrest.Matchers.anything;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;

import android.view.View;
import android.widget.SeekBar;

import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.platform.app.InstrumentationRegistry;

import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;


public class ViceDrivesTest extends C64EmulationTestBase {

    @Test
    public void t_0010_no_drive(){
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating()));
        /*
        Action: disable drive 8 and try to load directory
        Expected result: device not present error
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        onView(allOf(isDisplayed(), withText(R.string.IDS_DEVICES))).perform(click());
        onView(withTagValue(equalTo("Drive8Type"))).perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        onView(allOf(withParent(withParent(withId(R.id.drives))),withText("8"))).check(doesNotExist());
        type_load_directory(8);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-device-not-present-error.pixelbuffer", 5, TimeUnit.SECONDS)));
    }
    @Test
    public void t_0040_attached_diskimage() throws IOException {
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating()));
        /*
        Action: enable drive 8, but do not attach an image and try to load directory
        Expected result: file not found error, virtual drive led lighting up when drive is active and getting dark when drive is inactive
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        onView(allOf(isDisplayed(), withText(R.string.IDS_DEVICES))).perform(click());
        onView(withTagValue(equalTo("Drive8Type"))).perform(click());
        onData(isOption("CBM 1541")).perform(click());
        pressBack();
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        onView(allOf(withParent(withId(R.id.drives)), withText("8"))).check(matches(isDisplayed()));
        type_load_directory(8);
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-file-not-found-error.pixelbuffer", 5, TimeUnit.SECONDS)));
        onView(allOf(withParent(withId(R.id.drives)), withText("8"))).check(matches(anyOf(withAlpha(1f), withAlpha(192f / 255f))));
        /*
        Action: attach an image and try to load directory
        Expected result: no error, drive led lighting up when active and getting dark when inactive
         */
        openDocument(extractTestAsset("testprograms.d64"));
        waitForIdle();
        onView(withText(R.string.IDMS_DRIVE_8)).perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
    }
    @Test
    public void t_0080_attach_t64_file() {
        /*
        Action open t64 file
        Expected result: file cannot be "inserted", but only programs can be started.
         */
        try {
            openDocument(extractTestAsset("soundloop.t64"));
            onData(isOption("SOUNDLOOP")).inAdapterView(withId(R.id.lv_imagecontents))
                    .check(matches(isDisplayed()));
            onView(withId(R.id.attach_tape)).check(matches(not(isDisplayed())));
            /*
            Action: tap on program name
            Expected result: program is loaded without pressing any keys or datasette buttons.
             */
            onData(isOption("SOUNDLOOP")).inAdapterView(withId(R.id.lv_imagecontents))
                    .check(matches(isDisplayed()))
                    .perform(click());
            waitForActivity(EmulationActivity.class, 250, TimeUnit.MILLISECONDS);
            onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-soundloop-1.pixelbuffer", 10, TimeUnit.SECONDS)));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
    @Test
    public void t_0095_attach_tap_file() {
        try {
            onView(withId(R.id.gv_monitor))
                    .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)))
                    .check(matches(isScreenUpdating()));
            /*
            Action: attach a tap file and type in load command
            Expected result: Status bar shows "tape stopped" symbol and counter is 0
             */
            openDocument(extractTestAsset("soundloop.tap"));
            onView(withId(R.id.attach_tape)).perform(click());
            waitForActivity(EmulationActivity.class, 2, TimeUnit.SECONDS);
            onView(withId(R.id.iv_tape_status))
                    .check(matches(withTagValue(equalTo(DriveStatusListener.TapedriveState.STOP))));
            onView(withId(R.id.tv_tape_counter)).check(matches(withText("0")));
            /*
            Action: type in load command
            Expected result: "press play on tape" is shown
             */
            waitForActivity(EmulationActivity.class, 250, TimeUnit.MILLISECONDS);
            onView(isC64Key("L")).perform(tap());
            onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
            onView(isC64Key("SHIFT")).perform(tap());
            onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
            onView(isC64Key("O")).perform(tap());
            onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
            onView(isC64Key("RETURN")).perform(tap());
            onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
            onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-press-play.pixelbuffer", 1, TimeUnit.SECONDS)));
            /*
            Action: press tape stopped symbol
            Expected result: Tape menu becomes visible.
             */
            onView(withId(R.id.iv_tape_status)).perform(click());
            onView(withText(R.string.press_play)).check(matches(isDisplayed()));
            /*
            Action: press play button in menu
            Expected result: screen becomes inactive and active after while, file soundloop is found
             */
            onView(withText(R.string.press_play)).perform(click());
            onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-tape-found.pixelbuffer", 60, TimeUnit.SECONDS)));
            /*
            Action: hit key
            Expected result: file is loaded, tape counter is 8.
             */
            onView(isC64Key("C=")).perform(tap());
            onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-tape-loaded.pixelbuffer", 60, TimeUnit.SECONDS)));
            onView(withId(R.id.tv_tape_counter)).check(matches(withText("8")));

        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
    @Test
    public void t_0140_tape_save_rewind_load() {
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating()));
        final String timestamp = String.valueOf(System.currentTimeMillis());
        final String filename = "test-" + timestamp.substring(timestamp.length() - 10) + ".tap";
        final String path = InstrumentationRegistry.getInstrumentation().getTargetContext().getCacheDir() + "/" + filename;
        /*
        Action: create and insert a new tape image
        Expected result: tape status is displayed with the stop symbol and tape counter is 0
         */
        createAndAttachTapeImage(filename, path);
        onView(withId(R.id.iv_tape_status))
                .check(matches(withTagValue(equalTo(DriveStatusListener.TapedriveState.STOP))));
        onView(withId(R.id.tv_tape_counter)).check(matches(withText("0")));
        onView(isRoot()).check(matches(isFileHashCorrect(path, "55c1e3d0eaed0d330db51ade1eed961b")));

        /*
        Action: type in an program and save it
        Expected result: press record & play on tape is shown
         */
        onView(isC64Key("1")).perform(tap());
        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("/")).perform(tap());
        onView(isC64Key("RETURN")).perform(tap());
        onView(isC64Key("S")).perform(tap());
        onView(isC64Key("SHIFT")).perform(tap());
        onView(CoreMatchers.allOf(isDisplayed(), isC64Key("A"))).perform(tap());
        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("2")).perform(tap());
        onView(isC64Key("F")).perform(tap());
        onView(isC64Key("I")).perform(tap());
        onView(isC64Key("L")).perform(tap());
        onView(isC64Key("E")).perform(tap());
        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("2")).perform(tap());
        onView(isC64Key("RETURN")).perform(tap());
        /*
        Action: click tape symbol in status bar and then click record & play in menu
        Expected result:
        - Screen is blanked and after while shown again with file saved
        - Tape counter is 6 and tape status symbol still recording
         */
        onView(withId(R.id.iv_tape_status)).perform(click());
        onView(withText(R.string.press_record_and_play)).check(matches(isDisplayed()));

        onView(withText(R.string.press_record_and_play)).perform(click());
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-tape-active.pixelbuffer")));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-file-saved-to-tape.pixelbuffer", 50, TimeUnit.SECONDS)));
        onView(withId(R.id.iv_tape_status))
                .check(matches(withTagValue(equalTo(DriveStatusListener.TapedriveState.RECORD))));
        onView(withId(R.id.tv_tape_counter)).check(matches(withText("6")));
        onView(withId(R.id.iv_tape_status)).check(matches(withTagValue(equalTo(DriveStatusListener.TapedriveState.RECORD))));
        /*
        Action: stop and rewind tape
        Expected result: after a while tape status is stopped and tape counter zero
         */
        onView(withId(R.id.iv_tape_status)).perform(click());
        onView(withText(R.string.IDMS_STOP))
                .check(matches(isDisplayed()))
                .perform(click());
        onView(withId(R.id.iv_tape_status)).perform(click());
        onView(withText(R.string.IDMS_REWIND))
                .check(matches(isDisplayed()))
                .perform(click());
        onView(withId(R.id.iv_tape_status)).check(matches(withTagValue(equalTo(DriveStatusListener.TapedriveState.REWIND))));
        waitForView(allOf(withId(R.id.tv_tape_counter), withText("0")), 6, TimeUnit.SECONDS);
        waitForView(allOf(withId(R.id.iv_tape_status), withTagValue(equalTo(DriveStatusListener.TapedriveState.STOP))), 1, TimeUnit.SECONDS);
        /*
        Action: delete program and load from tape
        Expected result: program is deleted, press play on tape is shown
         */
        onView(isC64Key("N")).perform(tap());
        onView(isC64Key("E")).perform(tap());
        onView(isC64Key("W")).perform(tap());
        onView(isC64Key("RETURN")).perform(tap());
        onView(isC64Key("L")).perform(tap());
        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("I")).perform(tap());
        onView(isC64Key("RETURN")).perform(tap());
        onView(isC64Key("L")).perform(tap());
        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("O")).perform(tap());
        onView(isC64Key("RETURN")).perform(tap());
        /*
        Action: press play on tape
        Expected result: Screen is blanked and shown again with program found.
         */
        onView(withId(R.id.iv_tape_status)).perform(click());
        onView(withText(R.string.press_play))
                .check(matches(isDisplayed()))
                .perform(click());
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-found-file.pixelbuffer", 50, TimeUnit.SECONDS)));
        /*
        Action: press a key
        Expected result: Screen is blanked and shown again with program loaded.
         */
        onView(isC64Key("C=")).perform(tap());
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-loaded-file.pixelbuffer", 50, TimeUnit.SECONDS)));
        onView(isC64Key("C=")).perform(tap());
        /*
        Action: list program
        Expected result: program is shown as it was typed in
         */
        onView(isC64Key("RETURN")).perform(tap());
        onView(isC64Key("L")).perform(tap());
        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("I")).perform(tap());
        onView(isC64Key("RETURN")).perform(tap());
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-listed-file.pixelbuffer")));
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForIdle(1, TimeUnit.SECONDS);
        onView(isRoot()).check(matches(isFileHashCorrect(path, "d17cd20b571d9a7c9e6e24c35ad20beb")));
        if (!new File(path).delete()) {
            throw new RuntimeException(String.format("Could not delete %s", path));
        }

    }
    private static final char[] HEX_ARRAY = "0123456789abcdef".toCharArray();
    private static final int HEX_MASK = 0x0F;
    private Matcher<? super View> isFileHashCorrect(String path, String hash) {
        return new BaseMatcher<View>() {
            final private String mGivenHash=hash;
            private String mCalculatedHash=null;
            @Override
            public boolean matches(Object item) {
                try {
                    MessageDigest md = MessageDigest.getInstance("MD5");
                    //noinspection IOStreamConstructor
                    InputStream is = new FileInputStream(path);
                    byte[] b = new byte[is.available()];
                    //noinspection ResultOfMethodCallIgnored
                    is.read(b);
                    md.update(b);
                    byte[] digest = md.digest();
                    char[] hexChars = new char[digest.length * 2];
                    for (int j = 0; j < digest.length; j++) {
                        int v = digest[j] & 0xFF;
                        hexChars[j * 2] = HEX_ARRAY[v >>> 4];
                        hexChars[j * 2 + 1] = HEX_ARRAY[v & HEX_MASK];
                    }
                    mCalculatedHash = new String(hexChars);
                    is.close();
                    return mCalculatedHash.equals(hash);
                }
                catch (NoSuchAlgorithmException | IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void describeMismatch(Object item, Description mismatchDescription) {
                mismatchDescription.appendText("Given hash ").appendText(mGivenHash)
                        .appendText(" not equal to calculated hash ").appendText(mCalculatedHash);
            }

            @Override
            public void describeTo(Description description) {
                description.appendText("Compare MD5 hash of a given file with a given hash.");
            }
        };
    }

    @Test
    public void t_0230_fliplist_handling () {
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating()));
        try {
            extractTestAsset("flipdisk 1.d64");
            extractTestAsset("flipdisk 2.d64");
            /*
            Action: set drive 8 as only drive and load a fliplist
            Expected result: dialog is shown with flipdisk 1.d64 disabled (since it is automatically attached
            and flipdisk 2.d64 enabled.
             */
            onView(withId(R.id.ib_hamburger_menu)).perform(tap());
            waitForIdle();
            onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
            onView(allOf(isDisplayed(), withText(R.string.IDS_DEVICES))).perform(click());
            waitForIdle();
            onView(withTagValue(equalTo("Drive9Type"))).perform(click());
            onData(isOption(R.string.IDS_NONE)).perform(click());
            pressBack();
            openDocument(extractTestAsset("fliplist1.vfl"));
            //onView(isRoot()).perform(waitForMatch(withText("flipdisk 1.d64"),250,TimeUnit.MILLISECONDS));
            onView(withText("flipdisk 1.d64")).check(matches(not(isEnabled())));
            onView(withText("flipdisk 2.d64")).check(matches(isEnabled()));
            pressBack();
            /*
            Action: enable drive 9 and load a flipdisk
            Expected result: images are attached to drive 8 and 9 according to the fliplist
             */
            onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
            onView(withId(R.id.ib_hamburger_menu)).perform(tap());
            waitForIdle();
            onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
            onView(withTagValue(equalTo("Drive9Type"))).perform(click());
            onData(isOption("CBM 1541")).perform(click());
            onView(withId(R.id.bn_apply)).perform(click());
            onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
            openDocument(extractTestAsset("fliplist2.lst"));
            type_load_directory(8);
            onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-fliplist2-dir-loaded.pixelbuffer",10, TimeUnit.SECONDS)));
            onView(isC64Key("L")).perform(tap());
            onView(isC64Key("SHIFT")).perform(tap());
            onView(isC64Key("I")).perform(tap());
            onView(isC64Key("RETURN")).perform(tap());
            onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-fliplist2-dir-listed.pixelbuffer",10, TimeUnit.SECONDS)));
            type_load_directory(9);
            onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-fliplist2-dir-2-loaded.pixelbuffer",10, TimeUnit.SECONDS)));
            onView(isC64Key("L")).perform(tap());
            onView(isC64Key("SHIFT")).perform(tap());
            onView(isC64Key("I")).perform(tap());
            onView(isC64Key("RETURN")).perform(tap());
            onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-fliplist2-dir-2-listed.pixelbuffer",10, TimeUnit.SECONDS)));
            /*
            Action: show Images from List
            Expected result: dialog is showing up with 2 disk images, disabled for the drive they are already
            attached to and enabled for the other.
             */
            onView(withId(R.id.ib_hamburger_menu)).perform(tap());
            waitForIdle();
            onView(withId(R.id.ib_handle_opened_files)).perform(click());
            onView(withText(R.string.flip_file)).perform(click());
            waitForIdle();
            onView(allOf(withTagValue(equalTo(8)), anyOf(withText("FLIPDISK 1.D64"),withText("flipdisk 1.d64")))).check(matches(not(isEnabled())));
            onView(allOf(withTagValue(equalTo(9)), anyOf(withText("FLIPDISK 1.D64"),withText("flipdisk 1.d64")))).check(matches(isEnabled()));
            onView(allOf(withTagValue(equalTo(9)), anyOf(withText("FLIPDISK 2.D64"),withText("flipdisk 2.d64")))).check(matches(not(isEnabled())));
            onView(allOf(withTagValue(equalTo(8)), anyOf(withText("FLIPDISK 2.D64"),withText("flipdisk 2.d64")))).check(matches(isEnabled()));
            /*
            Action: attach the image that was attached to drive 9 to drive 8
            Expected result: Image is attached to drive 8 and removed from drive 9.
             */
            onView(allOf(withTagValue(equalTo(8)), anyOf(withText("FLIPDISK 2.D64"),withText("flipdisk 2.d64")))).perform(click());
            onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
            waitForIdle(1, TimeUnit.SECONDS);
            type_load_directory(8);
            onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-fliplist2-dir-3-loaded.pixelbuffer", 10, TimeUnit.SECONDS)));
            onView(isC64Key("L")).perform(tap());
            onView(isC64Key("SHIFT")).perform(tap());
            onView(isC64Key("I")).perform(tap());
            onView(isC64Key("RETURN")).perform(tap());
            onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-fliplist2-dir-3-listed.pixelbuffer", 20, TimeUnit.SECONDS)));
            type_load_directory(9);

            onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-fliplist2-dir-4-loaded.pixelbuffer", 20, TimeUnit.SECONDS)));
            onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
            onView(withId(R.id.ib_hamburger_menu)).perform(tap());
            waitForIdle();
            onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
            onView(withTagValue(equalTo("Drive9Type"))).perform(click());
            onData(isOption(R.string.IDS_NONE)).perform(click());
            pressBack();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
    @Test
    public void t_0340_flipdisk_with_special_chars() {
        try {
            onView(withId(R.id.gv_monitor))
                    .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)))
                    .check(matches(isScreenUpdating()));
            extractTestAsset("flipdisk 1.d64");
            extractTestAsset("flipdisk 2.d64");
            extractTestAsset("special-char-üöä €.d64");
            onView(withId(R.id.ib_hamburger_menu)).perform(tap());
            waitForIdle();
            onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
            /*
            Action: attach fliplist containing a disk iamge with non-ascii-characters in name
            Expected result: Disk name is shown correctly
             */
            onView(allOf(isDisplayed(), withText(R.string.IDS_DEVICES))).perform(click());
            onView(withTagValue(equalTo("Drive9Type"))).perform(click());
            onData(isOption(R.string.IDS_NONE)).perform(click());
            pressBack();
            waitForIdle();
            openDocument(extractTestAsset("special-char.vfl"));
            waitForIdle();
            onView(anyOf(withText("flipdisk 2.d64"),withText("FLIPDISK 2.D64")))
                    .check(matches(isDisplayed()))
                    .check(matches(isEnabled()));
            onView(anyOf(withText("flipdisk 1.d64"),withText("FLIPDISK 1.D64")))
                    .check(matches(isDisplayed()))
                    .check(matches(not(isEnabled())));
            /*
            Action: attach disk image with special characters in name and load directory
            Expected result: directory is shown correctly.
             */
            onView(anyOf(withText("special-char-üöä €.d64"),withText("SPECIAL-CHAR-ÜÖÄ €.D64")))
                    .check(matches(isDisplayed()))
                    .check(matches(isEnabled()))
                    .perform(click());
            type_load_directory(8);
            onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
            onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-special-char-disk-loading.pixelbuffer",10, TimeUnit.SECONDS)));
            onView(isC64Key("L")).perform(tap());
            onView(isC64Key("SHIFT")).perform(tap());
            onView(isC64Key("I")).perform(tap());
            onView(isC64Key("RETURN")).perform(tap());
            onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-special-char-disk-loaded.pixelbuffer",10, TimeUnit.SECONDS)));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
    @Test
    public void t_0380_diskimage_with_special_chars() {
        try {
            openDocument(extractTestAsset("special-char-üöä €.d64"));
            onView(withText("special-char-üöä €.d64")).check(matches(anything()));
            onData(isOption("SPECIAL-CHARS")).inAdapterView(withId(R.id.lv_imagecontents)).perform(click());
            waitForIdle();
            waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
            onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-special-chars.pixelbuffer", 15, TimeUnit.SECONDS)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
    private static ViewAction setProgress(final int progress) {
        return new ViewAction() {
            @Override
            public void perform(UiController uiController, View view) {
                ((SeekBar) view).setProgress(progress < 0 ? ((SeekBar) view).getMax() : progress);
            }

            @Override
            public String getDescription() {
                return "Set a progress";
            }

            @Override
            public Matcher<View> getConstraints() {
                return ViewMatchers.isAssignableFrom(SeekBar.class);
            }
        };
    }

    @Test
    public void t_0430_true_drive_emulation () {
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating()));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle(5, TimeUnit.SECONDS );
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        /*
        Action: enable drive 9 and true drive emulation
        Expected result: Volume slider is shown
         */
        onView(allOf(isDisplayed(),withText(R.string.IDS_DEVICES))).perform(click());
        onView(withTagValue(equalTo("Drive9Type"))).perform(click());
        onData(isOption("CBM 1541")).perform(click());
        onView(withText(R.string.IDMS_DRIVE_SOUND)).perform(scrollTo()).perform(click());
        waitForIdle();
        /*
        Action: set volume to max and try to load a file
        Expected result: Audio output and file not found.
         */
        onView(withTagValue(equalTo("DriveSoundEmulationVolume")))
                .perform(scrollTo())
                .check(matches(isDisplayed()))
                .perform(setProgress(-1));
        onView(withId(R.id.bn_apply)).perform(click());
        waitForActivity(EmulationActivity.class, 1, TimeUnit.SECONDS);
        type_load_directory(9);
        onView(withId(R.id.gv_monitor))
                .check(matches(isAudioPlaying()))
                .check(matches(showsBitmapEqualToAsset("screenshot-file-not-found-error-drive-9.pixelbuffer",120,TimeUnit.SECONDS)));
        /*
        Action: open settings, set volume to 0 and try to load a file
        Expected result: no Audio output and file not found.

         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        onView(withTagValue(equalTo("DriveSoundEmulationVolume")))
                .perform(scrollTo())
                .perform(setProgress(0));
        onView(withText(R.string.IDMS_DRIVE_SOUND)).perform(scrollTo()).check(matches(isChecked()));
        onView(withId(R.id.bn_apply)).perform(click());
        waitForActivity(EmulationActivity.class, 1, TimeUnit.SECONDS);
        type_load_directory(9);
        onView(withId(R.id.gv_monitor))
                .check(matches(not(isAudioPlaying())))
                .check(matches(showsBitmapEqualToAsset("screenshot-file-not-found-error-drive-9-2nd-attempt.pixelbuffer",60,TimeUnit.SECONDS)));
        /*
        Action: set volume to max, but disable sound output.
        Expected results:
        - after disabling sound output, volume slider is hidden
        - no audio output during drive access.
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        onView(withTagValue(equalTo("DriveSoundEmulationVolume")))
                .perform(scrollTo())
                .check(matches(isDisplayed()))
                .perform(setProgress(-1));
        //onView(withId(R.id.sv_settings)).perform(swipeToTop());
        onView(withText(R.string.IDMS_DRIVE_SOUND)).perform(scrollTo()).check(matches(isChecked())).perform(click()).check(matches(not(isChecked())));
        waitForIdle();
        onView(withTagValue(equalTo("DriveSoundEmulationVolume")))
                //.perform(scrollTo())
                .check(matches(not(isDisplayed())));
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor))
                .check(matches(not(isAudioPlaying())));
        type_load_directory(9);
        onView(withId(R.id.gv_monitor))
                .check(matches(not(isAudioPlaying())));

    }
}