package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withParent;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;

import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.equalTo;

import org.junit.Test;

import java.util.concurrent.TimeUnit;

public class Vic20SettingsTest extends Vic20EmulationTestBase{
    @Test
    public void t_0020_ntsc_mode()  {
        /*
        Action:
        Start VIC Emulation
        Expected result:
        Showing up in PAL mode
         */
        waitForIdle(3, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-vic20.pixelbuffer",2,TimeUnit.SECONDS)));
        /*
        Action:
        tap the hamburger, open settings, open VIC section, switch to ntsc mode, go back
        Expected result:
        Showing up in NTSC mode
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForActivity(SettingsActivity.class, 1, TimeUnit.SECONDS);
        onView(withId(R.id.gh_vic20settings)).perform(scrollTo()).perform(click());
        waitForIdle();
        onView(allOf(withParent(withTagValue(equalTo("MachineVideoStandard"))),withTagValue(equalTo("2")))).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("screenshot-vic-machine-ready-ntsc.pixelbuffer",5,TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating()));

    }
    @Test
    public void t_0050_vic_settings() {
        /*
        Action:
        Start VIC Emulation, type Text BLERB
        Expected result:
        Showing up with borders, BLERB is shown
         */
        waitForIdle(3, TimeUnit.SECONDS);
        onView(isC64Key("B")).perform(tap());
        onView(isC64Key("L")).perform(tap());
        onView(isC64Key("E")).perform(tap());
        onView(isC64Key("R")).perform(tap());
        onView(isC64Key("B")).perform(tap());
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-vic-typed-blerb.pixelbuffer",2,TimeUnit.SECONDS)));
        /*
        Action:
        tap the hamburger, open settings, open video section, disable borders, go back
        Expected result:
        Borders gone, but BLERB is still there
         */

        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForActivity(SettingsActivity.class, 1, TimeUnit.SECONDS);
        onView(withId(R.id.gh_vic_i_settings)).perform(click());
        waitForIdle();
        onView(allOf(withParent(withTagValue(equalTo("VICBorderMode"))),withTagValue(equalTo("3")))).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("screenshot-vic-typed-blerb-borderless.pixelbuffer")))
                .check(matches(isScreenUpdating()));
    }
    @Test
    public void t_0070_memory_extension() throws InterruptedException {
        /*
        Action:
        Start VIC Emulation
        Expected result:
        Showing up in PAL mode
         */
        waitForIdle(3, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-vic20.pixelbuffer",2,TimeUnit.SECONDS)));
        /*
        Action:
        tap the hamburger, open settings, open VIC section, switch to ntsc mode, go back
        Expected result:
        Showing up in NTSC mode
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForActivity(SettingsActivity.class);
        onView(withId(R.id.gh_vic20settings)).perform(click());
        waitForIdle();
        onView(withTagValue(equalTo("Vic20MemoryMap"))).perform(click());
        onData(isOption(R.string.ram_block_1_2)).perform(click());
        waitForIdle();
        onView(withId(R.id.bn_apply)).perform(click());
        Thread.sleep(2000);
        onView(withId(R.id.gv_monitor))
                //.perform(captureEmulationScreen("screenshot-vic-machine-ready-+16k.pixelbuffer"))
                .check(matches(showsBitmapEqualToAsset("screenshot-vic-machine-ready-+16k.pixelbuffer",2,TimeUnit.SECONDS)));
    }

}
