package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.longClick;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isAssignableFrom;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;

import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;

import androidx.appcompat.widget.AlertDialogLayout;
import androidx.test.espresso.ViewAssertion;
import androidx.test.filters.SdkSuppress;
import androidx.test.platform.app.InstrumentationRegistry;

import junit.framework.AssertionFailedError;

import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;


import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class UserdataExportImportTest extends MainActivityTestBase{

    @Test
    @SdkSuppress(minSdkVersion=21)
    public void t_01_testExport() throws IOException {
        if (getZipfile().exists() && !getZipfile().delete()) {
            throw new RuntimeException("Cannot delete "+getZipfile());
        }
        onView(withText("plain-c64")).check(doesNotExist());
        onView(isRoot()).perform(createdTileAction(R.string.name_c64, click()));
        waitForActivity(EmulationActivity.class, 10, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",10,TimeUnit.SECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForActivity(SettingsActivity.class, 2, TimeUnit.SECONDS);
        onView(withId(R.id.gh_c64_settings)).perform(scrollTo()).perform(click());
        waitForIdle();
        onView(withTagValue(equalTo("Drive9Type"))).perform(scrollTo()).perform(click());
        onData(isOption("CBM 1541")).perform(click());
        waitForIdle();
        onView(withId(R.id.bn_apply)).perform(click());

        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.savestates)).perform(click());
        waitForIdle();
        onView(isSaveStateIndicator(1)).perform(click());
        waitForIdle();
        onView(allOf(isDisplayed(), withId(R.id.bn_save))).perform(click());
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForIdle();
        onView(withId(R.id.bn_info)).check(matches(isDisplayed()));
        onView(withText("plain-c64")).check(doesNotExist());
        setIntendedFile(new File(extractTestAsset("plain-c64.8bw")));
        onView(isContentSourceViewWithTitle(InstrumentationRegistry.getInstrumentation().getTargetContext().getResources().getString(R.string.import_local_content))).perform(scrollTo()).perform(click());
        onView(withId(R.id.gh_preinstalled)).perform(scrollTo()).perform(click());
        //onView(withText("plain-c64")).check(matches(isDisplayed()));
        onView(withText("plain-c64")).perform(scrollTo());
        onView(withId(R.id.bn_info)).perform(click());
        onView(withText(R.string.global_settings)).perform(click());
        waitForIdle();
        setIntendedFile(getZipfile());
        onView(withId(R.id.bn_backup)).perform(click());
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gh_preinstalled)).perform(scrollTo()).perform(click());
        waitForIdle();
    }
    private File getZipfile() {
        return new File(InstrumentationRegistry.getInstrumentation().getTargetContext().getCacheDir(), String.format("__%s__test.zip", getClass().getSimpleName()));
        //return new File(Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOWNLOADS), String.format("__%s__test.zip", getClass().getSimpleName()));
    }
    /** @noinspection IOStreamConstructor*/
    @Test
    @SdkSuppress(minSdkVersion=21)
    public void t_02_simulateCleanData() throws IOException {
        File f = getZipfile();
        InputStream is = new FileInputStream(f);
        byte[] data = new byte[is.available()];
        //noinspection ResultOfMethodCallIgnored
        is.read(data);
        is.close();
        GlobalSettingsActivity.cleanUp(InstrumentationRegistry.getInstrumentation().getTargetContext());
        f = getZipfile();
        OutputStream os = new FileOutputStream(f);
        os.write(data);
        os.close();
        assert ((new Useropts().getBooleanValue("show_manual_hint", true))
                && (!new Useropts().getBooleanValue("show_manual_hint", false))) : "Global SharedPreferences not removed";
    }
    @Test
    @SdkSuppress(minSdkVersion=21)
    public void t_03_testImport() {
        onView(isAssignableFrom(AlertDialogLayout.class)).check(matches(isDisplayed()));
        onView(withText(android.R.string.ok)).perform(click());
        checkViews(doesNotExist());
        onView(withText("plain-c64")).check(doesNotExist());
        waitForActivity(MainActivity.class, 1, TimeUnit.SECONDS);
        onView(withId(R.id.bn_info)).check(matches(isDisplayed())).perform(click());
        onView(withText(R.string.global_settings)).perform(click());
        waitForIdle();
        setIntendedFile(getZipfile());
        onView(withId(R.id.bn_restore)).perform(click());
        onView(withText(android.R.string.ok)).perform(click());
        checkViews(matches(isDisplayed()));
        waitForActivity(MainActivity.class);
        onView(withText("plain-c64")).perform(scrollTo()).perform(click());
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",10, TimeUnit.SECONDS)));
        pressBack();
        onView(withText(R.string.quit)).perform(click());
    }

    private void checkViews(ViewAssertion assertion) {
        waitForActivity(MainActivity.class, 1, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(R.string.name_c64, click()));
        waitForActivity(EmulationActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        onView(withText("9")).check(assertion);

        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.savestates)).perform(click());
        waitForIdle();
        onView(isSaveStateIndicator(1)).perform(click());
        waitForIdle();
        onView(allOf(isDisplayed(), withId(R.id.bn_start))).check(assertion);
        pressBack();
        waitForIdle();
        pressBack();
        onView(withText(R.string.quit)).perform(click());
    }

    @Test
    @SdkSuppress(minSdkVersion=21)
    public void t_99_cleanup() {
        try {
            waitForActivity(MainActivity.class);
        } catch (AssertionFailedError e) {
            // that's ok
        }
        for (int resId : Arrays.asList(R.string.name_c64, R.string.name_pet, R.string.name_vic20)) {
            waitForActivity(MainActivity.class, 2, TimeUnit.SECONDS);
            onView(withText(resId)).perform(click());
            waitForActivity(EmulationActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
            onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating(5)));
            pressBack();
            onView(withText(R.string.quit)).perform(click());
        }
        waitForActivity(MainActivity.class, 2, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction("plain-c64", longClick()));
        onView(withText(R.string.uninstall)).perform(click());
        onView(withText(R.string.delete_useropts)).perform(click());
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
        onView(withText("plain-c64")).check(doesNotExist());
        if (getZipfile().exists()) {
            if (!getZipfile().delete()) {
                getZipfile().deleteOnExit();
            }
        }
    }
    @Test
    public void test_non_launchable_8bw() throws IOException {
        setIntendedFile(new File(extractTestAsset("kaputt-cmdline.8bw")));
        onView(isContentSourceViewWithTitle(InstrumentationRegistry.getInstrumentation().getTargetContext().getResources().getString(R.string.import_local_content))).perform(scrollTo()).perform(click());
        onView(withId(R.id.gh_preinstalled)).perform(scrollTo()).perform(click());
        onView(isRoot()).perform(createdTileAction("kaputt-cmdline", click()));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withText(R.string.package_error)).check(matches(isDisplayed()));
        onView(withText(android.R.string.ok)).perform(click());
        onView(isRoot()).perform(createdTileAction("kaputt-cmdline", longClick()));
        onView(withText(R.string.uninstall)).perform(click());
        onView(withText(R.string.delete_useropts)).perform(click());
        onView(withText(android.R.string.ok)).perform(click());
        onView(withText("kaputt-cmdline")).check(doesNotExist());
        waitForIdle();
        onView(withId(R.id.gh_preinstalled)).perform(scrollTo()).perform(click());


    }

    private void testCorruptedData(final String filename) throws IOException {
        setIntentCallback(new File(extractTestAsset(filename)).getAbsolutePath());
        onView(isContentSourceViewWithTitle(InstrumentationRegistry.getInstrumentation().getTargetContext().getResources().getString(R.string.import_local_content))).perform(scrollTo()).perform(click());
        onView(withId(R.id.preinstalled)).check(matches(isDisplayed()));
        onView(withId(R.id.usercontent)).check(matches(not(isDisplayed())));

    }
    @Test
    public void testCorruptedData() throws IOException {
        testCorruptedData("no-properties.8bw");
        testCorruptedData("no-manifest.rp9");
        testCorruptedData("empty.8bw");

    }
}
