package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.closeSoftKeyboard;
import static androidx.test.espresso.action.ViewActions.longClick;
import static androidx.test.espresso.action.ViewActions.typeText;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isAssignableFrom;
import static androidx.test.espresso.matcher.ViewMatchers.isChecked;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withText;

import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.not;

import android.content.Intent;
import android.net.Uri;
import android.widget.EditText;

import androidx.test.rule.ActivityTestRule;

import org.junit.Test;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class UninstallTileTest extends MainActivityTestBase{
    /** @noinspection deprecation*/
    public ActivityTestRule<ImportFileActivity> mActivityRule =
            new ActivityTestRule<>(ImportFileActivity.class, false, false);

    @Test
    public void testUninstallingIncluded() {
        /*
        Action: open popup in preinstalled configurations
        Expected result: no menuitems "uninstall"
         */
        onView(isRoot()).perform(createdTileAction("C64", longClick()));
        onView(withText(R.string.uninstall)).check(doesNotExist());
        pressBack();
        onView(isRoot()).perform(createdTileAction("Bubble Escape", longClick()));
        onView(withText(R.string.uninstall)).check(doesNotExist());
        pressBack();
    }
    @Test
    public void testUninstallImported() throws IOException{
        /*
        Action: import 8bw file and uninstall it
        Expected result: there is an option wether to delete useropts + savestates or not
         */
        onView(withText("plain-c64")).check(doesNotExist());
        Intent i = new Intent();
        i.setData(Uri.fromFile(new File(extractTestAsset("plain-c64.8bw"))));
        mActivityRule.launchActivity(i);
        waitForIdle();
        onView(withId(R.id.bn_add)).perform(click());
        waitForIdle();
        pressBack();
        waitForIdle();

        onView(isRoot()).perform(createdTileAction("plain-c64", longClick()));
        onView(withText(R.string.uninstall)).perform(click());
        onView(withText(R.string.delete_useropts)).check(matches(isDisplayed()));
        pressBack();
        /*
        Action:
        * restart tile, disable borders
        * Expected result: emulation running with disabled borders.
         */
        onView(isRoot()).perform(createdTileAction("plain-c64", click()));
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(click());
        waitForIdle();
        onView(withText(R.string.IDMS_SETTINGS)).perform(click());
        waitForIdle();
        waitForActivity(SettingsActivity.class,30,TimeUnit.SECONDS);
        onView(withId(R.id.gh_vic_ii_settings)).perform(click());
        waitForIdle();
        onView(withId(R.id.rb_c64_no_border)).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-borderless.pixelbuffer", 5, TimeUnit.SECONDS)));
        /*
        Action:
        * leave emulation
        * uninstall emulation, but do not check the option to remove settings.
        * Restart emulation
        Expected result: emulation running with disabled borders
         */
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForActivity(MainActivity.class,2,TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction("plain-c64", click()));
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-borderless.pixelbuffer", 5, TimeUnit.SECONDS)));
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForActivity(MainActivity.class,2,TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction("plain-c64", longClick()));
        onView(withText(R.string.uninstall)).perform(click());
        onView(withText(R.string.delete_useropts))
                .check(matches(isDisplayed()))
                .check(matches(not(isChecked())));
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
        i.setData(Uri.fromFile(new File(extractTestAsset("plain-c64.8bw"))));
        mActivityRule.launchActivity(i);
        waitForIdle();
        onView(withId(R.id.bn_add)).perform(click());
        waitForIdle();
        pressBack();
        waitForIdle();
        onView(isRoot()).perform(createdTileAction("plain-c64", click()));
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-borderless.pixelbuffer", 5, TimeUnit.SECONDS)));
        /*
        Action:
        * leave emulation
        * uninstall emulation and check the option to remove settings.
        * Restart emulation
        Expected result: emulation running with borders
         */
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForActivity(MainActivity.class,2,TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction("plain-c64", longClick()));
        onView(withText(R.string.uninstall)).perform(click());
        onView(withText(R.string.delete_useropts))
                .check(matches(isDisplayed()))
                .check(matches(not(isChecked())))
                .perform(click())
                .check(matches(isChecked()));
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
        i.setData(Uri.fromFile(new File(extractTestAsset("plain-c64.8bw"))));
        mActivityRule.launchActivity(i);
        waitForIdle();
        //onView(isRoot()).perform(createdTileAction("plain-c64", click()));
        //waitForIdle(250, TimeUnit.MILLISECONDS);
        waitForIdle();
        waitForActivity(ImportFileActivity.class,1,TimeUnit.SECONDS);
        onView(withId(R.id.bn_add)).perform(click());
        waitForIdle();
        pressBack();
        waitForIdle();
        waitForActivity(MainActivity.class, 30, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction("plain-c64", click()));
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)));
        pressBack();
        /*
        Action: leave and uninstall emulation
        Expected result: not tile for emulation
         */
        waitForIdle();
        onView(withText(R.string.quit)).perform(click());
        waitForIdle();
        waitForActivity(MainActivity.class, 2, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction("plain-c64", longClick()));
        onView(withText(R.string.uninstall)).perform(click());
        onView(withText(R.string.delete_useropts)).perform(click());
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
        onView(withText("plain-c64")).check(doesNotExist());
    }
    private final static String CREATED ="_created_";
    @Test
    public void testuninstallingAdded() {
        /*
        Action: run C64 emulation
        Expected: emulation started
         */
        //waitForActivity(MainActivity.class,2,TimeUnit.SECONDS);
        onView(withText(CREATED)).check(doesNotExist());
        onView(isRoot()).perform(createdTileAction("C64", click()));
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)));
        /*
        Action: Open menu with the hamburger and choose "Create Link"/"Verknüpfung erstellen
        Expected result: Dialog is showing up.
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withId(R.id.bn_share_current_state)).check(matches(isDisplayed())).perform(click());
        waitForIdle();
        onView(withText(R.string.add_to_main_activity)).perform(click());

        waitForIdle(2, TimeUnit.SECONDS);
        /*
        Action: type name and click on "OK"
        Expected result: Emulation is shown again
         */

        //noinspection unchecked
        onView(allOf(
                isAssignableFrom(EditText.class)))
                .perform(typeText(CREATED))
                .perform(closeSoftKeyboard());
        onView(withText(android.R.string.ok))
                .check(matches(isDisplayed()))
                .perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        waitForIdle();
        /*
        Action: leave emulation
        Expected result: Main activity is shown, there is a tile new tile with the given name
         */
        pressBack();
        onView(withText(R.string.global_action_logout)).perform(click());
        /*
        Action: click on "joy"
        Expected result: Emulation is showing up in the same state as when it was saved.
         */
        waitForActivity(MainActivity.class,2,TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(CREATED, longClick()));
        waitForIdle();
        onView(withText(R.string.uninstall)).perform(click());
        waitForIdle();
        onView(withText(R.string.will_delete_everything)).check(matches(isDisplayed()));
        onView(withText(R.string.delete_useropts)).check(doesNotExist());
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
        onView(withText(CREATED)).check(doesNotExist());
    }
}
