package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.closeSoftKeyboard;
import static androidx.test.espresso.action.ViewActions.pressKey;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.hasFocus;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isFocused;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withChild;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withParent;
import static androidx.test.espresso.matcher.ViewMatchers.withText;
import static org.hamcrest.CoreMatchers.allOf;
import static org.hamcrest.CoreMatchers.anyOf;
import static org.hamcrest.Matchers.instanceOf;

import android.view.KeyEvent;

import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.PerformException;

import junit.framework.AssertionFailedError;

import org.junit.Test;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class TvScreenshotsTest extends MainActivityTestBase{

    @Test
    @TvTest
    @SpecialTest
    public void takeTvScreenshots() {
        try {
            extractTestAsset("flipdisk 1.d64");
            extractTestAsset("flipdisk 2.d64");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        captureDeviceScreen("main-activity");
        navigateToHamburger();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        waitForActivity(BrowserActivity.class, 2, TimeUnit.SECONDS);
        waitForIdle(10, TimeUnit.SECONDS);
        captureDeviceScreen("about");
        pressBack();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        onView(withText(R.string.licences)).perform(click());
        waitForActivity(BrowserActivity.class, 2, TimeUnit.SECONDS);
        waitForIdle(10, TimeUnit.SECONDS);
        captureDeviceScreen("licenses");
        pressBack();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        onView(withText(R.string.manual)).perform(click());
        waitForIdle(10, TimeUnit.SECONDS);
        onView(withId(R.id.bn_reload)).check(matches(isDisplayed()));
        captureDeviceScreen("manual");
        pressBack();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        navigateToView(KeyEvent.KEYCODE_DPAD_LEFT, KeyEvent.KEYCODE_UNKNOWN, allOf(instanceOf(TileView.class), withChild(withText(R.string.name_c64))));
        waitForIdle();
        onView(isFocused()).check(matches(withChild(withText(R.string.name_c64))));
        captureDeviceScreen("first-tile-focusd");
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        waitForIdle();
        onView(withId(R.id.gv_monitor))
                .check(matches(isDisplayed()))
                .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",10, TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating()));

        captureDeviceScreen("c64-activity-default");

        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        captureDeviceScreen("menu");
        //onView(withText(R.string.rewind)).perform(click());
        onView(withId(R.id.bn_timemachine)).perform(click());
        waitForIdle();
        captureDeviceScreen("timemachine");
        pressBack();
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        try {
            onView(allOf(isDisplayed(), withId(R.id.bn_savestate))).perform(click());
        } catch (NoMatchingViewException e) {
            onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
            onView(withId(R.id.bn_savestate)).perform(click());
        }

        waitForIdle();
        captureDeviceScreen("savestate");
        pressBack();
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        try {
            onView(withId(R.id.bn_share_current_state)).perform(click());
        } catch (PerformException e) {
            onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
            onView(withId(R.id.bn_share_current_state)).perform(click());
        }
        onView(withText(R.string.add_to_main_activity)).perform(click());
        waitForDialog(withText(R.string.add_to_main_activity));
        captureDeviceScreen("add-to-start-screen");
        onView(withId(R.id.pb_next)).perform(click());
        waitForIdle();
        captureDeviceScreen("add-to-start-screen-pt-2");
        onView(isRoot()).perform((closeSoftKeyboard()));
        waitForIdle();
        captureDeviceScreen("add-to-start-screen-pt-2-wo-keyboard");
        pressBack();
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        try {
            onView(withId(R.id.bn_share_current_state)).perform(click());
        } catch (PerformException e) {
            onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
            onView(withId(R.id.bn_share_current_state)).perform(click());
        }

        waitForIdle();
        onView(withText(R.string.share_and_save)).perform(click());

        waitForIdle(1, TimeUnit.SECONDS);
        captureDeviceScreen("share-activity");
        onView(isRoot()).perform((closeSoftKeyboard()));
        waitForIdle(1, TimeUnit.SECONDS);
        captureDeviceScreen("share-activity-wo-keyboard");
        boolean found = false;
        while (!found) {
            pressBack();
            waitForIdle();
            try {
                onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
                found = true;
            } catch (NoMatchingViewException e) {
                waitForIdle(250, TimeUnit.MILLISECONDS);
            }
        }
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        try {
            onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
            onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        } catch (NoMatchingViewException e) {
            // that's ok.
        }
        waitForIdle();
        onView(withId(R.id.bn_settings)).perform(click());
        waitForIdle();
        waitForActivity(SettingsActivity.class, 2, TimeUnit.SECONDS);
        waitForIdle();
        captureDeviceScreen("settings-all-closed");
        try {
            onView(allOf(isFocused(), anyOf(instanceOf(GroupHeader.class),withParent(instanceOf(GroupHeader.class))))).check(matches(isFocused()));
        } catch (NoMatchingViewException e) {
            onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        }
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        captureDeviceScreen("settings-keyboard");
        for (String s : Arrays.asList("settings-joystick", "settings-c64-devices",
                "settings-c64-vic-ii", "settings-c64-sid")) {
            onView(allOf(isFocused(), anyOf(instanceOf(GroupHeader.class),withParent(instanceOf(GroupHeader.class))))).check(matches(isFocused()));
            waitForIdle();
            onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
            waitForIdle();
            onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
            waitForIdle();
            onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
            waitForIdle();
            onView(allOf(isFocused(), anyOf(instanceOf(GroupHeader.class),withParent(instanceOf(GroupHeader.class))))).check(matches(isFocused()));
            waitForIdle();
            captureDeviceScreen(s);

        }
        pressBack();
        waitForIdle();

        try {
            openDocument(extractTestAsset("soundloop.tap"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        waitForIdle();

        captureDeviceScreen("attach-tape");
        try {
            onView(withId(R.id.bn_tape)).check(matches(hasFocus()));
        } catch (AssertionFailedError e) {
            onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
            waitForIdle();
        }
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();

        try {
            openDocument(extractTestAsset("testprograms.d64"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        waitForIdle();
        captureDeviceScreen("attach-disk");
        try {
            onView(withText(R.string.IDMS_DRIVE_8)).check(matches(hasFocus()));
        } catch (AssertionFailedError e) {
            onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
            waitForIdle();
        }
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        waitForIdle();


        try {
            openDocument(extractTestAsset("fliplist1.vfl"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        waitForIdle();
        captureDeviceScreen("fliplist-from-file-selection");
        pressBack();

        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        try {
            onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
            onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        } catch (NoMatchingViewException e) {
            // that's ok
        }
        waitForIdle();
        onView(withId(R.id.ib_handle_opened_files)).perform(click());
        captureDeviceScreen("menu-extended");
        onView(withText(R.string.IDS_MP_DATASETTE_CONTROL)).perform(click());
        waitForIdle();
        captureDeviceScreen("tape-functions");
        pressBack();
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_MENU));
        waitForIdle();

        try {
            onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
            onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_MENU));
        } catch (NoMatchingViewException e) {
            // that's ok

        }
        onView(allOf(isDisplayed(), withText(R.string.show_keyboard))).perform(click());
        waitForIdle(1, TimeUnit.SECONDS);
        captureDeviceScreen("keyboard");
        pressBack();
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        pressBack();
        waitForIdle();
        try {
            onView(withText(R.string.quit)).perform(click());
        } catch (NoMatchingViewException e) {
            pressBack();
            onView(withText(R.string.quit)).perform(click());
        }
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);

        onView(isRoot()).perform(setJoysticksConnected(GameControllerJoystick.class, false));
        onView(isRoot()).perform(setJoysticksConnected(DpadJoystick.class, false));
        onView(isRoot()).perform(setHardwarekeyboardConnected(false));
        try {
            onView(isFocused()).check(matches(withText(R.string.name_c64)));

        } catch (NoMatchingViewException e) {
            navigateToView(KeyEvent.KEYCODE_DPAD_DOWN, KeyEvent.KEYCODE_UNKNOWN, instanceOf(TileView.class));
        }
        navigateToView(KeyEvent.KEYCODE_DPAD_RIGHT, KeyEvent.KEYCODE_UNKNOWN, withChild(withText("Pac-Mania")));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle(1, TimeUnit.SECONDS);
        waitForActivity(EmulationActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        waitForIdle(1, TimeUnit.SECONDS);
        captureDeviceScreen("pac-mania-startscreen");
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        try {
            onView(withText(R.string.show_softkeys)).check(matches(withText(R.string.show_softkeys)));
        } catch (NoMatchingViewException e) {
            onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        }

        waitForIdle();
        captureDeviceScreen("pac-mania-menu");
        onView(withText(R.string.show_softkeys)).perform(click());
        waitForIdle();
        captureDeviceScreen("pac-mania-softkeys");
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_RIGHT));
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        captureDeviceScreen("pac-mania-highscore");

    }
}
