package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.pressKey;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.intent.Intents.intending;
import static androidx.test.espresso.intent.matcher.IntentMatchers.hasAction;
import static androidx.test.espresso.intent.matcher.IntentMatchers.hasData;
import static androidx.test.espresso.matcher.RootMatchers.isPlatformPopup;
import static androidx.test.espresso.matcher.ViewMatchers.hasDescendant;
import static androidx.test.espresso.matcher.ViewMatchers.hasFocus;
import static androidx.test.espresso.matcher.ViewMatchers.isChecked;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isEnabled;
import static androidx.test.espresso.matcher.ViewMatchers.isFocused;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withChild;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withParent;
import static androidx.test.espresso.matcher.ViewMatchers.withText;

import static org.hamcrest.CoreMatchers.allOf;
import static org.hamcrest.CoreMatchers.anyOf;
import static org.hamcrest.CoreMatchers.instanceOf;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.Matchers.containsString;

import android.app.Activity;
import android.app.Instrumentation;
import android.content.Intent;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;

import androidx.annotation.IdRes;
import androidx.test.espresso.NoActivityResumedException;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.intent.Intents;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.uiautomator.UiDevice;
import androidx.test.uiautomator.UiObjectNotFoundException;
import androidx.test.uiautomator.UiSelector;

import junit.framework.AssertionFailedError;

import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.TimeUnit;

public class TvModeMainActivityTest extends MainActivityTestBase {
    @Test
    @TvTest
    @SpecialTest
    public void t_0010_main_activity_remote_control() {
        t_0010_main_activity(KeyEvent.KEYCODE_DPAD_CENTER, KeyEvent.KEYCODE_MENU,
                this::pressBack,
                this::pressBack);
    }

    @Test
    @TvTest
    @SpecialTest
    public void t_0010_main_activity_dpad() {
        t_0010_main_activity(KeyEvent.KEYCODE_BUTTON_START, KeyEvent.KEYCODE_BUTTON_SELECT,
                () -> onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_BUTTON_B)),
                () -> {
                    onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_BUTTON_SELECT));
                    waitForIdle();
                    for (int i = 0; i < 8; i++) {
                        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
                    }
                    onView(withText(R.string.quit)).check(matches(isFocused()));
                    onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_BUTTON_START));
                });
    }
    private void t_0010_main_activity(int normalkey, int extendedkey, Runnable runPressback, Runnable runQuit) {
        /*
        Action: Press right key
        Expected result: second tile is focussed
         */
        waitForIdle();
        onView(isFocused()).check(matches(allOf(instanceOf(TileView.class),withChild(withText(R.string.name_c64)))));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_RIGHT));
        onView(isFocused()).check(matches(allOf(instanceOf(TileView.class),withChild(withText(R.string.name_vic20)))));
        /*
        Action: Press right key
        Expected result: 3rd tile is focussed (pet)
         */

        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_RIGHT));
        onView(allOf(instanceOf(TileView.class),withChild(withText(R.string.name_pet)))).check(matches(isFocused()));
        /*
        Action: Press right key
        Expected result: 4th tile is focussed (c128)
         */

        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_RIGHT));
        onView(allOf(instanceOf(TileView.class),withChild(withText(R.string.name_c128)))).check(matches(isFocused()));
        /*
        Action: Press right key
        Expected result: 5th tile is focussed (plus4)
         */

        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_RIGHT));
        onView(allOf(instanceOf(TileView.class),withChild(withText(R.string.name_plus4)))).check(matches(isFocused()));


        /*
        Action: Press right key
        Expected result: 6th tile is focussed (bubble escape)
         */

        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_RIGHT));
        onView(allOf(instanceOf(TileView.class),withChild(withText("Bubble Escape")))).check(matches(isFocused()));

        /*
        Action: press menu key
        Expected result: popup menu with items Start and Website
         */
        onView(isRoot()).perform(pressKey(extendedkey));
        waitForIdle();
        onView(withText(R.string.IDMS_START)).check(matches(isDisplayed()));
        onView(withText(R.string.gotoweb)).check(matches(isDisplayed()));
        /*
        Action: close popup menu
        Expected result: tile is focussed
         */
        runPressback.run();
        waitForIdle();
        onView(allOf(instanceOf(TileView.class),withChild(withText("Bubble Escape")))).check(matches(isFocused()));
        waitForIdle();
        /*
        Action: Press Button
        Expected result: Bubble Escape is launched
         */
        onView(isRoot()).perform(pressKey(normalkey));
        waitForIdle();
        waitForEmulation("screenshot-bubble-escape.pixelbuffer", HTTP_GET_DELAY, TimeUnit.SECONDS);
        /*
        Action: Press Back Button
        Expected result: Quit Dialog showing, Button focussed.
         */
        runQuit.run();
        waitForIdle();
        onView(withText(R.string.quit))
                .check(matches(Matchers.instanceOf(Button.class)))
                .check(matches(isFocused()));
        /*
        Action: press Button
        Expected result: Main activity showing, Bubble Escape still focussed
         */
        onView(isRoot()).perform(pressKey(normalkey));
        waitForIdle();
        //waitForActivity(MainActivity.class,2,TimeUnit.SECONDS);
        onView(allOf(instanceOf(TileView.class),withChild(withText("Bubble Escape")))).check(matches(isFocused()));
        onView(isRoot()).perform(pressKey(extendedkey));
        /*
        Action: press Menu
        Expected result: Popup menu showing up
         */
        waitForIdle();
        Intents.release();
        Intents.init();
        /*
        Action: Select menuitem Website
        Expected result: Menu disappearing
         */
        intending(Matchers.allOf(hasAction(Intent.ACTION_VIEW),hasData("http://gremlinworld.emuunlim.com/commodore64.htm")))
                .respondWithFunction(intent -> new Instrumentation.ActivityResult(Activity.RESULT_OK, null));
        waitForIdle();
        //waitForIdle(1, TimeUnit.SECONDS);
        //if (normalkey == KeyEvent.KEYCODE_DPAD_CENTER) {
            onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));

            waitForIdle();
        //}
        onView(isRoot()).perform(pressKey(normalkey));
        // Special treatment for hardware device FireTV.
        waitForIdle();
        try {
            onView(isRoot()).check(matches(isRoot()));
        } catch (NoActivityResumedException nare) {
            UiDevice dev = UiDevice.getInstance(InstrumentationRegistry.getInstrumentation());
            try {
                dev.findObject(new UiSelector().clickable(true)).click();
            }
            catch (UiObjectNotFoundException onfe) {
                Log.e("UiDevice.dumpWindowHierarchy", "No clickable found, current hierarchy:");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    UiDevice.getInstance(InstrumentationRegistry.getInstrumentation()).dumpWindowHierarchy(baos);
                    for (String line : baos.toString().split("\\r?\\n")) {
                        Log.e("UiDevice.dumpWindowHierarchy", line);
                    }
                }
                catch (IOException ioe) {
                    Log.e("UiDevice.dumpWindowHierarchy", "error dumping hierarchy", ioe);
                }
            }

            waitForIdle();


        }
        waitForIdle();
        onView(withText(R.string.gotoweb)).check(doesNotExist());

        /*
        Action: move to the last tile, press Button
        Expected result: Popup menu showing up
         */
        navigateToHamburger();
        onView(isRoot()).perform(pressKey(normalkey));
        waitForIdle();
        /*
        Action: press Button
        Expected result: License activity showing up
         */
        //onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isFocused()).check(matches(anyOf(hasDescendant(withText(R.string.about)), withText(R.string.about))));
        onView(isRoot()).perform(pressKey(normalkey));
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        waitForActivity(BrowserActivity.class);
        /*
        Action: Press Back Button
        Expected result: Main activity showing, button still focussed
         */
        //runPressback.run();
        UiDevice.getInstance(InstrumentationRegistry.getInstrumentation()).pressBack();
        onView(withId(R.id.bn_info)).check(matches(isFocused()));

    }
    private void openSaveState2(int keycodeMain, int keycodeTab) {
        /*
        Action: press Button
        Expected result: Menu is showing
         */
        onView(isRoot()).perform(pressKey(keycodeMain));
        waitForIdle();
        /*
        Action: press right
        Expected result: Button save state is focussed.
         */
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(allOf(instanceOf(Button.class), withText(R.string.savestates)))
                .check(matches(isFocused()))
                .perform(pressKey(keycodeTab));
        /*
        Action: press button
        Expected result: dialog save states is showing, tab "1" is focussed
         */
        //onView(isRoot()).perform(pressKey(keycodeTab));
        waitForIdle();
        onView(Matchers.instanceOf(EmulationDialogFragmentRootview.class)).check(matches(isDisplayed()));
        onView(withText(R.string.savestates)).check(matches(isDisplayed()));
        onView(isFocused()).check(matches((withText("1"))));
        waitForIdle();
        /*
        Action: press right button
        Expected result: second tab is focussed
         */
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_RIGHT));
        waitForIdle();
        onView(isFocused()).check(matches(withText("2")));
        /*
        Action: press button
        Expected result: save state is empty.
         */
        onView(isRoot()).perform(pressKey(keycodeTab));
    }
    @TvTest
    @Test
    @SpecialTest
    public void t_0180_dialogs_remote_control() {
        t_0180_dialogs(KeyEvent.KEYCODE_DPAD_CENTER, KeyEvent.KEYCODE_MENU,
                this::pressBack);
    }
    @Test
    @TvTest
    @SpecialTest
    public void t_0180_dialogs_dpad() {
        t_0180_dialogs(KeyEvent.KEYCODE_BUTTON_START, KeyEvent.KEYCODE_BUTTON_SELECT,
                () -> onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_BUTTON_B)));
    }    
    private void t_0180_dialogs(int normalkey, int extendedkey, Runnable runPressback) {
        /*
        Action: Press button
        Expected result: C64 emulation showing, no hamburger button
         */
        onView(isRoot()).perform(pressKey(normalkey));
        waitForEmulation();
        onView(withId(R.id.ib_hamburger_menu)).check(matches(not(isDisplayed())));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",10, TimeUnit.SECONDS)));
        /*
        Action: open menu
        Expected result: menu items are focussed in the right order when using up and down key
         */
        onView(isRoot()).perform(pressKey(normalkey));
        if (normalkey == KeyEvent.KEYCODE_BUTTON_START) {
            waitForIdle();
            onView(isRoot()).perform(pressKey(normalkey));
            waitForIdle();
        }

        /*
        Action: press back button.
        Expected result: menu disappearing
         */
        runPressback.run();
        onView(withId(R.id.gv_monitor))
                .check(matches(isDisplayed()))
                .check(matches(isScreenUpdating()));
        waitForIdle(2, TimeUnit.SECONDS);
        /*
        Action: type text
        Expected result: text is displayed
         */
        for (ViewAction v:createTypeActions(Collections.singletonList(
                KeyEvent.KEYCODE_X),50,500)) {
            onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
            onView(withId(R.id.screen)).perform(v);
        }
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(not(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",1, TimeUnit.SECONDS))));
        /*
        Action: press button
        Expected result: Menu is showing, time machine is active
         */
        onView(isRoot()).perform(pressKey(normalkey));
        if (normalkey == KeyEvent.KEYCODE_BUTTON_START) {
            waitForIdle();
            onView(isRoot()).perform(pressKey(normalkey));

        }
        waitForIdle();

        onView(withText(R.string.rewind)).check(matches(isFocused()));
        /*
        Action: press button
        Expected result: time machine dialog showing, seek bar is focussed
         */
        onView(isRoot()).perform(pressKey(normalkey));
        waitForIdle();
        /*
        Action: press right 6 times
        Expected result: moment has moved to ~ 2 seconds
         */
        onView(isFocused()).check(matches(withId(R.id.sb_seekbar)));
        while (true) {
            try {
                onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_RIGHT));
                onView(withId(R.id.tv_time_offset)).check(matches(anyOf(withText(containsString("2.")),withText(containsString("2,")))));
                break;
            } catch (AssertionFailedError e) {
                // that's ok, keep looping
            }
        }
        /*
        Action: press down
        Expected result: button apply is focussed
         */
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(withId(R.id.bn_apply)).check(matches(isFocused()));
        /*
        Action: press right
        Expected result: button save is focussed
         */
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_RIGHT));
        onView(withId(R.id.bn_save)).check(matches(isFocused()));
        /*
        Action: press down
        Expected result: button apply is focussed
         */
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_LEFT));
        onView(withId(R.id.bn_apply)).check(matches(isFocused()));

        /*
        Action: press button
        Expected result: dialog is closed, emulation is in state before typing text.
         */
        onView(isRoot()).perform(pressKey(normalkey));
        waitForIdle(2,TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",2, TimeUnit.SECONDS)));
        openSaveState2(extendedkey, normalkey);
        //waitForIdle(100, TimeUnit.SECONDS);
        waitForIdle();
        onView(allOf(isDisplayed(), withText( R.string.available_snapshot_slot))).check(matches(isDisplayed()));
        /*
        Action: press down
        Expected result: save is focussed
         */
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        waitForIdle();
        onView(allOf(isDisplayed(), withId(R.id.bn_save))).check(matches(isFocused()));
        /*
        Action: press button
        Expected result: dialog disappears
         */
        onView(isRoot()).perform(pressKey(normalkey));
        waitForIdle();
        /*
        Action: type text
        Expected result: text is shown
         */
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",1, TimeUnit.SECONDS)));
        for (ViewAction v:createTypeActions(Collections.singletonList(
                KeyEvent.KEYCODE_X),50,500)) {
            onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
            onView(withId(R.id.screen)).perform(v);
        }
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(not(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",1, TimeUnit.SECONDS))));
        openSaveState2(extendedkey, normalkey);
        waitForIdle();
        /*
        Action: press down
        Expected result: button start is focussed
         */
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(allOf(isDisplayed(), withId(R.id.bn_start))).check(matches(isFocused()));
        /*
        Action: press button
        Expected result: emulation is running, not showing the typed text.
         */
        onView(isRoot()).perform(pressKey(normalkey));
        waitForIdle(2, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",1, TimeUnit.SECONDS)));
        openSaveState2(extendedkey, normalkey);
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        waitForIdle();
        onView(allOf(isDisplayed(), withId(R.id.bn_start))).check(matches(isFocused()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_RIGHT));
        onView(allOf(isDisplayed(), withId(R.id.bn_save))).check(matches(isFocused()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_RIGHT));
        onView(allOf(isDisplayed(), withId(R.id.bn_more))).check(matches(isFocused()));
        onView(isRoot()).perform(pressKey(normalkey));
        waitForIdle();
        onView(withText(R.string.delete)).inRoot(isPlatformPopup())
                .check(matches(isDisplayed()))
                .perform(pressKey(normalkey));
        waitForIdle();
        onView(allOf(isDisplayed(), withText( R.string.available_snapshot_slot))).check(matches(isDisplayed()));
    }
    private void openMenu(final int keycode) {
        onView(isRoot()).perform(pressKey(keycode));
        if (keycode == KeyEvent.KEYCODE_BUTTON_START) {
            waitForIdle();
            onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_BUTTON_START));
        }

    }
    private void openKeyboard(final int keycode) {
        openMenu(keycode);
        waitForIdle();
        for (int i = 0;i < 8; i++) {
            onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
            waitForIdle();
        }
        //onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_LEFT));
        onView(isFocused()).check(matches(withText((R.string.show_keyboard))));
        onView(isRoot()).perform(pressKey(keycode));
        waitForIdle();
    }
    private Matcher<? super View> checkGlSurfaceView(Matcher<?> m) {
        return new TypeSafeMatcher<View>() {
            @Override
            public void describeTo(Description description) {
                m.describeTo(description);

            }
            @Override
            protected boolean matchesSafely(View item) {
                Activity a= getActivity();
                if (a != null) {
                    View v= a.findViewById(R.id.gv_monitor);
                    if (v != null) {
                        return m.matches(v);
                    }
                }
                return false;
            }
        };
    }
    @Test
    @TvTest
    @SpecialTest
    public void t_0220_keyboard_remote_control() {
        t_0220_keyboard(KeyEvent.KEYCODE_DPAD_CENTER, KeyEvent.KEYCODE_DPAD_CENTER,
                this::pressBack);
    }
    @Test
    @TvTest
    @SpecialTest
    public void t_0220_keyboard_dpad() {
        t_0220_keyboard(KeyEvent.KEYCODE_BUTTON_START, KeyEvent.KEYCODE_BUTTON_SELECT,
                () -> onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_BUTTON_B)));
    }
    
    private void t_0220_keyboard(int normalkey, int buttonkey, Runnable runPressback) {
        onView(isRoot()).perform(pressKey(normalkey));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.ib_hamburger_menu)).check(matches(not(isDisplayed())));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",10, TimeUnit.SECONDS)));
        openKeyboard(normalkey);
        onView(isC64Key(" ")).check(matches(isFocused()));
        onView(isRoot()).perform(pressKey(buttonkey));
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_LEFT));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_LEFT));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_LEFT));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_UP));
        onView(isC64Key("SHIFT")).check(matches(isFocused()));
        onView(isRoot()).perform(pressKey(buttonkey));
        onView(isC64Key("SHIFT")).check(matches(isHighlightedC64Key()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_UP));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_RIGHT));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_RIGHT));
        onView(isC64Key("S")).check(matches(isFocused()));
        onView(isRoot()).perform(pressKey(buttonkey));
        waitForIdle();
        onView(isC64Key("SHIFT")).check(matches(not(isHighlightedC64Key())));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(allOf(isDisplayed(), isC64Key("Z"))).check(matches(isFocused()));
        runPressback.run();
        onView(isC64Key(" ")).check(doesNotExist());
        onView(withId(R.id.gv_monitor)).check(matches(
                showsBitmapEqualToAsset("screenshot-typed-heart.pixelbuffer", 1, TimeUnit.SECONDS)));


        openKeyboard(normalkey);

        for (int i = 0; i < 6; i++) {
            onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_UP));
        }
        onView(withText(R.string.hamburger)).check(matches(isFocused()));
        onView(isRoot()).perform(pressKey(buttonkey));
        UiDevice dev = UiDevice.getInstance(InstrumentationRegistry.getInstrumentation());
        waitForIdle();

        //vi.perform(pressKey(normalkey));
        dev.pressKeyCode(normalkey);
        waitForIdle();
        onView(isRoot()).check(matches(checkGlSurfaceView(isScrolledToTop())));
        onView(withText(R.string.hamburger)).check(matches(isFocused()));
        onView(isRoot()).perform(pressKey(buttonkey));

        //onView(withText(R.string.show_screen_top)).inRoot(isPlatformPopup()).check(matches(isChecked()));
        dev.pressKeyCode(KeyEvent.KEYCODE_DPAD_DOWN);
        waitForIdle();
        dev.pressKeyCode(normalkey);
        waitForIdle();
        onView(isRoot()).check(matches(checkGlSurfaceView(isScrolledToCenterY())));
        onView(withText(R.string.hamburger)).check(matches(isFocused()));
        onView(isRoot()).perform(pressKey(buttonkey));
        //onView(withText(R.string.show_screen_center)).inRoot(isPlatformPopup()).check(matches(isChecked()));
        dev.pressKeyCode(KeyEvent.KEYCODE_DPAD_DOWN);
        waitForIdle();
        dev.pressKeyCode(KeyEvent.KEYCODE_DPAD_DOWN);
        waitForIdle();
        dev.pressKeyCode(normalkey);
        waitForIdle();
        onView(isRoot()).check(matches(checkGlSurfaceView(isScrolledToBottom())));
        onView(isRoot()).perform(pressKey(normalkey));
        waitForIdle();
        //onView(withText(R.string.show_screen_bottom)).inRoot(isPlatformPopup()).check(matches(isChecked()));
        dev.pressKeyCode(KeyEvent.KEYCODE_DPAD_DOWN);
        waitForIdle();
        dev.pressKeyCode(KeyEvent.KEYCODE_DPAD_DOWN);
        waitForIdle();
        dev.pressKeyCode(KeyEvent.KEYCODE_DPAD_DOWN);
        waitForIdle();
        dev.pressKeyCode(normalkey);
        waitForIdle();
        onView(isRoot()).check(matches(checkGlSurfaceView(noScrollingRequired())));
        onView(isRoot()).perform(pressKey(normalkey));
        waitForIdle();
        //onView(withText(R.string.zoom_out)).inRoot(isPlatformPopup()).check(matches(isChecked()));
        dev.pressKeyCode(KeyEvent.KEYCODE_DPAD_DOWN);
        waitForIdle();
        dev.pressKeyCode(KeyEvent.KEYCODE_DPAD_DOWN);
        waitForIdle();
        dev.pressKeyCode(KeyEvent.KEYCODE_DPAD_DOWN);
        waitForIdle();
        dev.pressKeyCode(KeyEvent.KEYCODE_DPAD_DOWN);
        waitForIdle();
        dev.pressKeyCode(normalkey);
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        onView(isRoot()).perform(pressKey(normalkey));
        if (normalkey == KeyEvent.KEYCODE_BUTTON_START) {
            waitForIdle();
            onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_BUTTON_START));
        }
        waitForIdle();

        onView(withText(R.string.show_keyboard)).check(matches(isDisplayed()));
        pressBack();
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        pressBack();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
    }
    @Test
    @TvTest
    @SpecialTest
    public void t_0400_settings_remote_control() {
        t_0400_settings(KeyEvent.KEYCODE_DPAD_CENTER);
        pressBack();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));

    }
    @Test
    @TvTest
    @SpecialTest
    public void t_0400_settings_remote_dpad() {
        t_0400_settings(KeyEvent.KEYCODE_BUTTON_START);
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_BUTTON_START));
        waitForIdle();
        onView(withText(R.string.menu)).check(matches(isFocused()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isFocused()).check(matches(withText(R.string.softkeys)));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_BUTTON_START));
        waitForIdle();
        onView(allOf(isFocused(), instanceOf(Button.class))).check(matches(withText("+")));
        pressBack();
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("screenshot-typed-plus.pixelbuffer")))
                .check(matches(isScreenUpdating()));
        pressBack();
        waitForIdle();
        //onView(withText(R.string.quit)).perform(click());
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));


    }
    private Matcher<View> isFocusedHeader(@IdRes int id) {
        return new BaseMatcher<View>() {
            @Override
            public void describeTo(Description description) {
                //description.appendText("Check if Groupoxheader with given id has focus");
                allOf(isFocused(), anyOf(withId(id),withParent(withId(id)))).describeTo(description);
            }
            @Override
            public boolean matches(Object item) {
                return allOf(isFocused(), anyOf(withId(id),withParent(withId(id)))).matches(item);
            }

        };
    }
    private void t_0400_settings(int normalkey) {
        //waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);

        onView(isRoot()).perform(pressKey(normalkey));
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",10, TimeUnit.SECONDS)));
        /*
        Action: open menu
        Expected result: menu items are focussed in the right order when using up and down key
         */
        openMenu(normalkey);
        onView(isFocused()).check(matches(withText(R.string.rewind)));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        waitForIdle();
        onView(isFocused()).check(matches(withText(R.string.IDMS_SETTINGS)));
        onView(isRoot()).perform(pressKey(normalkey));
        waitForIdle();
        onView(isFocusedHeader(R.id.gh_keyboard)).check(matches(isFocused()));
        onView(withId(R.id.sp_keyboard_mapping)).check(matches(not(isDisplayed())));
        onView(isRoot()).perform(pressKey(normalkey));
        waitForIdle();
        onView(withId(R.id.sp_keyboard_mapping)).check(matches(isDisplayed()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isFocusedHeader(R.id.sp_keyboard_mapping)).check(matches(isFocused()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_UP));
        onView(isFocusedHeader(R.id.gh_keyboard)).check(matches(isFocused()));
        onView(isRoot()).perform(pressKey(normalkey));
        waitForIdle();
        onView(withId(R.id.sp_keyboard_mapping)).check(matches(not(isDisplayed())));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(normalkey));
        waitForIdle();

        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(withId(R.id.rb_c64_no_border))
                .check(matches(isFocused()))
                .check(matches(not(isChecked())));
        onView(isRoot()).perform(pressKey(normalkey));
        onView(withId(R.id.rb_c64_no_border))
                .check(matches(isFocused()))
                .check(matches(isChecked()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_UP));
        onView(isRoot()).perform(pressKey(normalkey));
        onView(withId(R.id.rb_c64_standard_border))
                .check(matches(isFocused()))
                .check(matches(isChecked()));
        onView(withId(R.id.rb_c64_no_border))
                .check(matches(not(isFocused())))
                .check(matches(not(isChecked())));

        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_UP));
        onView(isRoot()).perform(pressKey(normalkey));
        waitForIdle();
        onView(withId(R.id.rb_c64_no_border)).check(matches(not(isDisplayed())));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        //onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isFocused()).check(matches(withId(R.id.gh_mobile_device_settings)));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        onView(withText(R.string.show_statusbar)).check(matches(withText(R.string.show_statusbar)));
        onView(withText(R.string.screen_orientation)).check(doesNotExist());
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(withId(R.id.sv_settings)).check(matches(isDisplayed()));
        onView(withId(R.id.bn_apply)).check(matches(isDisplayed()));
        onView(withId(R.id.bn_apply)).check(matches(isFocused()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(normalkey));
        waitForActivity(EmulationActivity.class, 250, TimeUnit.MILLISECONDS);
        waitForIdle(2, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        onView(withText(R.string.rewind)).check(matches(hasFocus()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(withText(R.string.savestates)).check(matches(hasFocus()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(withText(R.string.current_state)).check(matches(hasFocus()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(withText(R.string.open_file)).check(matches(hasFocus()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(withText(R.string.IDMS_SETTINGS)).check(matches(hasFocus()));
        onView(isRoot()).perform(pressKey(normalkey));
        waitForActivity(SettingsActivity.class);
        onView(withId(R.id.gh_keyboard)).check(matches(hasFocus()));
        onView(isRoot()).perform(pressKey(normalkey));
        onView(withId(R.id.bn_add_softkey)).check(matches(isDisplayed()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(withId(R.id.bn_add_softkey)).check(matches(hasFocus()));
        onView(isRoot()).perform(pressKey(normalkey));
        try {
            onView(withId(R.id.sp_key)).check(matches(hasFocus()));
        } catch (AssertionError e) {
            onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
            onView(withId(R.id.sp_key)).check(matches(hasFocus()));
        }
        onView(isRoot()).perform(pressKey(normalkey));
        waitForIdle(200, TimeUnit.MILLISECONDS);
        for (int i = 0; i < 5; i++) {
            if (normalkey == KeyEvent.KEYCODE_DPAD_CENTER) {
                onView(isRoot()).inRoot(isPlatformPopup()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
            } else {
                onView(isRoot()).inRoot(isPlatformPopup()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
                waitForIdle(50, TimeUnit.MILLISECONDS);
            }
            waitForIdle();
        }
        onView(isRoot()).inRoot(isPlatformPopup()).perform(pressKey(normalkey));
        waitForIdle();
        onView(withId(R.id.et_label)).check(matches(withText("+")));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(withId(R.id.sp_modificator_key)).check(matches(hasFocus()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(withId(R.id.et_label)).check(matches(hasFocus()));


        waitForIdle(1, TimeUnit.SECONDS);

        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_TAB));
        waitForIdle(1, TimeUnit.SECONDS);
        //onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));

        onView(withText(R.string.add)).check(matches(hasFocus()));
        onView(isRoot()).perform(pressKey(normalkey));
        waitForIdle(200, TimeUnit.MILLISECONDS);
        onView(withText(R.string.press_button)).check(matches(isDisplayed()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_BUTTON_A));
        waitForIdle(10, TimeUnit.SECONDS);
        onView(withText(R.string.button_south)).check(matches(isDisplayed()));
        onView(withText(R.string.add)).check(matches(hasFocus()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_UP));
        onView(withText(R.string.change)).check(matches(hasFocus()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_RIGHT));
        onView(withText(R.string.remove)).check(matches(hasFocus()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(withId(R.id.cb_hide_on_keyboard)).check(matches(isFocused()));
        waitForIdle();
        UiDevice.getInstance(InstrumentationRegistry.getInstrumentation()).pressDPadDown();
        onView(withText(R.string.apply)).perform(click());
        onView(isRoot()).perform(pressKey(normalkey));
        waitForIdle();
        onView(Matchers.allOf(withId(R.id.tv_label),isInTableRow(1))).check(matches(withText("+")));
        boolean cont = true;

        while (cont) {
            onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
            try {
                onView(withId(R.id.bn_apply)).check(matches(isFocused()));
                cont = false;
            } catch (AssertionError e) {
                // keep looping
            }
        }

        onView(isRoot()).perform(pressKey(normalkey));
        waitForActivity(EmulationActivity.class);
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        pressBack();
        waitForIdle();
        onView(withText(R.string.quit)).check(matches(isFocused()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(pressKey(normalkey));
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        onView(withId(R.id.ib_hamburger_menu)).check(matches(not(isDisplayed())));
        openMenu(normalkey);
        waitForIdle();
        onView(withText(R.string.rewind)).check(matches(isFocused()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(withText(R.string.IDMS_SETTINGS)).check(matches(isFocused()));
        onView(isRoot()).perform(pressKey(normalkey));

        waitForActivity(SettingsActivity.class);
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        waitForIdle();
        onView(isRoot()).perform(pressKey(normalkey));
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(withId(R.id.rb_c64_standard_border)).check(matches(isFocused()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_UP));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));

        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isFocused()).check(matches(withId(R.id.bn_apply)));


        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForActivity(EmulationActivity.class);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",10, TimeUnit.SECONDS)));


        onView(instanceOf(SoftkeysLinearLayout.class)).check(matches(not(isDisplayed())));
        openMenu(normalkey);
        waitForIdle();
        onView(withText(R.string.rewind)).check(matches(isFocused()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        waitForIdle();
        onView(isFocused()).check(matches(withText(R.string.show_softkeys)));
        onView(isRoot()).perform(pressKey(normalkey));
        waitForIdle();
        onView(isFocused()).check(matches(withText("+")));
        onView(isRoot()).perform(pressKey(normalkey));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        onView(withText("+")).check(matches(not(isDisplayed())));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-typed-plus.pixelbuffer")));
    }
    @Test
    @TvTest
    @SpecialTest
    public void javascript() {
        waitForIdle();
        addTestConfigurations();
        waitForIdle();

        navigateToView(KeyEvent.KEYCODE_DPAD_RIGHT, KeyEvent.KEYCODE_UNKNOWN, withChild(withText("_JS_TV_UI_")));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        //onView(withText(R.string.IDMS_START)).perform(click());
        waitForEmulation();
        //onView(withId(R.id.monitorGLSurfaceView)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",10, TimeUnit.SECONDS)));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_BUTTON_START));
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        onView(withText("1")).check(matches(isFocused()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_RIGHT));
        onView(withText("2")).check(matches(isFocused()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_LEFT));
        onView(withText("1")).check(matches(isFocused()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_BUTTON_START));
        waitForIdle();
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_DOWN));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
        waitForIdle();
        onView(withText("1")).check(matches(isFocused()));
        onView(withText("2")).check(matches(not(isEnabled())));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_RIGHT));
        waitForIdle();
        onView(withText("3")).check(matches(isFocused()));
        pressBack();
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        pressBack();
        onView(withText(R.string.quit)).check(matches(isFocused()));
        onView(isRoot()).perform(pressKey(KeyEvent.KEYCODE_DPAD_CENTER));
    }

}
