package de.rainerhock.eightbitwonders;



import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;

import androidx.annotation.NonNull;
import androidx.test.platform.app.InstrumentationRegistry;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;

/**
 * Content provider to vend the age signals.
 * Returns responseStatus, userStatus, ageLower, ageUpper, userId, mostRecentApprovalDate
 */
public class TestContentProvider extends ContentProvider {

    private static final UriMatcher sUriMatcher = new UriMatcher(UriMatcher.NO_MATCH);

    static {
        sUriMatcher.addURI(AgeVerificationProviderImpl.AUTHORITY, "getUserAgeData", 1);
    }

    @Override
    public boolean onCreate() {
        return true;
    }

    @Override
    public String getType(@NonNull Uri uri) {
        return null;
    }

    @Override
    public Uri insert(@NonNull Uri uri, ContentValues values) {
        throw new UnsupportedOperationException("Insert not supported");
    }

    @Override
    public int delete(@NonNull Uri uri, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("Delete not supported");
    }

    @Override
    public int update(@NonNull Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("Update not supported");
    }

    @Override
    public final Cursor query(@NonNull Uri uri, String[] projection, Bundle queryArgs, CancellationSignal cancellationSignal) {
        return query(uri, null, null, null, null, cancellationSignal);
    }

    @Override
    public final Cursor query(@NonNull final Uri uri, final String[] projection, final String selection, final String[] selectionArgs, final String sortOrder) {
        return query(uri, projection, selection, selectionArgs, sortOrder, null);
    }

    @Override
    public final Cursor query(@NonNull final Uri uri, final String[] projection, final String selection,
                              final String[] selectionArgs, final String sortOrder, CancellationSignal cancellationSignal) {
        int match = sUriMatcher.match(uri);
        if (match != 1) {
            throw new IllegalArgumentException("Unknown URI: " + uri);
        }

        String param1 = uri.getQueryParameter("testOption");
        if (param1 == null) {
            throw new IllegalArgumentException("testOption parameter is required");
        }

        int option;
        try {
            option = Integer.parseInt(param1);
        } catch (NumberFormatException e) {
            throw new IllegalArgumentException("testOption must be a valid integer");
        }
        if (option < 1 || option > 11) {
            throw new IllegalArgumentException("testOption must be between 1 and 11");
        }
        MatrixCursor cursor = createCursor();
        cursor.addRow(getResponse(option));
        return cursor;
    }

    private Object[] getResponse(int option) {
        switch (option) {
            case 2: return getResponse2();
            case 3: return getResponse3();
            case 4: return getResponse4();
            case 5: return getResponse5();
            case 6: return getResponse6();
            case 7: return getResponse7();
            case 8: return getResponse8();
            case 9: return getResponse9();
            case 10: return getResponse10();
            case 11: return getResponse11();
        }
        return getResponse1();
    }

    private MatrixCursor createCursor() {
        return new MatrixCursor(new String[]{
                AgeVerificationProviderImpl.COLUMN_RESPONSE_STATUS,
                AgeVerificationProviderImpl.COLUMN_USER_STATUS,
                AgeVerificationProviderImpl.COLUMN_AGE_LOWER,
                AgeVerificationProviderImpl.COLUMN_AGE_UPPER,
                AgeVerificationProviderImpl.COLUMN_USER_ID,
                AgeVerificationProviderImpl.COLUMN_MOST_RECENT_APPROVAL_DATE
        });
    }

    /***
     * Sample response for 18+ user who is age verified
     * For more details see API documentation.
     */
    private static Object[] getResponse1() {
        return new Object[]{ "SUCCESS", "VERIFIED", 18, null, null, null };
    }


    /***
     * Sample response for any user where age verification/consent is not ascertainable.
     * For more details see API documentation.
     */
    private static Object[] getResponse2() {
        return new Object[]{ "SUCCESS", "UNKNOWN", null, null, null, null };
    }


    /***
     * Response for user with age range between 0 to 12.
     * For more details see API documentation.
     */
    private static Object[] getResponse3() {
        return new Object[]{ "SUCCESS", "SUPERVISED", 0, 12, "randomTestUserId1jC3QQeivdAytchaIVkWOjDiDlvz8xglhUcLwkbUHNQZKKw", "2023-07-01T00:00:00.008+02:00" };
    }


    /***
     * Response for user with age range between 13 to 15.
     * For more details see API documentation.
     */
    private static Object[] getResponse4() {
        return new Object[]{ "SUCCESS", "SUPERVISED", 13, 15, "randomTestUserId1jC3QQeivdAytchaIVkWOjDiDlvz8pUxhUcLwkbUHNQZKKw", "2023-07-01T00:00:00.008Z" };
    }


    /***
     * Response for user with age range between 16 to 17.
     * For more details see API documentation.
     */
    private static Object[] getResponse5() {
        return new Object[]{ "SUCCESS", "SUPERVISED", 16, 17, "randomTestUserId1jC3QQeivdhBcchaIVkWOjDiDlvz8pUxhUcLwkbUHNQZKKw", "2023-07-01T00:00:00.008Z" };
    }


    /*
     * Sample response for a user under 18 years old where consent is pending or not granted.
     * The following code uses "0, 12" as the age interval, but you can change this to suit your test case. Valid age intervals are "0, 12", "13, 15", and "16, 17".
     * For more details see API documentation.
     */
    private static Object[] getResponse6() {
        return new Object[]{ "SUCCESS", "CONSENT_NOT_GRANTED", 0, 12, "randomTestUserId1jC3QQeivdAytchaIVkWOjDiDlvz8xglhUcLwkbUHNQZKKw", "2023-07-01T00:00:00.008+02:00" };
    }


    /***
     * Response for any scenarios in general where age verification law is not applicable.
     * For more details see API documentation.
     */
    private static Object[] getResponse7() {
        return new Object[]{ "SUCCESS", "", null, null, null, null };
    }


    /***
     * Response when API returns APP_NOT_OWNED status
     * For more details see API documentation.
     */
    private static Object[] getResponse8() {
        return new Object[]{ "APP_NOT_OWNED", "", null, null, null, null };
    }


    /***
     * Response when API returns INTERNAL_TRANSIENT_ERROR status
     * For more details see API documentation.
     */
    private static Object[] getResponse9() {
        return new Object[]{ "INTERNAL_TRANSIENT_ERROR", "", null, null, null, null };
    }


    /***
     * Response when API returns INTERNAL_ERROR status
     * For more details see API documentation.
     */
    private static Object[] getResponse10() {
        return new Object[]{ "INTERNAL_ERROR", "", null, null, null, null };
    }


    /***
     * Response when API returns FEATURE_NOT_SUPPORTED status
     * For more details see API documentation.
     */
    private static Object[] getResponse11() {
        return new Object[]{ "FEATURE_NOT_SUPPORTED", "", null, null, null, null };
    }
}

