package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.intent.Intents.intending;
import static androidx.test.espresso.intent.matcher.IntentMatchers.hasAction;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withText;

import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.CoreMatchers.notNullValue;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.anyOf;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import android.app.Activity;
import android.app.Instrumentation;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Point;
import android.net.Uri;

import androidx.annotation.StringRes;
import androidx.test.espresso.intent.Intents;
import androidx.test.filters.SdkSuppress;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.uiautomator.By;
import androidx.test.uiautomator.UiDevice;
import androidx.test.uiautomator.UiObject;
import androidx.test.uiautomator.UiObject2;
import androidx.test.uiautomator.UiObjectNotFoundException;
import androidx.test.uiautomator.UiSelector;
import androidx.test.uiautomator.Until;

import org.junit.Test;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

@SdkSuppress(minSdkVersion=33, maxSdkVersion=34)
public class SystemUiTest extends MainActivityTestBase{
    private static final long LAUNCH_TIMEOUT = 5000;

    private Point getScreenCentre() {
        return new Point(UiDevice.getInstance(InstrumentationRegistry.getInstrumentation()).getDisplayWidth()/2,
                UiDevice.getInstance(InstrumentationRegistry.getInstrumentation()).getDisplayHeight()/2);
    }
    private void create_and_start_widget(@StringRes int name) throws UiObjectNotFoundException {
        UiDevice device = UiDevice.getInstance(InstrumentationRegistry.getInstrumentation());
        final String launcherPackage = device.getLauncherPackageName();
        assertThat(launcherPackage, notNullValue());
        device.wait(Until.hasObject(By.pkg(launcherPackage).depth(0)),
                LAUNCH_TIMEOUT);
        waitForIdle(1, TimeUnit.SECONDS);

        device.swipe((Point[]) Arrays.asList(getScreenCentre(), getScreenCentre()).toArray(), 300);

        device.wait(Until.findObject(By.text("Widgets")),1000).click();
        Resources res = InstrumentationRegistry.getInstrumentation().getTargetContext().getResources();
        String appname = res.getString(R.string.app_name);
        device.wait(Until.findObject(By.text(appname)),200).drag(new Point(getScreenCentre().x, getScreenCentre().y * 75 / 100), 1000);
        device.wait(Until.findObject(By.text(appname)),1000).click();
        waitForIdle(1, TimeUnit.SECONDS);
        String widgetname = res.getString(R.string.widgettitle);
        device.wait(Until.findObject(By.text(widgetname)),1000).drag(getScreenCentre(),1000);
        waitForIdle();
        onView(withText(name)).perform(click());
        assertThat(launcherPackage, notNullValue());
        device.wait(Until.hasObject(By.pkg(launcherPackage).depth(0)),
                LAUNCH_TIMEOUT);
        waitForIdle(1, TimeUnit.SECONDS);
        device.pressBack();
        UiObject widget = device.findObject(new UiSelector()
                .description("8-Bit Wonders"));
        widget.click();

    }
    @Test
    public void testCreatingAndRemoving() throws UiObjectNotFoundException {
        UiDevice device = UiDevice.getInstance(InstrumentationRegistry.getInstrumentation());
        onView(withId(R.id.preinstalled)).check(matches(isDisplayed()));
        device.pressHome();
        create_and_start_widget(R.string.name_c64);
        waitForActivity(EmulationActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 10, TimeUnit.SECONDS)));
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForIdle();
        device.pressHome();
        removeWidget();
    }

    private void removeWidget() throws UiObjectNotFoundException {
        UiDevice device = UiDevice.getInstance(InstrumentationRegistry.getInstrumentation());
        final String launcherPackage = device.getLauncherPackageName();
        device.wait(Until.hasObject(By.pkg(launcherPackage).depth(0)),
                LAUNCH_TIMEOUT);
        waitForIdle(1, TimeUnit.SECONDS);
        device.pressBack();
        waitForIdle();
        UiObject widget = device.findObject(new UiSelector()
                .description("8-Bit Wonders"));
        widget.dragTo(getScreenCentre().x, getScreenCentre().y * 20 / 100, 50);
        waitForIdle();
        try {
            assertThat("Widget removed", !device.findObject(new UiSelector()
                    .description("8-Bit Wonders")).exists());
        } catch (AssertionError e) {
            waitForIdle();
            widget = device.findObject(new UiSelector()
                    .description("8-Bit Wonders"));
            widget.dragTo(getScreenCentre().x, getScreenCentre().y * 25 / 100, 50);
            assertThat("Widget removed", !device.findObject(new UiSelector()
                    .description("8-Bit Wonders")).exists());

        }
    }

    @Test
    public void testConcurrentLaunch() throws UiObjectNotFoundException {
        UiDevice device = UiDevice.getInstance(InstrumentationRegistry.getInstrumentation());
        onView(withId(R.id.preinstalled)).check(matches(isDisplayed()));
        device.pressHome();
        create_and_start_widget(R.string.name_c64);
        waitForActivity(EmulationActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 10, TimeUnit.SECONDS)));
        device.pressHome();
        removeWidget();
        create_and_start_widget(R.string.name_vic20);
        waitForIdle(5, TimeUnit.SECONDS);
        String title = InstrumentationRegistry.getInstrumentation().getTargetContext().getResources().getString(R.string.currently_running, "C64");
        onView(withText(title)).check(matches(isDisplayed()));
        onView(withText(android.R.string.yes)).check(matches(isDisplayed()));
        onView(withText(android.R.string.no))
                .check(matches(isDisplayed()))
                .perform(click());
        waitForIdle();
        onView(withText(R.string.pause)).check(matches(isDisplayed()));
        //onView(isRoot()).perform(waitForMatch(withId(R.id.monitorGLSurfaceView),5, TimeUnit.SECONDS));
        //onView(withId(R.id.monitorGLSurfaceView)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 10, TimeUnit.SECONDS)));
        device.pressHome();
        final String launcherPackage = device.getLauncherPackageName();
        assertThat(launcherPackage, notNullValue());
        device.wait(Until.hasObject(By.pkg(launcherPackage).depth(0)),
                LAUNCH_TIMEOUT);
        waitForIdle(1, TimeUnit.SECONDS);
        device.pressBack();
        UiObject widget = device.findObject(new UiSelector()
                .description("8-Bit Wonders"));
        widget.click();
        waitForIdle(5, TimeUnit.SECONDS);
        title = InstrumentationRegistry.getInstrumentation().getTargetContext().getResources().getString(R.string.currently_running, "C64");
        onView(withText(title)).check(matches(isDisplayed()));
        onView(withText(android.R.string.no)).check(matches(isDisplayed()));
        onView(withText(android.R.string.yes))
                .check(matches(isDisplayed()))
                .perform(click());
        waitForIdle(1, TimeUnit.SECONDS);
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-vic-machine-ready-ntsc.pixelbuffer", 10, TimeUnit.SECONDS)));
        device.pressHome();
        removeWidget();
    }
    @Test
    public void testNotifications() {
        /*
        Action: start C64 and launch file that plays audio and updates the screen
        Expected result: program running and playing audio.
         */
        onView(withText(R.string.name_c64)).perform(scrollTo()).perform(click());
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating()));
        Intent resultData = new Intent();
        Instrumentation.ActivityResult result =
                new Instrumentation.ActivityResult(Activity.RESULT_OK, resultData);
        try {
            resultData.setData(Uri.fromFile(new File(extractTestAsset("soundloop.vsf"))));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        Intents.release();
        Intents.init();

        intending(anyOf(hasAction(Intent.ACTION_GET_CONTENT), hasAction(Intent.ACTION_CHOOSER))).respondWith(result);
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(isMenuPresent(R.string.start_open_file)).check(matches(isDisplayed()));
        onView(withText(R.string.start_open_file)).perform(click());
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("screenshot-soundloop-1.pixelbuffer", 20, TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating()))
                .check(matches(isAudioPlaying()));

        /*
        Action: open menu
        Expected result: no submenu with background menuitem
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        onView(withId(R.id.ll_background)).check(matches(not(isDisplayed())));
        onView(withId(R.id.ib_background)).perform(click());
        /*
        Action: click on hamburger next to pause and choose Background
        Expected results:
        - Running in Background dialog displayed
        - audio playing
        - No screen updates
         */
        onView(withText(R.string.audio_background)).perform(click());
        onView(withText(R.string.running_in_background)).check(matches(isDisplayed()));
        onView(withId(R.id.gv_monitor))
                .check(matches(not(isScreenUpdating())))
                .check(matches(isAudioPlaying()));
        /*
        Action: click on button to bring emulation back from background
        Expected results:
        - No Dialog
        - Audio playing
        - Screen updates
         */
        onView(withText(R.string.bring_back)).perform(click());
        onView(withText(R.string.bring_back)).check(doesNotExist());
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenUpdating()))
                .check(matches(isAudioPlaying()));

        /*
        Action: open menu
        Expected result: no submenu with background menuitem
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        onView(withId(R.id.ll_background)).check(matches(not(isDisplayed())));
        onView(withId(R.id.ib_background)).perform(click());
        /*
        Action: click on hamburger next to pause
        Expected result: Menu item Background (headset icon) is displayed
         */
        onView(withText(R.string.audio_background)).check(matches(isDisplayed()));
        /*
        Action: click on audio
        Expected result:
        - Info box about running background
        - Audio playing
        - No screen updates
         */
        onView(withText(R.string.audio_background)).perform(click());
        onView(withText(R.string.running_in_background)).check(matches(isDisplayed()));
        onView(withId(R.id.gv_monitor))
                .check(matches(not(isScreenUpdating())))
                .check(matches(isAudioPlaying()));
        /*
        Action: press home button and open notifications
        Expected result: Notification "resume to C64" and
         */
        UiDevice device = UiDevice.getInstance(InstrumentationRegistry.getInstrumentation());
        device.pressHome();
        device.openNotification();
        waitForIdle(1, TimeUnit.SECONDS);
        Context ctx = InstrumentationRegistry.getInstrumentation().getTargetContext();
        String textResume = ctx.getResources().getString(R.string.resume_to, "C64");
        UiObject2 notification = device.findObject(By.text(textResume));
        assertNotNull(notification);
        /*
        Action: click on notification "Resume to C54"
        Expected result:
        Expected result:
        - Info box about running background
        - Audio playing
        - No screen updates
         */
        notification.click();
        onView(withText(R.string.running_in_background)).check(matches(isDisplayed()));
        onView(withId(R.id.gv_monitor))
                .check(matches(not(isScreenUpdating())))
                .check(matches(isAudioPlaying(1, TimeUnit.SECONDS)));

        /*
        Action: press Back key
        Expected result:
        - no dialog
        - screens are updated
        - audio playing
         */
        pressBack();
        onView(withText(R.string.running_in_background)).check(doesNotExist());
        onView(withText(R.string.quit)).check(doesNotExist());
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenUpdating()))
                .check(matches(isAudioPlaying()));
        /*
        Action: open menu and choose send to background
        Expected result: notification with text "Pause" visible
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        onView(withId(R.id.ll_background)).check(matches(not(isDisplayed())));
        onView(withId(R.id.ib_background)).perform(click());
        onView(withText(R.string.audio_background)).perform(click());
        device.pressHome();
        device.openNotification();
        waitForIdle(1, TimeUnit.SECONDS);
        notification = device.findObject(By.text(ctx.getString(R.string.pause)));
        /*
        Action: click on "Pause"
        Expected result: text changes to "Continue"
         */
        assertNotNull(notification);
        notification.click();
        waitForIdle();
        notification = device.findObject(By.text(ctx.getString(R.string.cont)));
        assertNotNull(notification);
        /*
        Action: click on "Resume to C64"
        Expected result:
        - No screen updates
        - Audio not playing.
         */
        notification = device.findObject(By.text(textResume));
        assertNotNull(notification);
        notification.click();
        onView(withId(R.id.gv_monitor))
                .check(matches(not(isScreenUpdating())))
                .check(matches(not(isAudioPlaying())));
        onView(allOf(isDisplayed(), withText(R.string.pause))).check(matches(isDisplayed()));
        /*
        Action: press Home and open notification
        Expected result: Text "Pause"
         */
        device.pressHome();
        device.openNotification();
        waitForIdle(1, TimeUnit.SECONDS);
        notification = device.findObject(By.text(ctx.getString(R.string.pause)));
        assertNull(notification);
        device.pressBack();
    }
}
