package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.closeSoftKeyboard;
import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.typeText;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.intent.Intents.intending;
import static androidx.test.espresso.intent.matcher.IntentMatchers.hasAction;
import static androidx.test.espresso.matcher.ViewMatchers.assertThat;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isEnabled;
import static androidx.test.espresso.matcher.ViewMatchers.isFocusable;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withParent;
import static androidx.test.espresso.matcher.ViewMatchers.withParentIndex;
import static androidx.test.espresso.matcher.ViewMatchers.withSpinnerText;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;
import static org.hamcrest.CoreMatchers.allOf;
import static org.hamcrest.Matchers.*;
import static org.hamcrest.Matchers.instanceOf;
import static org.hamcrest.Matchers.not;
import android.app.Activity;
import android.app.Instrumentation;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import android.widget.Button;

import androidx.annotation.IdRes;
import androidx.appcompat.view.menu.ListMenuItemView;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.intent.Intents;
import androidx.test.filters.LargeTest;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.uiautomator.By;
import androidx.test.uiautomator.UiDevice;
import androidx.test.uiautomator.UiObject2;

import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;

//@RunWith(AndroidJUnit4.class)
//@RunWith(AndroidJUnit4)
@LargeTest
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class StorageAccessTest extends C64EmulationTestBase {
    UiDevice mDevice = UiDevice.getInstance(InstrumentationRegistry.getInstrumentation());
    @Override
    protected void checkForToast(@IdRes int resId) {
        String text = InstrumentationRegistry.getInstrumentation().getTargetContext().getString(resId);
        for (int i = 0; i < 10; i++) {
            UiObject2 o = mDevice.findObject(By.text(text));
            Log.v("checkForToast", String.format("found %s", o));
            if (o != null) {
                return;
            } else {
                try {
                    Thread.sleep(100);
                } catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
        }

    }
    }
    private void cancelDocumentOpening() {
        Intents.release();
        Intents.init();
        intending(anyOf(hasAction(Intent.ACTION_GET_CONTENT),hasAction(Intent.ACTION_CHOOSER)))
                .respondWith(new Instrumentation.ActivityResult(Activity.RESULT_CANCELED, null));
        chooseFileMenu();
    }
    private byte[] getDigest(String path) throws NoSuchAlgorithmException, IOException {
        @SuppressWarnings("IOStreamConstructor")
        DigestInputStream dis = new DigestInputStream(new FileInputStream(path), MessageDigest.getInstance("SHA-256"));
        byte[] buffer = new byte[dis.available()];
        if (dis.read(buffer)<0) {
            throw new IOException("Could not read "+path);
        }
        byte[] digest= dis.getMessageDigest().digest();
        dis.close();
        return digest;
    }

    @SuppressWarnings("SpellCheckingInspection")
    @Test
    public void t_0010_opendisk() {
        /*
        Action: disable drive 9 and return
        Expected result: Emulation running
         */
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        onView(allOf(isDisplayed(), withText(R.string.IDS_DEVICES))).perform(click());
        onView(withTagValue(equalTo("Drive9Type"))).perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());
        onView(withTagValue(equalTo("Drive8Type"))).perform(click());
        onData(isOption("CBM 1541")).perform(click());

        pressBack();
        waitForActivity(EmulationActivity.class, 1, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));

        /*
        Action: attempt to open a file and then cancel doing this.
        Expected result: Emulation running.
         */

        cancelDocumentOpening();
        waitForActivity(EmulationActivity.class, 1, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        /*
        Action: open testprograms.d64
        Expected result:
        - Activity to attach disk image or run program is shown
        - Disk has entry TUTAN2 and JOYSTICKTEST
        - Only button to attach to drive 8 and checkbox for read only are visible
         */
        try {
            openDocument(extractTestAsset("testprograms.d64"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        waitForIdle();
        onView(withText(R.string.IDMS_DRIVE_8)).check(matches(isDisplayed()));
        onView(withText(R.string.IDS_READ_ONLY)).check(matches(isDisplayed()));
        onView(withText(R.string.IDMS_DRIVE_9)).check(matches(not(isDisplayed())));
        onView(withText(R.string.IDMS_DRIVE_10)).check(matches(not(isDisplayed())));
        onView(withText(R.string.IDMS_DRIVE_11)).check(matches(not(isDisplayed())));
        onView(withText(R.string.IDS_ATTACH)).check(matches(not(isDisplayed())));
        onView(withText(R.string.IDS_TYPE)).check(matches(not(isDisplayed())));

        onData(isOption("JOYSTICKTEST")).inAdapterView(withId(R.id.lv_imagecontents)).check(matches(isDisplayed()));
        onData(isOption("SOUNDLOOP")).inAdapterView(withId(R.id.lv_imagecontents))
                .check(matches(isDisplayed()))
                .perform(click());
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("screenshot-soundloop-2.pixelbuffer", 60, TimeUnit.SECONDS)));

    }
    @Test
    public void t_0080_opentape() {
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating()));
        try {
            openDocument(extractTestAsset("soundloop.tap"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        onView(withText(R.string.IDS_READ_ONLY)).check(matches(isDisplayed()));
        onView(withText(R.string.IDMS_DRIVE_9)).check(matches(not(isDisplayed())));
        onView(withText(R.string.IDMS_DRIVE_10)).check(matches(not(isDisplayed())));
        onView(withText(R.string.IDMS_DRIVE_11)).check(matches(not(isDisplayed())));
        onView(withText(R.string.IDMS_DRIVE_8)).check(matches(not(isDisplayed())));
        onView(withText(R.string.IDS_TYPE)).check(matches(not(isDisplayed())));
        onView(withText(R.string.IDS_ATTACH))
                .check(matches(isDisplayed()))
                .perform((click()));
        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("STOP")).perform(tap());
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("screenshot-press-play-on-tape.pixelbuffer",2, TimeUnit.SECONDS)));
        onView(isC64Key("STOP")).perform(tap());
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("screenshot-load-error.pixelbuffer",2, TimeUnit.SECONDS)));
    }
    @Test
    public void t_0140_attach_cartridge() throws InterruptedException {
        try {
            /*
            Action: Open CRT file (cartridge)
            Expected result: Reset with cartridge attached
             */
            waitForActivity(EmulationActivity.class, 250, TimeUnit.MILLISECONDS);
            onView(instanceOf(EmulationTestInterface.class))
                    .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)))
                    .check(matches(isScreenUpdating()));
            openDocument(extractTestAsset("testcart.crt"));
            waitForActivity(EmulationActivity.class, 250, TimeUnit.MILLISECONDS);
            onView(withId(R.id.gv_monitor))
                    .check(matches(showsBitmapEqualToAsset("screenshot-testcart.pixelbuffer", 5, TimeUnit.SECONDS)))
                    .check(matches(isScreenUpdating()));
            /*
            Action: open BIN file with cartridge and choose which cartridge it is
            Expected result: Reset with cartridge attached
             */
            openDocument(extractTestAsset("testcart.bin"));

            onData(isOption("generic 8KiB game")).inAdapterView(withId(R.id.lv_cartridgetypes)).perform(click());
            waitForIdle();
            waitForActivity(EmulationActivity.class, 1, TimeUnit.SECONDS);
            onView(withId(R.id.gv_monitor))
                    .check(matches(isScreenUpdating()))
                    //.perform(takeScreenShot("screenshot-testcart.pixelbuffer"))
                    .check(matches(showsBitmapEqualToAsset("screenshot-testcart.pixelbuffer", 6, TimeUnit.SECONDS)));
            /*
            Action: open BIN file and choose a non-matching cartridge type
            Expected result: emulator running with emulators state unchanged.
             */
            onView(isC64Key("B")).perform(tap());
            onView(isC64Key("L")).perform(tap());
            onView(isC64Key("E")).perform(tap());
            onView(isC64Key("R")).perform(tap());
            onView(isC64Key("B")).perform(tap());
            Thread.sleep(500);
            //onView(withId(R.id.monitorGLSurfaceView)).perform(captureEmulationScreen("screenshot-testcart-blerb.pixelbuffer"));
            onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-testcart-blerb.pixelbuffer")));
            openDocument(extractTestAsset("testcart.bin"));
            onData(isOption("Simons' BASIC")).inAdapterView(withId(R.id.lv_cartridgetypes)).perform(click());
            //waitForIdle();
            checkForToast(R.string.IDS_CANNOT_ATTACH_FILE);
            onData(isOption("Simons' BASIC")).inAdapterView(withId(R.id.lv_cartridgetypes)).check(matches(isDisplayed()));

            intending(hasAction(Intent.ACTION_GET_CONTENT))
                    .respondWith(new Instrumentation.ActivityResult(Activity.RESULT_CANCELED, null));

            pressBack();
            waitForActivity(EmulationActivity.class, 1, TimeUnit.SECONDS);
            onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-testcart-blerb.pixelbuffer",2, TimeUnit.SECONDS)));
            /*
            Action: open BIN file and choose a non-matching cartridge type first, a matching one second.
            Expected result: new cartridge attached and reset.
             */
            openDocument(extractTestAsset("testcart.bin"));
            onData(isOption("Simons' BASIC")).inAdapterView(withId(R.id.lv_cartridgetypes)).perform(click());
            //waitForIdle();
            checkForToast(R.string.IDS_CANNOT_ATTACH_FILE);
            onData(isOption("generic 8KiB game")).inAdapterView(withId(R.id.lv_cartridgetypes)).perform(click());
            waitForIdle();
            waitForActivity(EmulationActivity.class, 1, TimeUnit.SECONDS);
            onView(withId(R.id.gv_monitor))
                    .check(matches(isScreenUpdating()))
                    .check(matches(showsBitmapEqualToAsset("screenshot-testcart.pixelbuffer",5, TimeUnit.SECONDS)));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }

    }
    @Test
    public void t_0190_attach_broken_diskimage() {
        /*
        Action: attach disk image and read directory
        Expected result: directory is shown
         */
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating()));
        try {
            openDocument(extractTestAsset("testprograms.d64"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        waitForIdle();
        onView(withText(R.string.IDMS_DRIVE_8)).perform(click());
        onView(instanceOf(EmulationTestInterface.class))
                .check(matches(isScreenUpdating()));

        type_load_directory(8);

        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-load-testprograms.pixelbuffer", 20, TimeUnit.SECONDS)));
        onView(isC64Key("L")).perform(tap());
        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("I")).perform(tap());
        onView(isC64Key("RETURN")).perform(tap());
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-dir-testprograms.pixelbuffer", 20, TimeUnit.SECONDS)));
        /*
        Action: attach a broken image
        Expected result: toast ist shown, not attaching

         */
        try {
            openDocument(extractTestAsset("kaputt.d64"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }

        String text = InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.could_not_open_file, "kaputt.d64");
        checkForToast(text);
        waitForIdle();
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("screenshot-dir-testprograms.pixelbuffer", 4, TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating()));
        /*
        Action: show directory again
        Expected result: old directory is shown again, since image is unchanged
         */
        type_load_directory(8);
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-2nd-load-testprograms.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(isC64Key("L")).perform(tap());
        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("I")).perform(tap());
        onView(isC64Key("RETURN")).perform(tap());
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-2nd-dir-testprograms.pixelbuffer", 5, TimeUnit.SECONDS)));

    }
    @Test
    public void t_0230_attach_broken_cartridge() {
        /*
        Action: attach working snapshot
        Expected result: snapshot is started
         */
        onView(instanceOf(EmulationTestInterface.class))
                .check(matches(isScreenInitialized()));
        try {
            openDocument(extractTestAsset("soundloop.vsf"));
            waitForActivity(EmulationActivity.class, 1, TimeUnit.SECONDS);
            onView(withId(R.id.gv_monitor))
                    .check(matches(isScreenUpdating()))
                    .check(matches(showsBitmapEqualToAsset("screenshot-soundloop-2.pixelbuffer",20, TimeUnit.SECONDS)))
                    .check(matches(isAudioPlaying()));
            /*
            Action: attach non-working snapshot
            Expected result: emulation is continued at previous state.
             */

            openDocument(extractTestAsset("kaputt.vsf"));
            waitForActivity(EmulationActivity.class, 1, TimeUnit.SECONDS);
            onView(withId(R.id.gv_monitor))
                    .check(matches(isScreenUpdating()))
                    .check(matches(isAudioPlaying()))
                    .check(matches(showsBitmapEqualToAsset("screenshot-soundloop-1.pixelbuffer",20, TimeUnit.SECONDS)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }

    }
    @Test
    public void t_0265_detach_images() {
        /*
        Action: start emulation
        Expected Result: button to detach image is either invisible or not focusable and not enabled.
         */
        waitForActivity(EmulationActivity.class, 1, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        //onView(withId(R.string.bluetooth)).check(matches(isDisplayed()));
        try {

            onView(withText(R.string.detach_file)).check(matches(not(allOf(isDisplayed(), anyOf(withParent(instanceOf(ListMenuItemView.class)), isFocusable()), isEnabled()))));
        } catch (NoMatchingViewException e) {
            // that's ok.
        }
        pressBack();
        /*
        Action: attach disk image
        Expected result: button to detach image is visible, focusable and enabled.
         */
        try {
            //setIntentCallback(extractTestAsset("testprograms.d64"));
            openDocument(extractTestAsset("testprograms.d64"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        waitForIdle();
        onView(withText(R.string.IDMS_DRIVE_8)).perform(click());
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        //onView(withId(R.string.drive8)).check(matches(isEnabled()));
        onView(withId(R.id.ib_handle_opened_files)).perform(click());
        onView(withText(R.string.detach_file)).check(matches(allOf(isDisplayed(), isFocusable(), isEnabled())));
        pressBack();
        /*
        Action: load directory of attached image.
        Expected result: directory is shown
         */
        type_load_directory(8);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-load-testprograms.pixelbuffer", 20, TimeUnit.SECONDS)));
        onView(isC64Key("L")).perform(tap());
        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("I")).perform(tap());
        onView(isC64Key("RETURN")).perform(tap());
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-dir-testprograms.pixelbuffer", 20, TimeUnit.SECONDS)));

        /*
        Action: attach tape image
        Expected result: no changes
         */
        try {
            openDocument(extractTestAsset("soundloop.tap"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        onView(withText(R.string.IDS_ATTACH)).perform(click());
        waitForActivity(EmulationActivity.class, 1, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        /*
        Action: detach disk image and try to load directory
        Expected result:
        - directory cannot be loaded
        . there is no button to detach disk image
        - there is a button to detach tape image
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        Context ctx = InstrumentationRegistry.getInstrumentation().getTargetContext();
        onView(withId(R.id.ib_handle_opened_files)).perform(click());
        onView(withText(R.string.detach_file)).perform(click());
        onView(withText(R.string.tape)).check(matches(allOf(isDisplayed(),isFocusable(), isEnabled())));
        onView(withText(R.string.IDMS_DRIVE_8))
                .check(matches(allOf(isDisplayed(),isFocusable(), isEnabled())))
                .perform(click());
        waitForActivity(EmulationActivity.class, 1, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(isRoot()).check(matches(not(isScreenUpdating())));
        onView(withId(R.id.ib_handle_opened_files)).perform(click());
        onView(withText(R.string.detach_file)).perform(click());
        onView(withText(ctx.getString(R.string.IDMS_DETACH_DISK_IMAGE) + ": "
                + ctx.getString(R.string.IDMS_DRIVE_8)))
                .check(doesNotExist());
        pressBack();
        type_load_directory(8);
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        onView(isC64Key("L")).perform(tap());
        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("I")).perform(tap());
        onView(isC64Key("RETURN")).perform(tap());

        onView(withId(R.id.gv_monitor)).check(matches(not(showsBitmapEqualToAsset("screenshot-dir-testprograms-2nd-load.pixelbuffer", 4, TimeUnit.SECONDS))));
        /*
        Action: detach remain images
        Expected Result: button to detach image is either invisible or not focusable and not enabled.
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withId(R.id.ib_handle_opened_files)).perform(click());
        onView(withText(R.string.detach_file)).perform(click());
        waitForIdle();
        onView(withText(ctx.getString(R.string.tape))).perform(click());
        waitForIdle();
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        try {
            onView(withText(R.string.detach_file)).check(matches(not(allOf(isDisplayed(),isFocusable(), isEnabled()))));
        } catch (NoMatchingViewException e) {
            // that's ok.
        }
        pressBack();
        waitForActivity(EmulationActivity.class, 1, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenUpdating()));
    }
    @Test
    public void t_0420_create_disk_image_t0560_modify_file() {
        final String timestamp = String.valueOf(System.currentTimeMillis());
        final String filename = "test-"+timestamp.substring(timestamp.length()-10)+".d64";
        final String path = InstrumentationRegistry.getInstrumentation().getTargetContext().getCacheDir()+"/"+filename;
        try {
            /*
            Action: Open menu and select Menuitem create file
            Expected result: Activity "Create Image" showing up with image type d64 preselected
            and button create disabled.
             */
            onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)));
            onView(withId(R.id.ib_hamburger_menu)).perform(tap());
            waitForIdle();
            onView(withId(R.id.ib_handle_opened_files)).perform(click());
            onView(withText(R.string.create_and_attach_image)).perform(click());
            waitForIdle();
            onView(withText(R.string.create_and_attach_image)).check(matches(anything()));
            onView(withText(R.string.create)).check(matches(not(isEnabled())));
            onView(withId(R.id.sp_typ)).check(matches(withSpinnerText("d64")));
            /* Action:
            type in disk label test and disk id 17, click Create
            Expected result: Activity to attach the file is shown, title is filename.
             */
            onView(withId(R.id.et_name)).perform(typeText("test"));
            onView(withText(R.string.create)).check(matches(isEnabled()));
            onView(withId(R.id.et_id)).perform(typeText("17"));
            closeSoftKeyboard();
            Intents.release();
            Intents.init();
            intending(hasAction(Intent.ACTION_CHOOSER)).respondWithFunction(intent ->
            {
                Intent resultData = new Intent();
                Instrumentation.ActivityResult ret = new Instrumentation.ActivityResult(Activity.RESULT_OK, resultData);
                resultData.setData(Uri.parse(path));
                return ret;

            });
            waitForIdle();
            onView(withText(R.string.create)).perform(click());
            onView(withText(filename)).check(matches(anything()));
            /*
            Action: click button to attach to drive 8.
            Expected result: Emulation is shown and running
             */
            onView(withText(R.string.IDMS_DRIVE_8)).perform(click());
            waitForActivity(EmulationActivity.class, 1, TimeUnit.SECONDS);
            onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
            /*
            Action: open menu
            Expected result: emulation is paused, button to detach image is visible, focusable and enabled.
             */
            onView(withId(R.id.ib_hamburger_menu)).perform(tap());
            waitForIdle();
            onView(withId(R.id.ib_handle_opened_files)).perform(click());
            onView(withText(R.string.detach_file)).check(matches(allOf(isDisplayed(), anyOf(not(instanceOf(Button.class)), isFocusable()), isEnabled())));
            onView(isRoot()).check(matches(not(isScreenUpdating())));
            /*
            Action: close menu
            Expected result: Emulation is running
             */
            pressBack();
            /*
            Action: show directory of created image
            Expected result: empty directory with disk name 8, id 17 and type 2a
             */
            onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
            type_load_directory(8);
            onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-dir-newdisk.pixelbuffer", 20, TimeUnit.SECONDS)));
            /*
            Action: detach file
            Expected result: Emulator is running
            */
            onView(withId(R.id.ib_hamburger_menu)).perform(tap());
            waitForIdle();
            onView(withId(R.id.ib_handle_opened_files)).perform(click());
            onView(withText(R.string.detach_file)).perform(click());
            Context ctx = InstrumentationRegistry.getInstrumentation().getTargetContext();
            onView(withText(R.string.IDMS_DRIVE_8)).perform(click());
            onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
            /*
            Action save a file to the disk image and leave the emulator
            Expected result: image file is modified.
             */
            byte[] olddigest = getDigest(path);
            openDocument(path);
            onView(withText(R.string.IDMS_DRIVE_8)).perform(click());
            onView(isC64Key("S")).perform(tap());
            onView(isC64Key("SHIFT")).perform(tap());
            onView(allOf(isDisplayed(), isC64Key("A"))).perform(tap());
            onView(isC64Key("SHIFT")).perform(tap());
            onView(isC64Key("2")).perform(tap());
            onView(isC64Key("T")).perform(tap());
            onView(isC64Key("SHIFT")).perform(tap());
            onView(isC64Key("2")).perform(tap());
            onView(allOf(isDisplayed(), isC64Key(","))).perform(tap());
            onView(isC64Key("8")).perform(tap());
            onView(isC64Key("RETURN")).perform(tap());
            onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-dir-newdisk-savedfile.pixelbuffer", 20, TimeUnit.SECONDS)));
            //cleanup();
            Thread.sleep(2000);
            waitForEmulationShutdown();
            cleanup();
            assertThat(olddigest, is(not((getDigest(path)))));
        } catch (IOException|NoSuchAlgorithmException|InterruptedException e) {
            throw new RuntimeException(e);
        } finally {
            File f = new File(path);
            if (f.exists()) {
                //noinspection ResultOfMethodCallIgnored
                f.delete();
            }
        }


    }


    @Test
    public void t_0500_create_tape_image() {
        final String timestamp = String.valueOf(System.currentTimeMillis());
        final String filename = "test-" + timestamp.substring(timestamp.length() - 10) + ".tap";
        final String path = InstrumentationRegistry.getInstrumentation().getTargetContext().getCacheDir()+"/" + filename;
        try {
            createAndAttachTapeImage(filename, path);
            /*
            Action: open menu
            Expected result: Emulation paused
             */
            onView(withId(R.id.ib_hamburger_menu)).perform(tap());
            waitForIdle();
            onView(isRoot()).check(matches(not(isScreenUpdating())));
            /*
            Action: choose Detach Image
            Expected result: Emulation paused, one menuitem to detach tape image
             */
            onView(withId(R.id.ib_handle_opened_files)).perform(click());
            onView(withText(R.string.detach_file)).perform(click());
            onView(withText(R.string.tape)).check(matches(isDisplayed()));

        }
        finally {
            File f = new File(path);
            if (f.exists()) {
                //noinspection ResultOfMethodCallIgnored
                f.delete();
            }
        }
    }

}