package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withText;

import static org.hamcrest.Matchers.allOf;

import androidx.test.platform.app.InstrumentationRegistry;

import org.junit.Test;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class SpeedSettingsTest extends C64EmulationTestBase{
    private void testSpeedSettings(String speed, int waitInMiliseconds) throws IOException {
        onView(withId(R.id.ib_hamburger_menu)).perform(click());
        onView(withText("100 %")).perform(click());
        waitForIdle();
        onView(allOf(isDisplayed(), withText(speed))).perform(click());
        openDocument(extractTestAsset("testprograms.d64"));
        onData(isOption("1SECINTERVAL")).inAdapterView(withId(R.id.lv_imagecontents))
                .check(matches(isDisplayed()))
                .perform(scrollTo())
                .perform(click());
        waitForIdle(waitInMiliseconds, TimeUnit.MILLISECONDS);

        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-5s-passed.pixelbuffer")));

    }
    @Test
    public void testSpeedSettings50() throws IOException {
        testSpeedSettings("50 %", 10_000);
    }
    @Test
    public void testSpeedSettings100() throws IOException {
        testSpeedSettings(
                InstrumentationRegistry.getInstrumentation().getTargetContext()
                        .getString(R.string.normal_speed),
                5_000);
    }
    @Test
    public void testSpeedSettings200() throws IOException {
        testSpeedSettings("200 %", 2_500);
    }
}
