package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.closeSoftKeyboard;
import static androidx.test.espresso.action.ViewActions.longClick;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.action.ViewActions.typeText;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.intent.Intents.intending;
import static androidx.test.espresso.intent.matcher.IntentMatchers.hasAction;
import static androidx.test.espresso.intent.matcher.IntentMatchers.hasData;
import static androidx.test.espresso.intent.matcher.IntentMatchers.hasExtraWithKey;
import static androidx.test.espresso.matcher.RootMatchers.isDialog;
import static androidx.test.espresso.matcher.RootMatchers.isPlatformPopup;
import static androidx.test.espresso.matcher.ViewMatchers.hasTextColor;
import static androidx.test.espresso.matcher.ViewMatchers.isChecked;
import static androidx.test.espresso.matcher.ViewMatchers.isDescendantOfA;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isEnabled;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withChild;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withParent;
import static androidx.test.espresso.matcher.ViewMatchers.withParentIndex;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.anyOf;
import static org.hamcrest.Matchers.containsString;
import static org.hamcrest.Matchers.instanceOf;
import static org.hamcrest.Matchers.not;

import static de.rainerhock.eightbitwonders.GameControllerJoystickTest.release;
import static de.rainerhock.eightbitwonders.GameControllerJoystickTest.setStickPosition;

import android.app.Activity;
import android.app.Instrumentation;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.RadioButton;

import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.action.GeneralClickAction;
import androidx.test.espresso.action.GeneralLocation;
import androidx.test.espresso.action.Press;
import androidx.test.espresso.action.Tap;
import androidx.test.espresso.action.ViewActions;
import androidx.test.espresso.intent.Intents;
import androidx.test.espresso.intent.matcher.IntentMatchers;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.rule.ActivityTestRule;
import androidx.test.uiautomator.UiDevice;

import junit.framework.AssertionFailedError;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;

public class ShareConfigurationTest extends MainActivityTestBase {
    private static final int ERROR_COLOR = android.R.color.holo_red_light;
    private final static String TWO_STICKS="_2_Sticks_";
    private static final String NO_KEYBOARD = "_NO_KEYBOARD_";
    private static final String FLIPLIST = "_FLIPLIST_";
    private final static String DIAGONALS="_DIAGONALS_";
    private static final String TIMEMACHINE = "_TIMEMACHINE SHRD_";
    private static final String SAVESTATES = "_SAVESTATES_";
    private static final String PADDLES = "_PADDLES_";
    private Matcher<View> hasControllerPortLabel(int resId) {
        String text = InstrumentationRegistry.getInstrumentation().getTargetContext().getString(resId);
        return withText(text.replace("Joystick in", "Controller in"));
        
    }
    @Test
    public void t_0010_joysticks() {
        // Prerequisite: no joysticks connected, no configuration named _TWO_STICKS_
        /*
        Action: launch C64 emulation
        Expected result: Emulation shown
         */
        waitForIdle(5, TimeUnit.SECONDS);
        onView(withText(TWO_STICKS)).check(doesNotExist());
        onView(withText("C64"))
                .perform(setJoysticksConnected(DpadJoystick.class, false))
                .perform(setJoysticksConnected(GameControllerJoystick.class, false))
                .perform(click());
        waitForIdle();
        /*
        Action: Open settings, choose touchscreen as joystick 1 and None as joystick 2, back to emulation
        Expected result: Emulation shown
         */
        waitForActivity(EmulationActivity.class, 2, TimeUnit.SECONDS);
        onView(withId(R.id.ib_hamburger_menu)).perform(click());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForActivity(SettingsActivity.class, 2, TimeUnit.SECONDS);
        onView(withText(R.string.joysticks)).perform(click());
        waitForIdle();
        onView(withTagValue(equalTo("port#1"))).perform(scrollTo()).perform(click());
        onData(isOption(R.string.virtual_touch_joystick)).perform(click());
        onView(withTagValue(equalTo("port#2"))).perform(scrollTo()).perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        onView(instanceOf(EmulationTestInterface.class))
                .check(matches(isDisplayed()))
                .check(matches(isScreenUpdating()));
        waitForIdle();
        /*
        Action: load Joysticktest from testprograms
        Expected result: 255 is shown
         */
        try {
            openDocument(extractTestAsset("testprograms.d64"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        onData(isOption("JOYSTICKTEST")).inAdapterView(withId(R.id.lv_imagecontents))
                .check(matches(isDisplayed()))
                .perform(click());
        waitForIdle();
        //onView(withId(R.id.imagecontents)).check(doesNotExist());
        waitForActivity(EmulationActivity.class, 10, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor))
                .check(matches(isDisplayed()))
                .check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 10, TimeUnit.SECONDS)));
        /*
        Action: touch joystick on the right side
        Expected result: 247 is shown
         */
        FingerState directionState = new FingerState();

        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.DOWN, directionState, 90, 50));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-right.pixelbuffer", 10, TimeUnit.SECONDS)));
        /*
        Action: remove finger from touch joystick
        Expected result: 255 is shown
         */
        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.UP, directionState, 90, 50));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 10, TimeUnit.SECONDS)));
        /*
        Action: tap the hamburger, choose menu item "Share"/"Teilen"
        Expected result: activity share is showing with:
        * Button "Share"/"Teilen" disabled
        * Edittexts are empty
        * Joystick in Port #1 "optional"
        * All other joysticks "unused"/"unbenutzt"
        * "Keyboard required"/"Tastatur benötigt" is checked
        * "Always show in landscape mode"/"Immer Querformat verwenden is not checked and disabled.
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(click());
        waitForIdle();
        onView(withId(R.id.bn_share_current_state)).perform(click());
        waitForIdle();
        onView(withText(R.string.share_and_save)).perform(click());
        waitForIdle();
        onView(withId(R.id.bn_share)).check(matches(not(isEnabled())));
        onView(withId(R.id.et_name)).check((matches(withText(""))));
        onView(withId(R.id.et_url)).check((matches(withText(""))));
        onView(withId(R.id.cb_share_useropts)).check(matches(isChecked()));
        onView(withText(R.string.keyboard_required)).check(matches(isChecked()));
        onView(allOf(instanceOf(RadioButton.class), withText(R.string.optional), withParent(withParent(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_1))))))
                .perform(scrollTo())
                .check(matches(isChecked()));
        onView(allOf(instanceOf(RadioButton.class), withText(R.string.unused), withParent(withParent(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_2))))))
                .perform(scrollTo())
                .check(matches(isChecked()));
        onView(allOf(instanceOf(RadioButton.class), withText(R.string.unused), withParent(withParent(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_EXTRA_PORT_1))))))
                .perform(scrollTo())
                .check(matches(isChecked()));
        onView(allOf(instanceOf(RadioButton.class), withText(R.string.unused), withParent(withParent(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_EXTRA_PORT_2))))))
                .perform(scrollTo())
                .check(matches(isChecked()));
        onView(withText(R.string.force_landscape))
                .perform(scrollTo())
                .check(matches(isDisplayed()));
        /*
        Action: type 1 character into Name
        Expected result: Button "Share"/"Teilen" is enabled.
         */
        onView(withId(R.id.et_name)).perform(scrollTo())
                .perform(typeText(TWO_STICKS.substring(0, 1)))
                .perform(closeSoftKeyboard());

        onView(withId(R.id.bn_share)).check(matches(isEnabled()));
        /*
        Action:
        set Website and make Joystick in Port 1 an Port 2 required, tap on share.
        Expected result: the shared configuration is immediately re-imported, a toast is shown to indicate this.
         */
        onView(withId(R.id.et_name)).perform(typeText(TWO_STICKS.substring(1)));
        onView(ViewMatchers.isRoot()).perform(closeSoftKeyboard());
        onView(withId(R.id.et_url)).perform(typeText("http://localhost"));
        onView(ViewMatchers.isRoot()).perform(closeSoftKeyboard());
        waitForIdle();
        onView(allOf(instanceOf(RadioButton.class), withText(R.string.required), withParent(withParent(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_1))))))
                .perform(scrollTo())
                .perform(click());
        onView(allOf(instanceOf(RadioButton.class), withText(R.string.required), withParent(withParent(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_2))))))
                .perform(scrollTo())
                .perform(click());
        onView(withId(R.id.cb_share_useropts)).perform(scrollTo()).perform(click());
        shareConfigurationPingPong(TWO_STICKS);
        onView(withId(R.id.bn_share)).perform(click());
        //checkForToast(InstrumentationRegistry.getInstrumentation().getTargetContext().getResources().getString(R.string.import_success, TWO_STICKS));
        /*
        Action: import configuration and go back
        Expected result: Emulation activity is shown, emulation running
         */
        onView(withId(R.id.tv_title))
                .check(matches(isDisplayed()))
                .check(matches(withText(TWO_STICKS)));
        onView(withId(R.id.bn_add)).perform(click());
        waitForIdle();
        pressBack();
        waitForIdle();
        onView(instanceOf(EmulationTestInterface.class))
                .check(matches(isDisplayed()))
                .check(matches(isScreenUpdating()));
        /*
        Action: press back
        Expected result: Dialog disappears
         */
        pressBack();
        waitForIdle();
        onView((withText(R.string.global_action_logout))).perform(click());
        waitForIdle();
        /*
        Action: launch created package
        Expected result: dialog is showing up, with:
        * "None"/"Kein" as Joystick for Port 1 and 2
        * no Option for DPAD-Joystick
        * Info "required"/"Notwendig" in red for both joystick ports.
         */
        //waitForIdle(10, TimeUnit.SECONDS);
        waitForActivity(MainActivity.class,2,TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(TWO_STICKS, click()));
        waitForIdle(5,TimeUnit.SECONDS);

        onView(allOf(instanceOf(RadioButton.class), withText(R.string.IDS_NONE), withParent(withParent(withChild(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_1)))))))
                .perform(scrollTo())
                .check(matches(isChecked()));
        onView(allOf(instanceOf(RadioButton.class), withText(new C64JoystickTestBase.UnitTestDpadJoystick().toString()), withParent(withParent(withChild(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_1))))))).check(doesNotExist());
        onView(allOf(instanceOf(RadioButton.class), withText(R.string.virtual_touch_joystick), withParent(withParent(withChild(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_1))))))).perform(scrollTo()).check(matches(not(isChecked())));
        onView(allOf(withText(R.string.required), withParent(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_1))))).check(matches(hasTextColor(ERROR_COLOR)));

        onView(allOf(instanceOf(RadioButton.class), hasControllerPortLabel(R.string.IDS_NONE), withParent(withParent(withChild(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_2)))))))
                .perform(scrollTo())
                .check(matches(isChecked()));
        onView(allOf(instanceOf(RadioButton.class), withText(new C64JoystickTestBase.UnitTestDpadJoystick().toString()), withParent(withParent(withChild(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_1))))))).check(doesNotExist());
        onView(allOf(instanceOf(RadioButton.class), withText(R.string.virtual_touch_joystick), withParent(withParent(withChild(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_2)))))))
                .perform(scrollTo())
                .check(matches(not(isChecked())));
        onView(allOf(withText(R.string.required), withParent(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_2))))).check(matches(hasTextColor(ERROR_COLOR)));
        waitForIdle();
        /*
        Action: Leave dialog and press back, confirm dialog.
        Expected result: Emulation activity is shown
         */
        pressBack();
        waitForIdle();
        onView(withId(R.id.gv_monitor))
                .check(matches(isDisplayed()))
                .check(matches(isScreenUpdating()));
        /*
        Action: press back
        Expected result: Dialog disappears
         */
        //pressBack();
        onView(withId(R.id.gv_monitor))
                .check(matches(isDisplayed()))
                .check(matches(isScreenUpdating()));
        waitForIdle();
        pressBack();
        onView((withText(R.string.global_action_logout))).perform(click());
        //onView((instanceOf(Button.class))).perform(click());
        waitForIdle();
        /*
        Action: launch created package
        Expected result: emulation is shown
        */
        waitForActivity(MainActivity.class, 2, TimeUnit.SECONDS);
        onView(withText(TWO_STICKS)).check(matches(isDisplayed()));
        onView(isRoot()).perform(createdTileAction(TWO_STICKS, click()));
        waitForIdle(5,TimeUnit.SECONDS);
        /*
        Action: choose Touchscreen joystick for Port 1
        Expected result: "Required"/"Notwendig" for Port 1 is not red anymore.
         */
        onView(allOf(instanceOf(RadioButton.class), withText(R.string.virtual_touch_joystick), withParent(withParent(withChild(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_1)))))))
                .perform(scrollTo())
                .check(matches(not(isChecked())))
                .perform(click())
                .check(matches(isChecked()));
        onView(allOf(withText(R.string.required), withParent(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_1))))).check(matches(not(hasTextColor(ERROR_COLOR))));
        /*
        Action: choose Touchscreen steering wheel / Touchscreen-Lenkrad for Port 2
        Expected results:
        * "Required"/"Notwendig" for Port 2 is not red anymore.
        * "Required"/"Notwendig" for Port 1 is red.
        * "None"/"Kein" is checked for Port 1
         */

        onView(allOf(instanceOf(RadioButton.class), withText(R.string.virtual_wheel_joystick), withParent(withParent(withChild(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_2)))))))
                .perform(scrollTo())
                .check(matches(not(isChecked())))
                .perform(click())
                .check(matches(isChecked()));
        onView(allOf(withText(R.string.required), withParent(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_2))))).check(matches(not(hasTextColor(ERROR_COLOR))));
        onView(allOf(withText(R.string.required), withParent(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_1))))).check(matches(hasTextColor(ERROR_COLOR)));
        onView(allOf(instanceOf(RadioButton.class), withText(R.string.virtual_touch_joystick), withParent(withParent(withChild(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_1)))))))
                .perform(scrollTo())
                .check(matches(not(isChecked())));
        /*
        Action: Tap on "Continue"/"Weiter"
        Expected result: Controls for virtual steering wheel are displayed.
         */
        onView(withText(R.string.apply)).perform(scrollTo()).perform(click());
        waitForIdle();
        onView(withId(R.id.jv_wheel)).check(matches(isDisplayed()));
        onView(withId(R.id.jv_flipswitch)).check(matches(isDisplayed()));
        /*
        Action: leave emulation
        Expected result: Main activity is shown
         */

        pressBack();
        onView((withText(R.string.global_action_logout))).perform(click());
        waitForIdle();
        /*
        Action: disconnect hardware DPAD-Joystick and launch created package
        Expected result: Dialog is shown with no entries for DPAD-Joystick
         */
        waitForActivity(MainActivity.class,2,TimeUnit.SECONDS);
        onView(isRoot())
                .perform(setJoysticksConnected(DpadJoystick.class, false))
                .perform(setJoysticksConnected(GameControllerJoystick.class, false))
                .perform(createdTileAction(TWO_STICKS, click()));
        waitForIdle(5, TimeUnit.SECONDS);
        onView(allOf(instanceOf(RadioButton.class), withText(R.string.IDS_NONE), withParent(withParent(withChild(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_1)))))))
                .perform(scrollTo())
                .check(matches(isChecked()));
        onView(allOf(withText(R.string.required), withParent(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_1)))))
                .perform(scrollTo())
                .check(matches(hasTextColor(ERROR_COLOR)));
        onView(allOf(instanceOf(RadioButton.class), withText(new C64JoystickTestBase.UnitTestDpadJoystick().toString()), withParent(withParent(withChild(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_1))))))).check(doesNotExist());

        onView(allOf(instanceOf(RadioButton.class), withText(R.string.virtual_wheel_joystick), withParent(withParent(withChild(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_2)))))))
                .perform(scrollTo())
                .check(matches(isChecked()));
        onView(allOf(withText(R.string.required), withParent(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_2)))))
                .perform(scrollTo())
                .check(matches(not(hasTextColor(ERROR_COLOR))));
        onView(allOf(instanceOf(RadioButton.class), withText(new C64JoystickTestBase.UnitTestDpadJoystick().toString()), withParent(withParent(withChild(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_2)))))))
                .check(doesNotExist());
        /*
        Action: connect hardware DPAD-Joystick
        Expected result: new entries for DPAD-Joystick are unchecked
         */

        onView(isRoot()).perform(setJoysticksConnected(DpadJoystick.class, true));
        waitForIdle();
        onView(allOf(instanceOf(RadioButton.class), withText(new C64JoystickTestBase.UnitTestDpadJoystick().toString()), withParent(withParent(withChild(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_2)))))))
                .perform(scrollTo())
                .check(matches(isDisplayed()))
                .check(matches(not(isChecked())));
        /*
        Action: disconnect hardware DPAD-Joystick
        Expected result: no entries for DPAD-Joystick

         */
        onView(isRoot()).perform(setJoysticksConnected(DpadJoystick.class, false));
        waitForIdle(1,TimeUnit.SECONDS);
        onView(allOf(instanceOf(RadioButton.class), withText(new C64JoystickTestBase.UnitTestDpadJoystick().toString()), withParent(withParent(withChild(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_2))))))).check(doesNotExist());
        onView(allOf(instanceOf(RadioButton.class), withText(R.string.IDS_NONE), withParent(withParent(withChild(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_1)))))))
                .perform(scrollTo())
                .check(matches(isChecked()));
        onView(allOf(withText(R.string.required), withParent(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_1)))))
                .perform(scrollTo())
                .check(matches(hasTextColor(ERROR_COLOR)));
        /*
        Action: connect hardware DPAD-Joystick and choose DPAD-Joystick for Port 1
        Expected result: "Required"/"Notwendig" for Port 1 is not red anymore.
         */
        onView(isRoot()).perform(setJoysticksConnected(DpadJoystick.class, true));
        waitForIdle(1,TimeUnit.SECONDS);
        onView(allOf(instanceOf(RadioButton.class), withText(new C64JoystickTestBase.UnitTestDpadJoystick().toString()), withParent(withParent(withChild(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_1)))))))
                .perform(scrollTo())
                .check(matches(isDisplayed()))
                .check(matches(not(isChecked())))
                .perform(click())
                .check(matches(isChecked()));
        onView(allOf(withText(R.string.required), withParent(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_1))))).check(matches(not(hasTextColor(ERROR_COLOR))));
        /*
        Action: tap on Continue/Weiter
        Expected result: emulation is shown
         */
        onView(withText(R.string.apply)).perform(scrollTo()).perform(click());
        onView(withId(R.id.gv_monitor)).check(matches(isScreenInitialized()));
        /*
        Action: Press back and confirm dialog
        Expected result: Main Activity is shown
         */
        pressBack();
        onView((withText(R.string.global_action_logout))).perform(click());
        waitForIdle();

        /*
        Action: launch created package
        Expected result: Emulation is shown without dialog.
         */
        waitForActivity(MainActivity.class, 2, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(TWO_STICKS, click()));
        waitForIdle();
        /*
        Action: Press Fire button
        Expected resul: 239 is displayed
         */
        onView(withId(R.id.gv_monitor))
                .perform(TestBase.pressDpadJoystickKey(KeyEvent.KEYCODE_BUTTON_A))
                .check(matches(showsBitmapEqualToAsset("screenshot-joystick-fire.pixelbuffer", 5, TimeUnit.SECONDS)));
        /*
        Action: Release Fire button
        Expected resul: 255 is displayed
         */
        onView(withId(R.id.gv_monitor)).perform(TestBase.releaseDpadJoystickKey(KeyEvent.KEYCODE_BUTTON_A));
        /*
        Action: Disconnect DPAD-Joystick
        Expected result: Dialog is shown with "Required"/"Notwendig" for Port 1 in Red
         */
        onView(withId(R.id.gv_monitor)).perform(setJoysticksConnected(DpadJoystick.class, false));
        waitForIdle(1,TimeUnit.SECONDS);
        onView(allOf(instanceOf(RadioButton.class), withText(R.string.IDS_NONE), withParent(withParent(withChild(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_1)))))))
                .perform(scrollTo())
                .check(matches(isChecked()));
        onView(allOf(withText(R.string.required), withParent(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_1)))))
                .perform(scrollTo())
                .check(matches(hasTextColor(ERROR_COLOR)));
        /*
        Action: Connect DPAD-Joystick
        Expected result: Dialog is disappearing.
         */
        onView(allOf(withText(R.string.required), withParent(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_1))))).perform(setJoysticksConnected(DpadJoystick.class, true));
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 5, TimeUnit.SECONDS)));
        /*
        Action: press back and confirm dialog
        Expected result: Main activity is shown.
         */
        waitForIdle();
        pressBack();
        onView((withText(R.string.global_action_logout))).perform(click());
        waitForIdle();
        /*
        Action: long click on created package and choose menu item "Website"/"Webseite"
        Expected result: Web site is shown
         */
        waitForActivity(MainActivity.class, 2, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(TWO_STICKS, longClick()));
        Intents.release();
        Intents.init();
        intending(allOf(IntentMatchers.hasAction(Intent.ACTION_VIEW), IntentMatchers.hasData("http://localhost"))).respondWith(new Instrumentation.ActivityResult(Activity.RESULT_OK, null));
        onView(withText(R.string.gotoweb)).perform(click());
        /*
        Action: long click on created package and choose menu item Start
        Expected result: Emulation is started.
         */
        waitForActivity(MainActivity.class, 2, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(TWO_STICKS, longClick()));
        onView(withText(R.string.IDMS_START)).perform(click());
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isScreenInitialized()));
        /*
        Action: press back and confirm dialog
        Expected result: Main activity is shown.
         */
        pressBack();
        onView((withText(R.string.global_action_logout))).perform(click());
        waitForIdle();
        /*
        Action: long click on created package and choose menu item "Uninstall"/"Deinstallieren"
        Expected result: Package is removed from activity.
         */
        waitForActivity(MainActivity.class, 2, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(TWO_STICKS, longClick()));
        waitForIdle();
        onView(withText(R.string.uninstall)).perform(click());
        waitForIdle();
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
        onView(withText(TWO_STICKS)).check(doesNotExist());
    }
    private void importConfiguration(File file) {
        setIntentCallback(file.getAbsolutePath());
        Intent i = new Intent();
        i.setData(Uri.fromFile(file));
        mActivityRule.launchActivity(i);

    }
    private void shareConfiguration(File file) {
        Intents.release();
        Intents.init();
        intending(anyOf(allOf(IntentMatchers.hasAction(Intent.ACTION_CHOOSER), hasExtraWithKey(Intent.EXTRA_INTENT)), hasAction(Intent.ACTION_SEND))).respondWithFunction(intent -> {
            Intent dataIntent;
            if (intent.getAction().equals(Intent.ACTION_SEND)) {
                dataIntent = intent;
            } else if (intent.getAction().equals(Intent.ACTION_CHOOSER)) {
                dataIntent = intent.getExtras().getParcelable(Intent.EXTRA_INTENT);
            } else {
                dataIntent = null;
            }
            if (dataIntent != null) {
                Uri uri = dataIntent.getClipData().getItemAt(0).getUri();
                Assert.assertNotNull(uri);
                try {
                    InputStream is = InstrumentationRegistry.getInstrumentation().getTargetContext().getContentResolver().openInputStream(uri);
                    byte[] data = new byte[is.available()];
                    is.read(data);
                    FileOutputStream fos = new FileOutputStream(file);
                    fos.write(data);
                    fos.close();
                    is.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return new Instrumentation.ActivityResult(Activity.RESULT_OK, null);
        });
    }
    private void shareConfigurationPingPong(String name) {
        Intents.release();
        Intents.init();
        intending(anyOf(allOf(IntentMatchers.hasAction(Intent.ACTION_CHOOSER), hasExtraWithKey(Intent.EXTRA_INTENT)), hasAction(Intent.ACTION_SEND))).respondWithFunction(intent -> {
            Intent dataIntent;
            if (intent.getAction().equals(Intent.ACTION_SEND)) {
                dataIntent = intent;
            } else if (intent.getAction().equals(Intent.ACTION_CHOOSER)) {
                dataIntent = intent.getExtras().getParcelable(Intent.EXTRA_INTENT);
            } else {
                dataIntent = null;
            }
            if (dataIntent != null) {
                Context ctx = InstrumentationRegistry.getInstrumentation().getTargetContext();
                String text = ctx.getString(R.string.use_8bw, ctx.getString(R.string.app_url));
                Uri uri = dataIntent.getClipData().getItemAt(0).getUri();
                Assert.assertNotNull(uri);
                Assert.assertEquals(dataIntent.getExtras().getString(Intent.EXTRA_TITLE),name);
                Assert.assertEquals(dataIntent.getExtras().getCharSequence(Intent.EXTRA_TEXT).toString(), text);
                Intent i = new Intent(ctx, ImportFileActivity.class);
                i.setData(uri);
                i.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                ctx.startActivity(i);
                return new Instrumentation.ActivityResult(Activity.RESULT_OK, null);
            }
            throw new AssertionFailedError("created intent "+intent+" does not match.");
        });
    }

    @Test
    public void t_0280_keyboard() {
        // Prerequisite: no hardware keyboard attached.
        // Prerequisite: no joysticks connected, no configuration named _TWO_STICKS_
        /*
        Action: launch C64 emulation
        Expected result: Emulation shown
         */
        //setKeyboardEnabled(false);
        onView(withText(NO_KEYBOARD)).check(doesNotExist());
        onView(withText("C64"))
                .perform(setHardwarekeyboardConnected(false))
                .perform(click());
        waitForIdle();
        /*
        Action: disable touch keyboard
        Expected result: keyboard not displayed.
        */
        onView(withId(R.id.ib_hamburger_menu)).perform(click());
        onView(withText(R.string.hide_keyboard)).perform(click());
        waitForIdle();
        onView(withId(R.id.keyboardview)).check(matches(not(isDisplayed())));
        /*
        Action:
        Action: tap the hamburger, choose menu item "Share"/"Teilen"
        Expected result: activity share is showing with:
        * keyboard required unchecked and
        * "Always show in landscape mode"/"Immer Querformat verwenden" enabled.
        */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withId(R.id.bn_share_current_state)).check(matches(isDisplayed())).perform(click());
        waitForIdle();
        onView(withText(R.string.share_and_save)).perform(click());
        waitForActivity(ShareEmulationActivity.class, 2, TimeUnit.SECONDS);
        onView(withId(R.id.cb_kbd_required))
                .check(matches(isEnabled()))
                .check(matches(not(isChecked())));
        onView(withId(R.id.cb_landscape))
                .check(matches(not(isChecked())))
                .check(matches(isEnabled()));
        /*
        Action: press back
        Expected result: Emulation is shown
         */
        onView(ViewMatchers.isRoot()).perform(closeSoftKeyboard());
        pressBack();
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        onView(isRoot()).check(matches(isScreenUpdating()));
        /*
        Action: connect hardware keyboard, tap the hamburger, choose menu item "Share"/"Teilen"
        Expected result: activity share is showing with:
        * keyboard required unchecked and
        * "Always show in landscape mode"/"Immer Querformat verwenden" enabled.
        */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withId(R.id.bn_share_current_state)).check(matches(isDisplayed())).perform(click());
        waitForIdle();
        onView(withText(R.string.share_and_save)).perform(click());
        waitForIdle();
        onView(withId(R.id.cb_kbd_required)).check(matches(isEnabled()));
        onView(withId(R.id.cb_kbd_required)).check(matches(not(isChecked())));
        onView(withId(R.id.cb_landscape)).check(matches(not(isChecked())));
        onView(withId(R.id.cb_landscape)).check(matches(isEnabled()));
        /*
        Action: press back
        Expected result: Emulation is shown
         */
        onView(ViewMatchers.isRoot()).perform(closeSoftKeyboard());
        pressBack();
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        onView(withId(R.id.screen))
                .perform(setHardwarekeyboardConnected(true))
                .perform(ViewActions.pressKey(KeyEvent.KEYCODE_1))
                .perform(ViewActions.pressKey(KeyEvent.KEYCODE_2))
                .perform(ViewActions.pressKey(KeyEvent.KEYCODE_3));

        /*
        Action: type some characters, tap the hamburger, choose menu item "Share"/"Teilen"
        Expected result: activity share is showing with:
        * "Keyboard required"/"Tastatur notwendig" checked and
        * "Always show in landscape mode"/"Immer Querformat verwenden" disabled.
        */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withId(R.id.bn_share_current_state)).check(matches(isDisplayed())).perform(click());
        waitForIdle();
        onView(withText(R.string.share_and_save)).perform(click());
        waitForIdle();

        onView(withId(R.id.cb_kbd_required))
                .perform(scrollTo())
                .check(matches(isDisplayed()))
                .check(matches(isChecked()));
        onView(withId(R.id.cb_landscape)).perform(scrollTo()).check(matches(isDisplayed()));

        /*
        Action: uncheck "Keyboard required"/"Tastatur notwendig"
        Expected result: "Always show in landscape mode"/"Immer Querformat verwenden" enabled
         */
        onView(withId(R.id.cb_kbd_required))
                .perform(scrollTo())
                .perform(click());
        onView(withId(R.id.cb_landscape))
                .perform(scrollTo())
                .check(matches(not(isChecked())))
                .check(matches(isEnabled()));

        /*
        Action: type in name, check Landscape mode and share
        Expected result: the shared configuration is immediately re-imported, a toast is shown to indicate this.
         */

        shareConfigurationPingPong(NO_KEYBOARD);
        onView(withId(R.id.cb_landscape))
                .perform(scrollTo())
                .perform(click());
        onView(withId(R.id.et_name))
                .perform(scrollTo())
                .perform(typeText(NO_KEYBOARD));
        onView(isRoot()).perform(closeSoftKeyboard());
        onView(withId(R.id.bn_share)).perform(click());
        waitForIdle();
        /*
        Action: import configuration and go back
        Expected result: Main activity is shown with the new activity
         */
        onView(withId(R.id.tv_title))
                .check(matches(isDisplayed()))
                .check(matches(withText(NO_KEYBOARD)));
        onView(withId(R.id.bn_add)).perform(click());
        waitForIdle();
        pressBack();
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        waitForIdle();
        pressBack();

        onView((withText(R.string.global_action_logout))).perform(click());
        waitForIdle();

        /*
        Action: launch created package
        Expected result: Emulation shown in landscape mode, no keyboard.
         */
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(NO_KEYBOARD, click()));
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.keyboardview))
                .check(matches(isInLandscapeMode()))
                .check(matches(not(isDisplayed())));
        /*
        Action: Open Menu
        Expected result: there is no menuitem to toggle keyboard
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.show_keyboard)).check(matches(not(isDisplayed())));
        onView(withText(R.string.hide_keyboard)).check(matches(not(isDisplayed())));

        pressBack();
        /*
        Action: Press back and confirm dialog
        Expected result: Main activity is shown with the new activity
         */
        waitForIdle();
        pressBack();
        onView((withText(R.string.global_action_logout))).perform(click());
        waitForIdle();
        /*
        Action: long click on created activity
        Expected result: there is no menu item to show a website.
         */
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(NO_KEYBOARD, longClick()));
        onView(withText(R.string.gotoweb)).check(doesNotExist());
         /*
        Action: choose menu item "Uninstall"/"Deinstallieren"
        Expected result: Package is removed from activity.
         */
        pressBack();
        waitForIdle();
        onView(isRoot()).perform(createdTileAction(NO_KEYBOARD, longClick()));
        waitForIdle();
        onView(withText(R.string.uninstall)).perform(scrollTo()).perform(click());
        waitForIdle();
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
    }
    @Test
    public void t_0420_fliplist() {
        // Prerequisite: no symbol named Fliplist
        onView(withText(FLIPLIST)).check(doesNotExist());
        /*
        Action: start C64
        Expected result: emulation is shown
         */
        onView(withText(R.string.name_c64)).perform(click());
        /*
        Action: attach disk image to drive 8, tap the hamburger, choose menu item "Share"/"Teilen"
        Expected result:
        * Share activity is shown with attached image shown
        * image cannot be removed
        * no other image visible

         */
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isScreenInitialized()));
        waitForIdle();
        try {
            openDocument(extractTestAsset("flipdisk 1.d64"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        onView(withText(R.string.IDMS_DRIVE_8)).perform(click());
        waitForIdle();
        onView(withId(R.id.ib_hamburger_menu)).perform(click());
        waitForIdle();
        onView(withId(R.id.bn_share_current_state)).check(matches(isDisplayed())).perform(click());
        waitForIdle();
        onView(withText(R.string.share_and_save)).perform(click());
        waitForIdle();
        onView(isRoot()).perform(closeSoftKeyboard());
        onView(withId(R.id.tl_additional_images)).perform(scrollTo());
        onView(allOf(withText("flipdisk 1.d64"), withParent(withParent(withId(R.id.tl_additional_images))))).check(matches(isDisplayed()));
        onView(allOf(withText(R.string.remove), instanceOf(Button.class), withParent(withChild(withText("flipdisk 1.d64"))))).check(matches(not(isDisplayed())));
        onView(allOf(withParentIndex(2), withParent(withId(R.id.tl_additional_images)))).check(doesNotExist());
        /*
        Action: add another image
        Expected result: image is shown and can be removed
         */
        try {
            setIntentCallback(extractTestAsset("testprograms.d64"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        onView(withId(R.id.bottom_anchor)).perform(scrollTo());
        waitForIdle(200, TimeUnit.MILLISECONDS);
        onView(withText(R.string.add)).perform(click());
        waitForIdle(200, TimeUnit.MILLISECONDS);
        onView(withId(R.id.tl_additional_images)).perform(scrollTo());
        onView(allOf(withText("flipdisk 1.d64"), withParent(withParent(withId(R.id.tl_additional_images))))).check(matches(isDisplayed()));
        onView(withId(R.id.bottom_anchor)).perform(scrollTo());
        waitForIdle(200, TimeUnit.MILLISECONDS);
        onView(allOf(withText(R.string.remove), instanceOf(Button.class), withParent(withChild(withText("flipdisk 1.d64"))))).check(matches(not(isDisplayed())));
        waitForIdle();
        onView(allOf(withText("testprograms.d64"), withParent(withParent(withId(R.id.tl_additional_images))))).check(matches(isDisplayed()));
        onView(allOf(withText(R.string.remove), instanceOf(Button.class), withParent(withChild(withText("testprograms.d64"))))).check(matches(isDisplayed()));
        onView(allOf(withParentIndex(2), withParent(withId(R.id.tl_additional_images)))).check(matches(isDisplayed()));
        onView(allOf(withParentIndex(3), withParent(withId(R.id.tl_additional_images)))).check(doesNotExist());
        /*
        Action: remove recently added image
        Expected result: image is removed from the list.
         */
        onView(allOf(withText(R.string.remove), instanceOf(Button.class), withParent(withChild(withText("testprograms.d64"))))).perform(click());
        onView(allOf(withParentIndex(2), withParent(withId(R.id.tl_additional_images)))).check(doesNotExist());
        /*
        Action: add another image
        Expected result: two images are in the list of required images.
         */
        try {
            setIntentCallback(extractTestAsset("flipdisk 2.d64"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        onView(withText(R.string.add)).perform(click());
        onView(withId(R.id.tl_additional_images)).perform(scrollTo());
        onView(allOf(withText("flipdisk 1.d64"), withParent(withParent(withId(R.id.tl_additional_images))))).check(matches(isDisplayed()));
        onView(allOf(withText("flipdisk 2.d64"), withParent(withParent(withId(R.id.tl_additional_images))))).check(matches(isDisplayed()));
        /*
        Action: type in name and click on "Share"/"Teilen"
        Expected result: activity offering importing or running is shown
         */
        onView(withId(R.id.et_name)).perform(scrollTo()).perform(typeText(FLIPLIST));
        onView(isRoot()).perform(closeSoftKeyboard());
        shareConfigurationPingPong(FLIPLIST);
        onView(withId(R.id.bn_share)).perform(click());
        waitForIdle();
        /*
        Action: import configuration and go back
        Expected result: Main activity is shown with the new activity
         */
        onView(withId(R.id.tv_title))
                .check(matches(isDisplayed()))
                .check(matches(withText(FLIPLIST)));
        onView(withId(R.id.bn_add)).perform(click());
        waitForIdle();
        pressBack();
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));

        /*
        Action: press back and confirm dialog
        Expected result: Main activity is shown.
         */
        waitForIdle();
        pressBack();
        onView((withText(R.string.global_action_logout))).perform(click());
        waitForIdle();
        /*
        Action: launch created package
        Expected result: emulation is shown
         */
        waitForActivity(MainActivity.class,5,TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(FLIPLIST, click()));
        waitForIdle();
        onView(withId(R.id.gv_monitor))
                .check(matches(isScreenInitialized()))
                .check(matches(isScreenUpdating()))
                .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 10, TimeUnit.SECONDS)));
        waitForIdle();

        /*
        Action: load directory from drive 8
        Expected result: contents of fliplist 1.d64 are displayed
         */
        type_load_directory(8);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-fliplist2-dir-loaded.pixelbuffer",10, TimeUnit.SECONDS)));
        onView(isC64Key("L")).perform(tap());
        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("I")).perform(tap());
        onView(isC64Key("RETURN")).perform(tap());
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-fliplist2-dir-listed.pixelbuffer",10, TimeUnit.SECONDS)));
        /*
        Action: open Image list
        Expected result: there is an image list with two entries fliplist 1.d64 and fliplist 2.d64
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withId(R.id.ib_handle_opened_files)).perform(click());
        onView(withText(R.string.flip_file)).perform(click());
        onView(withText("testprograms.d64")).check(doesNotExist());
        onView(withText("flipdisk 1.d64")).check(matches(not(isEnabled())));
        onView(withText("flipdisk 2.d64")).check(matches(isEnabled()));
        /*
        Action: assign flipdisk 2.d64 to drive 8 and load directory
        Expected result: directory is shown, there is a file flipdisk2
         */

        onView(withText("flipdisk 2.d64")).perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        type_load_directory(8);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-fliplist2-dir-5-loaded.pixelbuffer",10, TimeUnit.SECONDS)));
        onView(isC64Key("L")).perform(tap());
        onView(isC64Key("SHIFT")).perform(tap());
        onView(isC64Key("I")).perform(tap());
        onView(isC64Key("RETURN")).perform(tap());
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-fliplist2-dir-5-listed.pixelbuffer",10, TimeUnit.SECONDS)));
        /*
        Action: press back and confirm dialog
        Expected result: Main activity is shown.
         */
        waitForIdle();
        pressBack();
        onView((withText(R.string.global_action_logout))).perform(click());
        waitForIdle();
        /*
        Action: remove created package
        Expected result: there is no tile for the package.
         */
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(FLIPLIST, longClick()));
        waitForIdle();
        onView(withText(R.string.uninstall)).perform(click());
        waitForIdle();
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
        onView(withText(FLIPLIST)).check(doesNotExist());

    }



    /** @noinspection unused*/
    public void t_0580_joystick_diagonals() {
        // Prerequisite: no configuration named _DIAGONALS_
        /*
        Action: launch C64 emulation
        Expected result: Emulation shown
         */
        onView(withText(DIAGONALS)).check(doesNotExist());
        onView(withText("C64"))
                .perform(setJoysticksConnected(DpadJoystick.class, false))
                .perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isScreenInitialized()));
        /*
        Action: open settings, enable virtual touch joystick, disable diagonals
        Expected result: virtual touch controls are shown.
         */
        waitForActivity(EmulationActivity.class, 2, TimeUnit.SECONDS);
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        waitForIdle();
        onView(withTagValue(equalTo("port#1"))).perform(click());
        onData(isOption(R.string.virtual_touch_joystick)).perform(click());

        onView(withId(R.id.bn_apply)).perform(click());
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
        onView(withId(R.id.jv_directions)).check(matches(isDisplayed()));
        onView(withId(R.id.jv_fire)).check(matches(isDisplayed()));
        /*
        Action: tap the hamburger, choose share, type in name and click button "Share"/"Teilen"
        Expected result: the shared configuration is immediately re-imported, a toast is shown to indicate this.
         */

        onView(withId(R.id.ib_hamburger_menu)).perform(click());
        waitForIdle();
        onView(withId(R.id.bn_share_current_state)).check(matches(isDisplayed())).perform(click());
        waitForIdle();
        onView(withText(R.string.share_and_save)).inRoot(isPlatformPopup()).perform(click());
        waitForIdle();
        onView(withId(R.id.et_name)).perform(typeText(DIAGONALS));
        onView(isRoot()).perform(closeSoftKeyboard());
        shareConfigurationPingPong(DIAGONALS);
        onView(withId(R.id.bn_share)).perform(click());
        waitForIdle();
        onView(withId(R.id.tv_title))
                .check(matches(isDisplayed()))
                .check(matches(withText(DIAGONALS)));
        onView(withId(R.id.bn_add)).perform(click());
        waitForIdle();
        pressBack();
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));        /*
        Action: Leave dialog and press back, confirm dialog.
                Expected result: Main activity is shown
         */
        pressBack();
        waitForIdle();
        try {
            onView((withText(R.string.global_action_logout))).perform(click());
            // depending on the os we sometimes have to leave the share dialog by back key,
            // so no we are in the emualtion activity and have to quit it.
        } catch (NoMatchingViewException e) {
            onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
            pressBack();
            waitForIdle();
            onView((withText(R.string.global_action_logout))).perform(click());
        }
        waitForIdle();
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(DIAGONALS, click()));
        waitForIdle();
        onView(withId(R.id.ib_hamburger_menu)).perform(click());
        waitForIdle();
        /*
        Action: open settings
        Expected result: Option to use joystick diagonals is disabled and checked.

         */

        onView(withText(R.string.IDS_MP_SETTINGS))
                .check(matches(isDisplayed()))
                .perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        waitForIdle();

        pressBack();
        waitForIdle();
        pressBack();
        onView((withText(R.string.global_action_logout))).perform(click());
        waitForIdle();
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(DIAGONALS, longClick()));
        waitForIdle();
        onView(withText(R.string.uninstall)).perform(click());
        waitForIdle();
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
        onView(withText(DIAGONALS)).check(doesNotExist());
        onView(isRoot()).perform(createdTileAction("C64", click()));
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isScreenInitialized()));
        /*
        Action: open settings, enable virtual touch joystick, disable diagonals
        Expected result: virtual touch controls are shown.
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        waitForIdle();
   }
    @Test
    public void t_0620_timeshifted() {
        // Prerequisite: no configuration named _TIMESHIFTED_
        /*
        Action: launch C64 emulation
        Expected result: Emulation shown
         */
        onView(withText(TIMEMACHINE)).check(doesNotExist());
        onView(withText("C64"))
                .perform(setHardwarekeyboardConnected(false))
                .perform(click());
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isScreenInitialized()));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",10, TimeUnit.SECONDS)));
        /*
        Action: wait 7 seconds, type in BLERB, wait another 5 seconds
        Excpected result: BLERB is shown
         */
        waitForIdle(7, TimeUnit.SECONDS);
        onView(isC64Key("B")).perform(tap());
        onView(isC64Key("L")).perform(tap());
        onView(isC64Key("E")).perform(tap());
        onView(isC64Key("R")).perform(tap());
        onView(isC64Key("B")).perform(tap());
        onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating(2)));
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("screenshot-typed-blerb.pixelbuffer")));
        waitForIdle(5, TimeUnit.SECONDS);
        /*
        Action: wait another 5 seconds, type in more text
        Expected result: text is shown
         */
        onView(isC64Key("X")).perform(tap());
        onView(isC64Key("X")).perform(tap());
        onView(isC64Key("X")).perform(tap());
        onView(withId(R.id.gv_monitor))
                .check(matches(CoreMatchers.not(showsBitmapEqualToAsset("screenshot-typed-blerb.pixelbuffer"))));
        waitForIdle(5, TimeUnit.SECONDS);
        /*
        Action: share package
        Expected result: Activity is shown with a seekbar.
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withId(R.id.bn_share_current_state)).check(matches(isDisplayed())).perform(click());
        waitForIdle();
        onView(withText(R.string.share_and_save)).perform(click());
        waitForIdle();
        /*
        Action: slide seekbar to the right, type in name
        Expected result:
        - Configuration can be shared
        - Screenshot is with text "BLERB" only
         */
        onView(isRoot()).perform(closeSoftKeyboard());
        //noinspection deprecation
        onView(withId(R.id.sb_seekbar))
                .perform(scrollTo())
                .perform(new GeneralClickAction(Tap.SINGLE, GeneralLocation.CENTER_RIGHT, Press.PINPOINT));
        onView(withId(R.id.tv_time_offset)).check(matches(CoreMatchers.anyOf(withText(containsString("10.")),withText(containsString("10,")))));
        onView(withId(R.id.et_name))
                .perform(scrollTo())
                .perform(typeText(TIMEMACHINE));
        onView(isRoot()).perform(closeSoftKeyboard());
        /*
        Action:
        Share and re-import Configuration
        Expected result: Dialog disappears, Emulation is running.
         */
        shareConfigurationPingPong(TIMEMACHINE);
        onView(withId(R.id.bn_share)).perform(click());
        waitForIdle();
        onView(withId(R.id.tv_title))
                .check(matches(isDisplayed()))
                .check(matches(withText(TIMEMACHINE)));
        onView(withId(R.id.bn_add)).perform(click());
        waitForIdle();
        pressBack();
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        waitForIdle();
        onView(withId(R.id.gv_monitor))
                .check(matches(isDisplayed()))
                .check(matches(isScreenUpdating()));
        /*
        Action: leave emulation
        Expected result: Main activity is shown
         */
        pressBack();
        waitForIdle();
        onView((withText(R.string.global_action_logout))).perform(click());
        waitForIdle();
        /*
        Action: launch created package
        Expected result: emulation running and showing typed in text "blerb",
        but no the text typed in later
         */
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(TIMEMACHINE, click()));
        waitForIdle(5,TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-typed-blerb.pixelbuffer",10, TimeUnit.SECONDS)));
        pressBack();
        onView(withText(R.string.global_action_logout)).perform(click());
        waitForIdle(1, TimeUnit.SECONDS);
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(TIMEMACHINE, longClick()));
        waitForIdle();
        onView(withText(R.string.uninstall)).perform(click());
        waitForIdle();
        onView(withText(android.R.string.ok)).perform(click());
        waitForIdle();
        onView(withText(TIMEMACHINE)).check(doesNotExist());
   }
   @Test
   @PlaystoreTest
   @AppstoreTest
   public void t_0710_share_savestate() {
       onView(withText(SAVESTATES)).check(doesNotExist());
       onView(withText("C64")).perform(click());
       waitForIdle();
       onView(withId(R.id.gv_monitor))
               .check(matches(isScreenInitialized()))
               .check(matches(isScreenUpdating()))
               .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 10, TimeUnit.SECONDS)));
       waitForIdle();
       onView(withId(R.id.ib_hamburger_menu)).perform(tap());
       waitForIdle();
       onView(withText(R.string.savestates)).perform(click());
        /*
        Tap on hamburger, choose savestates from the menu, tap on tab 2
        Expected result: recentyl saved state is shown
         */
       onView(isSaveStateIndicator(1)).perform(click());
       onView(allOf(isDisplayed(), withId(R.id.bn_save)))
               .check(matches(isEnabled()))
               .perform(click());

       waitForIdle();
       onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
       onView(isC64Key("B")).perform(tap());
       onView(isC64Key("L")).perform(tap());
       onView(isC64Key("E")).perform(tap());
       onView(isC64Key("R")).perform(tap());
       onView(isC64Key("B")).perform(tap());
       onView(withId(R.id.gv_monitor))
               .check(matches(isScreenUpdating()))
               .check(matches(showsBitmapEqualToAsset("screenshot-typed-blerb.pixelbuffer", 10, TimeUnit.SECONDS)));
       onView(withId(R.id.ib_hamburger_menu)).perform(tap());
       waitForIdle();
       onView(withText(R.string.savestates)).perform(click());
        /*
        Tap on hamburger, choose savestates from the menu, tap on tab 2
        Expected result: recentyl saved state is shown
         */
       onView(isSaveStateIndicator(1)).perform(click());
       onView(allOf(isDisplayed(), withId(R.id.bn_more)))
               .check(matches(isEnabled()))
               .perform(click());
       onView(withText(R.string.share_and_save)).inRoot(isPlatformPopup()).perform(click());
       waitForIdle();
       onView(withId(R.id.et_name)).perform(scrollTo()).perform(typeText(SAVESTATES));
       onView(isRoot()).perform(closeSoftKeyboard());
       waitForIdle();
       shareConfigurationPingPong(SAVESTATES);
       onView(withId(R.id.bn_share)).perform(click());

       waitForIdle();
       onView(withId(R.id.tv_title))
               .check(matches(isDisplayed()))
               .check(matches(withText(SAVESTATES)));
       onView(withId(R.id.bn_add)).perform(click());
        waitForIdle();
       pressBack();
       waitForIdle();
       onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
       pressBack();
       onView((withText(R.string.global_action_logout))).perform(click());
       waitForIdle();
        /*
        Action: launch created package
        Expected result: Emulation is showing up with ready prompt, BLERB is not displayed
        * "None"/"Kein" as Joystick for Port 1 and 2
        * no Option for DPAD-Joystick
        * Info "required"/"Notwendig" in red for both joystick ports.
         */
       waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
       onView(isRoot()).perform(createdTileAction(SAVESTATES, click()));
       waitForIdle();
       onView(withId(R.id.gv_monitor))
               .check(matches(isScreenInitialized()))
               .check(matches(isScreenUpdating()))
               .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 10, TimeUnit.SECONDS)));
       pressBack();
       waitForIdle();
       onView((withText(R.string.global_action_logout))).perform(click());
       waitForIdle(1, TimeUnit.SECONDS);
       waitForActivity(MainActivity.class, 2, TimeUnit.SECONDS);
       onView(isRoot()).perform(createdTileAction(SAVESTATES, longClick()));
       waitForIdle();
       onView(withText(R.string.uninstall)).perform(click());
       waitForIdle();
       onView(withText(android.R.string.ok)).perform(click());
       waitForIdle();
       onView(withText(SAVESTATES)).check(doesNotExist());
  }
    /** @noinspection deprecation*/
    public ActivityTestRule<ImportFileActivity> mActivityRule =
            new ActivityTestRule<>(ImportFileActivity.class, false, false);


    @Test
    public void test_importing_and_running() throws IOException {
        onView(withText("plain-c64")).check(doesNotExist());
        Intent i = new Intent();
        i.setData(Uri.fromFile(new File(extractTestAsset("plain-c64.8bw"))));
        mActivityRule.launchActivity(i);
        waitForIdle();
        onView(withId(R.id.tv_title)).check(matches(withText("plain-c64")));
        onView(withId(R.id.iv_screenshot)).check(matches(isDisplayed()));
        onView(withId(R.id.bn_website)).check(matches(isDisplayed()));
        onView(withId(R.id.bn_run)).check(matches(isDisplayed()));
        onView(withId(R.id.bn_add)).check(matches(isDisplayed()));
        Intents.release();
        Intents.init();
        intending(allOf(hasAction(Intent.ACTION_VIEW),hasData("https://eightbitwonders.gitlab.io/app")))
            .respondWithFunction(intent -> new Instrumentation.ActivityResult(Activity.RESULT_OK, null));
        onView(withId(R.id.bn_website)).perform(click());
        onView(withId(R.id.bn_run)).perform(click());
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",5, TimeUnit.SECONDS)));
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForIdle();
        waitForActivity(ImportFileActivity.class, 2, TimeUnit.SECONDS);
        onView(withId(R.id.import_file)).check(matches(isDisplayed()));
        pressBack();

        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction(R.string.name_vic20, click()));
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-vic20.pixelbuffer", 5, TimeUnit.SECONDS)));
        waitForIdle(5, TimeUnit.SECONDS);
        pressBack();

        UiDevice.getInstance(InstrumentationRegistry.getInstrumentation()).pressHome();
        i = new Intent();
        i.setData(Uri.fromFile(new File(extractTestAsset("plain-c64.8bw"))));
        mActivityRule.launchActivity(i);
        onView(withId(R.id.bn_run)).perform(click());
        pressBack();
        onView(withId(R.id.bn_run)).perform(click());
        onView(withText(android.R.string.yes)).perform(click());
        waitForIdle(3, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)));

    }
  @Test
  public void test_importing_fail() throws IOException {
      onView(withText("plain-c64")).check(doesNotExist());
      Intent i = new Intent();
      i.setData(Uri.fromFile(new File(extractTestAsset("kaputt.8bw"))));
      mActivityRule.launchActivity(i);
      waitForIdle();
      onView(withText(R.string.importfile)).inRoot(isDialog()).check(matches(isDisplayed()));

  }
  private static final String WITH_SAVESTATE = "_WITH_SAVESTATE_";
  @Test
  public void test_savestates() {
      onView(withText(WITH_SAVESTATE)).check(doesNotExist());
      onView(withText("C64"))
              .perform(setJoysticksConnected(DpadJoystick.class, false))
              .perform(setJoysticksConnected(GameControllerJoystick.class, false))
              .perform(click());
      waitForIdle();
        /*
        Action: Open settings, choose touchscreen as joystick 1 and None as joystick 2, back to emulation
        Expected result: Emulation shown
         */
      waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
      onView(withId(R.id.gv_monitor))
              .check(matches(isScreenInitialized()))
              .check(matches(isScreenUpdating()))
              .check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 10, TimeUnit.SECONDS)))
              .check(matches(isScreenUpdating()));
      waitForIdle();

      onView(isC64Key("B")).perform(tap());
      onView(isC64Key("L")).perform(tap());
      onView(isC64Key("E")).perform(tap());
      onView(isC64Key("R")).perform(tap());
      onView(isC64Key("B")).perform(tap());

      onView(withId(R.id.ib_hamburger_menu)).perform(tap());
      waitForIdle();
      onView(withText(R.string.savestates)).perform(click());
        /*
        Tap on hamburger, choose savestates from the menu, tap on tab 2
        Expected result: recentyl saved state is shown
         */
      onView(isSaveStateIndicator(1)).perform(click());
      waitForIdle();
      onView(allOf(isDisplayed(), withId(R.id.bn_save))).perform(click());
      waitForIdle();
      onView(withId(R.id.ib_hamburger_menu)).perform(tap());
      waitForIdle();
      onView(withText(R.string.savestates)).perform(click());
        /*
        Tap on hamburger, choose savestates from the menu, tap on tab 2
        Expected result: recentyl saved state is shown
         */
      onView(isSaveStateIndicator(1)).perform(click());
      waitForIdle();
      onView(allOf(isDisplayed(), withId(R.id.bn_more)))
              .check(matches(isEnabled()))
              .perform(click());
      waitForIdle();
      onView(withText(R.string.share_and_save)).inRoot(isPlatformPopup()).perform(click());
      waitForIdle();
      onView(withId(R.id.bn_share)).check(matches(not(isEnabled())));
      onView(withId(R.id.et_name))
              .perform(typeText(WITH_SAVESTATE))
              .perform(closeSoftKeyboard());
      onView(withId(R.id.cb_share_savestates))
              .check(matches(not(isChecked())))
              .perform(scrollTo()).perform(click());
      shareConfigurationPingPong(WITH_SAVESTATE);
      onView(withId(R.id.bn_share)).perform(click());
      waitForIdle();
      onView(withId(R.id.bn_add)).perform(click());
      waitForIdle(1, TimeUnit.SECONDS);
      pressBack();
      waitForIdle();
      pressBack();
      onView(withText(R.string.quit)).perform(click());
      waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
      onView(withText(WITH_SAVESTATE)).perform(scrollTo()).perform(click());
      waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
      onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-typed-blerb.pixelbuffer", 5, TimeUnit.SECONDS)));
      for (int i = 0; i < 5;i++) {
          onView(isC64Key("DEL")).perform(tap());
      }
      onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS)));
      onView(withId(R.id.ib_hamburger_menu)).perform(tap());
      waitForIdle();
      onView(withText(R.string.savestates)).perform(click());
        /*
        Tap on hamburger, choose savestates from the menu, tap on tab 2
        Expected result: recentyl saved state is shown
         */
      onView(isSaveStateIndicator(1)).perform(click());
      waitForIdle();
      onView(allOf(isDisplayed(), withId(R.id.bn_start)))
              .check(matches(isEnabled()))
              .perform(click());
      waitForIdle(3, TimeUnit.SECONDS);
      onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-typed-blerb.pixelbuffer", 5, TimeUnit.SECONDS)));
      pressBack();
      onView(withText(R.string.quit)).perform(click());
      waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
      onView(isRoot()).perform(createdTileAction(WITH_SAVESTATE, longClick()));
      waitForIdle(1, TimeUnit.SECONDS);
      onView(withText(R.string.uninstall)).perform(click());
      waitForIdle();
      onView(withText(R.string.delete_useropts)).perform(click());
      onView(withText(android.R.string.ok)).perform(click());
      waitForIdle();
      onView(withId(R.id.preinstalled)).check(matches(isDisplayed()));
      onView(withText(WITH_SAVESTATE)).check(doesNotExist());

  }
  private final static String PLAIN_C64 ="plain-c64";
  private void testExportImportFromMainActivityVariant(Runnable runSetOptions,
                                                       Runnable runTestScreencontent,
                                                       Runnable runCreateSavestate,
                                                       Runnable runTestSavestate) throws IOException {
      setIntentCallback(extractTestAsset("plain-c64.8bw"));
      onView(withText(PLAIN_C64)).check(doesNotExist());
      onView(isContentSourceViewWithTitle(InstrumentationRegistry.getInstrumentation().getTargetContext().getResources().getString(R.string.import_local_content)))
              .perform(scrollTo())
              .perform(click());

      waitForIdle();
      onView(isRoot()).perform(createdTileAction(PLAIN_C64,click()));
      waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
      onView(withId(R.id.ib_hamburger_menu)).perform(click());
      waitForIdle();
      onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
      waitForIdle();
      onView(withId(R.id.gh_vic_ii_settings)).perform(click());
      waitForIdle();
      onView(allOf(withText(R.string.IDS_NONE), withParent(withTagValue(equalTo("VICIIBorderMode"))))).perform(click());
      onView(withId(R.id.bn_apply)).perform(click());
      waitForActivity(EmulationActivity.class, 2, TimeUnit.SECONDS);
      onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-borderless.pixelbuffer", 5, TimeUnit.SECONDS)));
      runCreateSavestate.run();
      pressBack();
      onView(withText(R.string.quit)).perform(click());
      waitForActivity(MainActivity.class,2,TimeUnit.SECONDS);
      onView(isRoot()).perform(createdTileAction(PLAIN_C64,click()));
      waitForActivity(EmulationActivity.class, 2, TimeUnit.SECONDS);
      onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-borderless.pixelbuffer", 5, TimeUnit.SECONDS)));
      pressBack();
      onView(withText(R.string.quit)).perform(click());
      waitForActivity(MainActivity.class,2,TimeUnit.SECONDS);
      onView(isRoot()).perform(createdTileAction(PLAIN_C64, longClick()));
      waitForIdle();
      onView(withText(R.string.share_and_save)).perform(click());
      runSetOptions.run();
      waitForIdle(1, TimeUnit.SECONDS);
      File tmpFile = File.createTempFile("_tmp_",".8bw");
      shareConfiguration(tmpFile);
      onView(withText(R.string.share_and_save)).perform(click());
      Useropts.deleteNow(InstrumentationRegistry.getInstrumentation().getTargetContext(), "C64", "7ab140d6-f369-4346-b2a5-2b5256382391");
      importConfiguration(tmpFile);
      tmpFile.delete();
      waitForIdle();
      onView(withId(R.id.bn_add)).perform(click());
      pressBack();
      new ActivityTestRule<>(MainActivity.class, false, false).launchActivity(null);
      waitForActivity(MainActivity.class, 2, TimeUnit.SECONDS);
      onView(isRoot()).perform(createdTileAction(PLAIN_C64, click()));
      waitForActivity(EmulationActivity.class, 2, TimeUnit.SECONDS);
      runTestScreencontent.run();
      runTestSavestate.run();
      pressBack();
      onView(withText(R.string.quit)).perform(click());
      waitForActivity(MainActivity.class,2,TimeUnit.SECONDS);

      onView(isRoot()).perform(createdTileAction(PLAIN_C64, longClick()));

      onView(withText(R.string.uninstall)).perform(click());
      onView(withText(R.string.delete_useropts)).perform(click());
      onView(withText(android.R.string.ok)).perform(click());
      waitForIdle();
      onView(withText(PLAIN_C64)).check(doesNotExist());
  }
  @Test
  public void testMainActivityUseropts() throws IOException {
      testExportImportFromMainActivityVariant(
              () -> {
                  onView(withText(R.string.share_savestates)).check(doesNotExist());
                  onView(withText(R.string.share_useropts)).check(matches(isDisplayed())).check(matches(isChecked()));
              },
              () -> onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-borderless.pixelbuffer", 5, TimeUnit.SECONDS))),
              () -> { },
              () -> { });
  }
  @Test
  public void testMainActivity() throws IOException {
      testExportImportFromMainActivityVariant(
              () -> onView(withText(R.string.share_useropts)).check(matches(isDisplayed())).check(matches(isChecked())).perform(click()).check(matches(not(isChecked()))),
              () -> onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS))),
              () -> { },
              () -> {
                  onView(withId(R.id.ib_hamburger_menu)).perform(tap());
                  waitForIdle();
                  onView(withText(R.string.savestates)).perform(click());
                  onView(isSaveStateIndicator(1)).perform(click());
                  waitForIdle();
                  onView(allOf(isDisplayed(), withId(R.id.bn_start))).check(doesNotExist());
                  pressBack();
                  waitForIdle();

              });

  }
  @Test
  public void testMainActivityScreenshot() throws IOException {
      testExportImportFromMainActivityVariant(
              () -> onView(withText(R.string.share_useropts)).check(matches(isDisplayed())).check(matches(isChecked())).perform(click()).check(matches(not(isChecked()))),
              () -> onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 5, TimeUnit.SECONDS))),
              () -> {
                  onView(withId(R.id.ib_hamburger_menu)).perform(tap());
                  waitForIdle();
                  onView(withText(R.string.savestates)).perform(click());
                  onView(isSaveStateIndicator(1)).perform(click());
                  waitForIdle();
                  onView(allOf(isDisplayed(), withId(R.id.bn_save))).perform(click());

                  waitForIdle();
              },
              () -> {
                  onView(withId(R.id.ib_hamburger_menu)).perform(tap());
                  waitForIdle();
                  onView(withText(R.string.savestates)).perform(click());
                  onView(isSaveStateIndicator(1)).perform(click());
                  waitForIdle();
                  onView(allOf(isDisplayed(), withId(R.id.bn_start))).check(matches(isEnabled()));
                  pressBack();
                  waitForIdle();

              });
    }
    private Matcher<View> getRadiobutton(final Matcher<View> buttonMatcher, final Matcher<View> parentMatcher) {
        return allOf(instanceOf(RadioButton.class), buttonMatcher, withParent(withParent(withChild(withChild(parentMatcher)))));

    }
    @Test
    public void test_paddles() {
        // Prerequisite: no joysticks connected, no configuration named _PADDLES_
        /*
        Action: launch C64 emulation
        Expected result: Emulation shown
         */
        waitForActivity(MainActivity.class);
        onView(withText(PADDLES)).check(doesNotExist());
        onView(withText("C64"))
                .perform(setJoysticksConnected(DpadJoystick.class, true))
                .perform(setJoysticksConnected(GameControllerJoystick.class, true))
                .perform(click());
        waitForIdle();
        waitForActivity(EmulationActivity.class, 2, TimeUnit.SECONDS);
        /* Actions:
        - open settings
        - use left gamecontroller analog stick for port 1
        - use right gamecontroller analog stick for port 2
        - use both as paddles
        - save settings
        Expected result: emulation running
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(click());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForActivity(SettingsActivity.class, 2, TimeUnit.SECONDS);
        onView(withText(R.string.joysticks)).perform(click());
        waitForIdle();
        onView(withTagValue(equalTo("port#1"))).perform(scrollTo()).perform(click());
        onData(isOption(String.format("%s (%s)", FAKE_GAMECONTROLLER_DEVICEID, InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.left_stick)))).perform(click());
        onView(allOf(isDescendantOfA(withChild(withTagValue(equalTo("port#1")))),withId(R.id.sp_typeselector)))
                .perform(scrollTo())
                .perform(click());
        onView(withText(R.string.paddle)).perform(click());
        onView(withId(R.id.sw_enable_extended_joysticks)).perform(scrollTo());
        onView(withTagValue(equalTo("port#2"))).perform(scrollTo()).perform(click());
        onData(isOption(String.format("%s (%s)", FAKE_GAMECONTROLLER_DEVICEID, InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.right_stick))))
                .perform(scrollTo())
                .perform(click());
        onView(allOf(isDescendantOfA(withChild(withTagValue(equalTo("port#2")))),withId(R.id.sp_typeselector)))
                .perform(scrollTo())
                .perform(click());
        onView(withText(R.string.paddle)).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForActivity(EmulationActivity.class);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer", 10, TimeUnit.SECONDS)));
        /*
        Action: tap the hamburger, choose menu item "Share"/"Teilen"
        Expected result: activity share is showing with infobox about analog controllers
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(click());
        waitForIdle();
        onView(withId(R.id.bn_share_current_state)).perform(click());
        waitForIdle();
        onView(withText(R.string.share_and_save)).perform(click());
        waitForActivity(ShareEmulationActivity.class);
        onView(withId(R.id.tv_warn_analog_input)).check(matches(isDisplayed()));
        /*
        Action:
        set Website and make Joystick in Port 1 an Port 2 required, tap on share.
        Expected result: the shared configuration is immediately re-imported, a toast is shown to indicate this.
         */
        onView(withId(R.id.et_name)).perform(typeText(PADDLES));
        onView(ViewMatchers.isRoot()).perform(closeSoftKeyboard());
        onView(withId(R.id.et_url)).perform(typeText("http://localhost"));
        onView(ViewMatchers.isRoot()).perform(closeSoftKeyboard());
        waitForIdle();
        onView(allOf(instanceOf(RadioButton.class),
                withText(R.string.required),
                withParent(withParent(withChild(hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_1))))))
                .perform(scrollTo())
                .perform(click());
        shareConfigurationPingPong(PADDLES);
        onView(withId(R.id.bn_share)).perform(click());
        onView(withId(R.id.bn_run)).perform(click());
        waitForIdle();
        onView(withText(android.R.string.ok))
                .check(matches(isDisplayed()))
                .perform(click());
        waitForIdle();
        waitForActivity(EmulationActivity.class);
        onView(getRadiobutton(withText(R.string.IDS_NONE), hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_1))).check(matches(isChecked()));
        onView(getRadiobutton(withText(String.format("%s (%s)", FAKE_GAMECONTROLLER_DEVICEID, InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.left_stick))), hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_1))).check(matches(isDisplayed()));
        onView(getRadiobutton(withText(String.format("%s (%s)", FAKE_GAMECONTROLLER_DEVICEID, InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.right_stick))), hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_1))).check(matches(isDisplayed()));
        onView(getRadiobutton(withText(String.format("%s (%s)", FAKE_GAMECONTROLLER_DEVICEID, InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.dpad))), hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_1))).check(doesNotExist());
        onView(getRadiobutton(withText(String.format("%s (%s)", FAKE_GAMECONTROLLER_DEVICEID, InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.left_stick))), hasControllerPortLabel(R.string.IDS_JOYSTICK_IN_PORT_1))).perform(click());
        onView(withText(R.string.apply)).perform(click());
        waitForIdle();
        run_program("MOUSE", "screenshot-paddle-top-left.pixelbuffer");
        GameControllerJoystickTest.JoystickState state = new GameControllerJoystickTest.JoystickState();
        onView(withId(R.id.gv_monitor))
                .perform(setStickPosition(state, 1f, 1f));
        waitForIdle(5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("screenshot-paddle-bottom-right.pixelbuffer", 10, TimeUnit.SECONDS)))
                .perform(release(state));

        //waitForIdle(1, TimeUnit.HOURS);
    }
}
