package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withParent;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;
import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.equalTo;

import android.content.Context;

import org.junit.Test;

import java.util.concurrent.TimeUnit;

public class Plus4SettingsTest extends EmulationTestBase{
    @Override
    protected EmulationConfiguration getConfiguration(Context context) {
        return new ConfigurationFactory.MachineConfiguration(context, "PLUS4");

    }

    @Test
    public void t_0020_ntsc_mode()  {
        /*
        Action:
        Start VIC Emulation
        Expected result:
        Showing up in PAL mode
         */
        waitForIdle(3, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-plus4.pixelbuffer",2,TimeUnit.SECONDS)));
        /*
        Action:
        tap the hamburger, open settings, open VIC section, switch to ntsc mode, go back
        Expected result:
        Showing up in NTSC mode
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForActivity(SettingsActivity.class);
        onView(withId(R.id.ted_settings)).perform(click());
        waitForIdle();
        onView(allOf(withParent(withTagValue(equalTo("TEDBorderMode"))),withTagValue(equalTo("3"))))
                .perform(scrollTo())
                .perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-plus4-noborder.pixeldata",5,TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating()));

    }
    @Test
    public void t_0050_ted_settings() throws InterruptedException {
        /*
        Action:
        Start VIC Emulation, type Text BLERB
        Expected result:
        Showing up with borders, BLERB is shown
         */
        waitForIdle(3, TimeUnit.SECONDS);
        onView(isC64Key("B")).perform(tap());
        onView(isC64Key("L")).perform(tap());
        onView(isC64Key("E")).perform(tap());
        onView(isC64Key("R")).perform(tap());
        onView(isC64Key("B")).perform(tap());
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-plus4-typed-blerb.pixelbuffer",2,TimeUnit.SECONDS)));
        /*
        Action:
        tap the hamburger, open settings, open video section, disable borders, go back
        Expected result:
        Borders gone, but BLERB is still there
         */

        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        onView(withId(R.id.ted_settings)).perform(click());
        onView(allOf(withParent(withTagValue(equalTo("TEDBorderMode"))),withTagValue(equalTo("3")))).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        onView(withId(R.id.gv_monitor))
                .check(matches(showsBitmapEqualToAsset("screenshot-plus4-typed-blerb-borderless.pixelbuffer", 1, TimeUnit.SECONDS)))
                .check(matches(isScreenUpdating()));

    }
}
