package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withText;

import androidx.test.espresso.NoMatchingViewException;

import org.junit.Test;

import java.util.concurrent.TimeUnit;


public class PlaystoreAgeVerificationTest extends AgeVerificationTest {
    @Test
    @SpecialTest
    @PlaystoreTest
    public void testPlaystore() {
        prepare();
        AgeVerificationProviderImpl.setFakeAgeSignalsManager(AgeVerificationProviderImpl.getFakeVerifiedUser());
        onView(withText(R.string.name_c64)).perform(scrollTo()).perform(click());
        waitForActivity(EmulationActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        AgeVerificationProviderImpl.setFakeAgeSignalsManager(AgeVerificationProviderImpl.getFakeSupervisedUser());
        onView(withText(R.string.name_c64)).perform(scrollTo()).perform(click());
        waitForActivity(EmulationActivity.class, 2, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        pressBack();
        onView(withText(R.string.quit)).perform(click());

        AgeVerificationProviderImpl.setFakeAgeSignalsManager(AgeVerificationProviderImpl.getNotAffectedUser());
        onView(withText(R.string.name_c64)).perform(scrollTo()).perform(click());
        waitForActivity(EmulationActivity.class, 2, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        pressBack();
        onView(withText(R.string.quit)).perform(click());


        AgeVerificationProviderImpl.setFakeAgeSignalsManager(AgeVerificationProviderImpl.getPendingChangesUser());
        onView(withText(R.string.name_c64)).perform(scrollTo()).perform(click());
        onView(withText(R.string.supervised_approval_pending)).check(matches(isDisplayed()));
        onView(withText(R.string.ok)).perform(click());
        onView(withText(R.string.name_c64)).check(matches(isDisplayed()));
        onView(withId(R.id.gv_monitor)).check(doesNotExist());

        AgeVerificationProviderImpl.setFakeAgeSignalsManager(AgeVerificationProviderImpl.getDeniedAccessUser());
        onView(withText(R.string.name_c64)).perform(scrollTo()).perform(click());
        onView(withText(R.string.supervised_approval_denied)).check(matches(isDisplayed()));
        onView(withText(R.string.ok)).perform(click());
        onView(withText(R.string.name_c64)).check(matches(isDisplayed()));
        onView(withId(R.id.gv_monitor)).check(doesNotExist());

        AgeVerificationProviderImpl.setFakeAgeSignalsManager(AgeVerificationProviderImpl.getUnknownUser());
        onView(withText(R.string.name_c64)).perform(scrollTo()).perform(click());
        onView(withText(R.string.unknown_user_pls)).check(matches(isDisplayed()));
        onView(withText(R.string.ok)).perform(click());
        onView(withText(R.string.name_c64)).check(matches(isDisplayed()));
        onView(withId(R.id.gv_monitor)).check(doesNotExist());
    }
}
