package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.hasSibling;
import static androidx.test.espresso.matcher.ViewMatchers.isChecked;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isEnabled;
import static androidx.test.espresso.matcher.ViewMatchers.withEffectiveVisibility;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withText;

import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.instanceOf;
import static org.hamcrest.Matchers.not;

import android.view.View;
import android.widget.SeekBar;

import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.matcher.ViewMatchers;

import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Test;

import java.util.Arrays;
import java.util.List;

public class OpenGlSettingsTest extends MainActivityTestBase {
    private static Matcher<View> withProgress(final int progress) {
        return new BaseMatcher<View>() {
            @Override
            public void describeMismatch(Object item, Description description) {
                description.appendValue("Expected progress "+ progress +", got "
                + ((SeekBar) item).getProgress());
            }

            @Override
            public void describeTo(Description description) {
                description.appendValue("Check SeekBar for progress " + progress);
            }

            @Override
            public boolean matches(Object item) {
                if (item instanceof SeekBar) {
                    return ((SeekBar) item).getProgress() == progress;
                }
                return false;
            }
        };
    }
    private static ViewAction setProgress(final int progress) {
        return new ViewAction() {
            @Override
            public void perform(UiController uiController, View view) {
                SeekBar seekBar = (SeekBar) view;
                seekBar.setProgress(progress);
            }
            @Override
            public String getDescription() {
                return "Set a progress on a SeekBar";
            }
            @Override
            public Matcher<View> getConstraints() {
                return ViewMatchers.isAssignableFrom(SeekBar.class);
            }
        };
    }
    @Test
    public void openglsettingstest() {
        /*
        Action: start emulation, open settings and video section
        Expected result: "Filter" is displayed.
         */
        onView(withText(R.string.name_c64)).perform(click());
        waitForActivity(EmulationActivity.class);
        onView(withId(R.id.ib_hamburger_menu))
                .check(matches(isDisplayed()))
                .perform(click());
        onView(withText(R.string.IDMS_SETTINGS)).perform(click());
        waitForIdle();
        onView(allOf(isDisplayed(), withText(R.string.video))).perform(click());
        waitForIdle();
        onView(withId(R.id.sp_filter)).check(matches(withEffectiveVisibility(ViewMatchers.Visibility.VISIBLE)));
        /*
        Action: set "Filter" to none
        Expected result: no options displayed
         */
        onView(withId(R.id.sp_filter)).perform(scrollTo()).perform(click());
        onData(isOption(R.string.shader_passthrough)).perform(click());
        waitForIdle();
        onView(withText(R.string.use_global_settings)).check(matches(not(isDisplayed())));
        onView(withId(R.id.sw_preview)).check(matches(not(isDisplayed())));
        /*
        Action: choose CRT emulation as filter
        Expectred results:
        - Checkbox "use global settings" is visible and checked
        - CRT related seekbars are visible and disabled
        - buttons are disabled
         */
        onView(withId(R.id.sp_filter)).perform(scrollTo()).perform(click());
        onData(isOption(R.string.shader_crt_emulation)).perform(click());

        onView(withText(R.string.use_global_settings))
                .perform(scrollTo())
                .check(matches(isChecked()));
        onView(withId(R.id.sw_preview))
                .check(matches(isDisplayed()))
                .check(matches(isChecked()));
        onView(withId(R.id.gv_preview)).check(matches(isDisplayed()));
        onView(withId(R.id.sw_preview)).perform(click());
        onView(withId(R.id.gv_preview)).check(matches(not(isDisplayed())));
        onView(withId(R.id.sw_preview)).perform(click());
        onView(withId(R.id.gv_preview)).check(matches(isDisplayed()));
        List<Integer> params = Arrays.asList(R.string.gl_u_curvature, R.string.gl_u_scanlineintensity,
                R.string.gl_u_vignettestrength, R.string.gl_u_phosphorglow, R.string.gl_u_noise);
        for (int id : params) {
            onView(allOf(instanceOf(SeekBar.class), hasSibling(withText(id))))
                    .perform(scrollTo())
                    .check(matches(not(isEnabled())));
        }
        onView(withText(R.string.read_from_globals)).check(matches(not(isEnabled())));
        onView(withText(R.string.write_to_globals)).check(matches(not(isEnabled())));
        onView(withText(R.string.reset_defaults)).check(matches(not(isEnabled())));
        /*
        Action: disable usage of global options
        Expected results:
        - Seekbars are enabled
        - Buttons are still disabled
         */
        onView(withText(R.string.use_global_settings))
                .perform(click())
                .check(matches(not(isChecked())));
        for (int id : params) {
            onView(allOf(instanceOf(SeekBar.class), hasSibling(withText(id))))
                    .check(matches(isEnabled()));
        }
        onView(withText(R.string.read_from_globals)).check(matches(not(isEnabled())));
        onView(withText(R.string.write_to_globals)).check(matches(not(isEnabled())));
        onView(withText(R.string.reset_defaults)).check(matches(not(isEnabled())));
        /*
        Action: move a seekbar
        Expected results:
        - buttons are enabled
         */
        onView(allOf(instanceOf(SeekBar.class), hasSibling(withText(R.string.gl_u_curvature))))
                .perform(setProgress(0));
        waitForIdle();
        onView(withText(R.string.read_from_globals)).check(matches(isEnabled()));
        onView(withText(R.string.write_to_globals)).check(matches(isEnabled()));
        onView(withText(R.string.reset_defaults)).check(matches(isEnabled()));
        /*
        Action: click "reset to default values."
        Expected result:
        - moved seekbas has default values.
        - all buttons are disabled
         */
        onView(withText(R.string.reset_defaults))
                .perform(scrollTo())
                .perform(click());
        onView(allOf(instanceOf(SeekBar.class), hasSibling(withText(R.string.gl_u_vignettestrength)))).check(matches(withProgress(10)));
        onView(withText(R.string.read_from_globals)).check(matches(not(isEnabled())));
        onView(withText(R.string.write_to_globals)).check(matches(not(isEnabled())));
        onView(withText(R.string.reset_defaults)).check(matches(not(isEnabled())));
        /*
        Action: move a seekbar
        Expected results:
        - buttons are enabled
         */
        onView(allOf(instanceOf(SeekBar.class), hasSibling(withText(R.string.gl_u_curvature))))
                .perform(setProgress(0));
        onView(withText(R.string.read_from_globals)).check(matches(isEnabled()));
        onView(withText(R.string.reset_defaults)).check(matches(isEnabled()));
        /*
        Action: copy current values to global values
        Expected results:
        - buttons to set current values as global values and vice versa are disabled.
        - button to reset to default values is enabled.
        - seekbar has default value
         */
        onView(withText(R.string.write_to_globals)).perform(click());
        waitForIdle();

        onView(withText(R.string.write_to_globals)).check(matches(not(isEnabled())));
        onView(allOf(instanceOf(SeekBar.class), hasSibling(withText(R.string.gl_u_curvature)))).check(matches(withProgress(0)));
        onView(withText(R.string.read_from_globals)).check(matches(not(isEnabled())));
        onView(withText(R.string.reset_defaults)).check(matches(isEnabled()));
        /*
        Action: move seekbar
        Expected results: Button to reset to current defaults
         */
        onView(allOf(instanceOf(SeekBar.class), hasSibling(withText(R.string.gl_u_curvature))))
                .perform(setProgress(10));

        onView(withText(R.string.read_from_globals)).perform(click());
        /*
        Action: move seekbar
        Expected results:
        - Buttons are enabled
         */
        onView(allOf(instanceOf(SeekBar.class), hasSibling(withText(R.string.gl_u_curvature)))).check(matches(withProgress(0)));
        onView(withText(R.string.write_to_globals)).check(matches(isEnabled()));
        onView(withText(R.string.read_from_globals)).check(matches(isEnabled()));
        onView(withText(R.string.reset_defaults)).check(matches(isEnabled()));
        /*
        Actions:
        - move seekbar to a value that is neither global value nor default
        - click apply
        Expected results:
        - Emulation is shown
         */
        onView(allOf(instanceOf(SeekBar.class), hasSibling(withText(R.string.gl_u_curvature))))
                .perform(setProgress(20));
        onView(withText(R.string.apply)).perform(click());
        waitForIdle();
        /*
        Action: open settings
        Expected results:
        - Seekbar has changed value
        - use global values is not checked
        - all buttons enabled
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(click());
        onView(withText(R.string.IDMS_SETTINGS)).perform(click());
        waitForIdle();
        onView(allOf(isDisplayed(), withText(R.string.video))).perform(scrollTo());
        onView(withText(R.string.use_global_settings)).check(matches(not(isChecked())));
        onView(allOf(instanceOf(SeekBar.class), hasSibling(withText(R.string.gl_u_curvature))))
                .check(matches(withProgress(20)));
        onView(withText(R.string.write_to_globals)).check(matches(isEnabled()));
        onView(withText(R.string.read_from_globals)).check(matches(isEnabled()));
        onView(withText(R.string.reset_defaults)).check(matches(isEnabled()));
        /*
        Actions:
        - click on reset to default values
        - click on on set as new global values
        - check use global settings
        Expected results:
        - all seekbars disabled
        - all buttons disabled
        - changed seekbar has default value
         */
        onView(withText(R.string.reset_defaults)).perform(scrollTo()).perform(click());
        onView(withText(R.string.write_to_globals)).perform(click());
        onView(withText(R.string.use_global_settings)).perform(scrollTo()).perform(click());
        waitForIdle();
        for (int id : params) {
            onView(allOf(instanceOf(SeekBar.class), hasSibling(withText(id))))
                    .check(matches(not(isEnabled())));

        }
        onView(allOf(instanceOf(SeekBar.class), hasSibling(withText(R.string.gl_u_curvature))))
                .check(matches(withProgress(8)));
        onView(withText(R.string.write_to_globals)).check(matches(not(isEnabled())));
        onView(withText(R.string.read_from_globals)).check(matches(not(isEnabled())));
        onView(withText(R.string.reset_defaults)).check(matches(not(isEnabled())));
        onView(withText(R.string.use_global_settings)).perform(scrollTo()).perform(click());
        /*
        Action change filter to upscaling
        Expected results:
        - Options for upscaling visible
        - Options for crt emulation not visible
         */
        onView(withId(R.id.sp_filter)).perform(scrollTo()).perform(click());
        onData(isOption(R.string.shader_upscaling)).perform(click());
        waitForIdle();
        onView(withText(R.string.gl_u_blur)).check(matches(isDisplayed()));
        for (int id : params) {
            onView(withText(id)).check(doesNotExist());
        }
        /*
        Action: change filter to passthrough
        Expected result: no filter specific options visible
         */
        onView(withId(R.id.sp_filter)).perform(scrollTo()).perform(click());
        onData(isOption(R.string.shader_passthrough)).perform(click());
        waitForIdle();
        onView(withText(R.string.gl_u_blur)).check(doesNotExist());
        for (int id : params) {
            onView(withText(id)).check(doesNotExist());
        }
        onView(withText(R.string.use_global_settings)).check(matches(not(isDisplayed())));
        onView(withText(R.string.write_to_globals)).check(matches(not(isDisplayed())));
        onView(withText(R.string.read_from_globals)).check(matches(not(isDisplayed())));
        onView(withText(R.string.reset_defaults)).check(matches(not(isDisplayed())));
        /*
        Action: finalize test and reset old value
         */
        onView(withId(R.id.gh_vic_ii_settings)).perform(scrollTo()).perform(click());
        onView(withText(R.string.apply)).perform(click());

    }
}
