 package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withAlpha;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.Matchers.allOf;

import android.view.KeyEvent;

import androidx.test.espresso.action.GeneralClickAction;
import androidx.test.espresso.action.GeneralLocation;
import androidx.test.espresso.action.Press;
import androidx.test.espresso.action.Tap;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matchers;
import org.junit.Test;

import java.util.concurrent.TimeUnit;

public class MultiplexerJoystickTest extends C64JoystickTestBase {
    @Test
    public void testSettings() {
        onView(isRoot()).perform(setHardwarekeyboardConnected(false));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        waitForIdle();
        onView(withTagValue(equalTo("port#2"))).perform(scrollTo()).perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());

        onView(withTagValue(equalTo("port#1"))).perform(scrollTo()).perform(click());
        onData(isOption(R.string.joystick_multiplexer)).perform(click());
        onData(isOption(R.string.paddle)).inAdapterView(allOf(isDisplayed(), withId(R.id.sp_typeselector))).check(matches(isDisplayed()));
        onView(withText(R.string.configure_single_joysticks)).perform(click());
        onView(withText(R.string.IDS_KEYSET_A)).check(doesNotExist());
        pressBack();
        onData(isOption(R.string.joystick)).inAdapterView(allOf(isDisplayed(), withId(R.id.sp_typeselector))).check(matches(isDisplayed()));
        onView(withText(R.string.configure_single_joysticks)).perform(click());
        onView(withText(R.string.virtual_touch_joystick))
                .check(matches(isDisplayed()))
                .perform(click());
        onView(withId(R.id.sb_joystick_transparency))
                .perform(new GeneralClickAction(Tap.SINGLE, GeneralLocation.CENTER_RIGHT, Press.FINGER))
                .check(matches(isWithProgress(60)));
        onView(withId(R.id.bn_apply)).perform(click());
        onView(withTagValue(equalTo("port#1"))).perform(click());
        onData(isOption(R.string.virtual_touch_joystick)).perform(click());
        onView(withId(R.id.sb_joystick_transparency))
                .check(matches(isWithProgress(60)))
                .perform(new GeneralClickAction(Tap.SINGLE, GeneralLocation.CENTER_LEFT, Press.FINGER))
                .check(matches(isWithProgress(0)));
        onView(withTagValue(equalTo("port#1"))).perform(click());
        onData(isOption(R.string.virtual_touch_joystick)).perform(click());
        onView(withId(R.id.sb_joystick_transparency))
                .check(matches(isWithProgress(0)));
        onView(withId(R.id.bn_apply)).perform(click());
        waitForActivity(EmulationActivity.class);
        onView(withId(R.id.jv_directions)).check(matches(withAlpha(0.2f)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForActivity(SettingsActivity.class);
        onData(isOption(R.string.virtual_touch_joystick)).inAdapterView(withTagValue(equalTo("port#1"))).check(matches(isDisplayed()));
        onView(withId(R.id.sb_joystick_transparency))
                .check(matches(isWithProgress(0)));
        pressBack();
        waitForActivity(EmulationActivity.class);
        onView(withId(R.id.jv_directions)).check(matches(withAlpha(0.2f)));
    }
    @Test
    public void testMultiplexing() {
        /*
        Action: run joystick test program
        Expected result: 255 is displayed
         */
        run_joystick_test_program();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 20, TimeUnit.SECONDS)));
        /*
        Actions:
        - open settings
        - assign F6 to fire on keyset a, f8 to fire on keyset b
        - assing F7 to south on keyset a, f9 to south on keyset b
        - enable multiplexing, so all keys will change the joystick value
        - click apply
        Expected result: emulation is shown and running.
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());

        onView(withTagValue(CoreMatchers.equalTo("port#2"))).perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());
        onView(withTagValue(CoreMatchers.equalTo("port#1"))).perform(click());
        onData(isOption(R.string.IDS_KEYSET_A)).perform(click());
        configDirection("FIRE", KeyEvent.KEYCODE_F6, R.string.IDS_PRESS_KEY_FIRE);
        configDirection("S", KeyEvent.KEYCODE_F7, R.string.IDS_PRESS_KEY_SOUTH);

        onView(withTagValue(CoreMatchers.equalTo("port#1"))).perform(click());
        onData(isOption(R.string.IDS_KEYSET_B)).perform(click());
        configDirection("FIRE", KeyEvent.KEYCODE_F8, R.string.IDS_PRESS_KEY_FIRE);
        configDirection("S", KeyEvent.KEYCODE_F9, R.string.IDS_PRESS_KEY_SOUTH);

        onView(withTagValue(CoreMatchers.equalTo("port#1"))).perform(click());
        onData(isOption(R.string.joystick_multiplexer)).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForActivity(EmulationActivity.class);

        /*
        Action: press F6 and F8 (assigned to fire) and release them
        Expected result: 239 is shown as value while key is pressed, otherwise 255
         */
        onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_F6));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-fire.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_F6));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 20, TimeUnit.SECONDS)));
        onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_F8));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-fire.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_F8));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 20, TimeUnit.SECONDS)));

        /*
        Action: press F7 and F9 (assigned to down) and release them
        Expected result: 253 is shown as value while key is pressed, otherwise 255
         */
        onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_F7));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-down.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_F7));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 20, TimeUnit.SECONDS)));
        onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_F9));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-down.pixelbuffer", 10, TimeUnit.SECONDS)));
        onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_F9));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 20, TimeUnit.SECONDS)));

        /*
        Actions:
        - open settings
        - disable keys in keyset b
        Expected result: emulation is shown and running.
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withTagValue(CoreMatchers.equalTo("port#1"))).perform(click());
        onData(isOption(R.string.IDS_KEYSET_B)).perform(click());
        onView(withTagValue(Matchers.equalTo("FIRE"))).perform(click());
        onView(withText(R.string.IDS_ROMSET_ARCHIVE_DELETE)).perform(click());
        onView(withTagValue(Matchers.equalTo("S"))).perform(click());
        onView(withText(R.string.IDS_ROMSET_ARCHIVE_DELETE)).perform(click());
        onView(withTagValue(CoreMatchers.equalTo("port#1"))).perform(click());
        onData(isOption(R.string.joystick_multiplexer)).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForActivity(EmulationActivity.class);
        /*
        Action: press keys of keyset b
        Expected result: keys are ignored, 255 is displayed.

         */
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 20, TimeUnit.SECONDS)));
        onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_F8));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 20, TimeUnit.SECONDS)));
        onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_F9));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 20, TimeUnit.SECONDS)));
        onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_F8));
        onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_F9));

    }

}
