package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isChecked;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;
import static org.hamcrest.CoreMatchers.equalTo;

import android.view.KeyEvent;

import androidx.test.platform.app.InstrumentationRegistry;

import org.junit.Test;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class MultiplexJoystickTest extends C64JoystickTestBase {
    private void keyboardUp(String expectedBitmap) {
        onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_DPAD_UP));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset(expectedBitmap, 30, TimeUnit.SECONDS)));
        onView(withId(R.id.screen)).perform(createTypeAction(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_DPAD_UP));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 10, TimeUnit.SECONDS)));
    }
    private void dpadUp(String expectedBitmap) {
        onView(withId(R.id.screen)).perform(pressDpadJoystickKey(KeyEvent.KEYCODE_DPAD_UP));
        waitForIdle(1, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset(expectedBitmap, 30, TimeUnit.SECONDS)));
        /*
        Action: Push Joystick right
        Expected result: 247 is displayed
         */
        onView(withId(R.id.screen)).perform(releaseDpadJoystickKey(KeyEvent.KEYCODE_DPAD_UP));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 10, TimeUnit.SECONDS)));
    }
    private final static String SCREEN_WITH_JOYSTICK_UP = "screenshot-joystick-up.pixelbuffer";
    private final static String SCREEN_WITH_JOYSTICK_CENTERED = "screenshot-joystick-centered.pixelbuffer";
    @Test
    public void test_multiplexing() {
        /*
        Action choose Joystick and load JOYSTICKTEST from testprograms.
        Expected result: 255 is displayed.
         */
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        onView(withTagValue(equalTo("port#1"))).perform(click());
        onData(isOption(new C64JoystickTestBase.UnitTestDpadJoystick().toString()))
                .perform(scrollTo())
                .perform(click());
        onView(withText(R.string.joysticks)).perform(scrollTo()).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForActivity(EmulationActivity.class, 2, TimeUnit.SECONDS);
        run_joystick_test_program();
        dpadUp(SCREEN_WITH_JOYSTICK_UP);
        keyboardUp(SCREEN_WITH_JOYSTICK_CENTERED);
        prepare_port_0_with_dpad_keys();
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(scrollTo()).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForActivity(EmulationActivity.class, 2, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 10, TimeUnit.SECONDS)));
        dpadUp(SCREEN_WITH_JOYSTICK_CENTERED);
        keyboardUp(SCREEN_WITH_JOYSTICK_UP);
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        onView(withTagValue(equalTo("port#1"))).perform(click());
        onData(isOption(InstrumentationRegistry.getInstrumentation().getTargetContext().getResources().getString(R.string.joystick_multiplexer))).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-joystick-centered.pixelbuffer", 10, TimeUnit.SECONDS)));
        keyboardUp(SCREEN_WITH_JOYSTICK_UP);
        dpadUp(SCREEN_WITH_JOYSTICK_UP);
    }
    @Test
    public void test_useropts() {
        onView(isRoot()).perform(setJoysticksConnected(GameControllerJoystick.class, true));
        onView(isRoot()).perform(setJoysticksConnected(UnitTestDpadJoystick.class, true));

        onView(withId(R.id.jv_fire)).check((doesNotExist()));
        onView(withId(R.id.jv_directions)).check((doesNotExist()));
        onView(withId(R.id.jv_wheel)).check((doesNotExist()));
        onView(withId(R.id.jv_flipswitch)).check((doesNotExist()));

        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        onView(withTagValue(equalTo("port#2")))
                .perform(scrollTo())
                .perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());

        onView(withTagValue(equalTo("port#1"))).perform(click());
        waitForIdle();
        onData(isOption(InstrumentationRegistry.getInstrumentation().getTargetContext().getResources().getString(R.string.joystick_multiplexer))).perform(click());
        onView(withId(R.id.rb_show_joystick)).check(matches(isDisplayed())).check(matches(isChecked()));
        onView(withId(R.id.bn_apply)).perform(click());
        waitForActivity(EmulationActivity.class, 2, TimeUnit.SECONDS);
        onView(isRoot()).perform(setJoysticksConnected(GameControllerJoystick.class, false));
        onView(isRoot()).perform(setJoysticksConnected(UnitTestDpadJoystick.class, false));
        onView(withId(R.id.jv_fire)).check(matches(isDisplayed()));
        onView(isRoot()).perform(setJoysticksConnected(GameControllerJoystick.class, true));
        onView(isRoot()).perform(setJoysticksConnected(UnitTestDpadJoystick.class, true));
        onView(withId(R.id.jv_fire)).check((doesNotExist()));
        onView(isRoot()).perform(setJoysticksConnected(GameControllerJoystick.class, false));
        onView(isRoot()).perform(setJoysticksConnected(UnitTestDpadJoystick.class, false));
        onView(withId(R.id.jv_fire)).check(matches(isDisplayed()));
        onView(withId(R.id.jv_directions)).check(matches(isDisplayed()));
        onView(withId(R.id.jv_wheel)).check(doesNotExist());
        onView(withId(R.id.jv_flipswitch)).check(doesNotExist());

        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();

        onView(withId(R.id.rb_show_joystick)).check(matches(isDisplayed())).check(matches(isChecked()));
        onView(withId(R.id.rb_show_wheel)).check(matches(isDisplayed())).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForActivity(EmulationActivity.class, 2, TimeUnit.SECONDS);

        onView(withId(R.id.jv_fire)).check((doesNotExist()));
        onView(withId(R.id.jv_directions)).check((doesNotExist()));
        onView(withId(R.id.jv_wheel)).check(matches(isDisplayed()));
        onView(withId(R.id.jv_flipswitch)).check(matches(isDisplayed()));

        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();

        onView(withId(R.id.rb_show_wheel)).check(matches(isDisplayed())).check(matches(isChecked()));
        onView(withId(R.id.rb_show_none)).check(matches(isDisplayed())).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForActivity(EmulationActivity.class, 2, TimeUnit.SECONDS);

        onView(withId(R.id.jv_fire)).check((doesNotExist()));
        onView(withId(R.id.jv_directions)).check((doesNotExist()));
        onView(withId(R.id.jv_wheel)).check((doesNotExist()));
        onView(withId(R.id.jv_flipswitch)).check((doesNotExist()));
    }
    @Test
    public void test_multiplex_force_recenter() throws IOException {
        test_force_recenter(InstrumentationRegistry.getInstrumentation().getTargetContext().getResources().getString(R.string.joystick_multiplexer),
                () -> onView(withId(R.id.screen)).perform(pressDpadJoystickKey(KeyEvent.KEYCODE_DPAD_RIGHT)),
                () -> onView(withId(R.id.screen)).perform(pressDpadJoystickKey(KeyEvent.KEYCODE_DPAD_UP)),
                () -> onView(withId(R.id.screen)).perform(releaseDpadJoystickKey(KeyEvent.KEYCODE_DPAD_RIGHT)),
                () -> onView(withId(R.id.screen)).perform(releaseDpadJoystickKey(KeyEvent.KEYCODE_DPAD_UP)));
    }

}
