package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.isEnabled;
import static androidx.test.espresso.matcher.ViewMatchers.isRoot;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withParent;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;

import static org.hamcrest.CoreMatchers.allOf;
import static org.hamcrest.CoreMatchers.instanceOf;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.Matchers.equalTo;

import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;

import androidx.test.espresso.ViewAction;
import androidx.test.espresso.assertion.PositionAssertions;
import androidx.test.platform.app.InstrumentationRegistry;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Test;

import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class JavaScriptTest extends MainActivityTestBase{
    @Test
    public void peeks_and_pokes() {
        addTestConfigurations();
        waitForActivity(MainActivity.class, 2, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction("_JS_PEEKS_AND_POKES_", click()));
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",5, TimeUnit.SECONDS)));
        waitForIdle(1, TimeUnit.SECONDS);
        // Action: Press Key "A"
        // Expected result: Border color to grey
        onView(allOf(isDisplayed(), isC64Key("A"))).perform(tap());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-grey-border.pixeldata", 1, TimeUnit.SECONDS)));
        // Action: Press Key "A"
        // Expected result: Border color to black
        onView(allOf(isDisplayed(), isC64Key("A"))).perform(tap());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-black-border.pixeldata", 1, TimeUnit.SECONDS)));

        // Action: Press Key "B"
        // Expected result: first to lines of screen contents flip
        onView(isC64Key("B")).perform(tap());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-black-border-flipped.pixeldata", 1, TimeUnit.SECONDS)));
        // Action: Press Key "B"
        // Expected result: first to lines of screen contents flip back
        onView(isC64Key("B")).perform(tap());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-black-border.pixeldata", 1, TimeUnit.SECONDS)));

        // Action: Press KEY "C"
        // Expected result: "8 BIT WONDERS" is printed in the list line
        onView(isC64Key("C")).perform(tap());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-8bw-text.pixeldata", 1, TimeUnit.SECONDS)));

        // Aktion: Type text 000
        // Expected result: "ZEROS ENTERED is type in the second to last line.
        onView(isC64Key("0")).perform(tap());
        waitForIdle();
        onView(isC64Key("0")).perform(tap());
        waitForIdle();
        onView(isC64Key("0")).perform(tap());
        waitForIdle();

        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-black-border-000-entered.pixeldata", 2, TimeUnit.SECONDS)));
        // Aktion: Delete last 0 from 000
        // Expected result: second line is restored
        for (ViewAction v : createTypeActions(Arrays.asList(KeyEvent.KEYCODE_FORWARD_DEL), 60, 60)) {
            onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
            onView(withId(R.id.screen)).perform(v);
        }

        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(not(showsBitmapEqualToAsset("screenshot-8bw-text.pixeldata", 2, TimeUnit.SECONDS))));
        for (ViewAction v : createTypeActions(Arrays.asList(KeyEvent.KEYCODE_FORWARD_DEL), 60, 60)) {
            onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
            onView(withId(R.id.screen)).perform(v);
        }
        waitForIdle();
        for (ViewAction v : createTypeActions(Arrays.asList(KeyEvent.KEYCODE_FORWARD_DEL), 60, 60)) {
            onView(withId(R.id.gv_monitor)).check(matches(isScreenUpdating()));
            onView(withId(R.id.screen)).perform(v);
        }
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-8bw-text.pixeldata", 1, TimeUnit.SECONDS)));
        // Poke 1 into memory adress 2
        // Expected result: "ONE" is displayed in the third to last row
        for (String s : new String[] {"P", "O", "K", "E", " ", "2", ",", "1", "RETURN"}) {
            onView(allOf(isDisplayed(), isC64Key(s))).perform(tap());
        }
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-black-border-text-one.pixeldata", 1, TimeUnit.SECONDS)));
        // Poke 2 into memory adress 2
        // Expected result: "TWO" is displayed in the third to last row
        for (String s : new String[] {"P", "O", "K", "E", " ", "2", ",", "2", "RETURN"}) {
            onView(allOf(isDisplayed(), isC64Key(s))).perform(tap());
        }
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-black-border-text-two.pixeldata", 1, TimeUnit.SECONDS)));

        // Poke 3 into memory adress 2
        // Expected result: "MANY" is displayed in the third to last row
        for (String s : new String[] {"P", "O", "K", "E", " ", "2", ",", "3", "RETURN"}) {
            onView(allOf(isDisplayed(), isC64Key(s))).perform(tap());
        }
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-black-border-text-many.pixeldata", 1, TimeUnit.SECONDS)));

        // Poke 4 into memory adress 2
        // Expected result: "MANY" is displayed in the third to last row
        for (String s : new String[] {"P", "O", "K", "E", " ", "2", ",", "4", "RETURN"}) {
            onView(allOf(isDisplayed(), isC64Key(s))).perform(tap());
        }
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-black-border-text-many-2.pixeldata", 1, TimeUnit.SECONDS)));
        // Type Button "D"
        // 1 Second nothing happening, then text "DELAY" in forth row to last
        long t1 = System.currentTimeMillis();
        onView(allOf(isDisplayed(), isC64Key("D"))).perform(tap());
        long t2 = System.currentTimeMillis();
        onView(withId(R.id.gv_monitor)).check(matches(not(showsBitmapEqualToAsset("screenshot-black-border-text-delay.pixeldata", 1500, TimeUnit.MILLISECONDS))));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-black-border-text-delay.pixeldata", 1000, TimeUnit.MILLISECONDS)));

        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForIdle();
    }
    private Matcher<View> isSoftKey(String text) {
        return allOf(withParent(withId(R.id.softkeys)),withText(text),instanceOf(Button.class));
    }
    @Test
    public void ui() {
        addTestConfigurations();
        onView(isRoot()).perform(createdTileAction("_JS_UI_", click()));
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-black-border.pixeldata",5, TimeUnit.SECONDS)));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.hide_keyboard)).perform(click());
        onView(withId(R.id.keyboardview)).check(matches(not(isDisplayed())));
        Runnable checkAllKeys = () -> {
            for (String key : Arrays.asList("1", "2", "3", "4", "5")) {
                onView(isSoftKey(key)).check(matches(allOf(isDisplayed(), isEnabled())));
            }
        };
        checkAllKeys.run();
        onView(isSoftKey("2")).check(PositionAssertions.isCompletelyLeftOf(isSoftKey("3")));
        onView(isSoftKey("1")).perform(click());
        onView(isSoftKey("2")).check(matches(not(isEnabled())));
        onView(isSoftKey("1")).perform(click());
        onView(isSoftKey("2")).check(matches(isEnabled()));
        onView(isSoftKey("4")).check(PositionAssertions.isCompletelyLeftOf(isSoftKey("5")));
        onView(isSoftKey("5")).perform(click());
        onView(isSoftKey("4")).check(doesNotExist());
        onView(isSoftKey("5")).perform(click());
        onView(isSoftKey("4")).check(PositionAssertions.isCompletelyRightOf(isSoftKey("5")));
        onView(isRoot()).perform(orientationLandscape());
        waitForIdle();
        checkAllKeys.run();
        onView(isSoftKey("3")).perform(tap());
        checkForToast("8 BIT WONDERS");
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-black-border.pixeldata",5, TimeUnit.SECONDS)));
        onView(isRoot()).perform(orientationPortrait());
        onView(withId(R.id.ib_hamburger_menu)).perform(click());
        waitForIdle(10, TimeUnit.SECONDS);
        onView(withText(R.string.show_keyboard)).perform(click());
        waitForIdle();
        onView(withId(R.id.keyboardview)).check(matches(isDisplayed()));
        for (String key : Arrays.asList("1", "2", "3", "4", "5")) {
            onView(isSoftKey(key)).check(matches(not(isDisplayed())));
        }
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.hide_keyboard)).perform(click());
        waitForIdle();
        checkAllKeys.run();
    }
    @Test
    public void input() {
        addTestConfigurations();
        onView(isRoot()).perform(createdTileAction("_JS_INPUT_", click()));
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-black-border.pixeldata",5, TimeUnit.SECONDS)));
        onView(isC64Key("X")).perform(tap());
        onView(isC64Key("X")).perform(tap());
        onView(isC64Key("X")).perform(tap());
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-uxx.pixeldata",5, TimeUnit.SECONDS)));
        onView(isC64Key("F7")).perform(tap());
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        waitForIdle();
        onView(withTagValue(CoreMatchers.equalTo("port#1"))).perform(scrollTo()).perform(click());
        onData(isOption(R.string.virtual_touch_joystick)).perform(click());
        onView(withTagValue(CoreMatchers.equalTo("port#2"))).perform(scrollTo()).perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());

        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        FingerState fingerState = new FingerState();
        /*
        Action: touch left part of joystick direction view
        Expected result: 251 is displayed, "left" indicator of the view is highlighted.
         */
        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.DOWN, fingerState, 10, 50));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-js-joystick-left.pixeldata")));
        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.MOVE, fingerState, 10, 10));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-js-joystick-topleft.pixeldata")));
        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.UP, fingerState, 0, 0));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-uxx.pixeldata",5, TimeUnit.SECONDS)));
        onView(withId(R.id.jv_directions)).perform(doFingerAction(FingerAction.DOWN, fingerState, 90, 90));
        onView(withId(R.id.jv_fire)).perform(doFingerAction(FingerAction.DOWN, new FingerState(), 50, 50));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-js-joystick-bottomright-fire.pixeldata")));

    }
    @Test
    public void developer() {
        addTestConfigurations();
        onView(isRoot()).perform(createdTileAction("_JS_DEV_", click()));
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-black-border.pixeldata",5, TimeUnit.SECONDS)));
    }
    @Test
    public void properties() {
        addTestConfigurations();
        onView(isRoot()).perform(createdTileAction("_JS_PROPERTIES_", click()));
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",5, TimeUnit.SECONDS)));
        onView(isC64Key("F1")).perform(tap());
        waitForIdle();
        type_load_directory(8);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-fliplist1-dir-loaded.pixelbuffer",10, TimeUnit.SECONDS)));
        onView(isC64Key("F3")).perform(tap());
        waitForIdle();
        type_load_directory(8);
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-fliplist1-dir-load-failed.pixelbuffer",20, TimeUnit.SECONDS)));

        onView(isC64Key("F7")).perform(tap());
        waitForIdle(1, TimeUnit.SECONDS);
        onView(isC64Key("F7")).perform(tap());
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-fliplist1-dir-load-failed.pixelbuffer",20, TimeUnit.SECONDS)));
        pressBack();
        waitForIdle();
        onView(withText(R.string.quit)).perform(click());
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction("_JS_PROPERTIES_", click()));
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",5, TimeUnit.SECONDS)));
        onView(isC64Key("STOP")).perform(tap());
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-black-border.pixeldata",5, TimeUnit.SECONDS)));
        onView(isC64Key("STOP")).perform(tap());
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-grey-border.pixeldata",5, TimeUnit.SECONDS)));

    }
    @Test
    public void gamepad()  {
        addTestConfigurations();
        onView(isRoot()).perform(createdTileAction("_JS_GAMEPAD_", click()));
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",10, TimeUnit.SECONDS)));
        onView(withId(R.id.gv_monitor)).check(matches(isScreenInitialized()));
        waitForIdle();
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withText(R.string.joysticks)).perform(click());
        waitForIdle();
        onView(withTagValue(CoreMatchers.equalTo("port#1"))).perform(click());
        onData(isOption(R.string.IDS_NONE)).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        onView(withId(R.id.gv_monitor)).check(matches(isScreenInitialized()));
        waitForIdle();
        onView(isC64Key("CTRL")).perform(tap());
        waitForIdle();
        onView(isC64Key("7")).perform(tap());
        waitForIdle();
        onView(isC64Key("F7")).perform(tap());
        waitForIdle();
        onView(isC64Key(" ")).perform(tap());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-js-2-joysticks.pixelbuffer")));
        onView(withId(R.id.screen)).perform(keyAction(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_BUTTON_A, GameControllerJoystickTest.DEVICE_ID));
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-js-2-joysticks-button-a-pressed.pixelbuffer")));
        onView(withId(R.id.screen)).perform(keyAction(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_BUTTON_A, GameControllerJoystickTest.DEVICE_ID));
        waitForIdle();
        onView(withId(R.id.screen)).perform(keyAction(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_BUTTON_X, GameControllerJoystickTest.DEVICE_ID));
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-js-2-joysticks-button-x-pressed.pixelbuffer")));
        onView(withId(R.id.screen)).perform(keyAction(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_BUTTON_X, GameControllerJoystickTest.DEVICE_ID));
        waitForIdle();

        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-js-2-joysticks.pixelbuffer")));
        waitForIdle();
        onView(isRoot()).perform(setJoysticksConnected(DpadJoystick.class, false));
        waitForIdle();
        onView(isC64Key(" ")).perform(tap());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-js-1-joystick.pixelbuffer")));
        waitForIdle();
        onView(isRoot()).perform(setJoysticksConnected(GameControllerJoystick.class, false));
        waitForIdle();
        onView(isC64Key(" ")).perform(tap());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-js-0-joysticks.pixelbuffer")));
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        waitForIdle();
        onView(withTagValue(CoreMatchers.equalTo("port#1"))).perform(click());
        onData(isOption(R.string.virtual_touch_joystick)).perform(click());
        onView(withTagValue(equalTo(InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.value_joystick_button_right)))).perform(click());
        onView(withId(R.id.bn_apply)).perform(click());
        waitForIdle();
        onView(withId(R.id.jv_directions))
                .check(matches(isDisplayed()));
        onView(isC64Key(" ")).perform(tap());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-js-virtualstick.pixelbuffer")));
        waitForIdle();
        FingerState fireState = new FingerState();
        onView(withId(R.id.jv_fire)).perform(doFingerAction(FingerAction.DOWN, fireState, 50, 50));
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-js-virtualstick-pressed.pixelbuffer")));
        onView(withId(R.id.jv_fire)).perform(doFingerAction(FingerAction.UP, fireState, 50, 50));
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-js-virtualstick.pixelbuffer")));
    }
    @Test
    public void softkeyboard(){
        addTestConfigurations();
        onView(isRoot()).perform(createdTileAction("_JS_SOFTKEYBOARD_", click()));
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",10, TimeUnit.SECONDS)));
        onView(withId(R.id.gv_monitor)).check(matches(isScreenInitialized()));
        waitForIdle();
        onView(isRoot()).perform(setHardwarekeyboardConnected(false));
        rotate(orientationLandscape(), not(isDisplayed()));
        onView(withId(R.id.gv_monitor))
                .perform(doubleClick());
        onView(isSoftKey("T")).perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isScrolledToPosition(EmulationUi.SCREENPART_TOP, 1, TimeUnit.SECONDS)));
        onView(isC64Key("RETURN")).perform(tap());
        waitForIdle();

        onView(isSoftKey("C")).perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isScrolledToPosition(EmulationUi.SCREENPART_CENTER, 1, TimeUnit.SECONDS)));
        onView(isC64Key("RETURN")).perform(tap());

        waitForIdle();
        onView(isSoftKey("B")).perform(click());
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(isScrolledToPosition(EmulationUi.SCREENPART_BOTTOM, 10, TimeUnit.SECONDS)));

        onView(isC64Key("RETURN")).perform(tap());
        waitForIdle();

        //Thread.sleep(10*60*1000);
    }
    private void i18n_per_language(Locale locale, String filename) {
        addTestConfigurations();
        setTestLocale(locale);

        onView(isRoot())
                .perform(createdTileAction("_JS_I18N_", click()));
        waitForIdle();
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("snapshot-machine-ready.pixelbuffer",10, TimeUnit.SECONDS)));
        onView(withId(R.id.gv_monitor)).check(matches(isScreenInitialized()));
        onView(isC64Key("F7")).perform(tap());
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset(filename,10, TimeUnit.SECONDS)));
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForIdle();
        waitForActivity(MainActivity.class, 2, TimeUnit.SECONDS);
    }
    @Test
    public void i18n() {
        i18n_per_language(Locale.US, "screenshot-i18n-us.pixelbuffer");
        i18n_per_language(Locale.FRENCH, "screenshot-i18n-fr.pixelbuffer");
        i18n_per_language(Locale.GERMAN, "screenshot-i18n-de.pixelbuffer");
    }
    private void remove_initial_snapshot() {
        File rootfolder = new File(InstrumentationRegistry.getInstrumentation().getTargetContext().getCacheDir(), "initial_snapshots");
        File[] files = new File(rootfolder, "C64_736302f7-d0a6-42b9-a9f4-b9e69280786b_default").listFiles();
        if (files != null) {
            for (File f:files) {
                if (!f.delete()) {
                    f.deleteOnExit();
                }
            }
        }
    }
    /** @noinspection unused*/ // Loop test to test flakiness of timemachine_store_last_entry
    // uncomment @Test tag to test.
    //@Test
    @SpecialTest
    public void loopUntilError() {
        int i = 0;
        //noinspection InfiniteLoopStatement
        while (true) {
            i++;
            Log.e("loopUntilError", "Loop #"+i);
            initial_snapshots();
        }
    }
    @Test
    public void initial_snapshots() {
        addTestConfigurations();
        remove_initial_snapshot();
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction("_JS_INITIAL_SNAPSHOTS_", click()));
        waitForIdle();
        waitForActivity(EmulationActivity.class, 2, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-loading-directory.pixelbuffer", 30, TimeUnit.SECONDS)));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-program-started.pixelbuffer",120,TimeUnit.SECONDS)));
        waitForIdle(5, TimeUnit.SECONDS);
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        waitForActivity(MainActivity.class, 5, TimeUnit.SECONDS);
        onView(isRoot()).perform(createdTileAction("_JS_INITIAL_SNAPSHOTS_", click()));
        waitForActivity(EmulationActivity.class, 2, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-program-started.pixelbuffer",3,TimeUnit.SECONDS)));
        pressBack();
        onView(withText(R.string.quit)).perform(click());
        remove_initial_snapshot();
    }
    @Test
    public void c128_monitor_switch() {
        addTestConfigurations();
        onView(isRoot()).perform(createdTileAction("_JS_C128_", click()));
        waitForIdle();
        waitForActivity(EmulationActivity.class, 5, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isScreenInitialized()));
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-c128.pixelbuffer", 15, TimeUnit.SECONDS)));
        for (String key: Arrays.asList("0", "ESC", "X", "V", "D", "C")) {
            waitForIdle(50, TimeUnit.MILLISECONDS);
            onView(isC64Key(key)).perform(tap());
            waitForIdle(50, TimeUnit.MILLISECONDS);
        }
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-c128-80-col-text.pixelbuffer")));
        for (String key: Arrays.asList("1", "ESC", "X")) {
            waitForIdle(50, TimeUnit.MILLISECONDS);
            onView(isC64Key(key)).perform(tap());
            waitForIdle(50, TimeUnit.MILLISECONDS);
        }
        onView(withId(R.id.gv_monitor)).check(matches(showsBitmapEqualToAsset("screenshot-machine-ready-c128.pixelbuffer", 10, TimeUnit.SECONDS)));
    }
}
