package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.withId;

import androidx.test.platform.app.InstrumentationRegistry;

import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

import java.util.concurrent.TimeUnit;

@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class ChangelogTest extends MainActivityTestBase{
    @Test
    public void t_01_prepare() {
        Useropts opts = new Useropts(
                InstrumentationRegistry.getInstrumentation().getTargetContext());
        opts.setValue(Useropts.Scope.GLOBAL, MainActivity.CHANGELOG_SHOWN, "v0");
    }
    @Test
    public void t_02_first_start_after_update() {
        waitForIdle();

        onView(withId(R.id.bn_close_changelog)).check(matches(isDisplayed()));
        onView(withId(R.id.bn_full_changelog)).perform(click());
        waitForActivity(BrowserActivity.class);
        pressBack();
        waitForActivity(MainActivity.class);
        onView(withId(R.id.bn_close_changelog)).perform(click());
        onView(withId(R.id.preinstalled)).check(matches(isDisplayed()));
    }
    @Test
    public void t_02_second_start_after_update() {
        onView(withId(R.id.preinstalled)).check(matches(isDisplayed()));
    }

}
