package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onData;
import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isDescendantOfA;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.withChild;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withTagValue;
import static androidx.test.espresso.matcher.ViewMatchers.withText;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.Matchers.allOf;

import android.content.Context;
import android.view.View;

import androidx.annotation.StringRes;
import androidx.test.espresso.PerformException;
import androidx.test.platform.app.InstrumentationRegistry;

import org.hamcrest.Matcher;

abstract class C64EmulationTestBase extends EmulationTestBase {

    @Override
    protected EmulationConfiguration getConfiguration(Context context) {
        return new ConfigurationFactory.MachineConfiguration(context, "C64");

    }

    protected void setControllerPort1(final String deviceLabel, final @StringRes int inputtype, boolean hasMultiTypes) {
        onView(withId(R.id.ib_hamburger_menu)).perform(tap());
        waitForIdle();
        onView(withText(R.string.IDS_MP_SETTINGS)).perform(click());
        try {
            onView(withTagValue(equalTo("port#2"))).perform(scrollTo()).perform(click());
        } catch (PerformException e) {
            onView(withText(R.string.joysticks)).perform(click());
            onView(withTagValue(equalTo("port#2"))).perform(scrollTo()).perform(click());
        }
        onData(isOption(InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.IDS_NONE))).perform(click());
        //onData(isOption(deviceLabel)).perform(click());
        onView(withTagValue(equalTo("port#1"))).perform(scrollTo()).perform(click());
        //onData(isOption(String.format("%s (%s)", FAKE_GAMECONTROLLER_DEVICEID, InstrumentationRegistry.getInstrumentation().getTargetContext().getString(R.string.IDS_JOYSTICK_1)))).perform(click());
        onData(isOption(deviceLabel)).perform(click());
        if (hasMultiTypes) {
            Matcher<View> spinner = allOf(isDescendantOfA(withChild(withTagValue(equalTo("port#1")))), withId(R.id.sp_typeselector));
            onView(spinner).perform(click());
            onView(withText(inputtype)).perform(click());
            onData(isOption(inputtype)).inAdapterView(spinner).check(matches(isDisplayed()));
        }
    }
}
