package de.rainerhock.eightbitwonders;

import static androidx.test.espresso.Espresso.onView;
import static androidx.test.espresso.action.ViewActions.click;
import static androidx.test.espresso.action.ViewActions.scrollTo;
import static androidx.test.espresso.assertion.ViewAssertions.doesNotExist;
import static androidx.test.espresso.assertion.ViewAssertions.matches;
import static androidx.test.espresso.matcher.ViewMatchers.isDisplayed;
import static androidx.test.espresso.matcher.ViewMatchers.withId;
import static androidx.test.espresso.matcher.ViewMatchers.withText;

import org.junit.Test;

import java.util.concurrent.TimeUnit;


public class AppstoreAgeVerificationTest extends AgeVerificationTest {
    @Test
    @SpecialTest
    @AppstoreTest
    public void testAppStore() {
        prepare();
        AgeVerificationProviderImpl.setFakeAgeSignalsManager(AgeVerificationProviderImpl.getFakeVerifiedUser());
        onView(withText(R.string.name_c64)).perform(scrollTo()).perform(click());
        waitForActivity(EmulationActivity.class, HTTP_GET_DELAY, TimeUnit.SECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        pressBack();
        onView(withText(R.string.quit)).perform(click());

        AgeVerificationProviderImpl.setFakeAgeSignalsManager(AgeVerificationProviderImpl.getFakeSupervisedUser());
        onView(withText(R.string.name_c64)).perform(scrollTo()).perform(click());
        waitForIdle(250, TimeUnit.MILLISECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        pressBack();
        onView(withText(R.string.quit)).perform(click());

        AgeVerificationProviderImpl.setFakeAgeSignalsManager(AgeVerificationProviderImpl.getUnknownUser());
        onView(withText(R.string.name_c64)).perform(scrollTo()).perform(click());
        onView(withText(R.string.unknown_user_pls)).check(matches(isDisplayed()));
        onView(withText(R.string.ok)).perform(click());
        onView(withText(R.string.name_c64)).check(matches(isDisplayed()));
        onView(withId(R.id.gv_monitor)).check(doesNotExist());

        AgeVerificationProviderImpl.setFakeAgeSignalsManager(AgeVerificationProviderImpl.getDeniedAccessUser());
        onView(withText(R.string.name_c64)).perform(scrollTo()).perform(click());
        onView(withText(R.string.consent_not_granted)).check(matches(isDisplayed()));
        onView(withText(R.string.ok)).perform(click());
        onView(withText(R.string.name_c64)).check(matches(isDisplayed()));
        onView(withId(R.id.gv_monitor)).check(doesNotExist());

        AgeVerificationProviderImpl.setFakeAgeSignalsManager(AgeVerificationProviderImpl.getNotAffectedUser());
        onView(withText(R.string.name_c64)).perform(scrollTo()).perform(click());
        waitForIdle(250, TimeUnit.MILLISECONDS);
        onView(withId(R.id.gv_monitor)).check(matches(isDisplayed()));
        pressBack();
        onView(withText(R.string.quit)).perform(click());

        AgeVerificationProviderImpl.setFakeAgeSignalsManager(AgeVerificationProviderImpl.getErrorForUser());
        onView(withText(R.string.name_c64)).perform(scrollTo()).perform(click());
        onView(withText(R.string.not_installed_by_appstore)).check(matches(isDisplayed()));
        onView(withText(R.string.ok)).perform(click());
        onView(withText(R.string.name_c64)).check(matches(isDisplayed()));
        onView(withId(R.id.gv_monitor)).check(doesNotExist());


    }
}
